/*
 * Decompiled with CFR 0.152.
 */
package de.rafael.modflared.mixin.client;

import de.rafael.modflared.interfaces.mixin.IServerInfo;
import de.rafael.modflared.tunnel.TunnelStatus;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerSelectionList.OnlineServerEntry.class})
public abstract class ServerEntryMixin
extends ServerSelectionList.Entry {
    @Shadow
    @Final
    private ServerData serverData;
    @Unique
    private static final ResourceLocation MODFLARED_INDICATOR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"modflared", (String)"icon/indicator");

    @Inject(method={"renderContent(Lnet/minecraft/client/gui/GuiGraphics;IIZF)V"}, at={@At(value="TAIL")})
    public void render(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float deltaTicks, CallbackInfo ci) {
        TunnelStatus tunnelStatus = ((IServerInfo)this.serverData).getTunnelStatus();
        if (tunnelStatus != null && tunnelStatus.state() == TunnelStatus.State.USE) {
            int xOffset = this.getContentWidth() - 15;
            int yOffset = 11;
            int x = this.getContentX();
            int y = this.getContentY();
            context.blitSprite(RenderPipelines.GUI_TEXTURED, MODFLARED_INDICATOR_TEXTURE, x + xOffset, y + yOffset, 10, 10);
            int l = mouseX - x;
            int m = mouseY - y;
            if (l >= this.getContentWidth() - 15 && l <= this.getContentWidth() - 5 && m >= 9 && m <= 19) {
                context.setTooltipForNextFrame((Component)Component.translatable((String)"gui.multiplayer.tunnel.status.0").withStyle(ChatFormatting.AQUA), mouseX, mouseY);
            }
        }
    }
}

