/*
 * Decompiled with CFR 0.152.
 */
package de.rafael.modflared.tunnel;

import de.rafael.modflared.Modflared;
import de.rafael.modflared.binary.Cloudflared;
import de.rafael.modflared.tunnel.manager.TunnelManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.zip.CRC32;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.Platform;

public record RunningTunnel(Access access, Process process) {
    @NotNull
    public static CompletableFuture<RunningTunnel> createTunnel(@NotNull Cloudflared binary, @NotNull Access access) {
        CompletableFuture<RunningTunnel> future = new CompletableFuture<RunningTunnel>();
        Modflared.EXECUTOR.execute(() -> {
            try {
                String line;
                ProcessBuilder processBuilder = new ProcessBuilder(binary.buildCommand(access));
                if (Platform.get() != Platform.WINDOWS) {
                    processBuilder.directory(TunnelManager.DATA_FOLDER);
                }
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    TunnelManager.CLOUDFLARE_LOGGER.info(line);
                    if (!line.contains("Start Websocket listener")) continue;
                    Thread.sleep(250L);
                    future.complete(new RunningTunnel(access, process));
                }
            }
            catch (IOException | InterruptedException exception) {
                Modflared.LOGGER.error("Failed to start cloudflared", (Throwable)exception);
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    public void closeTunnel() {
        this.process.destroy();
    }

    public record Access(String protocol, String hostname, InetSocketAddress tunnelAddress) {
        @Contract(value="_ -> new")
        @NotNull
        public static Access localWithRandomPort(String host) {
            return new Access("tcp", host, new InetSocketAddress("127.0.0.1", Access.computePort(host)));
        }

        public String @NotNull [] command(@NotNull String fileName, boolean prefix) {
            return new String[]{(prefix && Platform.get() != Platform.WINDOWS ? "./" : "") + fileName, "access", this.protocol, "--hostname", this.hostname, "--url", this.tunnelAddress.getHostString() + ":" + this.tunnelAddress.getPort()};
        }

        public static int computePort(@NotNull String host) {
            int MIN_PORT = 25565;
            int MAX_PORT = 65530;
            int RANGE = 39966;
            CRC32 crc32 = new CRC32();
            crc32.update(host.getBytes());
            long hash = crc32.getValue();
            return (int)(hash % 39966L + 25565L);
        }
    }
}

