/*
 * Decompiled with CFR 0.152.
 */
package de.rafael.modflared.binary.local;

import de.rafael.modflared.Modflared;
import de.rafael.modflared.binary.Cloudflared;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalCloudflared
extends Cloudflared {
    public LocalCloudflared(String version) {
        super(version);
    }

    @Override
    public CompletableFuture<Void> prepare() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String[] buildCommand( @NotNull RunningTunnel.Access access) {
        return access.command("cloudflared", false);
    }

    @Nullable
    public static Cloudflared tryCreate() {
        try {
            ProcessBuilder builder = new ProcessBuilder("cloudflared", "--version");
            Process process = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String versionString = reader.readLine();
            String version = versionString.split(" ")[2];
            Modflared.LOGGER.info("Cloudflared output: {}", (Object)versionString);
            Modflared.LOGGER.info("Cloudflared version {} is already installed on the system", (Object)version);
            return new LocalCloudflared(version);
        }
        catch (Throwable ignored) {
            Modflared.LOGGER.info("Cloudflared is not installed on the system. Downloading it if necessary...");
            return null;
        }
    }
}

