/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model.data;

import com.crashstudios.crashcore.model.data.AnimationInstant;
import com.crashstudios.crashcore.model.data.AnimationValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AnimationElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String id;
    public List<AnimationInstant> timeline;

    public AnimationElement(String id) {
        this.id = id;
        this.timeline = new ArrayList<AnimationInstant>();
    }

    public Object getProperty(Object baseValue, String property, int tick) {
        PropertyInfo before;
        block46: {
            PropertyInfo after;
            block47: {
                PropertyInfo beforePrev = null;
                before = null;
                after = null;
                PropertyInfo afterNext = null;
                int i = 0;
                block24: while (i < this.timeline.size()) {
                    AnimationValue value;
                    AnimationInstant instant = this.timeline.get(i);
                    if (instant.tick <= tick) {
                        value = instant.properties.get(property);
                        if (value != null) {
                            beforePrev = before;
                            before = new PropertyInfo(value.value, value.interpolation, instant.tick);
                        }
                    } else {
                        value = instant.properties.get(property);
                        if (value != null) {
                            after = new PropertyInfo(value.value, value.interpolation, instant.tick);
                            int j = i + 1;
                            while (j < this.timeline.size()) {
                                AnimationInstant nextInstant = this.timeline.get(j);
                                if (nextInstant.properties != null && nextInstant.properties.containsKey(property)) {
                                    AnimationValue nextValue = nextInstant.properties.get(property);
                                    afterNext = new PropertyInfo(nextValue.value, nextValue.interpolation, nextInstant.tick);
                                    break block24;
                                }
                                ++j;
                            }
                            break;
                        }
                    }
                    ++i;
                }
                if (after == null) break block46;
                if (before == null) {
                    before = new PropertyInfo(baseValue, "linear", 0);
                }
                if (!"catmullrom".equals(after.interpolation)) break block47;
                switch (property) {
                    case "offset": 
                    case "rotation": 
                    case "scale": 
                    case "position": {
                        return AnimationElement.interpolateCatmullRomArray(tick, beforePrev, before, after, afterNext);
                    }
                    case "model_id": 
                    case "item_id": {
                        return before.value;
                    }
                }
                return AnimationElement.interpolateCatmullRom(tick, beforePrev, before, after, afterNext);
            }
            double fade = AnimationElement.interpolate(before.tick, after.tick, after.interpolation, tick);
            switch (property) {
                case "offset": 
                case "rotation": 
                case "scale": 
                case "position": {
                    double[] beforeArr = (double[])before.value;
                    double[] afterArr = (double[])after.value;
                    double[] result = new double[beforeArr.length];
                    int i = 0;
                    while (i < beforeArr.length) {
                        result[i] = beforeArr[i] + (afterArr[i] - beforeArr[i]) * fade;
                        ++i;
                    }
                    return result;
                }
                case "model_id": 
                case "item_id": {
                    return before.value;
                }
            }
            double beforeVal = ((Number)before.value).doubleValue();
            double afterVal = ((Number)after.value).doubleValue();
            return beforeVal + (afterVal - beforeVal) * fade;
        }
        if (before != null) {
            return before.value;
        }
        return null;
    }

    private static double interpolate(int start, int end, String interpolation, int tick) {
        switch (interpolation) {
            case "linear": {
                return AnimationElement.linear(start, end, tick);
            }
            case "sine-in": {
                return AnimationElement.easeInSine(start, end, tick);
            }
            case "sine-out": {
                return AnimationElement.easeOutSine(start, end, tick);
            }
            case "sine-in-out": {
                return AnimationElement.easeInOutSine(start, end, tick);
            }
            case "cubic-in": {
                return AnimationElement.easeInCubic(start, end, tick);
            }
            case "cubic-out": {
                return AnimationElement.easeOutCubic(start, end, tick);
            }
            case "cubic-in-out": {
                return AnimationElement.easeInOutCubic(start, end, tick);
            }
            case "expo-in": {
                return AnimationElement.easeInExpo(start, end, tick);
            }
            case "expo-out": {
                return AnimationElement.easeOutExpo(start, end, tick);
            }
            case "expo-in-out": {
                return AnimationElement.easeInOutExpo(start, end, tick);
            }
            case "back-in": {
                return AnimationElement.easeInBack(start, end, tick);
            }
            case "back-out": {
                return AnimationElement.easeOutBack(start, end, tick);
            }
            case "back-in-out": {
                return AnimationElement.easeInOutBack(start, end, tick);
            }
            case "elastic-in": {
                return AnimationElement.easeInElastic(start, end, tick);
            }
            case "elastic-out": {
                return AnimationElement.easeOutElastic(start, end, tick);
            }
            case "elastic-in-out": {
                return AnimationElement.easeInOutElastic(start, end, tick);
            }
            case "bounce-in": {
                return AnimationElement.easeInBounce(start, end, tick);
            }
            case "bounce-out": {
                return AnimationElement.easeOutBounce(start, end, tick);
            }
            case "bounce-in-out": {
                return AnimationElement.easeInOutBounce(start, end, tick);
            }
        }
        return 0.0;
    }

    private static double linear(int start, int end, int current) {
        double duration = end - start;
        double offset = current - start;
        double x = duration == 0.0 ? 0.0 : offset / duration;
        return x;
    }

    private static double easeInSine(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return 1.0 - Math.cos(x * Math.PI / 2.0);
    }

    private static double easeOutSine(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return Math.sin(x * Math.PI / 2.0);
    }

    private static double easeInOutSine(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return -(Math.cos(Math.PI * x) - 1.0) / 2.0;
    }

    private static double easeInCubic(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return x * x * x;
    }

    private static double easeOutCubic(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return 1.0 - Math.pow(1.0 - x, 3.0);
    }

    private static double easeInOutCubic(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
    }

    private static double easeInExpo(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
    }

    private static double easeOutExpo(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return x == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x);
    }

    private static double easeInOutExpo(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return x < 0.5 ? Math.pow(2.0, 20.0 * x - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * x + 10.0)) / 2.0;
    }

    private static double easeInBack(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        double c1 = 1.70158;
        double c3 = 2.70158;
        return 2.70158 * x * x * x - 1.70158 * x * x;
    }

    private static double easeOutBack(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        double c1 = 1.70158;
        double c3 = 2.70158;
        return 1.0 + 2.70158 * Math.pow(x - 1.0, 3.0) + 1.70158 * Math.pow(x - 1.0, 2.0);
    }

    private static double easeInOutBack(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        double c1 = 1.70158;
        double c2 = 2.5949095;
        return x < 0.5 ? Math.pow(2.0 * x, 2.0) * (7.189819 * x - 2.5949095) / 2.0 : (Math.pow(2.0 * x - 2.0, 2.0) * (3.5949095 * (x * 2.0 - 2.0) + 2.5949095) + 2.0) / 2.0;
    }

    private static double easeInElastic(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        double c4 = 2.0943951023931953;
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * 2.0943951023931953);
    }

    private static double easeOutElastic(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        double c4 = 2.0943951023931953;
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * 2.0943951023931953) + 1.0;
    }

    private static double easeInOutElastic(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        double c5 = 1.3962634015954636;
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return x < 0.5 ? -(Math.pow(2.0, 20.0 * x - 10.0) * Math.sin((20.0 * x - 11.125) * 1.3962634015954636)) / 2.0 : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * 1.3962634015954636) / 2.0 + 1.0;
    }

    private static double easeInBounce(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return 1.0 - AnimationElement.easeOutBounce_(1.0 - x);
    }

    private static double easeOutBounce(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return AnimationElement.easeOutBounce_(x);
    }

    private static double easeOutBounce_(double x) {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (x < 0.36363636363636365) {
            return 7.5625 * x * x;
        }
        if (x < 0.7272727272727273) {
            return 7.5625 * (x -= 0.5454545454545454) * x + 0.75;
        }
        if (x < 0.9090909090909091) {
            return 7.5625 * (x -= 0.8181818181818182) * x + 0.9375;
        }
        return 7.5625 * (x -= 0.9545454545454546) * x + 0.984375;
    }

    private static double easeInOutBounce(int start, int end, int current) {
        double x = AnimationElement.linear(start, end, current);
        return x < 0.5 ? (1.0 - AnimationElement.easeOutBounce_(1.0 - 2.0 * x)) / 2.0 : (1.0 + AnimationElement.easeOutBounce_(2.0 * x - 1.0)) / 2.0;
    }

    private static double[] interpolateCatmullRomArray(int t, PropertyInfo p0, PropertyInfo p1, PropertyInfo p2, PropertyInfo p3) {
        double[] arr1 = (double[])p1.value;
        double[] result = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            double value0 = p0 != null ? ((double[])p0.value)[i] : arr1[i];
            double value1 = arr1[i];
            double value2 = ((double[])p2.value)[i];
            double value3 = p3 != null ? ((double[])p3.value)[i] : value2;
            result[i] = AnimationElement.interpolateCatmullRom(t, new PropertyInfo(value0, null, p1.tick), new PropertyInfo(value1, null, p1.tick), new PropertyInfo(value2, null, p2.tick), new PropertyInfo(value3, null, p2.tick));
            ++i;
        }
        return result;
    }

    private static double interpolateCatmullRom(int t, PropertyInfo p0, PropertyInfo p1, PropertyInfo p2, PropertyInfo p3) {
        if (p1 == null || p2 == null) {
            return p1 != null ? ((Number)p1.value).doubleValue() : 0.0;
        }
        int t1 = p1.tick;
        int t2 = p2.tick;
        if (t1 == t2) {
            return ((Number)p1.value).doubleValue();
        }
        if (t <= t1) {
            return ((Number)p1.value).doubleValue();
        }
        if (t >= t2) {
            return ((Number)p2.value).doubleValue();
        }
        double val0 = p0 != null ? ((Number)p0.value).doubleValue() : ((Number)p1.value).doubleValue();
        double val1 = ((Number)p1.value).doubleValue();
        double val2 = ((Number)p2.value).doubleValue();
        double val3 = p3 != null ? ((Number)p3.value).doubleValue() : val2;
        double u = (double)(t - t1) / (double)(t2 - t1);
        double u2 = u * u;
        double u3 = u * u * u;
        double result = 0.5 * (2.0 * val1 + (-val0 + val2) * u + (2.0 * val0 - 5.0 * val1 + 4.0 * val2 - val3) * u2 + (-val0 + 3.0 * val1 - 3.0 * val2 + val3) * u3);
        return result;
    }

    public static class PropertyInfo {
        Object value;
        String interpolation;
        int tick;

        PropertyInfo(Object value, String interpolation, int tick) {
            this.value = value;
            this.interpolation = interpolation;
            this.tick = tick;
        }
    }
}

