/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.packet;

import com.crashstudios.crashcore.packet.ChannelListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class ChannelManager {
    protected static HashMap<NamespacedKey, ChannelListener> listeners = new HashMap();
    protected static Class<?> craftServerClass;
    protected static Method handleServerMethod;
    protected static Class<?> craftWorldClass;
    protected static Method handleWorldMethod;
    protected static Class<?> craftPlayerClass;
    protected static Method handlePlayerMethod;
    protected static Field playerConnectionField;
    protected static Field networkField;
    protected static Method sendPacketMethod;

    public static void addListener(NamespacedKey key, ChannelListener listener) {
        listeners.put(key, listener);
    }

    public static void removeListener(NamespacedKey key) {
        listeners.remove(key);
    }

    public static Object getServer() {
        try {
            if (craftServerClass == null) {
                craftServerClass = ChannelManager.getNMSClass("org.bukkit.craftbukkit.", "CraftServer");
                handleServerMethod = craftServerClass.getMethod("getHandle", new Class[0]);
            }
            return handleServerMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WorldServer getWorldServer(World world) {
        try {
            if (craftWorldClass == null) {
                craftWorldClass = ChannelManager.getNMSClass("org.bukkit.craftbukkit.", "CraftWorld");
                handleWorldMethod = craftWorldClass.getMethod("getHandle", new Class[0]);
            }
            return (WorldServer)handleWorldMethod.invoke((Object)world, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EntityPlayer getEntityPlayer(Player player) {
        try {
            if (craftPlayerClass == null) {
                craftPlayerClass = ChannelManager.getNMSClass("org.bukkit.craftbukkit.", "entity.CraftPlayer");
                handlePlayerMethod = craftPlayerClass.getMethod("getHandle", new Class[0]);
            }
            return (EntityPlayer)handlePlayerMethod.invoke((Object)player, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PlayerConnection getPlayerConnection(Player player) {
        try {
            if (playerConnectionField == null) {
                Field[] fieldArray = EntityPlayer.class.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    if (f.getType() == PlayerConnection.class) {
                        playerConnectionField = f;
                        break;
                    }
                    ++n2;
                }
            }
            return (PlayerConnection)playerConnectionField.get(ChannelManager.getEntityPlayer(player));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NetworkManager getNetworkManager(Player player) {
        try {
            if (networkField == null) {
                Field[] fieldArray = PlayerConnection.class.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    if (f.getType() == NetworkManager.class) {
                        networkField = f;
                        networkField.setAccessible(true);
                        break;
                    }
                    ++n2;
                }
            }
            return (NetworkManager)networkField.get(ChannelManager.getPlayerConnection(player));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        try {
            if (sendPacketMethod == null) {
                sendPacketMethod = PlayerConnection.class.getMethod("a", Packet.class);
            }
            sendPacketMethod.invoke((Object)ChannelManager.getPlayerConnection(player), packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Class<?> getNMSClass(String prefix, String nmsClassString) throws ClassNotFoundException {
        String pkgname = Bukkit.getServer().getClass().getPackage().getName();
        if (pkgname.equalsIgnoreCase("org.bukkit.craftbukkit")) {
            return Class.forName(prefix + nmsClassString);
        }
        String version = pkgname.replace(".", ",").split(",")[3] + ".";
        String name = prefix + version + nmsClassString;
        return Class.forName(name);
    }
}

