/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script.interaction;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.CustomEvent;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.script.Vector;
import com.crashstudios.crashcore.script.interaction.LeftClickListener;
import com.crashstudios.crashcore.script.interaction.RightClickListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InteractionListener
implements Listener {
    public static HashMap<Interaction, LeftClickListener> leftClicksListener = new HashMap();
    public static HashMap<Interaction, RightClickListener> rightClicksListener = new HashMap();

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent e) {
        Entity ent = e.getRightClicked();
        PersistentDataContainer cont = ent.getPersistentDataContainer();
        Object[] args = new Object[]{e.getPlayer(), e.getPlayer().getEquipment().getItem(e.getHand()), ent};
        InteractionListener.callEvent(cont, args, "rightclickinteraction");
        if (ent.getType() != EntityType.INTERACTION) {
            return;
        }
        RightClickListener listener = rightClicksListener.get(ent);
        if (listener != null) {
            listener.onClick(e.getPlayer(), e.getPlayer().getEquipment().getItem(e.getHand()));
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getDamager();
        Entity ent = e.getEntity();
        PersistentDataContainer cont = ent.getPersistentDataContainer();
        Object[] args = new Object[]{p, p.getEquipment().getItemInMainHand(), ent};
        InteractionListener.callEvent(cont, args, "leftclickinteraction");
        if (e.getEntityType() != EntityType.INTERACTION) {
            return;
        }
        LeftClickListener listener = leftClicksListener.get(ent);
        if (listener != null) {
            listener.onClick(p, p.getEquipment().getItemInMainHand());
        }
    }

    public static void callEvent(PersistentDataContainer cont, Object[] args, String type) {
        String data = "";
        if (cont.has(CustomNodes.CUSTOMEVENTKEY, PersistentDataType.STRING)) {
            data = (String)cont.get(CustomNodes.CUSTOMEVENTKEY, PersistentDataType.STRING);
        }
        List list = data.length() > 0 ? Arrays.asList(data.substring(1, data.length() - 1).split("\ue315\ue315")) : List.of();
        for (CustomEvent file : CustomNodes.customevent.values()) {
            for (CompiledScript.Node node : file.getScript().startingNodes) {
                if (!node.type.equals(type) || !((CompiledScript.Data)node.input[0]).data.isEmpty() && !list.contains(((CompiledScript.Data)node.input[0]).data)) continue;
                node.start(new HashMap<CompiledScript.Node, Pins>(), args);
            }
        }
    }

    public static void callEvent(Object[] args, String type) {
        for (CustomEvent file : CustomNodes.customevent.values()) {
            for (CompiledScript.Node node : file.getScript().startingNodes) {
                if (!node.type.equals(type)) continue;
                node.start(new HashMap<CompiledScript.Node, Pins>(), args);
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        Entity ent = e.getEntity();
        InteractionListener.callEvent(ent.getPersistentDataContainer(), new Object[]{ent, e, e.getDamage()}, "damageaction");
    }

    @EventHandler
    public void onDeath(EntityDeathEvent e) {
        LivingEntity ent = e.getEntity();
        InteractionListener.callEvent(ent.getPersistentDataContainer(), new Object[]{ent}, "deathaction");
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Player p = e.getPlayer();
        Bukkit.getScheduler().runTask((Plugin)Main.INSTANCE, () -> InteractionListener.callEvent(p.getPersistentDataContainer(), new Object[]{p}, "respawnaction"));
    }

    @EventHandler
    public void onAttack(EntityDamageByEntityEvent e) {
        Entity ent = e.getEntity();
        InteractionListener.callEvent(ent.getPersistentDataContainer(), new Object[]{ent, e, e.getDamage(), e.getDamager()}, "attackedaction");
        ent = e.getDamager();
        InteractionListener.callEvent(ent.getPersistentDataContainer(), new Object[]{ent, e, e.getDamage(), e.getEntity()}, "attackaction");
    }

    @EventHandler
    public void onJoin(final PlayerJoinEvent e) {
        InteractionListener.callEvent(new Object[]{e.getPlayer(), new Cancellable(){

            public void setCancelled(boolean cancel) {
                if (cancel) {
                    e.setJoinMessage(null);
                }
            }

            public boolean isCancelled() {
                return false;
            }
        }}, "joinaction");
    }

    @EventHandler
    public void onQuit(final PlayerQuitEvent e) {
        InteractionListener.callEvent(new Object[]{e.getPlayer(), new Cancellable(){

            public void setCancelled(boolean cancel) {
                if (cancel) {
                    e.setQuitMessage(null);
                }
            }

            public boolean isCancelled() {
                return false;
            }
        }}, "quitaction");
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        InteractionListener.callEvent(new Object[]{e.getPlayer(), e, e.getMessage()}, "chataction");
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        InteractionListener.callEvent(p.getPersistentDataContainer(), new Object[]{p, e, new Vector(e.getFrom()), new Vector(e.getTo())}, "moveaction");
    }

    @EventHandler
    public void onExplode(EntityExplodeEvent e) {
        InteractionListener.callEvent(new Object[]{e, e.getEntity().getWorld(), new Vector(e.getLocation()), (double)e.getYield(), e.blockList().stream().map(b -> {
            Location l = b.getLocation();
            return l.getX() + " " + l.getY() + " " + l.getZ();
        }).collect(Collectors.toList()), Boolean.TRUE, e.getEntity()}, "explodeaction");
    }

    @EventHandler
    public void onExplode(BlockExplodeEvent e) {
        Object[] objectArray = new Object[7];
        objectArray[0] = e;
        objectArray[1] = e.getBlock().getWorld();
        objectArray[2] = new Vector(e.getBlock().getLocation());
        objectArray[3] = (double)e.getYield();
        objectArray[4] = e.blockList().stream().map(b -> {
            Location l = b.getLocation();
            return l.getX() + " " + l.getY() + " " + l.getZ();
        }).collect(Collectors.toList());
        objectArray[5] = Boolean.FALSE;
        InteractionListener.callEvent(objectArray, "explodeaction");
    }
}

