/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore;

import com.crashstudios.crashcore.bridge.CitizensListener;
import com.crashstudios.crashcore.bridge.LuckPermsManager;
import com.crashstudios.crashcore.bridge.WorldGuardManager;
import com.crashstudios.crashcore.commands.CrashConnectCommand;
import com.crashstudios.crashcore.commands.CustomParticlesCommand;
import com.crashstudios.crashcore.commands.ReloadResourcepackCommand;
import com.crashstudios.crashcore.config.CustomConfigManager;
import com.crashstudios.crashcore.console.ConsoleFilter;
import com.crashstudios.crashcore.debug.DebugManager;
import com.crashstudios.crashcore.discord.DiscordBotManager;
import com.crashstudios.crashcore.model.CustomModelCommand;
import com.crashstudios.crashcore.model.CustomModelListener;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.ModelListener;
import com.crashstudios.crashcore.model.ModelUtils_1_19_4;
import com.crashstudios.crashcore.model.ModelUtils_1_20_5;
import com.crashstudios.crashcore.model.Scripts;
import com.crashstudios.crashcore.net.ConnectionClient;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.net.RequestPacketListener;
import com.crashstudios.crashcore.packet.PacketManager;
import com.crashstudios.crashcore.packet.PacketPlayerManagerCrashPanel;
import com.crashstudios.crashcore.packet.PlayerChannelListener;
import com.crashstudios.crashcore.particles.ParticleEditor;
import com.crashstudios.crashcore.pkg.PackageManager;
import com.crashstudios.crashcore.player.PlayerData;
import com.crashstudios.crashcore.player.PlayerDatas;
import com.crashstudios.crashcore.player.PlayerList;
import com.crashstudios.crashcore.player.PlayerListener;
import com.crashstudios.crashcore.player.PlayerMessage;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.script.FunctionsManager;
import com.crashstudios.crashcore.script.interaction.InteractionListener;
import com.crashstudios.crashcore.script.inv.InventoryListener;
import com.crashstudios.crashcore.script.miscellaneous.ParticleUtils;
import com.crashstudios.crashcore.script.miscellaneous.ParticleUtils1_19;
import com.crashstudios.crashcore.script.miscellaneous.ParticleUtils1_21;
import com.crashstudios.crashcore.storage.ConfigManager;
import com.crashstudios.crashcore.storage.SLAPI;
import com.crashstudios.crashcore.utilities.ColorUtils;
import com.crashstudios.crashcore.utilities.VersionChecker;
import com.crashstudios.crashcore.utilities.gui.GuiListener;
import com.crashstudios.crashcore.versions.IUtils;
import com.crashstudios.crashcore.versions.Utils1_19;
import com.crashstudios.crashcore.versions.Utils1_20;
import com.crashstudios.crashcore.versions.Utils1_21_3;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.management.OperatingSystemMXBean;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static long LAST_START_TIME = System.currentTimeMillis();
    public static Main INSTANCE;
    public static String token;
    public static Thread connectionThread;
    public static String upgrade;
    private static boolean debug;
    public static IUtils utils;

    static {
        debug = false;
    }

    public Main() {
        ConsoleFilter filter = new ConsoleFilter();
        ((Logger)LogManager.getRootLogger()).addFilter((Filter)filter);
    }

    public void onLoad() {
        INSTANCE = this;
        if (new File(this.getDataFolder(), "debug_local").exists()) {
            debug = true;
        }
    }

    public static boolean getDebug() {
        return debug;
    }

    public void onEnable() {
        File packFile;
        File playerlistFolder;
        File userdatasFolder;
        VersionChecker.checkVersion("CrashCore", "4", "0.6.2 BETA");
        switch (Main.getMinecraftVersion()) {
            case "1.19": 
            case "1.19.1": 
            case "1.19.2": 
            case "1.19.3": 
            case "1.19.4": {
                utils = new Utils1_19();
                ModelEditor.modelUtils = new ModelUtils_1_19_4();
                ParticleUtils.utils = new ParticleUtils1_19();
                break;
            }
            case "1.20": 
            case "1.20.1": 
            case "1.20.2": 
            case "1.20.3": 
            case "1.20.4": {
                utils = new Utils1_20();
                ModelEditor.modelUtils = new ModelUtils_1_19_4();
                ParticleUtils.utils = new ParticleUtils1_19();
                break;
            }
            case "1.20.5": 
            case "1.20.6": {
                utils = new Utils1_20();
                ModelEditor.modelUtils = new ModelUtils_1_20_5();
                ParticleUtils.utils = new ParticleUtils1_19();
                break;
            }
            case "1.21": 
            case "1.21.1": 
            case "1.21.2": {
                utils = new Utils1_20();
                ModelEditor.modelUtils = new ModelUtils_1_20_5();
                ParticleUtils.utils = new ParticleUtils1_21();
                break;
            }
            default: {
                utils = new Utils1_21_3();
                ModelEditor.modelUtils = new ModelUtils_1_20_5();
                ParticleUtils.utils = new ParticleUtils1_21();
            }
        }
        File playerdatasFolder = new File(INSTANCE.getDataFolder(), "playerdatas");
        if (!playerdatasFolder.exists()) {
            playerdatasFolder.mkdirs();
        }
        if (!(userdatasFolder = new File(INSTANCE.getDataFolder(), "userdatas")).exists()) {
            userdatasFolder.mkdirs();
        }
        if (!(playerlistFolder = new File(INSTANCE.getDataFolder(), "playerlist")).exists()) {
            playerlistFolder.mkdirs();
            PlayerList.saveNames();
            PlayerList.saveRecent();
            PlayerList.savePlaytime();
            PlayerList.saveAlphabetic();
        } else {
            PlayerList.loadNames();
            PlayerList.loadRecent();
            PlayerList.loadPlaytime();
            PlayerList.loadAlphabetic();
        }
        File tokenFile = new File(this.getDataFolder(), "token.dat");
        if (tokenFile.exists()) {
            try {
                token = (String)SLAPI.load(tokenFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((packFile = new File(this.getDataFolder(), "pack.dat")).exists()) {
            try {
                PlayerListener.resourcePack = (Boolean)SLAPI.load(packFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PacketManager.manager = new PacketPlayerManagerCrashPanel();
        FunctionsManager.loadBase();
        CustomNodes.load();
        PackageManager.load();
        ModelEditor.load();
        Scripts.load();
        DiscordBotManager.load();
        ParticleEditor.load();
        CustomConfigManager.load();
        DebugManager.load();
        File serverDataFile = new File(this.getDataFolder(), "ServerProperties.dat");
        if (serverDataFile.exists()) {
            try {
                FunctionsManager.serverData = (HashMap)SLAPI.load(serverDataFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                SLAPI.save(FunctionsManager.serverData, serverDataFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File resourcepack = new File(INSTANCE.getDataFolder(), "resourcepack.txt");
        if (resourcepack.exists()) {
            try {
                PlayerListener.resourcePackUrl = Files.readString(resourcepack.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        connectionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConnectionClient.test(debug);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        connectionThread.start();
        final OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (!ConnectionClientHandler.channelActivated) {
                    return;
                }
                JsonObject json = new JsonObject();
                if (Bukkit.getVersion().toLowerCase().contains("spigot")) {
                    json.addProperty("software", Bukkit.getName() + " (Spigot) " + Bukkit.getBukkitVersion());
                } else {
                    json.addProperty("software", Bukkit.getName() + " " + Bukkit.getBukkitVersion());
                }
                json.addProperty("cpu", "" + (int)(osBean.getSystemCpuLoad() * 100.0));
                json.addProperty("cpumax", "" + osBean.getAvailableProcessors() * 100);
                json.addProperty("ram", String.valueOf(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
                json.addProperty("rammax", String.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
                json.addProperty("tps", (Number)MinecraftServer.getServer().recentTps[0]);
                json.addProperty("tpsmax", "20");
                json.addProperty("uptime", "" + (System.currentTimeMillis() - LAST_START_TIME) / 1000L);
                json.addProperty("players", (Number)Bukkit.getOnlinePlayers().size());
                json.addProperty("playersmax", (Number)Bukkit.getMaxPlayers());
                ConnectionClientHandler.sendInfoPacket("generalinformation", json);
            }
        }, 200L, 200L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (!ConnectionClientHandler.channelActivated) {
                    return;
                }
                JsonObject json = new JsonObject();
                json.addProperty("chart1", "" + (int)(osBean.getSystemCpuLoad() * 100.0));
                json.addProperty("maxchart1", "" + osBean.getAvailableProcessors() * 100);
                json.addProperty("minchart1", "0");
                json.addProperty("chart2", String.valueOf(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
                json.addProperty("maxchart2", String.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
                json.addProperty("minchart2", "0");
                ConnectionClientHandler.sendInfoPacket("usagecharts", json);
            }
        }, 200L, 200L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (!ConnectionClientHandler.channelActivated) {
                    ConsoleFilter.newMessages.clear();
                    return;
                }
                if (ConsoleFilter.newMessages.size() > 0) {
                    JsonObject json = new JsonObject();
                    json.addProperty("init", Boolean.valueOf(false));
                    JsonArray array = new JsonArray();
                    for (PlayerMessage mex : ConsoleFilter.newMessages) {
                        JsonObject message = new JsonObject();
                        message.addProperty("dt", (Number)mex.getDatetime().toInstant(ZoneOffset.UTC).toEpochMilli());
                        message.addProperty("mx", mex.getMessage());
                        array.add((JsonElement)message);
                    }
                    ConsoleFilter.newMessages.clear();
                    json.add("data", (JsonElement)array);
                    ConnectionClientHandler.sendInfoPacket("console", json);
                }
            }
        }, 20L, 20L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    UUID uuid = p.getUniqueId();
                    PlayerList.recent.remove(uuid);
                    PlayerList.recent.add(uuid);
                    PlayerList.saveRecent();
                }
            }
        }, 300L, 300L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                HashMap<UUID, Integer> sortedPlayers = PlayerList.sortByValue(PlayerList.playtime);
                PlayerList.playtime = sortedPlayers;
                PlayerList.savePlaytime();
            }
        }, 1200L, 1200L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){
            private int i = 0;

            @Override
            public void run() {
                PlayerData data;
                UUID uuid;
                for (Player p : Bukkit.getOnlinePlayers()) {
                    uuid = p.getUniqueId();
                    data = PlayerDatas.getPlayerData(uuid);
                    data.setTotalPlayTime(data.getTotalPlayTime() + 5L);
                    data.setLastPlayTime(data.getLastPlayTime() + 5L);
                }
                if (this.i > 12) {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        uuid = p.getUniqueId();
                        data = PlayerDatas.getPlayerData(uuid);
                        PlayerList.playtime.put(uuid, (int)data.getTotalPlayTime());
                        data.save();
                    }
                    this.i = 0;
                }
                ++this.i;
            }
        }, 100L, 100L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (Interaction i : new HashSet<Interaction>(InteractionListener.leftClicksListener.keySet())) {
                    if (!i.isDead()) continue;
                    InteractionListener.leftClicksListener.remove(i);
                }
                for (Interaction i : new HashSet<Interaction>(InteractionListener.rightClicksListener.keySet())) {
                    if (!i.isDead()) continue;
                    InteractionListener.rightClicksListener.remove(i);
                }
            }
        }, 1200L, 1200L);
        ConnectionClientHandler.requestPacketListeners.put("packmanager", new RequestPacketListener("packmanager"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                boolean data;
                ConfigManager.autopack = data = packet.get("info").getAsJsonObject().get("data").getAsBoolean();
                ConfigManager.save();
            }
        });
        if (new File(INSTANCE.getDataFolder(), "config.yml").exists()) {
            ConfigManager.load();
        }
        ConfigManager.save();
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerChannelListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InteractionListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CitizensListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new com.crashstudios.crashcore.script.player.PlayerListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CustomModelListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ModelListener(), (Plugin)this);
        this.getCommand("crashconnect").setExecutor((CommandExecutor)new CrashConnectCommand());
        this.getCommand("reloadresourcepack").setExecutor((CommandExecutor)new ReloadResourcepackCommand());
        this.getCommand("custommodel").setExecutor((CommandExecutor)new CustomModelCommand());
        this.getCommand("custommodel").setTabCompleter((TabCompleter)new CustomModelCommand());
        this.getCommand("customparticles").setExecutor((CommandExecutor)new CustomParticlesCommand());
        this.getCommand("customparticles").setTabCompleter((TabCompleter)new CustomParticlesCommand());
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            WorldGuardManager.init();
        }
        this.getServer().getPluginManager().getPlugin("ProtocolLib");
        if (this.getServer().getPluginManager().getPlugin("LuckPerms") != null) {
            LuckPermsManager.init();
        }
        ColorUtils.add(new ColorUtils());
        this.getLogger().info("CrashCore has started");
    }

    public void onDisable() {
        ConnectionClientHandler.addonsToUpdate.clear();
        ConnectionClient.group.shutdownGracefully();
    }

    public void addAddonsToUpdate(String id, String name) {
        ConnectionClientHandler.addonsToUpdate.add(id + "%%%" + name);
        ConnectionClientHandler.sendAddonToUpdate();
    }

    public static String getMinecraftVersion() {
        Matcher matcher = Pattern.compile("(\\(MC: )([\\d\\.]+)(\\))").matcher(Bukkit.getVersion());
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }
}

