/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.model.CustomModelData;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.Scripts;
import com.crashstudios.crashcore.model.data.BaseElement;
import com.crashstudios.crashcore.model.data.Group;
import com.crashstudios.crashcore.model.data.Model;
import com.crashstudios.crashcore.pkg.PackageIdsChange;
import com.crashstudios.crashcore.storage.SLAPI;
import java.io.File;
import java.util.List;
import java.util.UUID;

public class CustomModel {
    public CustomModelData data;

    public CustomModel(CustomModelData data) {
        this.data = data;
    }

    public CustomModel(UUID uuid) {
        this.data = new CustomModelData();
        this.data.uuid = uuid;
        this.data.name = "Custom_Model";
        UUID scriptUUID = UUID.randomUUID();
        this.data.scripts.add(scriptUUID);
        EditorFile2 script = new EditorFile2();
        Scripts.save(scriptUUID, script);
        Scripts.scripts.put(scriptUUID, script);
    }

    public String getElementName(String id) {
        return this.getElementName(id, this.data.outline);
    }

    public String getElementName(String id, List<BaseElement> content) {
        for (BaseElement element : content) {
            if (element.id.equals(id)) {
                return element.name;
            }
            if (!(element instanceof Group)) continue;
            return this.getElementName(id, ((Group)element).content);
        }
        return null;
    }

    public void save() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "models");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            SLAPI.save((Object)this.data, new File(folder, this.data.uuid.toString() + ".dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "models");
        try {
            new File(folder, this.data.uuid.toString() + ".dat").delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (UUID uuid : this.data.scripts) {
            Scripts.remove(uuid);
        }
        ModelEditor.models.remove(this.data.uuid);
    }

    public void updateModelId(PackageIdsChange change) {
        for (BaseElement element : this.data.outline) {
            if (element instanceof Model) {
                Model model = (Model)element;
                try {
                    int model_id = Integer.parseInt(model.model_id);
                    Integer newModelId = change.models.get(model_id + 2000000);
                    if (newModelId == null) continue;
                    model.model_id = "" + (newModelId - 2000000);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!(element instanceof Group)) continue;
            this.updateModelIdGroup((Group)element, change);
        }
    }

    private void updateModelIdGroup(Group group, PackageIdsChange change) {
        for (BaseElement element : group.content) {
            if (element instanceof Model) {
                Model model = (Model)element;
                try {
                    int model_id = Integer.parseInt(model.model_id);
                    Integer newModelId = change.models.get(model_id + 2000000);
                    if (newModelId == null) continue;
                    model.model_id = "" + (newModelId - 2000000);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!(element instanceof Group)) continue;
            this.updateModelIdGroup((Group)element, change);
        }
    }
}

