/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model;

import com.crashstudios.crashcore.model.BBModelFile;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.data.Animation;
import com.crashstudios.crashcore.model.data.AnimationValue;
import com.crashstudios.crashcore.model.data.BaseElement;
import com.crashstudios.crashcore.model.data.Collision;
import com.crashstudios.crashcore.model.data.Group;
import com.crashstudios.crashcore.model.data.Head;
import com.crashstudios.crashcore.model.data.Hitbox;
import com.crashstudios.crashcore.model.data.Item;
import com.crashstudios.crashcore.model.data.Model;
import com.crashstudios.crashcore.model.data.ModelFile;
import com.crashstudios.crashcore.model.data.Particle;
import com.crashstudios.crashcore.model.data.Sensor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CustomModelData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public UUID uuid;
    public String name;
    public List<BaseElement> outline = new ArrayList<BaseElement>();
    public List<ModelFile> models = new ArrayList<ModelFile>();
    public List<Animation> animations = new ArrayList<Animation>();
    public List<UUID> scripts = new ArrayList<UUID>();

    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(BaseElement.class, (Object)new BaseElementAdapter()).registerTypeAdapter(AnimationValue.class, (Object)new AnimationValueAdapter()).create();
    }

    public JsonObject toJson() {
        Gson gson = CustomModelData.createGson();
        JsonObject jsonObject = gson.toJsonTree((Object)this).getAsJsonObject();
        if (jsonObject.has("models")) {
            JsonArray modelsArray = jsonObject.getAsJsonArray("models");
            int i = 0;
            while (i < modelsArray.size()) {
                JsonObject modelFileJson = modelsArray.get(i).getAsJsonObject();
                if (modelFileJson.has("type") && "bbmodel".equals(modelFileJson.get("type").getAsString()) && modelFileJson.has("id")) {
                    try {
                        UUID modelId = UUID.fromString(modelFileJson.get("id").getAsString());
                        BBModelFile bbModel = ModelEditor.bbModels.get(modelId);
                        if (bbModel != null) {
                            modelFileJson.add("content", (JsonElement)bbModel.toJson().get("content").getAsJsonArray());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return jsonObject;
    }

    public static CustomModelData fromJson(JsonObject jsonObject) {
        Gson gson = CustomModelData.createGson();
        return (CustomModelData)gson.fromJson((JsonElement)jsonObject, CustomModelData.class);
    }

    private static class AnimationValueAdapter
    implements JsonDeserializer<AnimationValue>,
    JsonSerializer<AnimationValue> {
        private AnimationValueAdapter() {
        }

        public AnimationValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            AnimationValue result = new AnimationValue();
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                if (obj.has("value")) {
                    JsonElement valueElem = obj.get("value");
                    if (valueElem.isJsonArray()) {
                        JsonArray arr = valueElem.getAsJsonArray();
                        double[] intArr = new double[arr.size()];
                        int i = 0;
                        while (i < arr.size()) {
                            intArr[i] = arr.get(i).getAsDouble();
                            ++i;
                        }
                        result.value = intArr;
                    } else {
                        result.value = context.deserialize(valueElem, Object.class);
                    }
                }
                if (obj.has("interpolation")) {
                    result.interpolation = obj.get("interpolation").getAsString();
                }
            }
            return result;
        }

        public JsonElement serialize(AnimationValue src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            if (src.value != null) {
                obj.add("value", context.serialize(src.value));
            }
            if (src.interpolation != null) {
                obj.addProperty("interpolation", src.interpolation);
            }
            return obj;
        }
    }

    private static class BaseElementAdapter
    implements JsonSerializer<BaseElement>,
    JsonDeserializer<BaseElement> {
        private BaseElementAdapter() {
        }

        public JsonElement serialize(BaseElement src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src, src.getClass());
        }

        public BaseElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String type;
            JsonObject jsonObject = json.getAsJsonObject();
            switch (type = jsonObject.get("type").getAsString()) {
                case "group": {
                    return (BaseElement)context.deserialize(json, Group.class);
                }
                case "hitbox": {
                    return (BaseElement)context.deserialize(json, Hitbox.class);
                }
                case "particle": {
                    return (BaseElement)context.deserialize(json, Particle.class);
                }
                case "sensor": {
                    return (BaseElement)context.deserialize(json, Sensor.class);
                }
                case "model": {
                    return (BaseElement)context.deserialize(json, Model.class);
                }
                case "item": {
                    return (BaseElement)context.deserialize(json, Item.class);
                }
                case "head": {
                    return (BaseElement)context.deserialize(json, Head.class);
                }
                case "collision": {
                    return (BaseElement)context.deserialize(json, Collision.class);
                }
            }
            throw new JsonParseException("Tipo di elemento sconosciuto: " + type);
        }
    }
}

