/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.particles;

import com.crashstudios.crashcore.particles.ParticlePropertyValue;
import com.crashstudios.crashcore.particles.ParticleTimeline;
import com.crashstudios.crashcore.utilities.MathUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParticleEmitter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int id;
    public String name;
    public String emitter;
    public List<ParticleTimeline> timeline = new ArrayList<ParticleTimeline>();

    public Object getProperty(String property, double tick) {
        ParticleTimeline before = null;
        ParticleTimeline after = null;
        for (ParticleTimeline tl : this.timeline) {
            if (!tl.properties.containsKey(property)) continue;
            if ((double)tl.tick <= tick) {
                if (before != null && tl.tick <= before.tick) continue;
                before = tl;
                continue;
            }
            if (after != null && tl.tick >= after.tick) continue;
            after = tl;
            break;
        }
        if (before == null) {
            return null;
        }
        ParticlePropertyValue beforeVal = before.properties.get(property);
        if (after == null) {
            return beforeVal.value;
        }
        ParticlePropertyValue afterVal = after.properties.get(property);
        if (beforeVal == null || afterVal == null) {
            return beforeVal.value;
        }
        double fade = this.calculateFade(before.tick, after.tick, afterVal.interpolation, tick);
        if (this.isVectorProperty(property)) {
            MathUtil.Vector3D bv = (MathUtil.Vector3D)beforeVal.value;
            MathUtil.Vector3D av = (MathUtil.Vector3D)afterVal.value;
            return new MathUtil.Vector3D(this.interpolateDouble(bv.x, av.x, fade), this.interpolateDouble(bv.y, av.y, fade), this.interpolateDouble(bv.z, av.z, fade));
        }
        return this.interpolateNumber(((Number)beforeVal.value).doubleValue(), ((Number)afterVal.value).doubleValue(), fade);
    }

    private boolean isVectorProperty(String property) {
        return Arrays.asList("direction", "position", "rotation", "offset", "scale", "color").contains(property);
    }

    private double calculateFade(int beforeTick, int afterTick, String interpolation, double currentTick) {
        if (beforeTick == afterTick) {
            return 0.0;
        }
        double t = (currentTick - (double)beforeTick) / (double)(afterTick - beforeTick);
        if (interpolation == null) {
            interpolation = "linear";
        }
        switch (interpolation.toLowerCase()) {
            case "sine-in": {
                return 1.0 - Math.cos(t * Math.PI / 2.0);
            }
            case "sine-out": {
                return Math.sin(t * Math.PI / 2.0);
            }
            case "sine-in-out": {
                return -(Math.cos(Math.PI * t) - 1.0) / 2.0;
            }
            case "cubic-in": {
                return t * t * t;
            }
            case "cubic-out": {
                return 1.0 - Math.pow(1.0 - t, 3.0);
            }
            case "cubic-in-out": {
                return t < 0.5 ? 4.0 * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0;
            }
            case "expo-in": {
                if (t == 0.0) {
                    return 0.0;
                }
                return Math.pow(2.0, 10.0 * t - 10.0);
            }
            case "expo-out": {
                if (t == 1.0) {
                    return 1.0;
                }
                return 1.0 - Math.pow(2.0, -10.0 * t);
            }
            case "expo-in-out": {
                if (t == 0.0) {
                    return 0.0;
                }
                if (t == 1.0) {
                    return 1.0;
                }
                return t < 0.5 ? Math.pow(2.0, 20.0 * t - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * t + 10.0)) / 2.0;
            }
            case "back-in": {
                double c1 = 1.70158;
                double c3 = c1 + 1.0;
                return c3 * t * t * t - c1 * t * t;
            }
            case "back-out": {
                double c1 = 1.70158;
                double c3 = c1 + 1.0;
                return 1.0 + c3 * Math.pow(t - 1.0, 3.0) + c1 * Math.pow(t - 1.0, 2.0);
            }
            case "back-in-out": {
                double c1 = 1.70158;
                double c2 = c1 * 1.525;
                if (t < 0.5) {
                    return Math.pow(2.0 * t, 2.0) * ((c2 + 1.0) * 2.0 * t - c2) / 2.0;
                }
                return (Math.pow(2.0 * t - 2.0, 2.0) * ((c2 + 1.0) * (2.0 * t - 2.0) + c2) + 2.0) / 2.0;
            }
            case "elastic-in": {
                if (t == 0.0) {
                    return 0.0;
                }
                if (t == 1.0) {
                    return 1.0;
                }
                double c4 = 2.0943951023931953;
                return -Math.pow(2.0, 10.0 * t - 10.0) * Math.sin((t * 10.0 - 10.75) * c4);
            }
            case "elastic-out": {
                if (t == 0.0) {
                    return 0.0;
                }
                if (t == 1.0) {
                    return 1.0;
                }
                double c4 = 2.0943951023931953;
                return Math.pow(2.0, -10.0 * t) * Math.sin((t * 10.0 - 0.75) * c4) + 1.0;
            }
            case "elastic-in-out": {
                if (t == 0.0) {
                    return 0.0;
                }
                if (t == 1.0) {
                    return 1.0;
                }
                double c5 = 1.3962634015954636;
                if (t < 0.5) {
                    return -(Math.pow(2.0, 20.0 * t - 10.0) * Math.sin((20.0 * t - 11.125) * c5)) / 2.0;
                }
                return Math.pow(2.0, -20.0 * t + 10.0) * Math.sin((20.0 * t - 11.125) * c5) / 2.0 + 1.0;
            }
            case "bounce-in": {
                return 1.0 - this.easeOutBounce(1.0 - t);
            }
            case "bounce-out": {
                return this.easeOutBounce(t);
            }
            case "bounce-in-out": {
                if (t < 0.5) {
                    return (1.0 - this.easeOutBounce(1.0 - 2.0 * t)) / 2.0;
                }
                return (1.0 + this.easeOutBounce(2.0 * t - 1.0)) / 2.0;
            }
        }
        return t;
    }

    private double easeOutBounce(double x) {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (x < 0.36363636363636365) {
            return 7.5625 * x * x;
        }
        if (x < 0.7272727272727273) {
            return 7.5625 * (x -= 0.5454545454545454) * x + 0.75;
        }
        if (x < 0.9090909090909091) {
            return 7.5625 * (x -= 0.8181818181818182) * x + 0.9375;
        }
        return 7.5625 * (x -= 0.9545454545454546) * x + 0.984375;
    }

    private double interpolateDouble(double a, double b, double fade) {
        return a + (b - a) * fade;
    }

    private Object interpolateNumber(double a, double b, double fade) {
        return a + (b - a) * fade;
    }
}

