/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.storage;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PluginDownloader {
    public static void downloadPlugin(String id) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.INSTANCE, () -> {
            JsonObject json;
            try {
                String str = IOUtils.toString((URL)new URL("https://crashplugin.com/api/plugin/" + id + "/info"), (Charset)Charset.forName("UTF-8"));
                json = (JsonObject)ConnectionClientHandler.gson.fromJson(str, JsonObject.class);
            }
            catch (IOException e) {
                return;
            }
            String name = json.get("name").getAsString();
            File file = new File("plugins", name + ".jar");
            boolean update = false;
            if (file.exists()) {
                file = new File(Main.INSTANCE.getServer().getUpdateFolderFile(), name + ".jar");
                update = true;
            }
            try {
                Main.INSTANCE.getServer().getUpdateFolderFile().mkdir();
                URL url = Main.upgrade != null ? new URL("https://crashplugin.com/catalog/" + id + "/download?prorequestid=" + ConnectionClientHandler.proRequestID) : new URL("https://crashplugin.com/catalog/" + id + "/download");
                ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                fileOutputStream.close();
                if (update) {
                    Main.INSTANCE.getLogger().info(name + " has been updated!");
                } else {
                    Main.INSTANCE.getLogger().info(name + " has been downloaded!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

