/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.utilities.gson;

import com.crashstudios.crashcore.particles.ParticlePropertyValue;
import com.crashstudios.crashcore.utilities.MathUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;

public class ParticlePropertyValueDeserializer
implements JsonDeserializer<ParticlePropertyValue> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParticlePropertyValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonElement valueElement;
        JsonObject jsonObject = json.getAsJsonObject();
        ParticlePropertyValue propertyValue = new ParticlePropertyValue();
        if (jsonObject.has("interpolation")) {
            propertyValue.interpolation = jsonObject.get("interpolation").getAsString();
        }
        if ((valueElement = jsonObject.get("value")).isJsonPrimitive()) {
            JsonPrimitive primitive = valueElement.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                propertyValue.value = primitive.getAsDouble();
                return propertyValue;
            } else {
                if (!primitive.isString()) return propertyValue;
                propertyValue.value = primitive.getAsString();
            }
            return propertyValue;
        } else {
            if (!valueElement.isJsonObject()) throw new JsonParseException("Unsupported type for 'value'");
            JsonObject vectorObject = valueElement.getAsJsonObject();
            if (!vectorObject.has("x") || !vectorObject.has("y") || !vectorObject.has("z")) throw new JsonParseException("Invalid Vector3D structure");
            double x = vectorObject.get("x").getAsDouble();
            double y = vectorObject.get("y").getAsDouble();
            double z = vectorObject.get("z").getAsDouble();
            propertyValue.value = new MathUtil.Vector3D(x, y, z);
        }
        return propertyValue;
    }
}

