/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.bridge;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.script.FunctionsManager;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.script.Vector;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.event.CitizensEnableEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CitizensListener
implements Listener {
    @EventHandler
    public void citizenEnable(CitizensEnableEvent enable) {
        Main.INSTANCE.getLogger().info("Citizens detected.");
        ConnectionClientHandler.addons.add("citizens");
        ConnectionClientHandler.sendAddonPacket("citizens");
        FunctionsManager.functions.put("spawnnpc", pins -> {
            String type = (String)pins.values[0];
            String name = (String)pins.values[1];
            World world = (World)pins.values[2];
            Vector vect = (Vector)pins.values[3];
            EntityType entityType = null;
            try {
                entityType = EntityType.valueOf((String)type.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (entityType == null) {
                return null;
            }
            NPC npc = CitizensAPI.getNPCRegistry().createNPC(entityType, name);
            npc.spawn(vect.getLocation(world));
            return new Pins(npc, npc.getEntity());
        });
        FunctionsManager.functions.put("despawnnpc", pins -> {
            NPC npc = (NPC)pins.values[0];
            npc.destroy();
            return new Pins(new Object[0]);
        });
        FunctionsManager.functions.put("pausenavigationnpc", pins -> {
            NPC npc = (NPC)pins.values[0];
            Boolean bool = (Boolean)pins.values[1];
            npc.getNavigator().setPaused(bool.booleanValue());
            return new Pins(new Object[0]);
        });
        FunctionsManager.functions.put("npctarget", pins -> {
            NPC npc = (NPC)pins.values[0];
            Location loc = npc.getNavigator().getTargetAsLocation();
            if (loc != null) {
                return new Pins(Boolean.TRUE, new Vector(loc.getX(), loc.getY(), loc.getZ()));
            }
            return new Pins(Boolean.FALSE, new Vector(0.0f, 0.0f, 0.0f));
        });
        FunctionsManager.functions.put("setnpctarget", pins -> {
            NPC npc = (NPC)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            npc.getNavigator().getLocalParameters().distanceMargin(0.0);
            npc.getNavigator().setTarget(vect.getLocation(npc.getEntity().getWorld()));
            return new Pins(new Object[0]);
        });
        FunctionsManager.functions.put("npctargetent", pins -> {
            NPC npc = (NPC)pins.values[0];
            EntityTarget ent = npc.getNavigator().getEntityTarget();
            if (ent != null && ent.getTarget() != null) {
                return new Pins(Boolean.TRUE, ent.getTarget(), ent.isAggressive());
            }
            return new Pins(Boolean.FALSE, npc.getEntity(), Boolean.FALSE);
        });
        FunctionsManager.functions.put("setnpctargetent", pins -> {
            NPC npc = (NPC)pins.values[0];
            Entity ent = (Entity)pins.values[1];
            Boolean aggressive = (Boolean)pins.values[2];
            npc.getNavigator().setTarget(ent, aggressive.booleanValue());
            return new Pins(new Object[0]);
        });
        FunctionsManager.functions.put("entitytonpc", pins -> {
            Entity entity = (Entity)pins.values[0];
            if (CitizensAPI.getNPCRegistry().isNPC(entity)) {
                return new Pins(CitizensAPI.getNPCRegistry().getNPC(entity), Boolean.TRUE);
            }
            return new Pins(null, Boolean.FALSE);
        });
        FunctionsManager.functions.put("npcspeak", pins -> {
            NPC npc = (NPC)pins.values[0];
            String str = (String)pins.values[1];
            npc.getDefaultSpeechController().speak(new SpeechContext(str));
            return new Pins(new Object[0]);
        });
    }
}

