/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.config;

import com.crashstudios.crashcore.Main;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigInstance {
    public UUID uuid;
    public HashMap<String, FileConfiguration> files = new HashMap();

    public ConfigInstance(UUID uuid) {
        this.uuid = uuid;
    }

    public void loadFiles() {
        File uuidFolder;
        File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        if (!(uuidFolder = new File(pluginDataFolder, this.uuid.toString())).exists() || !uuidFolder.isDirectory()) {
            return;
        }
        File[] ymlFiles = uuidFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (ymlFiles == null) {
            return;
        }
        File[] fileArray = ymlFiles;
        int n = ymlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                try {
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                    String fileName = file.getName();
                    String configName = fileName.substring(0, fileName.length() - 4);
                    this.files.put(configName, (FileConfiguration)config);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public FileConfiguration loadSingleFile(String configName) {
        File uuidFolder;
        File configFile;
        FileConfiguration config = this.files.get(configName);
        if (config != null) {
            return config;
        }
        File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        if (!(configFile = new File(uuidFolder = new File(pluginDataFolder, this.uuid.toString()), configName + ".yml")).exists() || !configFile.isFile()) {
            config = new YamlConfiguration();
            this.files.put(configName, config);
            return config;
        }
        try {
            config = YamlConfiguration.loadConfiguration((File)configFile);
            this.files.put(configName, config);
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveSingleFile(String newName, FileConfiguration config) {
        File uuidFolder;
        File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        if (!(uuidFolder = new File(pluginDataFolder, this.uuid.toString())).exists()) {
            uuidFolder.mkdirs();
        }
        File configFile = new File(uuidFolder, newName + ".yml");
        try {
            ((YamlConfiguration)config).save(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deleteSingleFile(String configName) {
        File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        this.files.remove(configName);
        File uuidFolder = new File(pluginDataFolder, this.uuid.toString());
        File configFile = new File(uuidFolder, configName + ".yml");
        configFile.delete();
    }

    public static YamlConfiguration optimizedClone(YamlConfiguration original) {
        YamlConfiguration clone = new YamlConfiguration();
        try {
            String data = original.saveToString();
            clone.loadFromString(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clone;
    }
}

