/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.config;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.config.ConfigData;
import com.crashstudios.crashcore.config.ConfigFile;
import com.crashstudios.crashcore.config.ConfigInstance;
import com.crashstudios.crashcore.config.CustomConfig;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.net.InfoPacketListener;
import com.crashstudios.crashcore.net.RequestPacketListener;
import com.crashstudios.crashcore.storage.SLAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;

public class CustomConfigManager {
    public static HashMap<UUID, CustomConfig> configs = new HashMap();
    public static HashMap<UUID, ConfigInstance> instances = new HashMap();
    public static UUID uuidCounter = UUID.randomUUID();

    public static ConfigFile getConfigFile(UUID groupUUID, String customFile) {
        CustomConfig config = configs.get(groupUUID);
        if (config != null) {
            ConfigInstance instance = instances.get(groupUUID);
            if (instance == null) {
                instance = new ConfigInstance(groupUUID);
                instances.put(groupUUID, instance);
            }
            FileConfiguration fileConfiguration = instance.loadSingleFile(customFile);
            return new ConfigFile(instance, customFile, fileConfiguration);
        }
        return null;
    }

    public static boolean configFileExists(UUID groupUUID, String customFile) {
        CustomConfig config = configs.get(groupUUID);
        if (config != null) {
            File uuidFolder;
            File configFile;
            File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
            if (!pluginDataFolder.exists()) {
                pluginDataFolder.mkdirs();
            }
            return (configFile = new File(uuidFolder = new File(pluginDataFolder, groupUUID.toString()), customFile + ".yml")).exists() && configFile.isFile();
        }
        return false;
    }

    public static void load() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                if (file.isFile()) {
                    ConfigData data = (ConfigData)SLAPI.load(file);
                    configs.put(data.uuid, new CustomConfig(data));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        ConnectionClientHandler.requestPacketListeners.put("customconfigslist", new RequestPacketListener("customconfigslist"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                JsonObject json = new JsonObject();
                json.addProperty("page", (Number)1);
                json.addProperty("maxpage", (Number)1);
                json.addProperty("sessionid", (Number)data.get("sessionid").getAsInt());
                json.addProperty("createlink", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/customconfiginformation/" + String.valueOf(uuidCounter));
                JsonArray elements = new JsonArray();
                String name = data.get("text").getAsString();
                for (CustomConfig config : configs.values()) {
                    if (!config.data.name.toLowerCase().contains(name.toLowerCase())) continue;
                    JsonObject element = new JsonObject();
                    element.addProperty("image", "/images/crashcommand/CommandBlock.webp");
                    element.addProperty("name", config.data.name);
                    element.addProperty("id", config.data.uuid.toString());
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/customconfiginformation/" + String.valueOf(config.data.uuid));
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                ConnectionClientHandler.sendInfoPacket("customconfigslist", json);
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("customconfiginfo", new RequestPacketListener("customconfiginfo"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid = UUID.fromString(packet.get("info").getAsJsonObject().get("id").getAsString());
                String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                CustomConfig config = configs.get(uuid);
                if (config == null && uuid.equals(uuidCounter)) {
                    config = new CustomConfig(uuid);
                    config.save();
                    configs.put(uuid, config);
                    uuidCounter = UUID.randomUUID();
                }
                if (config != null) {
                    JsonObject json = new JsonObject();
                    json.addProperty("datatype", "data");
                    json.addProperty("name", config.data.name);
                    json.addProperty("key", config.data.uuid.toString());
                    json.addProperty("id", config.data.uuid.toString());
                    JsonArray files = config.getFilesName();
                    json.add("files", (JsonElement)files);
                    json.addProperty("sessionid", sessionid);
                    ConnectionClientHandler.sendInfoPacket("customconfiginfo", json);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("customconfiginfo", new InfoPacketListener("customconfiginfo"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject().get("data").getAsJsonObject();
                String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                UUID uuid = UUID.fromString(packet.get("info").getAsJsonObject().get("id").getAsString());
                CustomConfig config = configs.get(uuid);
                if (config != null) {
                    String type = data.get("type").getAsString();
                    if (type.equals("getfile")) {
                        String id = data.get("fileid").getAsString();
                        JsonObject json = new JsonObject();
                        json.addProperty("datatype", "getfile");
                        json.addProperty("key", config.data.uuid.toString());
                        json.addProperty("id", config.data.uuid.toString());
                        json.addProperty("fileid", id);
                        json.addProperty("content", config.getFileContent(id));
                        json.addProperty("sessionid", sessionid);
                        ConnectionClientHandler.sendInfoPacket("customconfiginfo", json);
                    } else if (type.equals("changename")) {
                        config.data.name = data.get("name").getAsString();
                        config.save();
                    } else if (type.equals("updatefile")) {
                        String id = data.get("fileid").getAsString();
                        String newid = data.get("newfileid").getAsString();
                        String content = data.get("content").getAsString();
                        config.setFile(id, newid, content);
                        JsonObject json = new JsonObject();
                        json.addProperty("datatype", "updatesuccess");
                        json.addProperty("key", config.data.uuid.toString());
                        json.addProperty("id", config.data.uuid.toString());
                        json.addProperty("fileid", newid);
                        json.addProperty("sessionid", sessionid);
                        ConnectionClientHandler.sendInfoPacket("customconfiginfo", json);
                    } else if (type.equals("deletefile")) {
                        String id = data.get("fileid").getAsString();
                        config.removeFile(id);
                    } else if (type.equals("deleteall")) {
                        config.remove();
                    }
                }
            }
        });
    }
}

