/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.editor;

import com.crashstudios.crashcore.editor.EditorComment;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.editor.EditorNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.HashMap;

public class EditorFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public HashMap<Integer, EditorNode> nodes = new HashMap();

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        for (EditorNode node : this.nodes.values()) {
            JsonObject data = new JsonObject();
            data.addProperty("id", (Number)node.id);
            data.addProperty("type", node.type);
            data.addProperty("x", (Number)Float.valueOf(node.x));
            data.addProperty("y", (Number)Float.valueOf(node.y));
            if (node instanceof EditorComment) {
                EditorComment comment = (EditorComment)node;
                data.addProperty("width", (Number)comment.width);
                data.addProperty("height", (Number)comment.height);
                data.addProperty("text", comment.text);
                data.addProperty("color", comment.color);
                data.addProperty("pinned", Boolean.valueOf(comment.pinned));
            }
            JsonArray execOutput = new JsonArray();
            int[] nArray = node.execOutput;
            int n = node.execOutput.length;
            int n2 = 0;
            while (n2 < n) {
                int output = nArray[n2];
                execOutput.add((Number)output);
                ++n2;
            }
            data.add("execOutput", (JsonElement)execOutput);
            JsonArray inputs = new JsonArray();
            int i = 0;
            while (i < node.inputs.length) {
                EditorNode.Input input = node.inputs[i];
                if (input != null) {
                    if (input instanceof EditorNode.InputConnection) {
                        EditorNode.InputConnection inputConnection = (EditorNode.InputConnection)input;
                        JsonArray inp = new JsonArray();
                        inp.add((Number)inputConnection.nodeID);
                        inp.add((Number)inputConnection.pinPos);
                        inputs.add((JsonElement)inp);
                    } else if (input instanceof EditorNode.InputData) {
                        EditorNode.InputData inputData = (EditorNode.InputData)input;
                        inputs.add(inputData.data);
                    }
                } else {
                    JsonArray inp = new JsonArray();
                    inputs.add((JsonElement)inp);
                }
                ++i;
            }
            data.add("inputs", (JsonElement)inputs);
            json.add("" + node.id, (JsonElement)data);
        }
        return json;
    }

    public static EditorFile deserialize(JsonObject json) {
        EditorFile file = new EditorFile();
        for (String key : json.keySet()) {
            EditorNode node;
            JsonObject data = json.get(key).getAsJsonObject();
            String type = data.get("type").getAsString();
            if ("comment".equals(type)) {
                EditorComment comment = new EditorComment();
                comment.id = data.get("id").getAsInt();
                comment.type = type;
                comment.x = data.get("x").getAsFloat();
                comment.y = data.get("y").getAsFloat();
                comment.width = data.has("width") ? data.get("width").getAsInt() : 200;
                comment.height = data.has("height") ? data.get("height").getAsInt() : 200;
                comment.text = data.has("text") ? data.get("text").getAsString() : "";
                comment.color = data.has("color") ? data.get("color").getAsString() : "#87CEEB";
                comment.pinned = data.has("pinned") && data.get("pinned").getAsBoolean();
                node = comment;
            } else {
                node = new EditorNode();
                node.id = data.get("id").getAsInt();
                node.type = type;
                node.x = data.get("x").getAsFloat();
                node.y = data.get("y").getAsFloat();
            }
            JsonArray execOutput = data.get("execOutput").getAsJsonArray();
            node.execOutput = new int[execOutput.size()];
            int i = 0;
            while (i < execOutput.size()) {
                node.execOutput[i] = execOutput.get(i).getAsInt();
                ++i;
            }
            JsonArray inputs = data.get("inputs").getAsJsonArray();
            node.inputs = new EditorNode.Input[inputs.size()];
            int i2 = 0;
            while (i2 < inputs.size()) {
                JsonPrimitive prim;
                JsonElement el = inputs.get(i2);
                if (el.isJsonArray()) {
                    JsonArray input = el.getAsJsonArray();
                    if (input.size() == 2) {
                        node.inputs[i2] = new EditorNode.InputConnection(input.get(0).getAsInt(), input.get(1).getAsInt());
                    }
                } else if (el.isJsonPrimitive() && (prim = el.getAsJsonPrimitive()).isString()) {
                    node.inputs[i2] = new EditorNode.InputData(prim.getAsString());
                }
                ++i2;
            }
            file.nodes.put(node.id, node);
        }
        return file;
    }

    public EditorFile2 toV2() {
        EditorFile2 file = new EditorFile2();
        file.nodes = this.nodes;
        return file;
    }
}

