/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.ModelEntity;
import com.crashstudios.crashcore.model.data.AnimationElement;
import com.crashstudios.crashcore.pkg.PackageIdsChange;
import com.crashstudios.crashcore.script.Vector;
import com.crashstudios.crashcore.storage.SLAPI;
import com.crashstudios.crashcore.utilities.ItemStackBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.persistence.PersistentDataType;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BBModelFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public UUID id;
    public List<Object> content = new ArrayList<Object>();
    private static final int[] baseRotation = new int[3];
    private static final int[] basePosition = new int[3];

    public BBModelFile(UUID id) {
        this.id = id;
    }

    public void spawn(ModelEntity modelEntity, Location loc, String id, Matrix4f matrix) {
        this.spawn(modelEntity, this.content, loc, id, matrix);
    }

    private void spawn(ModelEntity modelEntity, List<Object> content, Location loc, String id, Matrix4f matrix) {
        for (Object obj : content) {
            Matrix4f m;
            if (obj instanceof BBModelFileGroup) {
                BBModelFileGroup group = (BBModelFileGroup)obj;
                m = new Matrix4f();
                m.translateLocal(-group.origin.values[0] / 16.0f, -group.origin.values[1] / 16.0f, -group.origin.values[2] / 16.0f);
                m.rotateLocalZ((float)Math.toRadians(group.rotation.values[2]));
                m.rotateLocalY((float)Math.toRadians(group.rotation.values[1]));
                m.rotateLocalX((float)Math.toRadians(group.rotation.values[0]));
                m.translateLocal(group.origin.values[0] / 16.0f, group.origin.values[1] / 16.0f, group.origin.values[2] / 16.0f);
                this.spawn(modelEntity, group.content, loc, id, m.mulLocal((Matrix4fc)matrix));
                continue;
            }
            if (!(obj instanceof BBModelFileModel)) continue;
            BBModelFileModel model = (BBModelFileModel)obj;
            m = new Matrix4f();
            m.translateLocal(0.5f, 0.5f, 0.5f);
            m.scaleLocal(100.0f);
            m.translateLocal((-model.origin.values[0] + model.offset.values[0]) / 16.0f, (-model.origin.values[1] + model.offset.values[1]) / 16.0f, (-model.origin.values[2] + model.offset.values[2]) / 16.0f);
            m.rotateLocalZ((float)Math.toRadians(model.rotation.values[2]));
            m.rotateLocalY((float)Math.toRadians(model.rotation.values[1]));
            m.rotateLocalX((float)Math.toRadians(model.rotation.values[0]));
            m.rotateY((float)Main.utils.getDisplayAngleOffset());
            m.translateLocal(model.origin.values[0] / 16.0f, model.origin.values[1] / 16.0f, model.origin.values[2] / 16.0f);
            m.rotateLocalY((float)Main.utils.getDisplayAngleOffset());
            ItemDisplay display = (ItemDisplay)loc.getWorld().spawnEntity(loc, EntityType.ITEM_DISPLAY);
            display.setRotation(modelEntity.data.rotation[0], modelEntity.data.rotation[1]);
            display.setItemStack(ItemStackBuilder.Builder(Material.PAPER).setCustomModelData(model.model_id + 100).build());
            display.setTransformationMatrix(m.mulLocal((Matrix4fc)matrix));
            display.getPersistentDataContainer().set(ModelEditor.MODEL, PersistentDataType.STRING, (Object)modelEntity.data.uuid.toString());
            modelEntity.data.uuids.put(id + model.id, display.getUniqueId());
        }
    }

    public void update(ModelEntity modelEntity, Location loc, String id, Matrix4f matrix) {
        this.update(modelEntity, this.content, loc, id, matrix);
    }

    private void update(ModelEntity modelEntity, List<Object> content, Location loc, String id, Matrix4f matrix) {
        for (Object obj : content) {
            if (obj instanceof BBModelFileGroup) {
                BBModelFileGroup group = (BBModelFileGroup)obj;
                Matrix4f m = new Matrix4f();
                m.translateLocal(-group.origin.values[0] / 16.0f, -group.origin.values[1] / 16.0f, -group.origin.values[2] / 16.0f);
                m.rotateLocalZ((float)Math.toRadians(group.rotation.values[2]));
                m.rotateLocalY((float)Math.toRadians(group.rotation.values[1]));
                m.rotateLocalX((float)Math.toRadians(group.rotation.values[0]));
                m.translateLocal(group.origin.values[0] / 16.0f, group.origin.values[1] / 16.0f, group.origin.values[2] / 16.0f);
                boolean rotationB = true;
                boolean positionB = true;
                for (ModelEntity.AnimationState state : modelEntity.states) {
                    double[] positionValues;
                    Object position;
                    double[] rotationValues;
                    Object rotation;
                    AnimationElement animationElement = state.animation.getElement(group.id);
                    if (animationElement == null) continue;
                    if (rotationB && (rotation = animationElement.getProperty(baseRotation, "rotation", state.tick % state.animation.tickDurations)) != null && (rotationValues = (double[])rotation) != null) {
                        m.rotateLocalZ((float)rotationValues[2]);
                        m.rotateLocalY((float)(-rotationValues[1]));
                        m.rotateLocalX((float)rotationValues[0]);
                        rotationB = false;
                    }
                    if (!positionB || (position = animationElement.getProperty(basePosition, "position", state.tick % state.animation.tickDurations)) == null || (positionValues = (double[])position) == null) continue;
                    m.translateLocal((float)positionValues[0], (float)positionValues[1], (float)positionValues[2]);
                    positionB = false;
                }
                this.update(modelEntity, group.content, loc, id, m.mulLocal((Matrix4fc)matrix));
                continue;
            }
            if (!(obj instanceof BBModelFileModel)) continue;
            BBModelFileModel model = (BBModelFileModel)obj;
            UUID uuid = modelEntity.data.uuids.get(id + model.id);
            if (uuid == null) continue;
            Matrix4f m = new Matrix4f();
            m.translateLocal(0.5f, 0.5f, 0.5f);
            m.scaleLocal(100.0f);
            m.translateLocal((-model.origin.values[0] + model.offset.values[0]) / 16.0f, (-model.origin.values[1] + model.offset.values[1]) / 16.0f, (-model.origin.values[2] + model.offset.values[2]) / 16.0f);
            m.rotateLocalZ((float)Math.toRadians(model.rotation.values[2]));
            m.rotateLocalY((float)Math.toRadians(model.rotation.values[1]));
            m.rotateLocalX((float)Math.toRadians(model.rotation.values[0]));
            m.rotateY((float)Main.utils.getDisplayAngleOffset());
            m.translateLocal(model.origin.values[0] / 16.0f, model.origin.values[1] / 16.0f, model.origin.values[2] / 16.0f);
            m.rotateLocalY((float)Main.utils.getDisplayAngleOffset());
            Entity ent = Bukkit.getEntity((UUID)uuid);
            if (ent == null || !(ent instanceof ItemDisplay)) continue;
            ItemDisplay display = (ItemDisplay)ent;
            display.teleport(loc);
            display.setTransformationMatrix(m.mulLocal((Matrix4fc)matrix));
        }
    }

    public int countModels() {
        int count = 0;
        for (Object obj : this.content) {
            if (obj instanceof BBModelFileGroup) {
                BBModelFileGroup group = (BBModelFileGroup)obj;
                count += group.countModels();
                continue;
            }
            if (!(obj instanceof BBModelFileModel)) continue;
            ++count;
        }
        return count;
    }

    public void getIds(JsonArray ids) {
        for (Object obj : this.content) {
            if (obj instanceof BBModelFileGroup) {
                BBModelFileGroup group = (BBModelFileGroup)obj;
                group.getIds(ids);
                continue;
            }
            if (!(obj instanceof BBModelFileModel)) continue;
            BBModelFileModel model = (BBModelFileModel)obj;
            ids.add((Number)model.model_id);
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id.toString());
        JsonArray contentarr = new JsonArray();
        for (Object obj : this.content) {
            if (obj instanceof BBModelFileGroup) {
                BBModelFileGroup group = (BBModelFileGroup)obj;
                JsonObject groupJson = new JsonObject();
                group.toJson(groupJson);
                contentarr.add((JsonElement)groupJson);
                continue;
            }
            if (!(obj instanceof BBModelFileModel)) continue;
            BBModelFileModel model = (BBModelFileModel)obj;
            JsonObject modelJson = new JsonObject();
            modelJson.addProperty("id", model.id);
            modelJson.addProperty("model_id", (Number)model.model_id);
            modelJson.add("origin", (JsonElement)model.origin.toJsonArray());
            modelJson.add("rotation", (JsonElement)model.rotation.toJsonArray());
            modelJson.add("offset", (JsonElement)model.offset.toJsonArray());
            contentarr.add((JsonElement)modelJson);
        }
        json.add("content", (JsonElement)contentarr);
        return json;
    }

    public void deserializeContentAndChange(JsonArray array, PackageIdsChange change) {
        this.content.clear();
        int i = 0;
        while (i < array.size()) {
            JsonElement elem = array.get(i);
            if (elem.isJsonObject()) {
                JsonObject obj = elem.getAsJsonObject();
                if (obj.has("content")) {
                    BBModelFileGroup group = new BBModelFileGroup(obj.get("id").getAsString(), Vector.fromJson(obj.get("origin").getAsJsonArray()), Vector.fromJson(obj.get("rotation").getAsJsonArray()));
                    group.content.clear();
                    group.deserializeContentAndChange(obj.getAsJsonArray("content"), change);
                    this.content.add(group);
                } else {
                    int modelid = obj.get("model_id").getAsInt();
                    change.models.put(modelid, ModelEditor.idCounter);
                    BBModelFileModel model = new BBModelFileModel(obj.get("id").getAsString(), ModelEditor.idCounter, Vector.fromJson(obj.get("origin").getAsJsonArray()), Vector.fromJson(obj.get("rotation").getAsJsonArray()), Vector.fromJson(obj.get("offset").getAsJsonArray()));
                    ModelEditor.idCounter = ModelEditor.idCounter + 1;
                    this.content.add(model);
                }
            }
            ++i;
        }
    }

    public void save() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "bbmodels");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            SLAPI.save((Object)this, new File(folder, this.id.toString() + ".dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "bbmodels");
        try {
            new File(folder, this.id.toString() + ".dat").delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ModelEditor.bbModels.remove(this.id);
    }

    public static void optimizeJson(JsonObject json) {
        if (!json.has("outline") || !json.has("models")) {
            return;
        }
        JsonArray outline = json.getAsJsonArray("outline");
        JsonArray models = json.getAsJsonArray("models");
        BBModelFile.optimizeArray(outline, models);
        json.add("outline", (JsonElement)outline);
        json.add("models", (JsonElement)models);
    }

    private static void optimizeArray(JsonArray arr, JsonArray models) {
        ArrayList<ModelRef> modelRefs = new ArrayList<ModelRef>();
        int i = 0;
        while (i < arr.size()) {
            JsonObject obj;
            JsonElement elem = arr.get(i);
            if (elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isString()) {
                String id = elem.getAsString();
                JsonObject modelObj = BBModelFile.findModelById(models, id);
                if (modelObj != null) {
                    modelRefs.add(new ModelRef(modelObj, i, true, id));
                }
            } else if (elem.isJsonObject() && (obj = elem.getAsJsonObject()).has("children")) {
                BBModelFile.optimizeArray(obj.getAsJsonArray("children"), models);
            }
            ++i;
        }
        List<List<ModelRef>> mergeGroups = BBModelFile.findMergeGroups(modelRefs);
        for (List<ModelRef> group : mergeGroups) {
            if (group.size() <= 1) continue;
            ModelRef merged = BBModelFile.mergeModels(group);
            int j = group.size() - 1;
            while (j >= 0) {
                arr.remove((JsonElement)new JsonPrimitive(group.get((int)j).id));
                --j;
            }
            arr.add((JsonElement)new JsonPrimitive(merged.id));
            j = 0;
            while (j < group.size()) {
                String modelIdToRemove = group.get((int)j).obj.get("id").getAsString();
                BBModelFile.removeModelById(models, modelIdToRemove);
                ++j;
            }
            models.add((JsonElement)merged.obj);
        }
    }

    private static JsonObject findModelById(JsonArray models, String id) {
        for (JsonElement el : models) {
            JsonObject obj;
            if (!el.isJsonObject() || !(obj = el.getAsJsonObject()).has("id") || !obj.get("id").getAsString().equals(id)) continue;
            return obj;
        }
        return null;
    }

    private static List<List<ModelRef>> findMergeGroups(List<ModelRef> refs) {
        ArrayList<List<ModelRef>> groups = new ArrayList<List<ModelRef>>();
        boolean[] used = new boolean[refs.size()];
        int i = 0;
        while (i < refs.size()) {
            if (!used[i]) {
                ArrayList<ModelRef> group = new ArrayList<ModelRef>();
                group.add(refs.get(i));
                used[i] = true;
                JsonArray originA = refs.get((int)i).obj.getAsJsonArray("origin");
                JsonArray rotA = refs.get((int)i).obj.getAsJsonArray("rotation");
                int j = i + 1;
                while (j < refs.size()) {
                    JsonArray rotB;
                    JsonArray originB;
                    if (!used[j] && BBModelFile.canMerge(originA, rotA, originB = refs.get((int)j).obj.getAsJsonArray("origin"), rotB = refs.get((int)j).obj.getAsJsonArray("rotation"))) {
                        group.add(refs.get(j));
                        used[j] = true;
                    }
                    ++j;
                }
                groups.add(group);
            }
            ++i;
        }
        return groups;
    }

    private static boolean canMerge(JsonArray originA, JsonArray rotA, JsonArray originB, JsonArray rotB) {
        if (BBModelFile.isZeroRotation(rotA) && BBModelFile.isZeroRotation(rotB)) {
            return true;
        }
        return originA.equals((Object)originB) && rotA.equals((Object)rotB);
    }

    private static ModelRef mergeModels(List<ModelRef> group) {
        JsonObject first = group.get((int)0).obj;
        JsonObject merged = new JsonObject();
        merged.addProperty("id", first.get("id").getAsString());
        merged.add("origin", (JsonElement)first.getAsJsonArray("origin"));
        merged.add("rotation", (JsonElement)first.getAsJsonArray("rotation"));
        JsonArray offset = first.getAsJsonArray("offset");
        merged.add("offset", (JsonElement)offset);
        JsonArray content = new JsonArray();
        for (ModelRef ref : group) {
            JsonObject model = ref.obj;
            if (!model.has("content")) continue;
            JsonArray modelContent = model.getAsJsonArray("content");
            JsonArray offset2 = model.getAsJsonArray("offset");
            JsonArray diffOffset = new JsonArray();
            int i = 0;
            while (i < offset.size()) {
                diffOffset.add((Number)(offset2.get(i).getAsDouble() - offset.get(i).getAsDouble()));
                ++i;
            }
            for (JsonElement elem : modelContent) {
                JsonObject objElem = elem.getAsJsonObject();
                JsonArray from = objElem.getAsJsonArray("from");
                JsonArray to = objElem.getAsJsonArray("to");
                JsonArray newFrom = new JsonArray();
                JsonArray newTo = new JsonArray();
                int i2 = 0;
                while (i2 < from.size()) {
                    newFrom.add((Number)(from.get(i2).getAsDouble() + diffOffset.get(i2).getAsDouble() * 0.01));
                    newTo.add((Number)(to.get(i2).getAsDouble() + diffOffset.get(i2).getAsDouble() * 0.01));
                    ++i2;
                }
                JsonObject newElem = new JsonObject();
                newElem.add("from", (JsonElement)newFrom);
                newElem.add("to", (JsonElement)newTo);
                newElem.add("faces", (JsonElement)objElem.getAsJsonObject("faces"));
                content.add((JsonElement)newElem);
            }
        }
        merged.add("content", (JsonElement)content);
        return new ModelRef(merged, group.get((int)0).index, group.get((int)0).isString, merged.get("id").getAsString());
    }

    private static boolean isZeroRotation(JsonArray rotation) {
        return rotation.size() == 3 && rotation.get(0).getAsDouble() == 0.0 && rotation.get(1).getAsDouble() == 0.0 && rotation.get(2).getAsDouble() == 0.0;
    }

    private static void removeModelById(JsonArray models, String modelId) {
        int i = 0;
        while (i < models.size()) {
            JsonObject model = models.get(i).getAsJsonObject();
            if (model.has("id") && model.get("id").getAsString().equals(modelId)) {
                models.remove(i);
                break;
            }
            ++i;
        }
    }

    public static BBModelFile fromJson(JsonObject json) {
        BBModelFile file = new BBModelFile(UUID.fromString(json.get("id").getAsString()));
        if (json.has("models") || json.has("outline") || json.has("textures")) {
            JsonArray models = json.getAsJsonArray("models");
            JsonArray outline = json.getAsJsonArray("outline");
            int i = 0;
            while (i < outline.size()) {
                JsonElement obj = outline.get(i);
                BBModelFile.addGroup(obj, file.content, models);
                ++i;
            }
        }
        return file;
    }

    private static void addGroup(JsonElement obj, List<Object> content, JsonArray models) {
        if (obj.isJsonPrimitive() && obj.getAsJsonPrimitive().isString()) {
            String modelId = obj.getAsString();
            int i = 0;
            while (i < models.size()) {
                JsonObject modelObj;
                JsonElement modelElement = models.get(i);
                if (modelElement.isJsonObject() && (modelObj = modelElement.getAsJsonObject()).has("id") && modelObj.get("id").getAsString().equals(modelId)) {
                    BBModelFileModel model = new BBModelFileModel(modelObj.get("id").getAsString(), modelObj.get("model_id").getAsInt(), Vector.fromJson(modelObj.get("origin").getAsJsonArray()), Vector.fromJson(modelObj.get("rotation").getAsJsonArray()), Vector.fromJson(modelObj.get("offset").getAsJsonArray()));
                    content.add(model);
                    return;
                }
                ++i;
            }
        } else {
            JsonObject obj2 = obj.getAsJsonObject();
            BBModelFileGroup group = new BBModelFileGroup(obj2.get("id").getAsString(), Vector.fromJson(obj2.get("origin").getAsJsonArray()), Vector.fromJson(obj2.get("rotation").getAsJsonArray()));
            JsonArray contentArray = obj2.getAsJsonArray("children");
            int i = 0;
            while (i < contentArray.size()) {
                JsonElement element = contentArray.get(i);
                BBModelFile.addGroup(element, group.content, models);
                ++i;
            }
            content.add(group);
        }
    }

    public static class BBModelFileGroup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String id;
        public List<Object> content = new ArrayList<Object>();
        public Vector origin;
        public Vector rotation;

        public BBModelFileGroup(String id, Vector origin, Vector rotation) {
            this.id = id;
            this.origin = origin;
            this.rotation = rotation;
        }

        public int countModels() {
            int count = 0;
            for (Object obj : this.content) {
                if (obj instanceof BBModelFileGroup) {
                    BBModelFileGroup group = (BBModelFileGroup)obj;
                    count += group.countModels();
                    continue;
                }
                if (!(obj instanceof BBModelFileModel)) continue;
                ++count;
            }
            return count;
        }

        public void getIds(JsonArray ids) {
            for (Object obj : this.content) {
                if (obj instanceof BBModelFileGroup) {
                    BBModelFileGroup group = (BBModelFileGroup)obj;
                    group.getIds(ids);
                    continue;
                }
                if (!(obj instanceof BBModelFileModel)) continue;
                BBModelFileModel model = (BBModelFileModel)obj;
                ids.add((Number)model.model_id);
            }
        }

        public void toJson(JsonObject json) {
            json.addProperty("id", this.id);
            json.add("origin", (JsonElement)this.origin.toJsonArray());
            json.add("rotation", (JsonElement)this.rotation.toJsonArray());
            JsonArray children = new JsonArray();
            for (Object child : this.content) {
                if (child instanceof BBModelFileGroup) {
                    BBModelFileGroup group = (BBModelFileGroup)child;
                    JsonObject groupJson = new JsonObject();
                    group.toJson(groupJson);
                    children.add((JsonElement)groupJson);
                    continue;
                }
                if (!(child instanceof BBModelFileModel)) continue;
                BBModelFileModel model = (BBModelFileModel)child;
                JsonObject modelJson = new JsonObject();
                modelJson.addProperty("id", model.id);
                modelJson.addProperty("model_id", (Number)model.model_id);
                modelJson.add("origin", (JsonElement)model.origin.toJsonArray());
                modelJson.add("rotation", (JsonElement)model.rotation.toJsonArray());
                modelJson.add("offset", (JsonElement)model.offset.toJsonArray());
                children.add((JsonElement)modelJson);
            }
            json.add("content", (JsonElement)children);
        }

        public void deserializeContentAndChange(JsonArray array, PackageIdsChange change) {
            this.content.clear();
            int i = 0;
            while (i < array.size()) {
                JsonElement elem = array.get(i);
                if (elem.isJsonObject()) {
                    JsonObject obj = elem.getAsJsonObject();
                    if (obj.has("content")) {
                        BBModelFileGroup group = new BBModelFileGroup(obj.get("id").getAsString(), Vector.fromJson(obj.get("origin").getAsJsonArray()), Vector.fromJson(obj.get("rotation").getAsJsonArray()));
                        group.content.clear();
                        group.deserializeContentAndChange(obj.getAsJsonArray("content"), change);
                        this.content.add(group);
                    } else {
                        int modelid = obj.get("model_id").getAsInt();
                        change.models.put(modelid, ModelEditor.idCounter);
                        BBModelFileModel model = new BBModelFileModel(obj.get("id").getAsString(), ModelEditor.idCounter, Vector.fromJson(obj.get("origin").getAsJsonArray()), Vector.fromJson(obj.get("rotation").getAsJsonArray()), Vector.fromJson(obj.get("offset").getAsJsonArray()));
                        ModelEditor.idCounter = ModelEditor.idCounter + 1;
                        this.content.add(model);
                    }
                }
                ++i;
            }
        }
    }

    public static class BBModelFileModel
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String id;
        public int model_id;
        public Vector origin;
        public Vector rotation;
        public Vector offset;

        public BBModelFileModel(String id, int model_id, Vector origin, Vector rotation, Vector offset) {
            this.id = id;
            this.model_id = model_id;
            this.origin = origin;
            this.rotation = rotation;
            this.offset = offset;
        }
    }

    private static class ModelRef {
        JsonObject obj;
        int index;
        boolean isString;
        String id;

        ModelRef(JsonObject obj, int index, boolean isString, String id) {
            this.obj = obj;
            this.index = index;
            this.isString = isString;
            this.id = id;
        }
    }
}

