/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.model.BBModelFile;
import com.crashstudios.crashcore.model.CustomModel;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.Scripts;
import com.crashstudios.crashcore.model.data.Animation;
import com.crashstudios.crashcore.model.data.AnimationElement;
import com.crashstudios.crashcore.model.data.BaseElement;
import com.crashstudios.crashcore.model.data.Collision;
import com.crashstudios.crashcore.model.data.Group;
import com.crashstudios.crashcore.model.data.Head;
import com.crashstudios.crashcore.model.data.Hitbox;
import com.crashstudios.crashcore.model.data.Item;
import com.crashstudios.crashcore.model.data.Model;
import com.crashstudios.crashcore.model.data.Particle;
import com.crashstudios.crashcore.model.data.Sensor;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.script.Vector;
import com.crashstudios.crashcore.storage.SLAPI;
import com.crashstudios.crashcore.utilities.ItemStackBuilder;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Shulker;
import org.bukkit.event.Cancellable;
import org.bukkit.persistence.PersistentDataType;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class ModelEntity {
    public ModelEntityData data;
    public boolean removed = false;
    public boolean dirty = false;
    public boolean toSave = false;
    public boolean persistent = true;
    public Entity vehicle;
    public float offsetY = 0.0f;
    public List<AnimationState> states = new ArrayList<AnimationState>();
    private CustomModel customModel;
    private World world;

    public ModelEntity(ModelEntityData data) {
        this.data = data;
    }

    public ModelEntity(UUID uuid, UUID customModel) {
        this.data = new ModelEntityData();
        this.data.uuid = uuid;
        this.data.customModel = customModel;
    }

    public void spawn(CustomModel customModel, Location loc) {
        this.data.worldUID = loc.getWorld().getUID();
        this.data.origin[0] = (float)loc.getX();
        this.data.origin[1] = (float)loc.getY();
        this.data.origin[2] = (float)loc.getZ();
        this.data.rotation[0] = loc.getYaw();
        this.data.rotation[1] = loc.getPitch();
        Matrix4f matrix = new Matrix4f();
        matrix.translateLocal(0.0f, -this.offsetY, 0.0f);
        this.spawn(customModel, customModel.data.outline, loc, matrix);
        ModelEditor.entities.put(this.data.uuid, this);
        this.save();
        Scripts.getCompiledScript(this.getScriptUUID()).run("model_createaction", new Object[]{this, loc.getWorld(), new Vector(loc)});
    }

    private void spawn(CustomModel customModel, List<BaseElement> content, Location loc, Matrix4f matrix) {
        for (BaseElement element : content) {
            Matrix4f m;
            if (element instanceof Model) {
                Model model = (Model)element;
                m = this.applyTransformation(model, matrix, true);
                String modelID = model.model_id;
                try {
                    int n = Integer.parseInt(modelID);
                    ItemDisplay display = (ItemDisplay)loc.getWorld().spawnEntity(loc, EntityType.ITEM_DISPLAY);
                    display.setRotation(this.data.rotation[0], this.data.rotation[1]);
                    display.setItemStack(ItemStackBuilder.Builder(Material.PAPER).setCustomModelData(n + 2000100).build());
                    display.setTransformationMatrix(m);
                    display.getPersistentDataContainer().set(ModelEditor.MODEL, PersistentDataType.STRING, (Object)this.data.uuid.toString());
                    this.data.uuids.put(element.id, display.getUniqueId());
                }
                catch (NumberFormatException e) {
                    BBModelFile bbFile = ModelEditor.bbModels.get(UUID.fromString(modelID));
                    if (bbFile == null) continue;
                    bbFile.spawn(this, loc, element.id, m);
                }
                continue;
            }
            if (element instanceof Group) {
                Group group = (Group)element;
                m = this.applyTransformation(group, matrix, false);
                this.spawn(customModel, group.content, loc, m);
                continue;
            }
            if (element instanceof Hitbox) {
                Hitbox hitbox = (Hitbox)element;
                m = this.applyTransformation(hitbox, matrix, false);
                m.rotateLocalY((float)Math.toRadians(-loc.getYaw()));
                Vector3f translation = new Vector3f();
                m.getTranslation(translation);
                Interaction interaction = (Interaction)loc.getWorld().spawnEntity(loc.clone().add((double)translation.x(), (double)translation.y(), (double)translation.z()), EntityType.INTERACTION);
                interaction.setInteractionWidth((float)element.scale[0]);
                interaction.setInteractionHeight((float)element.scale[1]);
                interaction.getPersistentDataContainer().set(ModelEditor.INTERACTION, PersistentDataType.STRING, (Object)hitbox.script_id);
                interaction.getPersistentDataContainer().set(ModelEditor.MODEL, PersistentDataType.STRING, (Object)this.data.uuid.toString());
                this.data.uuids.put(element.id, interaction.getUniqueId());
                continue;
            }
            if (element instanceof Particle || element instanceof Sensor) continue;
            if (element instanceof Item) {
                Material material;
                Item item = (Item)element;
                m = this.applyTransformation(item, matrix, true);
                if (item.custom_item || (material = Material.matchMaterial((String)item.item_id)) == null) continue;
                ItemDisplay display = (ItemDisplay)loc.getWorld().spawnEntity(loc, EntityType.ITEM_DISPLAY);
                display.setRotation(this.data.rotation[0], this.data.rotation[1]);
                display.setItemStack(ItemStackBuilder.Builder(material).build());
                display.setTransformationMatrix(m);
                display.getPersistentDataContainer().set(ModelEditor.MODEL, PersistentDataType.STRING, (Object)this.data.uuid.toString());
                this.data.uuids.put(element.id, display.getUniqueId());
                continue;
            }
            if (element instanceof Head || !(element instanceof Collision)) continue;
            Collision collision = (Collision)element;
            m = this.applyTransformation(collision, matrix, false);
            m.rotateLocalY((float)Math.toRadians(-loc.getYaw()));
            UUID[] newUUIDs = ModelEditor.modelUtils.spawnCollision(loc, collision, m, this.data.uuid);
            this.data.uuids.put(element.id, newUUIDs[0]);
            this.data.uuids.put(element.id + "_passenger", newUUIDs[1]);
        }
    }

    private Matrix4f applyTransformation(BaseElement element, Matrix4f matrix, boolean display) {
        Matrix4f m = new Matrix4f();
        m.scaleLocal((float)element.scale[0], (float)element.scale[1], (float)element.scale[2]);
        m.translateLocal((float)element.offset[0], (float)element.offset[1], (float)element.offset[2]);
        m.rotateLocalZ((float)element.rotation[2]);
        m.rotateLocalY((float)element.rotation[1]);
        m.rotateLocalX((float)element.rotation[0]);
        m.translateLocal((float)element.position[0], (float)element.position[1], (float)element.position[2]);
        if (display) {
            m.rotateY((float)Main.utils.getDisplayAngleOffset());
        }
        return m.mulLocal((Matrix4fc)matrix);
    }

    public void update() {
        if (this.customModel == null) {
            this.customModel = ModelEditor.models.get(this.data.customModel);
            if (this.customModel == null) {
                return;
            }
        }
        if (this.world == null) {
            this.world = Bukkit.getWorld((UUID)this.data.worldUID);
            if (this.world == null) {
                return;
            }
        }
        Location loc = new Location(this.world, (double)this.data.origin[0], (double)this.data.origin[1], (double)this.data.origin[2], this.data.rotation[0], this.data.rotation[1]);
        this.states.clear();
        for (Animation animation : this.customModel.data.animations) {
            Integer tick = null;
            for (ModelEntityAnimationData animData : this.data.currentAnimations) {
                if (!animData.anim.equals(animation.id)) continue;
                tick = animData.counter;
                break;
            }
            if (tick == null) continue;
            this.states.add(new AnimationState(animation, tick));
        }
        Matrix4f matrix = new Matrix4f();
        matrix.translateLocal(0.0f, -this.offsetY, 0.0f);
        this.update(this.customModel, this.customModel.data.outline, loc, matrix);
    }

    private void update(CustomModel customModel, List<BaseElement> content, Location loc, Matrix4f matrix) {
        for (BaseElement element : content) {
            Vector3f translation;
            ItemDisplay display;
            Entity ent;
            UUID uuid;
            Matrix4f m;
            if (element instanceof Model) {
                Model model = (Model)element;
                m = this.applyAnimatedTransformation(model, matrix, true);
                String modelID = model.model_id;
                try {
                    Integer.parseInt(modelID);
                    uuid = this.data.uuids.get(element.id);
                    if (uuid == null || (ent = Bukkit.getEntity((UUID)uuid)) == null || !(ent instanceof ItemDisplay)) continue;
                    display = (ItemDisplay)ent;
                    display.teleport(loc);
                    display.setTransformationMatrix(m);
                }
                catch (NumberFormatException e) {
                    BBModelFile bbFile = ModelEditor.bbModels.get(UUID.fromString(modelID));
                    if (bbFile == null) continue;
                    bbFile.update(this, loc, element.id, matrix);
                }
                continue;
            }
            if (element instanceof Group) {
                Group group = (Group)element;
                m = this.applyAnimatedTransformation(group, matrix, false);
                this.update(customModel, group.content, loc, m);
                continue;
            }
            if (element instanceof Hitbox) {
                Hitbox hitbox = (Hitbox)element;
                m = this.applyAnimatedTransformation(hitbox, matrix, false);
                m.rotateLocalY((float)Math.toRadians(-loc.getYaw()));
                translation = new Vector3f();
                m.getTranslation(translation);
                uuid = this.data.uuids.get(element.id);
                if (uuid == null || (ent = Bukkit.getEntity((UUID)uuid)) == null || !(ent instanceof Interaction)) continue;
                Interaction interaction = (Interaction)ent;
                interaction.teleport(loc.clone().add((double)translation.x(), (double)translation.y(), (double)translation.z()));
                boolean scaleB = true;
                for (AnimationState state : this.states) {
                    float[] scaleValues;
                    Object scale;
                    AnimationElement animationElement = state.animation.getElement(element.id);
                    if (animationElement == null || !scaleB || (scale = animationElement.getProperty(element.scale, "scale", state.tick)) == null || (scaleValues = (float[])scale) == null) continue;
                    interaction.setInteractionWidth(scaleValues[0]);
                    interaction.setInteractionHeight(scaleValues[1]);
                    scaleB = false;
                }
                if (!scaleB) continue;
                interaction.setInteractionWidth((float)element.scale[0]);
                interaction.setInteractionHeight((float)element.scale[1]);
                continue;
            }
            if (element instanceof Particle || element instanceof Sensor) continue;
            if (element instanceof Item) {
                Entity ent2;
                UUID uuid2;
                Item item = (Item)element;
                m = this.applyAnimatedTransformation(item, matrix, true);
                if (item.custom_item || (uuid2 = this.data.uuids.get(element.id)) == null || (ent2 = Bukkit.getEntity((UUID)uuid2)) == null || !(ent2 instanceof ItemDisplay)) continue;
                ItemDisplay display2 = (ItemDisplay)ent2;
                display2.teleport(loc);
                display2.setTransformationMatrix(m);
                continue;
            }
            if (element instanceof Head || !(element instanceof Collision)) continue;
            Collision collision = (Collision)element;
            m = this.applyAnimatedTransformation(collision, matrix, false);
            m.rotateLocalY((float)Math.toRadians(-loc.getYaw()));
            translation = new Vector3f();
            m.getTranslation(translation);
            uuid = this.data.uuids.get(element.id);
            if (uuid == null || (ent = Bukkit.getEntity((UUID)uuid)) == null || !(ent instanceof Display)) continue;
            display = (Display)ent;
            if (display.getPassengers().isEmpty()) {
                return;
            }
            Shulker shulker = (Shulker)display.getPassengers().get(0);
            display.removePassenger((Entity)shulker);
            display.teleport(loc.clone().add((double)translation.x(), (double)translation.y(), (double)translation.z()));
            display.addPassenger((Entity)shulker);
            boolean scaleB = true;
            for (AnimationState state : this.states) {
                float[] scaleValues;
                Object scale;
                AnimationElement animationElement = state.animation.getElement(element.id);
                if (animationElement == null || !scaleB || (scale = animationElement.getProperty(element.scale, "scale", state.tick)) == null || (scaleValues = (float[])scale) == null) continue;
                ModelEditor.modelUtils.updateCollision(shulker, scaleValues[0]);
                scaleB = false;
            }
            if (!scaleB) continue;
            ModelEditor.modelUtils.updateCollision(shulker, element.scale[0]);
        }
    }

    private Matrix4f applyAnimatedTransformation(BaseElement element, Matrix4f matrix, boolean display) {
        Matrix4f m = new Matrix4f();
        boolean scaleB = true;
        boolean offsetB = true;
        boolean rotationB = true;
        boolean positionB = true;
        for (AnimationState state : this.states) {
            double[] positionValues;
            Object position;
            double[] rotationValues;
            Object rotation;
            double[] offsetValues;
            Object offset;
            double[] scaleValues;
            Object scale;
            AnimationElement animationElement = state.animation.getElement(element.id);
            if (animationElement == null) continue;
            if (scaleB && (scale = animationElement.getProperty(element.scale, "scale", state.tick % state.animation.tickDurations)) != null && (scaleValues = (double[])scale) != null) {
                m.scaleLocal((float)scaleValues[0], (float)scaleValues[1], (float)scaleValues[2]);
                scaleB = false;
            }
            if (offsetB && (offset = animationElement.getProperty(element.offset, "offset", state.tick % state.animation.tickDurations)) != null && (offsetValues = (double[])offset) != null) {
                m.translateLocal((float)offsetValues[0], (float)offsetValues[1], (float)offsetValues[2]);
                offsetB = false;
            }
            if (rotationB && (rotation = animationElement.getProperty(element.rotation, "rotation", state.tick % state.animation.tickDurations)) != null && (rotationValues = (double[])rotation) != null) {
                m.rotateLocalZ((float)rotationValues[2]);
                m.rotateLocalY((float)rotationValues[1]);
                m.rotateLocalX((float)rotationValues[0]);
                rotationB = false;
            }
            if (!positionB || (position = animationElement.getProperty(element.position, "position", state.tick % state.animation.tickDurations)) == null || (positionValues = (double[])position) == null) continue;
            m.translateLocal((float)positionValues[0], (float)positionValues[1], (float)positionValues[2]);
            positionB = false;
        }
        if (scaleB) {
            m.scaleLocal((float)element.scale[0], (float)element.scale[1], (float)element.scale[2]);
        }
        if (offsetB) {
            m.translateLocal((float)element.offset[0], (float)element.offset[1], (float)element.offset[2]);
        }
        if (rotationB) {
            m.rotateLocalZ((float)element.rotation[2]);
            m.rotateLocalY((float)element.rotation[1]);
            m.rotateLocalX((float)element.rotation[0]);
        }
        if (positionB) {
            m.translateLocal((float)element.position[0], (float)element.position[1], (float)element.position[2]);
        }
        if (display) {
            m.rotateY((float)Main.utils.getDisplayAngleOffset());
        }
        return m.mulLocal((Matrix4fc)matrix);
    }

    public void setPersistent(boolean value) {
        this.persistent = value;
        this.forEachEntity(e -> e.setPersistent(value));
        if (value) {
            this.toSave = true;
        } else {
            File folder = new File(Main.INSTANCE.getDataFolder(), "modelentities");
            try {
                new File(folder, this.data.uuid.toString() + ".dat").delete();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void forEachEntity(Consumer<Entity> consumer) {
        for (UUID uuid : this.data.uuids.values()) {
            Entity ent = Bukkit.getEntity((UUID)uuid);
            if (ent == null) continue;
            consumer.accept(ent);
        }
    }

    public UUID getScriptUUID() {
        CustomModel customModel = ModelEditor.models.get(this.data.customModel);
        if (customModel == null) {
            return null;
        }
        return customModel.data.scripts.get(0);
    }

    public boolean sendData(String key, String value) {
        Cancellable cancellable = new Cancellable(){
            boolean cancelled = false;

            public void setCancelled(boolean cancelled) {
                this.cancelled = cancelled;
            }

            public boolean isCancelled() {
                return this.cancelled;
            }
        };
        for (CompiledScript.Node node : Scripts.getCompiledScript((UUID)this.getScriptUUID()).startingNodes) {
            if (!node.type.equals("model_receivedata") || !key.equals(((CompiledScript.Data)node.input[0]).data)) continue;
            node.start(new HashMap<CompiledScript.Node, Pins>(), new Object[]{this, cancellable, value});
        }
        return cancellable.isCancelled();
    }

    public void save() {
        if (!this.persistent) {
            return;
        }
        File folder = new File(Main.INSTANCE.getDataFolder(), "modelentities");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            SLAPI.save((Object)this.data, new File(folder, this.data.uuid.toString() + ".dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveThreadSafe() {
        if (!this.persistent) {
            return;
        }
        File folder = new File(Main.INSTANCE.getDataFolder(), "modelentities");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            ModelEntityData dataCopy;
            ModelEntity modelEntity = this;
            synchronized (modelEntity) {
                dataCopy = new ModelEntityData();
                dataCopy.uuid = this.data.uuid;
                dataCopy.customModel = this.data.customModel;
                dataCopy.worldUID = this.data.worldUID;
                dataCopy.origin = (float[])this.data.origin.clone();
                dataCopy.rotation = (float[])this.data.rotation.clone();
                dataCopy.uuids = new HashMap<String, UUID>(this.data.uuids);
                dataCopy.currentAnimations = new ArrayList<ModelEntityAnimationData>();
                for (ModelEntityAnimationData anim : new ArrayList<ModelEntityAnimationData>(this.data.currentAnimations)) {
                    dataCopy.currentAnimations.add(new ModelEntityAnimationData(anim.anim, anim.tick));
                }
            }
            SLAPI.save((Object)dataCopy, new File(folder, this.data.uuid.toString() + ".dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        for (UUID uuid : this.data.uuids.values()) {
            Entity ent = Bukkit.getEntity((UUID)uuid);
            if (ent == null) continue;
            ent.remove();
        }
        File folder = new File(Main.INSTANCE.getDataFolder(), "modelentities");
        try {
            new File(folder, this.data.uuid.toString() + ".dat").delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ModelEditor.entities.remove(this.data.uuid);
        this.removed = true;
    }

    public static class AnimationState {
        public Animation animation;
        public int tick;

        public AnimationState(Animation animation, int tick) {
            this.animation = animation;
            this.tick = tick;
        }
    }

    public static class ModelEntityAnimationData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String anim;
        public int tick;
        public int counter = 0;

        public ModelEntityAnimationData(String anim, int tick) {
            this.anim = anim;
            this.tick = tick;
        }
    }

    public static class ModelEntityData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public UUID uuid;
        public UUID customModel;
        public HashMap<String, UUID> uuids = new HashMap();
        public UUID worldUID;
        public float[] origin = new float[3];
        public float[] rotation = new float[2];
        public List<ModelEntityAnimationData> currentAnimations = new ArrayList<ModelEntityAnimationData>();
    }
}

