/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.particles;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.net.InfoPacketListener;
import com.crashstudios.crashcore.net.RequestPacketListener;
import com.crashstudios.crashcore.particles.CustomParticle;
import com.crashstudios.crashcore.particles.ParticleData;
import com.crashstudios.crashcore.particles.ParticleEmitter;
import com.crashstudios.crashcore.particles.ParticlePropertyValue;
import com.crashstudios.crashcore.storage.SLAPI;
import com.crashstudios.crashcore.utilities.gson.ParticlePropertyValueDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class ParticleEditor {
    public static HashMap<UUID, CustomParticle> particles = new HashMap();
    public static UUID uuidCounter = UUID.randomUUID();

    public static void load() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "particles");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                ParticleData data = (ParticleData)SLAPI.load(file);
                particles.put(data.id, new CustomParticle(data));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ParticlePropertyValue.class, (Object)new ParticlePropertyValueDeserializer());
        final Gson customGson = gsonBuilder.create();
        ConnectionClientHandler.requestPacketListeners.put("customparticleslist", new RequestPacketListener("customparticleslist"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                JsonObject json = new JsonObject();
                json.addProperty("page", (Number)1);
                json.addProperty("maxpage", (Number)1);
                json.addProperty("sessionid", (Number)data.get("sessionid").getAsInt());
                json.addProperty("createlink", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/particles/" + ConnectionClientHandler.serverID + "?file=" + String.valueOf(uuidCounter));
                JsonArray elements = new JsonArray();
                String name = data.get("text").getAsString();
                for (CustomParticle particle : particles.values()) {
                    if (!particle.data.name.toLowerCase().contains(name.toLowerCase())) continue;
                    JsonObject element = new JsonObject();
                    element.addProperty("image", "/serverdata/" + ConnectionClientHandler.serverID + "/particleimgs/" + particle.data.id.toString() + ".gif");
                    element.addProperty("name", particle.data.name);
                    element.addProperty("id", particle.data.id.toString());
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/particles/" + ConnectionClientHandler.serverID + "?file=" + particle.data.id.toString());
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                ConnectionClientHandler.sendInfoPacket("customparticleslist", json);
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("particleseditor", new RequestPacketListener("particleseditor"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid = UUID.fromString(packet.get("info").getAsJsonObject().get("id").getAsString());
                String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                CustomParticle particle = particles.get(uuid);
                if (particle == null && uuid.equals(uuidCounter)) {
                    if (Main.upgrade == null && particles.size() >= 6) {
                        return;
                    }
                    particle = new CustomParticle(uuid);
                    particle.save();
                    particles.put(uuid, particle);
                    uuidCounter = UUID.randomUUID();
                }
                if (particle != null) {
                    JsonObject json = new JsonObject();
                    json.addProperty("datatype", "data");
                    json.addProperty("name", particle.data.name);
                    json.addProperty("key", particle.data.id.toString());
                    json.addProperty("id", particle.data.id.toString());
                    json.addProperty("ticks", (Number)particle.data.ticks);
                    JsonArray emitters = new Gson().toJsonTree(particle.data.emitters).getAsJsonArray();
                    json.add("emitters", (JsonElement)emitters);
                    json.addProperty("sessionid", sessionid);
                    ConnectionClientHandler.sendInfoPacket("particleseditor", json);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("particleseditor", new InfoPacketListener("particleseditor"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject().get("data").getAsJsonObject();
                String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                UUID uuid = UUID.fromString(packet.get("info").getAsJsonObject().get("id").getAsString());
                CustomParticle particle = particles.get(uuid);
                if (particle != null) {
                    String type = data.get("type").getAsString();
                    if (type.equals("changename")) {
                        particle.data.name = data.get("name").getAsString();
                        particle.save();
                    } else if (type.equals("update")) {
                        int ticks;
                        JsonArray emitters = data.get("emitters").getAsJsonArray();
                        particle.data.emitters = (List)customGson.fromJson((JsonElement)emitters, (TypeToken)new TypeToken<List<ParticleEmitter>>(){});
                        particle.data.ticks = ticks = data.get("ticks").getAsInt();
                        particle.save();
                        JsonObject json = new JsonObject();
                        json.addProperty("datatype", "savesuccess");
                        json.addProperty("key", particle.data.id.toString());
                        json.addProperty("id", particle.data.id.toString());
                        json.addProperty("sessionid", sessionid);
                        ConnectionClientHandler.sendInfoPacket("particleseditor", json);
                    } else if (type.equals("deleteall")) {
                        particle.remove();
                    }
                }
            }
        });
    }
}

