/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.utilities.gui;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.utilities.gui.ButtonHandler;
import com.crashstudios.crashcore.utilities.gui.CloseHandler;
import com.crashstudios.crashcore.utilities.gui.GuiCentral;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SimpleGui {
    private Inventory inv;
    private List<Integer> listInteger = new ArrayList<Integer>();

    public SimpleGui(int size, String title) {
        this.inv = Bukkit.createInventory(null, (int)size, (String)title);
    }

    public void fill(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "blankguimaker");
        meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
        item.setItemMeta(meta);
        int i = 0;
        while (i < this.inv.getSize()) {
            this.inv.setItem(i, item);
            ++i;
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public void addButton(int slot, ItemStack item, ButtonHandler buttonHandler) {
        Random random = new Random();
        int n = random.nextInt(Integer.MAX_VALUE);
        while (GuiCentral.buttonList.containsKey(n)) {
            n = random.nextInt(Integer.MAX_VALUE);
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "buttonguimaker");
        meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)n);
        item.setItemMeta(meta);
        this.inv.setItem(slot, item);
        GuiCentral.buttonList.put(n, buttonHandler);
        buttonHandler.setItem(item);
        this.listInteger.add(n);
    }

    public void addItem(int slot, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "blankguimaker");
        meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
        item.setItemMeta(meta);
        this.inv.setItem(slot, item);
    }

    public void close() {
        for (HumanEntity p : new ArrayList(this.inv.getViewers())) {
            p.closeInventory();
        }
        for (Integer i : this.listInteger) {
            GuiCentral.buttonList.remove(i);
        }
        this.inv.clear();
    }

    public void setTitle(String title) {
        ItemStack[] content = (ItemStack[])this.inv.getContents().clone();
        ArrayList humans = new ArrayList(this.inv.getViewers());
        this.inv = Bukkit.createInventory(null, (int)this.inv.getSize(), (String)title);
        this.inv.setContents(content);
        for (HumanEntity p : humans) {
            p.openInventory(this.inv);
        }
    }

    public void setCloseHandler(CloseHandler closeHandler) {
        GuiCentral.closerList.put(this.inv, closeHandler);
    }
}

