/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.bridge;

import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.script.FunctionsManager;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.script.Vector;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class WorldGuardManager {
    public static boolean active = false;

    public static void init() {
        active = true;
        ConnectionClientHandler.addons.add("worldguard");
        ConnectionClientHandler.sendAddonPacket("worldguard");
        FunctionsManager.functions.put("getregions", pins -> {
            Vector pos = (Vector)pins.values[0];
            World world = (World)pins.values[1];
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            ArrayList<String> list = new ArrayList<String>();
            for (ProtectedRegion r : container.get(BukkitAdapter.adapt((World)world)).getApplicableRegions(BlockVector3.at((int)((int)pos.values[0]), (int)((int)pos.values[1]), (int)((int)pos.values[2]))).getRegions()) {
                list.add(r.getId());
            }
            return new Pins(list);
        });
        FunctionsManager.functions.put("playersinregion", pins -> {
            String id = (String)pins.values[0];
            World world = (World)pins.values[1];
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            ProtectedRegion r = container.get(BukkitAdapter.adapt((World)world)).getRegion(id);
            if (r == null) {
                return new Pins(new ArrayList());
            }
            BlockVector3 min = r.getMinimumPoint();
            BlockVector3 max = r.getMaximumPoint();
            BlockVector3 diff = max.subtract(min).divide(2);
            Collection entities = world.getNearbyEntities(new Location(world, (double)(min.getX() + diff.getX()) + 0.5, (double)(min.getY() + diff.getY()) + 0.5, (double)(min.getZ() + diff.getZ()) + 0.5), (double)diff.getX(), (double)diff.getY(), (double)diff.getZ());
            ArrayList<String> list = new ArrayList<String>();
            for (Entity ent : entities) {
                Location l = ent.getLocation();
                if (ent.getType() != EntityType.PLAYER || !r.contains(l.getBlockX(), l.getBlockY(), l.getBlockZ())) continue;
                list.add(ent.getUniqueId().toString());
            }
            return new Pins(list);
        });
        FunctionsManager.functions.put("entitiesinregion", pins -> {
            String id = (String)pins.values[0];
            World world = (World)pins.values[1];
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            ProtectedRegion r = container.get(BukkitAdapter.adapt((World)world)).getRegion(id);
            if (r == null) {
                return new Pins(new ArrayList());
            }
            BlockVector3 min = r.getMinimumPoint();
            BlockVector3 max = r.getMaximumPoint();
            BlockVector3 diff = max.subtract(min).divide(2);
            Collection entities = world.getNearbyEntities(new Location(world, (double)(min.getX() + diff.getX()) + 0.5, (double)(min.getY() + diff.getY()) + 0.5, (double)(min.getZ() + diff.getZ()) + 0.5), (double)diff.getX(), (double)diff.getY(), (double)diff.getZ());
            ArrayList<String> list = new ArrayList<String>();
            for (Entity ent : entities) {
                Location l = ent.getLocation();
                if (!r.contains(l.getBlockX(), l.getBlockY(), l.getBlockZ())) continue;
                list.add(ent.getUniqueId().toString());
            }
            return new Pins(list);
        });
        FunctionsManager.functions.put("regionowners", pins -> {
            String id = (String)pins.values[0];
            World world = (World)pins.values[1];
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            ProtectedRegion r = container.get(BukkitAdapter.adapt((World)world)).getRegion(id);
            if (r == null) {
                return new Pins(new ArrayList());
            }
            ArrayList<String> list = new ArrayList<String>();
            for (UUID uuid : r.getOwners().getUniqueIds()) {
                list.add(uuid.toString());
            }
            return new Pins(list);
        });
        FunctionsManager.functions.put("regionmembers", pins -> {
            String id = (String)pins.values[0];
            World world = (World)pins.values[1];
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            ProtectedRegion r = container.get(BukkitAdapter.adapt((World)world)).getRegion(id);
            if (r == null) {
                return new Pins(new ArrayList());
            }
            ArrayList<String> list = new ArrayList<String>();
            for (UUID uuid : r.getMembers().getUniqueIds()) {
                list.add(uuid.toString());
            }
            return new Pins(list);
        });
    }
}

