/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.commands;

import com.crashstudios.crashcore.particles.CustomParticle;
import com.crashstudios.crashcore.particles.ParticleEditor;
import com.crashstudios.crashcore.particles.ParticleEmitter;
import com.crashstudios.crashcore.particles.ParticleEngine;
import com.crashstudios.crashcore.particles.ParticleInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CustomParticlesCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("spawn")) {
                    p.sendMessage("\u00a7cWrong arguments. /customparticles spawn <id or name> [duration in ticks]");
                } else if (args[0].equalsIgnoreCase("eyespawn")) {
                    p.sendMessage("\u00a7cWrong arguments. /customparticles eyespawn <id or name> [duration in ticks]");
                }
            } else if (args.length == 2 || args.length == 3) {
                if (args[0].equalsIgnoreCase("spawn") || args[0].equalsIgnoreCase("eyespawn")) {
                    CustomParticle particle = null;
                    try {
                        particle = ParticleEditor.particles.get(UUID.fromString(args[1]));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (particle == null) {
                        for (CustomParticle m : ParticleEditor.particles.values()) {
                            if (!m.data.name.equalsIgnoreCase(args[1])) continue;
                            particle = m;
                            break;
                        }
                    }
                    if (particle != null) {
                        Location loc = p.getLocation();
                        boolean eye = args[0].equalsIgnoreCase("eyespawn");
                        if (eye) {
                            loc = p.getEyeLocation();
                        }
                        ArrayList<ParticleInstance> instances = new ArrayList<ParticleInstance>();
                        for (ParticleEmitter emitter : particle.data.emitters) {
                            ParticleInstance instance = new ParticleInstance();
                            instance.setEmitter(emitter);
                            instances.add(instance);
                        }
                        ParticleEngine engine = new ParticleEngine(loc, -Math.toRadians(loc.getYaw()), eye ? Math.toRadians(loc.getPitch()) : 0.0, 0.0, particle.data.ticks, instances, e -> {
                            if (eye) {
                                e.location = p.getEyeLocation();
                                e.pitch = Math.toRadians(e.location.getPitch());
                            } else {
                                e.location = p.getLocation();
                            }
                            e.yaw = -Math.toRadians(e.location.getYaw());
                        });
                        if (args.length == 3) {
                            int ticks;
                            try {
                                ticks = Integer.parseInt(args[2]);
                            }
                            catch (NumberFormatException e2) {
                                p.sendMessage("\u00a7cDuration must be expressed in ticks (an integer)");
                                return true;
                            }
                            engine.start(ticks);
                            p.sendMessage("\u00a7aCustom Particles spawned for " + ticks + " ticks.");
                        } else {
                            engine.start(particle.data.ticks);
                            p.sendMessage("\u00a7aCustom Particles spawned for " + particle.data.ticks + " ticks.");
                        }
                    } else {
                        p.sendMessage("\u00a7cInvalid ID/name.");
                    }
                }
            } else {
                sender.sendMessage("\u00a7cWrong Argument.");
                sender.sendMessage("\u00a7c/customparticles spawn <id or name> [duration in ticks]: spawns custom particles.");
                sender.sendMessage("\u00a7c/customparticles eyespawn <id or name> [duration in ticks]: spawns custom particles.");
            }
        } else {
            sender.sendMessage("\u00a7cYou must be a player.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.add("spawn");
            list.add("eyespawn");
        } else if (args.length == 2 && (args[0].equalsIgnoreCase("spawn") || args[0].equalsIgnoreCase("eyespawn"))) {
            for (CustomParticle particle : ParticleEditor.particles.values()) {
                if (!particle.data.name.contains(args[1])) continue;
                list.add(particle.data.name);
            }
        }
        return list;
    }
}

