/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.config;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.config.ConfigData;
import com.crashstudios.crashcore.config.ConfigInstance;
import com.crashstudios.crashcore.config.CustomConfigManager;
import com.crashstudios.crashcore.storage.SLAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class CustomConfig {
    public ConfigData data;
    public ConfigInstance instance;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");

    public CustomConfig(UUID uuid) {
        this.data = new ConfigData();
        this.data.uuid = uuid;
        this.data.name = "New Config";
    }

    public CustomConfig(ConfigData data) {
        this.data = data;
    }

    public JsonArray getFilesName() {
        File uuidFolder;
        File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        if (!(uuidFolder = new File(pluginDataFolder, this.data.uuid.toString())).exists() || !uuidFolder.isDirectory()) {
            return new JsonArray();
        }
        File[] ymlFiles = uuidFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (ymlFiles == null) {
            return new JsonArray();
        }
        JsonArray array = new JsonArray();
        File[] fileArray = ymlFiles;
        int n = ymlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                try {
                    String fileName = file.getName();
                    String configName = fileName.substring(0, fileName.length() - 4);
                    JsonObject obj = new JsonObject();
                    obj.addProperty("name", configName);
                    obj.addProperty("date", sdf.format(new Date(file.lastModified())));
                    array.add((JsonElement)obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return array;
    }

    public String getFileContent(String fileid) {
        File uuidFolder;
        File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        if (!(uuidFolder = new File(pluginDataFolder, this.data.uuid.toString())).exists()) {
            uuidFolder.mkdirs();
        }
        File configFile = new File(uuidFolder, fileid + ".yml");
        String content = "";
        try {
            content = Files.readString(configFile.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public void setFile(String fileid, String newfileid, String content) {
        File uuidFolder;
        File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        if (!(uuidFolder = new File(pluginDataFolder, this.data.uuid.toString())).exists()) {
            uuidFolder.mkdirs();
        }
        File configFile = new File(uuidFolder, fileid + ".yml");
        if (!fileid.equals(newfileid)) {
            if (!fileid.equals("")) {
                configFile.delete();
            }
            configFile = new File(uuidFolder, newfileid + ".yml");
        }
        try {
            Files.writeString(configFile.toPath(), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeFile(String fileid) {
        File uuidFolder;
        File pluginDataFolder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        if (!(uuidFolder = new File(pluginDataFolder, this.data.uuid.toString())).exists()) {
            uuidFolder.mkdirs();
        }
        File configFile = new File(uuidFolder, fileid + ".yml");
        configFile.delete();
    }

    public void save() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            SLAPI.save((Object)this.data, new File(folder, this.data.uuid.toString() + ".dat"));
            new File(folder, this.data.uuid.toString()).mkdir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "customconfigs");
        try {
            new File(folder, this.data.uuid.toString() + ".dat").delete();
            FileUtils.deleteDirectory((File)new File(folder, this.data.uuid.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CustomConfigManager.configs.remove(this.data.uuid);
    }
}

