/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.debug;

import com.crashstudios.crashblock.breaking.BreakingManager;
import com.crashstudios.crashblock.data.NormalBlocks;
import com.crashstudios.crashblock.marker.Markers;
import com.crashstudios.crashblock.multi.MultiBlocks;
import com.crashstudios.crashblock.world.WorldManager;
import com.crashstudios.crashblock.world.WorldScripts;
import com.crashstudios.crashcommand.data.Commands;
import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.config.CustomConfigManager;
import com.crashstudios.crashcore.console.ConsoleFilter;
import com.crashstudios.crashcore.discord.DiscordBotManager;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.net.RequestPacketListener;
import com.crashstudios.crashcore.particles.ParticleEditor;
import com.crashstudios.crashcore.pkg.PackageManager;
import com.crashstudios.crashcore.player.PlayerDatas;
import com.crashstudios.crashcore.player.PlayerList;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.script.FunctionsManager;
import com.crashstudios.crashcore.script.interaction.InteractionListener;
import com.crashstudios.crashcore.script.inv.InventoryListener;
import com.crashstudios.crashcore.script.player.PlayerListener;
import com.crashstudios.crashcore.user.UserDatas;
import com.crashstudios.crashcore.utilities.gui.GuiCentral;
import com.crashstudios.crashitem.ItemListener;
import com.crashstudios.crashitem.data.Items;
import com.crashstudios.crashitem.data.emote.Emotes;
import com.crashstudios.crashitem.data.gui.Guis;
import com.crashstudios.crashitem.data.gui.Scripts;
import com.crashstudios.crashitem.data.loottable.LootTables;
import com.crashstudios.crashitem.data.vanilla.VanillaItems;
import com.crashstudios.crashmob.data.Mobs;
import com.crashstudios.crashmob.models.MobModels;
import com.crashstudios.crashmob.vehicle.VehicleManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import org.bukkit.Bukkit;

public class DebugManager {
    public static void load() {
        ConnectionClientHandler.requestPacketListeners.put("debuginformation", new RequestPacketListener("debuginformation"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject json = new JsonObject();
                JsonArray elements = new JsonArray();
                elements.add("Current Time: " + Instant.now().toString());
                elements.add("MC Version: " + Main.getMinecraftVersion());
                elements.add("Software: " + Bukkit.getName() + " " + Bukkit.getVersion() + " " + Bukkit.getBukkitVersion());
                elements.add("Custom Configs Data: " + CustomConfigManager.configs.size());
                elements.add("Custom Configs Instances: " + CustomConfigManager.instances.size());
                elements.add("Custom Configs Instances: " + CustomConfigManager.instances.values().stream().flatMap(i -> i.files.values().stream()).count());
                elements.add("Console Messages: " + ConsoleFilter.messages.size());
                elements.add("New Console Messages: " + ConsoleFilter.newMessages.size());
                elements.add("Discord commands: " + DiscordBotManager.data.commands.size());
                elements.add("Discord callbacks: " + DiscordBotManager.callbacks.size());
                elements.add("Model Editor models: " + ModelEditor.models.size());
                elements.add("Model Editor entities: " + ModelEditor.entities.size());
                elements.add("Model Editor bbModels: " + ModelEditor.bbModels.size());
                elements.add("Model Editor compiled scripts: " + com.crashstudios.crashcore.model.Scripts.compiledScripts.size());
                elements.add("Model Editor script listeners: " + com.crashstudios.crashcore.model.Scripts.compiledScripts.values().stream().mapToInt(l -> l.startingNodes.size()).sum());
                elements.add("Server ID: " + ConnectionClientHandler.serverID);
                elements.add("Network ID: " + ConnectionClientHandler.networkID);
                elements.add("Addons: " + ConnectionClientHandler.addons.stream().reduce((a, b) -> a + ", " + b).orElse("None"));
                elements.add("Addons To Update: " + ConnectionClientHandler.addonsToUpdate.stream().reduce((a, b) -> a + ", " + b).orElse("None"));
                elements.add("Info Packet Listeners size: " + ConnectionClientHandler.infoPacketListeners.size());
                elements.add("Request Packet Listeners size: " + ConnectionClientHandler.requestPacketListeners.size());
                elements.add("Model Editor models: " + ParticleEditor.particles.size());
                elements.add("Packages: " + PackageManager.serverPackage.size());
                elements.add("Loaded Player Datas: " + PlayerDatas.getLoadedPlayerDatas());
                elements.add("Player List: " + PlayerList.names.size());
                elements.add("Script Functions: " + FunctionsManager.functions.size() + " " + FunctionsManager.specialFunctions.size());
                elements.add("Script Specific Cache Instances: " + FunctionsManager.serverData.size() + " " + FunctionsManager.brokenBlocks.size() + " " + FunctionsManager.cooldownTasks.size() + " " + FunctionsManager.playerBreaker.size());
                elements.add("Custom Event: " + CustomNodes.customevent.size());
                elements.add("Custom Nodes: " + CustomNodes.nodes.size());
                elements.add("Script Interaction Left Click Listeners: " + InteractionListener.leftClicksListener.size());
                elements.add("Script Interaction Right Click Listeners: " + InteractionListener.rightClicksListener.size());
                elements.add("Script Inventory Click Listeners: " + InventoryListener.clickslistener.size());
                elements.add("Script Inventory Close Listeners: " + InventoryListener.closelistener.size());
                elements.add("Script Player Chat Listeners: " + PlayerListener.chatlistener.size());
                elements.add("Script Player Jump Listeners: " + PlayerListener.jumplistener.size());
                elements.add("Script Player Shift Listeners: " + PlayerListener.shiftlisteneron.size() + " " + PlayerListener.shiftlisteneroff.size());
                elements.add("Loaded User Datas: " + UserDatas.users.size());
                elements.add("Gui Button Listener: " + GuiCentral.getButtonListSize());
                elements.add("Gui Closer Listener: " + GuiCentral.getCloserListSize());
                if (ConnectionClientHandler.addons.contains("crashitems")) {
                    elements.add("CrashItems - Item Listener: " + ItemListener.players.size() + " " + ItemListener.players.size());
                    elements.add("CrashItems - Items: " + Items.items.size());
                    elements.add("CrashItems - Items compiled scripts: " + com.crashstudios.crashitem.data.Scripts.compiledScripts.size());
                    elements.add("CrashItems - Items script listeners: " + com.crashstudios.crashitem.data.Scripts.compiledScripts.values().stream().mapToInt(l -> l.startingNodes.size()).sum());
                    elements.add("CrashItems - Emotes: " + Emotes.emotes.size());
                    elements.add("CrashItems - Guis: " + Guis.guis.size());
                    elements.add("CrashItems - Guis compiled scripts: " + Scripts.compiledScripts.size());
                    elements.add("CrashItems - Guis script listeners: " + Scripts.compiledScripts.values().stream().mapToInt(l -> l.startingNodes.size()).sum());
                    elements.add("CrashItems - LootTables: " + LootTables.lootTables.size());
                    elements.add("CrashItems - Vanilla Items: " + VanillaItems.items.size());
                }
                if (ConnectionClientHandler.addons.contains("crashblock")) {
                    elements.add("CrashBlock - Broken Blocks Service: " + BreakingManager.brokenBlocksService.brokenBlocks.size());
                    elements.add("CrashBlock - Blocks: " + NormalBlocks.blocks.size());
                    elements.add("CrashBlock - Placed Blocks: " + NormalBlocks.placedBlocks.size());
                    elements.add("CrashBlock - Blocks compiled scripts: " + com.crashstudios.crashblock.data.Scripts.compiledScripts.size());
                    elements.add("CrashBlock - Blocks script listeners: " + com.crashstudios.crashblock.data.Scripts.compiledScripts.values().stream().mapToInt(l -> l.startingNodes.size()).sum());
                    elements.add("CrashBlock - Markers: " + Markers.markers.size());
                    elements.add("CrashBlock - Multi Blocks: " + MultiBlocks.placedBlocks.size());
                    elements.add("CrashBlock - World Generator: " + WorldManager.generators.size());
                    elements.add("CrashBlock - World Generator compiled scripts: " + WorldScripts.compiledScripts.size());
                    elements.add("CrashBlock - World Generator script listeners: " + WorldScripts.compiledScripts.values().stream().mapToInt(l -> l.startingNodes.size()).sum());
                }
                if (ConnectionClientHandler.addons.contains("crashcommand")) {
                    elements.add("CrashCommand - Commands: " + Commands.commands.size());
                    elements.add("CrashCommand - Commands compiled scripts: " + com.crashstudios.crashcommand.data.Scripts.compiledScripts.size());
                    elements.add("CrashCommand - Commands script listeners: " + com.crashstudios.crashcommand.data.Scripts.compiledScripts.values().stream().mapToInt(l -> l.startingNodes.size()).sum());
                }
                if (ConnectionClientHandler.addons.contains("crashmob")) {
                    elements.add("CrashMob - Mobs: " + Mobs.mobs.size());
                    elements.add("CrashMob - Mobs compiled scripts: " + com.crashstudios.crashmob.data.Scripts.compiledScripts.size());
                    elements.add("CrashMob - Mobs script listeners: " + com.crashstudios.crashmob.data.Scripts.compiledScripts.values().stream().mapToInt(l -> l.startingNodes.size()).sum());
                    elements.add("CrashMob - Mob Models: " + MobModels.models.size());
                    elements.add("CrashMob - Vehicles: " + VehicleManager.vehicles.size());
                }
                json.add("entries", (JsonElement)elements);
                ConnectionClientHandler.sendInfoPacket("debuginformation", json);
            }
        });
    }
}

