/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.discord;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.discord.DiscordBotCommandData;
import com.crashstudios.crashcore.discord.DiscordBotData;
import com.crashstudios.crashcore.discord.DiscordBotOptionData;
import com.crashstudios.crashcore.discord.DiscordBotOptionType;
import com.crashstudios.crashcore.discord.ScriptChannelData;
import com.crashstudios.crashcore.discord.ScriptCommandData;
import com.crashstudios.crashcore.discord.ScriptMemberData;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.net.InfoPacketListener;
import com.crashstudios.crashcore.net.RequestPacketListener;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.CustomEvent;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.storage.SLAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.util.HashMap;
import java.util.function.Consumer;

public class DiscordBotManager {
    public static DiscordBotData data;
    public static HashMap<Integer, Consumer<JsonObject>> callbacks;

    static {
        callbacks = new HashMap();
    }

    public static void load() {
        File file;
        File folder = new File(Main.INSTANCE.getDataFolder(), "discordbot");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((file = new File(folder, "data.dat")).exists()) {
            try {
                data = (DiscordBotData)SLAPI.load(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            data = new DiscordBotData();
            DiscordBotManager.save();
        }
        ConnectionClientHandler.requestPacketListeners.put("discordcommands", new RequestPacketListener("discordcommands"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                DiscordBotManager.updateCommandList();
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("discordcommands", new InfoPacketListener("discordcommands"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                DiscordBotCommandData command;
                JsonObject data = packet.get("info").getAsJsonObject();
                String type = data.get("type").getAsString();
                String id = data.get("id").getAsString().toLowerCase();
                if (type.equals("create")) {
                    if (DiscordBotManager.getCommand(id) != null) {
                        JsonObject json = new JsonObject();
                        json.addProperty("alert", "There is already a command with this ID.");
                        ConnectionClientHandler.sendInfoPacket("discordcommands", json);
                        return;
                    }
                    DiscordBotCommandData command2 = new DiscordBotCommandData();
                    command2.id = id;
                    command2.description = data.get("desc").getAsString();
                    JsonArray options = data.get("options").getAsJsonArray();
                    int i = 0;
                    while (i < options.size()) {
                        JsonObject o = options.get(i).getAsJsonObject();
                        DiscordBotOptionData option = new DiscordBotOptionData();
                        option.id = o.get("id").getAsString().toLowerCase();
                        option.description = o.get("desc").getAsString();
                        option.type = DiscordBotOptionType.valueOf(o.get("type").getAsString());
                        option.required = o.get("req").getAsBoolean();
                        command2.options.add(option);
                        ++i;
                    }
                    DiscordBotManager.data.commands.add(command2);
                    DiscordBotManager.save();
                    DiscordBotManager.updateDiscordBot();
                } else if (type.equals("edit")) {
                    DiscordBotCommandData command3 = DiscordBotManager.getCommand(id);
                    if (command3 != null) {
                        command3.description = data.get("desc").getAsString();
                        JsonArray options = data.get("options").getAsJsonArray();
                        command3.options.clear();
                        int i = 0;
                        while (i < options.size()) {
                            JsonObject o = options.get(i).getAsJsonObject();
                            DiscordBotOptionData option = new DiscordBotOptionData();
                            option.id = o.get("id").getAsString().toLowerCase();
                            option.description = o.get("desc").getAsString();
                            option.type = DiscordBotOptionType.valueOf(o.get("type").getAsString());
                            option.required = o.get("req").getAsBoolean();
                            command3.options.add(option);
                            ++i;
                        }
                        DiscordBotManager.save();
                        DiscordBotManager.updateDiscordBot();
                    }
                } else if (type.equals("delete") && (command = DiscordBotManager.getCommand(id)) != null) {
                    DiscordBotManager.data.commands.remove(command);
                    DiscordBotManager.save();
                    DiscordBotManager.updateDiscordBot();
                }
                DiscordBotManager.updateCommandList();
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("discordproperties", new RequestPacketListener("discordproperties"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                String session = packet.get("info").getAsJsonObject().get("data").getAsString();
                JsonObject json = new JsonObject();
                json.addProperty("session", session);
                json.addProperty("discordbot", Boolean.valueOf(DiscordBotManager.data.active));
                json.addProperty("roles", Boolean.valueOf(DiscordBotManager.data.listenRoles));
                json.addProperty("reaction", Boolean.valueOf(DiscordBotManager.data.listenReactions));
                json.addProperty("messages", Boolean.valueOf(DiscordBotManager.data.listenMessages));
                json.addProperty("users", Boolean.valueOf(DiscordBotManager.data.listenUsers));
                ConnectionClientHandler.sendInfoPacket("discordproperties", json);
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("discordproperties", new InfoPacketListener("discordproperties"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonArray json = (JsonArray)ConnectionClientHandler.gson.fromJson(packet.get("info").getAsJsonObject().get("data").getAsString(), JsonArray.class);
                for (JsonElement e : json) {
                    String[] entry = e.getAsString().split(":");
                    if (entry.length == 2) {
                        DiscordBotManager.setDiscordProperty(entry[0], entry[1]);
                        continue;
                    }
                    if (entry.length != 1) continue;
                    DiscordBotManager.setDiscordProperty(entry[0], "");
                }
                DiscordBotManager.save();
                DiscordBotManager.updateDiscordBot();
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("discordcontroller", new InfoPacketListener("discordcontroller"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                block26: {
                    Consumer<JsonObject> consumer;
                    JsonObject json;
                    block24: {
                        json = packet.get("info").getAsJsonObject();
                        if (!json.has("t")) break block24;
                        switch (json.get("t").getAsString()) {
                            case "message": {
                                String channel = json.get("c").getAsString();
                                String guild = json.get("g").getAsString();
                                DiscordBotManager.callEvent(channel, new Object[]{new ScriptChannelData(channel), guild, new ScriptMemberData(guild, json.get("m").getAsString()), json.get("mx").getAsString(), json.get("mxi").getAsString()}, "discord_onmessage");
                                break;
                            }
                            case "memberjoin": {
                                String member = json.get("m").getAsString();
                                String guild = json.get("g").getAsString();
                                DiscordBotManager.callEvent(new Object[]{new ScriptMemberData(guild, member), guild}, "discord_onmemberjoin");
                                break;
                            }
                            case "memberleave": {
                                String member = json.get("m").getAsString();
                                String guild = json.get("g").getAsString();
                                DiscordBotManager.callEvent(new Object[]{member, guild}, "discord_onmemberleave");
                                break;
                            }
                            case "memberupdate": {
                                String member = json.get("m").getAsString();
                                String guild = json.get("g").getAsString();
                                DiscordBotManager.callEvent(new Object[]{new ScriptMemberData(guild, member), guild}, "discord_onmemberupdate");
                                break;
                            }
                            case "reaction": {
                                String channel = json.get("c").getAsString();
                                String guild = json.get("g").getAsString();
                                DiscordBotManager.callEvent(channel, new Object[]{new ScriptChannelData(channel), guild, new ScriptMemberData(guild, json.get("m").getAsString()), json.get("mx").getAsString(), json.get("mxi").getAsString(), json.get("e").getAsString(), json.get("a").getAsBoolean()}, "discord_onreact");
                                break;
                            }
                            case "command": {
                                String session = json.get("s").getAsString();
                                String command = json.get("i").getAsString();
                                String channel = json.get("c").getAsString();
                                String guild = json.get("g").getAsString();
                                JsonArray options = json.get("o").getAsJsonArray();
                                HashMap<String, String> map = new HashMap<String, String>();
                                int i = 0;
                                while (i < options.size()) {
                                    JsonObject option = options.get(i).getAsJsonObject();
                                    map.put(option.get("k").getAsString(), option.get("v").getAsString());
                                    ++i;
                                }
                                DiscordBotManager.callEvent(command, new Object[]{new ScriptCommandData(session), new ScriptMemberData(guild, json.get("m").getAsString()), guild, new ScriptChannelData(channel), map}, "discord_oncommand");
                            }
                        }
                        break block26;
                    }
                    if (json.has("s") && (consumer = callbacks.remove(json.get("s").getAsInt())) != null) {
                        consumer.accept(json);
                    }
                }
            }
        });
    }

    public static void setDiscordProperty(String property, String value) {
        switch (property) {
            case "discordbot": {
                DiscordBotManager.data.active = Boolean.valueOf(value);
                break;
            }
            case "roles": {
                DiscordBotManager.data.listenRoles = Boolean.valueOf(value);
                break;
            }
            case "reaction": {
                DiscordBotManager.data.listenReactions = Boolean.valueOf(value);
                break;
            }
            case "messages": {
                DiscordBotManager.data.listenMessages = Boolean.valueOf(value);
                break;
            }
            case "users": {
                DiscordBotManager.data.listenUsers = Boolean.valueOf(value);
            }
        }
    }

    public static void updateCommandList() {
        JsonArray commands = new JsonArray();
        for (DiscordBotCommandData c : DiscordBotManager.data.commands) {
            JsonObject obj = new JsonObject();
            obj.addProperty("id", c.id);
            obj.addProperty("desc", c.description);
            JsonArray options = new JsonArray();
            for (DiscordBotOptionData o : c.options) {
                JsonObject option = new JsonObject();
                option.addProperty("id", o.id);
                option.addProperty("desc", o.description);
                option.addProperty("type", o.type.toString());
                option.addProperty("req", Boolean.valueOf(o.required));
                options.add((JsonElement)option);
            }
            obj.add("options", (JsonElement)options);
            commands.add((JsonElement)obj);
        }
        JsonObject json = new JsonObject();
        json.add("commands", (JsonElement)commands);
        ConnectionClientHandler.sendInfoPacket("discordcommands", json);
    }

    public static DiscordBotCommandData getCommand(String id) {
        for (DiscordBotCommandData command : DiscordBotManager.data.commands) {
            if (!command.id.equals(id)) continue;
            return command;
        }
        return null;
    }

    public static void save() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "discordbot");
        File file = new File(folder, "data.dat");
        try {
            SLAPI.save((Object)data, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void callEvent(String channel, Object[] args, String type) {
        for (CustomEvent file : CustomNodes.customevent.values()) {
            for (CompiledScript.Node node : file.getScript().startingNodes) {
                if (!node.type.equals(type) || !((CompiledScript.Data)node.input[0]).data.isEmpty() && !channel.equals(((CompiledScript.Data)node.input[0]).data)) continue;
                node.start(new HashMap<CompiledScript.Node, Pins>(), args);
            }
        }
    }

    public static void callEvent(Object[] args, String type) {
        for (CustomEvent file : CustomNodes.customevent.values()) {
            for (CompiledScript.Node node : file.getScript().startingNodes) {
                if (!node.type.equals(type)) continue;
                node.start(new HashMap<CompiledScript.Node, Pins>(), args);
            }
        }
    }

    public static void updateDiscordBot() {
        JsonObject json = new JsonObject();
        json.addProperty("t", "info");
        json.addProperty("active", Boolean.valueOf(DiscordBotManager.data.active));
        json.addProperty("messages", Boolean.valueOf(DiscordBotManager.data.listenMessages));
        json.addProperty("reactions", Boolean.valueOf(DiscordBotManager.data.listenReactions));
        json.addProperty("roles", Boolean.valueOf(DiscordBotManager.data.listenRoles));
        json.addProperty("users", Boolean.valueOf(DiscordBotManager.data.listenUsers));
        JsonArray commands = new JsonArray();
        for (DiscordBotCommandData c : DiscordBotManager.data.commands) {
            JsonObject obj = new JsonObject();
            obj.addProperty("id", c.id);
            obj.addProperty("desc", c.description);
            JsonArray options = new JsonArray();
            for (DiscordBotOptionData o : c.options) {
                JsonObject option = new JsonObject();
                option.addProperty("id", o.id);
                option.addProperty("desc", o.description);
                option.addProperty("type", o.type.toString());
                option.addProperty("req", Boolean.valueOf(o.required));
                options.add((JsonElement)option);
            }
            obj.add("options", (JsonElement)options);
            commands.add((JsonElement)obj);
        }
        json.add("commands", (JsonElement)commands);
        ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
    }
}

