/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.editor;

import com.crashstudios.crashcore.editor.EditorFile;
import com.crashstudios.crashcore.editor.EditorGroup;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashMap;

public class EditorFile2
extends EditorFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public HashMap<String, EditorGroup> groups = new HashMap();

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.add("data", (JsonElement)super.serialize());
        JsonArray groups = new JsonArray();
        for (EditorGroup groupData : this.groups.values()) {
            JsonObject node = new JsonObject();
            node.addProperty("title", groupData.title);
            node.addProperty("header", groupData.header);
            JsonArray labels = new JsonArray();
            int i = 0;
            while (i < groupData.labels.length) {
                labels.add(groupData.labels[i]);
                ++i;
            }
            node.add("labels", (JsonElement)labels);
            JsonArray inputsType = new JsonArray();
            int i2 = 0;
            while (i2 < groupData.inputsType.length) {
                inputsType.add(groupData.inputsType[i2]);
                ++i2;
            }
            node.add("inputsType", (JsonElement)inputsType);
            JsonArray outputsType = new JsonArray();
            int i3 = 0;
            while (i3 < groupData.outputsType.length) {
                outputsType.add(groupData.outputsType[i3]);
                ++i3;
            }
            node.add("outputsType", (JsonElement)outputsType);
            JsonObject group = new JsonObject();
            group.addProperty("id", groupData.id);
            group.add("node", (JsonElement)node);
            group.add("modules", (JsonElement)groupData.file.serialize());
            groups.add((JsonElement)group);
        }
        json.add("groups", (JsonElement)groups);
        return json;
    }

    public static EditorFile2 deserialize(JsonObject json) {
        EditorFile2 file = new EditorFile2();
        if (json.has("data")) {
            file.nodes = EditorFile.deserialize((JsonObject)json.get((String)"data").getAsJsonObject()).nodes;
            if (json.has("groups")) {
                JsonArray groups = json.get("groups").getAsJsonArray();
                int i = 0;
                while (i < groups.size()) {
                    JsonObject g = groups.get(i).getAsJsonObject();
                    EditorGroup group = new EditorGroup();
                    group.id = g.get("id").getAsString();
                    JsonObject node = g.get("node").getAsJsonObject();
                    group.title = node.get("title").getAsString();
                    group.header = node.get("header").getAsString();
                    JsonArray labels = node.get("labels").getAsJsonArray();
                    String[] labels2 = new String[labels.size()];
                    int j = 0;
                    while (j < labels.size()) {
                        labels2[j] = labels.get(j).getAsString();
                        ++j;
                    }
                    group.labels = labels2;
                    JsonArray inputsType = node.get("inputsType").getAsJsonArray();
                    String[] inputsType2 = new String[inputsType.size()];
                    int j2 = 0;
                    while (j2 < inputsType.size()) {
                        inputsType2[j2] = inputsType.get(j2).getAsString();
                        ++j2;
                    }
                    group.inputsType = inputsType2;
                    JsonArray outputsType = node.get("outputsType").getAsJsonArray();
                    String[] outputsType2 = new String[outputsType.size()];
                    int j3 = 0;
                    while (j3 < outputsType.size()) {
                        outputsType2[j3] = outputsType.get(j3).getAsString();
                        ++j3;
                    }
                    group.outputsType = outputsType2;
                    group.file = EditorFile.deserialize(g.get("modules").getAsJsonObject());
                    file.groups.put(group.id, group);
                    ++i;
                }
            }
        } else {
            file.nodes = EditorFile.deserialize((JsonObject)json).nodes;
        }
        return file;
    }

    public static void sendSavedSuccess(String moduleID, String key) {
        JsonObject json = new JsonObject();
        json.addProperty("key", key);
        json.addProperty("datatype", "saved");
        ConnectionClientHandler.sendInfoPacket(moduleID, json);
    }
}

