/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.folia;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CrashScheduler {
    private static GlobalRegionScheduler globalRegionScheduler = null;
    private static RegionScheduler regionScheduler = null;
    private static AsyncScheduler asyncScheduler = null;
    private static Method getPlayerSchedulerMethod = null;
    private static Method teleportAsyncMethod = null;
    private static boolean isFoliaChecked = false;
    private static boolean isFolia = false;

    public static boolean isFolia() {
        if (isFoliaChecked) {
            return isFolia;
        }
        try {
            Bukkit.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
            isFoliaChecked = true;
            isFolia = true;
            try {
                globalRegionScheduler = (GlobalRegionScheduler)Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
                regionScheduler = (RegionScheduler)Bukkit.class.getMethod("getRegionScheduler", new Class[0]).invoke(null, new Object[0]);
                asyncScheduler = (AsyncScheduler)Bukkit.class.getMethod("getAsyncScheduler", new Class[0]).invoke(null, new Object[0]);
                getPlayerSchedulerMethod = Entity.class.getMethod("getScheduler", new Class[0]);
                teleportAsyncMethod = Entity.class.getMethod("teleportAsync", Location.class);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            isFoliaChecked = true;
            isFolia = false;
            return false;
        }
    }

    public static CancelHandle runTask(Plugin plugin, Runnable task) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(task);
        if (CrashScheduler.isFolia()) {
            final AtomicReference<ScheduledTask> ref = new AtomicReference<ScheduledTask>();
            ScheduledTask t = globalRegionScheduler.run(plugin, st -> task.run());
            ref.set(t);
            return new CancelHandle(){

                @Override
                public void cancel() {
                    ScheduledTask s = ref.getAndSet(null);
                    if (s != null) {
                        s.cancel();
                    }
                }

                @Override
                public boolean isCancelled() {
                    return ref.get() == null || ((ScheduledTask)ref.get()).isCancelled();
                }
            };
        }
        BukkitTask t = Bukkit.getScheduler().runTask(plugin, task);
        return CrashScheduler.bukkitHandle(t);
    }

    public static void runTaskLater(Plugin plugin, Runnable task, long delayTicks) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(task);
        if (CrashScheduler.isFolia()) {
            globalRegionScheduler.runDelayed(plugin, st -> task.run(), delayTicks);
        } else {
            BukkitTask t = Bukkit.getScheduler().runTaskLater(plugin, task, Math.max(0L, delayTicks));
            CrashScheduler.bukkitHandle(t);
        }
    }

    public static CancelHandle runTaskTimer(Plugin plugin, Runnable task, long initialDelayTicks, long periodTicks) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(task);
        if (periodTicks <= 0L) {
            periodTicks = 1L;
        }
        if (CrashScheduler.isFolia()) {
            final AtomicReference<ScheduledTask> ref = new AtomicReference<ScheduledTask>();
            ScheduledTask t = globalRegionScheduler.runAtFixedRate(plugin, st -> task.run(), initialDelayTicks, periodTicks);
            ref.set(t);
            return new CancelHandle(){

                @Override
                public void cancel() {
                    ScheduledTask s = ref.getAndSet(null);
                    if (s != null) {
                        s.cancel();
                    }
                }

                @Override
                public boolean isCancelled() {
                    return ref.get() == null || ((ScheduledTask)ref.get()).isCancelled();
                }
            };
        }
        BukkitTask t = Bukkit.getScheduler().runTaskTimer(plugin, task, Math.max(0L, initialDelayTicks), Math.max(1L, periodTicks));
        return CrashScheduler.bukkitHandle(t);
    }

    public static void runTaskTimer(Plugin plugin, Consumer<CancelHandle> task, long initialDelayTicks, long periodTicks) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(task);
        if (periodTicks <= 0L) {
            periodTicks = 1L;
        }
        if (CrashScheduler.isFolia()) {
            final AtomicReference<ScheduledTask> ref = new AtomicReference<ScheduledTask>();
            CancelHandle handle = new CancelHandle(){

                @Override
                public void cancel() {
                    ScheduledTask s = ref.getAndSet(null);
                    if (s != null) {
                        s.cancel();
                    }
                }

                @Override
                public boolean isCancelled() {
                    return ref.get() == null || ((ScheduledTask)ref.get()).isCancelled();
                }
            };
            ScheduledTask t2 = globalRegionScheduler.runAtFixedRate(plugin, st -> task.accept(handle), initialDelayTicks, periodTicks);
            ref.set(t2);
        } else {
            Bukkit.getScheduler().runTaskTimer(plugin, (T t) -> {
                CancelHandle cancelHandle = CrashScheduler.bukkitHandle(t);
            }, Math.max(0L, initialDelayTicks), Math.max(1L, periodTicks));
        }
    }

    public static CancelHandle runAtLocation(Plugin plugin, Location where, Runnable task) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(where);
        Objects.requireNonNull(task);
        if (CrashScheduler.isFolia()) {
            final AtomicReference<ScheduledTask> ref = new AtomicReference<ScheduledTask>();
            ScheduledTask t = regionScheduler.run(plugin, where, st -> task.run());
            ref.set(t);
            return new CancelHandle(){

                @Override
                public void cancel() {
                    ScheduledTask s = ref.getAndSet(null);
                    if (s != null) {
                        s.cancel();
                    }
                }

                @Override
                public boolean isCancelled() {
                    return ref.get() == null || ((ScheduledTask)ref.get()).isCancelled();
                }
            };
        }
        BukkitTask t = Bukkit.getScheduler().runTask(plugin, task);
        return CrashScheduler.bukkitHandle(t);
    }

    public static CancelHandle runPlayerRepeating(Plugin plugin, Player player, Runnable task, long initialDelayTicks, long periodTicks) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(player);
        Objects.requireNonNull(task);
        if (CrashScheduler.isFolia()) {
            ScheduledTask t;
            final AtomicReference<ScheduledTask> ref = new AtomicReference<ScheduledTask>();
            try {
                t = ((EntityScheduler)getPlayerSchedulerMethod.invoke((Object)player, new Object[0])).runAtFixedRate(plugin, st -> task.run(), () -> {}, initialDelayTicks, periodTicks);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
            ref.set(t);
            return new CancelHandle(){

                @Override
                public void cancel() {
                    ScheduledTask s = ref.getAndSet(null);
                    if (s != null) {
                        s.cancel();
                    }
                }

                @Override
                public boolean isCancelled() {
                    return ref.get() == null || ((ScheduledTask)ref.get()).isCancelled();
                }
            };
        }
        BukkitTask t = Bukkit.getScheduler().runTaskTimer(plugin, task, Math.max(0L, initialDelayTicks), Math.max(1L, periodTicks));
        return CrashScheduler.bukkitHandle(t);
    }

    public static CancelHandle runTaskAsynchronously(Plugin plugin, Runnable task) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(task);
        if (CrashScheduler.isFolia()) {
            try {
                Method m = asyncScheduler.getClass().getMethod("runNow", Plugin.class, Consumer.class);
                final AtomicReference<Object> ref = new AtomicReference<Object>();
                Object schedTask = m.invoke((Object)asyncScheduler, plugin, st -> task.run());
                ref.set(schedTask);
                return new CancelHandle(){

                    @Override
                    public void cancel() {
                        Object s = ref.getAndSet(null);
                        if (s != null) {
                            CrashScheduler.invokeCancel(s);
                        }
                    }

                    @Override
                    public boolean isCancelled() {
                        Object s = ref.get();
                        return s == null || CrashScheduler.isCancelled(s);
                    }
                };
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("AsyncScheduler.runNow not found", e);
            }
        }
        BukkitTask t = Bukkit.getScheduler().runTaskAsynchronously(plugin, task);
        return CrashScheduler.bukkitHandle(t);
    }

    public static CancelHandle runAsyncLater(Plugin plugin, Runnable task, long delayTicks) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(task);
        if (CrashScheduler.isFolia()) {
            AsyncScheduler scheduler = asyncScheduler;
            Class<?> cls = scheduler.getClass();
            try {
                Method m = cls.getMethod("runDelayed", Plugin.class, Consumer.class, Duration.class);
                final AtomicReference<Object> ref = new AtomicReference<Object>();
                Object st = m.invoke((Object)scheduler, plugin, ignored -> task.run(), Duration.ofMillis(Math.max(0L, delayTicks) * 50L));
                ref.set(st);
                return new CancelHandle(){

                    @Override
                    public void cancel() {
                        Object s = ref.getAndSet(null);
                        if (s != null) {
                            CrashScheduler.invokeCancel(s);
                        }
                    }

                    @Override
                    public boolean isCancelled() {
                        Object s = ref.get();
                        return s == null || CrashScheduler.isCancelled(s);
                    }
                };
            }
            catch (NoSuchMethodException e) {
                try {
                    Method m = cls.getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE, TimeUnit.class);
                    final AtomicReference<Object> ref = new AtomicReference<Object>();
                    Object st = m.invoke((Object)scheduler, new Object[]{plugin, ignored -> task.run(), Math.max(0L, delayTicks), TimeUnit.MILLISECONDS});
                    ref.set(st);
                    return new CancelHandle(){

                        @Override
                        public void cancel() {
                            Object s = ref.getAndSet(null);
                            if (s != null) {
                                CrashScheduler.invokeCancel(s);
                            }
                        }

                        @Override
                        public boolean isCancelled() {
                            Object s = ref.get();
                            return s == null || CrashScheduler.isCancelled(s);
                        }
                    };
                }
                catch (ReflectiveOperationException e2) {
                    throw new IllegalStateException("AsyncScheduler.runDelayed not found (Duration or TimeUnit)", e2);
                }
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("AsyncScheduler.runDelayed invocation failed", e);
            }
        }
        BukkitTask t = Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, task, Math.max(0L, delayTicks));
        return CrashScheduler.bukkitHandle(t);
    }

    public static CancelHandle runTaskTimerAsynchronously(Plugin plugin, Runnable task, long initialDelayTicks, long periodTicks) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(task);
        if (periodTicks <= 0L) {
            periodTicks = 1L;
        }
        if (CrashScheduler.isFolia()) {
            AsyncScheduler scheduler = asyncScheduler;
            Class<?> cls = scheduler.getClass();
            try {
                Method m = cls.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Duration.class, Duration.class);
                final AtomicReference<Object> ref = new AtomicReference<Object>();
                Object st = m.invoke((Object)scheduler, plugin, ignored -> task.run(), Duration.ofMillis(Math.max(0L, initialDelayTicks) * 50L), Duration.ofMillis(Math.max(1L, periodTicks) * 50L));
                ref.set(st);
                return new CancelHandle(){

                    @Override
                    public void cancel() {
                        Object s = ref.getAndSet(null);
                        if (s != null) {
                            CrashScheduler.invokeCancel(s);
                        }
                    }

                    @Override
                    public boolean isCancelled() {
                        Object s = ref.get();
                        return s == null || CrashScheduler.isCancelled(s);
                    }
                };
            }
            catch (NoSuchMethodException e) {
                try {
                    Method m = cls.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class);
                    final AtomicReference<Object> ref = new AtomicReference<Object>();
                    long delayMs = Math.max(0L, initialDelayTicks) * 50L;
                    long periodMs = Math.max(1L, periodTicks) * 50L;
                    Object st = m.invoke((Object)scheduler, new Object[]{plugin, ignored -> task.run(), delayMs, periodMs, TimeUnit.MILLISECONDS});
                    ref.set(st);
                    return new CancelHandle(){

                        @Override
                        public void cancel() {
                            Object s = ref.getAndSet(null);
                            if (s != null) {
                                CrashScheduler.invokeCancel(s);
                            }
                        }

                        @Override
                        public boolean isCancelled() {
                            Object s = ref.get();
                            return s == null || CrashScheduler.isCancelled(s);
                        }
                    };
                }
                catch (ReflectiveOperationException e2) {
                    throw new IllegalStateException("AsyncScheduler.runAtFixedRate not found (Duration or TimeUnit)", e2);
                }
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("AsyncScheduler.runAtFixedRate invocation failed", e);
            }
        }
        BukkitTask t = Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, task, Math.max(0L, initialDelayTicks), Math.max(1L, periodTicks));
        return CrashScheduler.bukkitHandle(t);
    }

    public static void runTaskTimerAsynchronously(Plugin plugin, Consumer<CancelHandle> task, long initialDelayTicks, long periodTicks) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(task);
        if (periodTicks <= 0L) {
            periodTicks = 1L;
        }
        if (CrashScheduler.isFolia()) {
            AsyncScheduler scheduler = asyncScheduler;
            Class<?> cls = scheduler.getClass();
            try {
                Method m = cls.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Duration.class, Duration.class);
                final AtomicReference<Object> ref = new AtomicReference<Object>();
                CancelHandle handle = new CancelHandle(){

                    @Override
                    public void cancel() {
                        Object s = ref.getAndSet(null);
                        if (s != null) {
                            CrashScheduler.invokeCancel(s);
                        }
                    }

                    @Override
                    public boolean isCancelled() {
                        Object s = ref.get();
                        return s == null || CrashScheduler.isCancelled(s);
                    }
                };
                Object st = m.invoke((Object)scheduler, plugin, ignored -> task.accept(handle), Duration.ofMillis(Math.max(0L, initialDelayTicks) * 50L), Duration.ofMillis(Math.max(1L, periodTicks) * 50L));
                ref.set(st);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method m = cls.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class);
                    final AtomicReference<Object> ref = new AtomicReference<Object>();
                    long delayMs = Math.max(0L, initialDelayTicks) * 50L;
                    long periodMs = Math.max(1L, periodTicks) * 50L;
                    CancelHandle handle = new CancelHandle(){

                        @Override
                        public void cancel() {
                            Object s = ref.getAndSet(null);
                            if (s != null) {
                                CrashScheduler.invokeCancel(s);
                            }
                        }

                        @Override
                        public boolean isCancelled() {
                            Object s = ref.get();
                            return s == null || CrashScheduler.isCancelled(s);
                        }
                    };
                    Object st = m.invoke((Object)scheduler, new Object[]{plugin, ignored -> task.accept(handle), delayMs, periodMs, TimeUnit.MILLISECONDS});
                    ref.set(st);
                }
                catch (ReflectiveOperationException e2) {
                    throw new IllegalStateException("AsyncScheduler.runAtFixedRate not found (Duration or TimeUnit)", e2);
                }
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("AsyncScheduler.runAtFixedRate invocation failed", e);
            }
        } else {
            Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, (T ta) -> task.accept(CrashScheduler.bukkitHandle(ta)), Math.max(0L, initialDelayTicks), Math.max(1L, periodTicks));
        }
    }

    public static void teleport(Entity entity, Location location) {
        Objects.requireNonNull(entity);
        Objects.requireNonNull(location);
        if (CrashScheduler.isFolia()) {
            try {
                teleportAsyncMethod.invoke((Object)entity, location);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            entity.teleport(location);
        }
    }

    private static void invokeCancel(Object scheduledTask) {
        try {
            scheduledTask.getClass().getMethod("cancel", new Class[0]).invoke(scheduledTask, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static boolean isCancelled(Object scheduledTask) {
        try {
            return (Boolean)scheduledTask.getClass().getMethod("isCancelled", new Class[0]).invoke(scheduledTask, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    private static CancelHandle bukkitHandle(BukkitTask t) {
        final AtomicReference<BukkitTask> ref = new AtomicReference<BukkitTask>(t);
        return new CancelHandle(){

            @Override
            public void cancel() {
                BukkitTask cur = ref.getAndSet(null);
                if (cur != null) {
                    cur.cancel();
                }
            }

            @Override
            public boolean isCancelled() {
                BukkitTask cur = (BukkitTask)ref.get();
                return cur == null || cur.isCancelled();
            }
        };
    }

    public static interface CancelHandle {
        public void cancel();

        public boolean isCancelled();
    }
}

