/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.folia.CrashScheduler;
import com.crashstudios.crashcore.model.CustomModel;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.ModelEntity;
import com.crashstudios.crashcore.model.data.Animation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CustomModelCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("spawn")) {
                    p.sendMessage("\u00a7cWrong arguments. /custommodel spawn <id or name>");
                } else if (args[0].equalsIgnoreCase("kill")) {
                    p.sendMessage("\u00a7cWrong arguments. /custommodel kill <uuid>");
                }
            } else if (args.length == 2) {
                if (args[0].equalsIgnoreCase("spawn")) {
                    CustomModel model = null;
                    try {
                        model = ModelEditor.models.get(UUID.fromString(args[1]));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (model == null) {
                        for (CustomModel m : ModelEditor.models.values()) {
                            if (!m.data.name.equalsIgnoreCase(args[1])) continue;
                            model = m;
                            break;
                        }
                    }
                    if (model != null) {
                        Location origin = p.getLocation().clone();
                        origin.setPitch(0.0f);
                        ModelEntity entity = new ModelEntity(UUID.randomUUID(), model.data.uuid);
                        entity.spawn(model, origin);
                        p.sendMessage("\u00a7aModel Entity spawned with '" + entity.data.uuid.toString() + "' UUID.");
                    } else {
                        p.sendMessage("\u00a7cInvalid ID/name.");
                    }
                } else if (args[0].equalsIgnoreCase("spawnanimation")) {
                    sender.sendMessage("\u00a7c/custommodel spawnanimation <id or name> <animation> [duration]: spawns a temporary custom model with an animation.");
                } else if (args[0].equalsIgnoreCase("kill")) {
                    ModelEntity model = null;
                    try {
                        model = ModelEditor.entities.get(UUID.fromString(args[1]));
                    }
                    catch (IllegalArgumentException origin) {
                        // empty catch block
                    }
                    if (model != null) {
                        model.remove();
                        p.sendMessage("\u00a7aModel Entity removed.");
                    } else {
                        p.sendMessage("\u00a7cModel Entity not found.");
                    }
                }
            } else if (args.length == 3 || args.length == 4 || args.length == 5) {
                if (args[0].equalsIgnoreCase("spawnanimation")) {
                    CustomModel model = null;
                    try {
                        model = ModelEditor.models.get(UUID.fromString(args[1]));
                    }
                    catch (IllegalArgumentException origin) {
                        // empty catch block
                    }
                    if (model == null) {
                        for (CustomModel m : ModelEditor.models.values()) {
                            if (!m.data.name.equalsIgnoreCase(args[1])) continue;
                            model = m;
                            break;
                        }
                    }
                    if (model != null) {
                        Animation animation = null;
                        for (Animation anim : model.data.animations) {
                            if (!anim.id.equalsIgnoreCase(args[2])) continue;
                            animation = anim;
                            break;
                        }
                        if (animation != null) {
                            Location origin = p.getLocation().clone();
                            origin.setPitch(0.0f);
                            ModelEntity entity = new ModelEntity(UUID.randomUUID(), model.data.uuid);
                            entity.spawn(model, origin);
                            entity.setPersistent(false);
                            int tick = animation.tickDurations;
                            if (args.length >= 4) {
                                try {
                                    tick = Integer.parseInt(args[3]);
                                }
                                catch (NumberFormatException e) {
                                    p.sendMessage("\u00a7cInvalid duration, using default: " + animation.tickDurations);
                                }
                                if (args.length == 5 && args[4].equalsIgnoreCase("follow")) {
                                    CrashScheduler.CancelHandle task = CrashScheduler.runTaskTimer((Plugin)Main.INSTANCE, () -> {
                                        Location loc = p.getLocation();
                                        modelEntity.data.origin[0] = (float)loc.getX();
                                        modelEntity.data.origin[1] = (float)loc.getY();
                                        modelEntity.data.origin[2] = (float)loc.getZ();
                                        modelEntity.data.rotation[0] = loc.getYaw();
                                        modelEntity.data.rotation[1] = loc.getPitch();
                                        modelEntity.dirty = true;
                                    }, 1L, 1L);
                                    CrashScheduler.runTaskLater((Plugin)Main.INSTANCE, () -> task.cancel(), tick);
                                }
                            }
                            CrashScheduler.runTaskLater((Plugin)Main.INSTANCE, () -> {
                                if (entity != null) {
                                    entity.remove();
                                }
                            }, tick);
                            entity.data.currentAnimations.add(new ModelEntity.ModelEntityAnimationData(animation.id, tick));
                            p.sendMessage("\u00a7aTemporary Model Entity spawned with '" + entity.data.uuid.toString() + "' UUID for " + tick + " ticks.");
                        } else {
                            p.sendMessage("\u00a7cInvalid animation ID.");
                        }
                    } else {
                        p.sendMessage("\u00a7cInvalid ID/name.");
                    }
                }
            } else {
                sender.sendMessage("\u00a7cWrong Argument.");
                sender.sendMessage("\u00a7c/custommodel spawn <id or name>: spawns a custom model.");
                sender.sendMessage("\u00a7c/custommodel spawnanimation <id or name> <animation> [duration] [follow|stay]: spawns a temporary custom model with an animation.");
                sender.sendMessage("\u00a7c/custommodel kill <uuid>: kills a custom model.");
            }
        } else {
            sender.sendMessage("\u00a7cYou must be a player.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.add("spawn");
            list.add("spawnanimation");
            list.add("kill");
        } else if (args.length == 2 && (args[0].equalsIgnoreCase("spawn") || args[0].equalsIgnoreCase("spawnanimation"))) {
            for (CustomModel model : ModelEditor.models.values()) {
                if (!model.data.name.contains(args[1])) continue;
                list.add(model.data.name);
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("spawnanimation")) {
            for (CustomModel model : ModelEditor.models.values()) {
                if (!model.data.name.equalsIgnoreCase(args[1])) continue;
                for (Animation anim : model.data.animations) {
                    if (!anim.id.contains(args[2])) continue;
                    list.add(anim.id);
                }
            }
        } else if (args.length == 5 && args[0].equalsIgnoreCase("spawnanimation")) {
            list.add("follow");
            list.add("stay");
        }
        return list;
    }
}

