/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model;

import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.ModelEntity;
import com.crashstudios.crashcore.model.Scripts;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.Pins;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.persistence.PersistentDataType;

public class CustomModelListener
implements Listener {
    @EventHandler
    public void onInteract(PlayerInteractEntityEvent e) {
        Entity ent = e.getRightClicked();
        if (ent.getPersistentDataContainer().has(ModelEditor.INTERACTION, PersistentDataType.STRING)) {
            String script_id = (String)ent.getPersistentDataContainer().get(ModelEditor.INTERACTION, PersistentDataType.STRING);
            ModelEntity model = ModelEditor.entities.get(UUID.fromString((String)ent.getPersistentDataContainer().get(ModelEditor.MODEL, PersistentDataType.STRING)));
            if (model != null) {
                CustomModelListener.callEvent(model, script_id, new Object[]{e.getPlayer(), e, model}, "model_rightinteract");
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        Entity ent = e.getEntity();
        if (ent.getPersistentDataContainer().has(ModelEditor.INTERACTION, PersistentDataType.STRING)) {
            String script_id = (String)ent.getPersistentDataContainer().get(ModelEditor.INTERACTION, PersistentDataType.STRING);
            ModelEntity model = ModelEditor.entities.get(UUID.fromString((String)ent.getPersistentDataContainer().get(ModelEditor.MODEL, PersistentDataType.STRING)));
            if (model != null) {
                if (e.getDamager() instanceof Player) {
                    Player p = (Player)e.getDamager();
                    CustomModelListener.callEvent(model, script_id, new Object[]{p, e, model}, "model_leftinteract");
                }
                CustomModelListener.callEvent(model, script_id, new Object[]{e.getDamager(), e, model, e.getDamage()}, "model_damageaction");
            }
        }
    }

    public static void callEvent(ModelEntity model, String script_id, Object[] args, String type) {
        for (CompiledScript.Node node : Scripts.getCompiledScript((UUID)model.getScriptUUID()).startingNodes) {
            if (!node.type.equals(type) || !((CompiledScript.Data)node.input[0]).data.isEmpty() && !script_id.equals(((CompiledScript.Data)node.input[0]).data)) continue;
            node.start(new HashMap<CompiledScript.Node, Pins>(), args);
        }
    }
}

