/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.editor.EditorFile;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.folia.CrashScheduler;
import com.crashstudios.crashcore.model.BBModelFile;
import com.crashstudios.crashcore.model.CustomModel;
import com.crashstudios.crashcore.model.CustomModelData;
import com.crashstudios.crashcore.model.ModelEntity;
import com.crashstudios.crashcore.model.ModelUtils_1_19_4;
import com.crashstudios.crashcore.model.Scripts;
import com.crashstudios.crashcore.model.data.ModelFile;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.net.InfoPacketListener;
import com.crashstudios.crashcore.net.RequestPacketListener;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.storage.SLAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;

public class ModelEditor {
    public static Integer idCounter = 2000000;
    public static UUID uuidCounter = UUID.randomUUID();
    public static ConcurrentHashMap<UUID, CustomModel> models = new ConcurrentHashMap();
    public static HashMap<UUID, ModelEntity> entities = new HashMap();
    public static HashMap<UUID, BBModelFile> bbModels = new HashMap();
    public static NamespacedKey INTERACTION = new NamespacedKey((Plugin)Main.INSTANCE, "modelinteraction");
    public static NamespacedKey MODEL = new NamespacedKey((Plugin)Main.INSTANCE, "custommodelid");
    public static NamespacedKey COLLISION = new NamespacedKey((Plugin)Main.INSTANCE, "modelcollision");
    public static ModelUtils_1_19_4 modelUtils = new ModelUtils_1_19_4();

    public static void load() {
        Serializable data;
        File file;
        File idDataFile;
        File folder = new File(Main.INSTANCE.getDataFolder(), "models");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((idDataFile = new File(Main.INSTANCE.getDataFolder(), "modelcomponent.dat")).exists()) {
            try {
                idCounter = (Integer)SLAPI.load(idDataFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ModelEditor.saveIDCounter();
        }
        File uuidDataFile = new File(Main.INSTANCE.getDataFolder(), "modeluuid.dat");
        if (uuidDataFile.exists()) {
            try {
                uuidCounter = (UUID)SLAPI.load(uuidDataFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ModelEditor.saveUUIDCounter();
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            try {
                data = (CustomModelData)SLAPI.load(file);
                models.put(data.uuid, new CustomModel((CustomModelData)data));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        folder = new File(Main.INSTANCE.getDataFolder(), "modelentities");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        fileArray = folder.listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            try {
                data = (ModelEntity.ModelEntityData)SLAPI.load(file);
                entities.put(((ModelEntity.ModelEntityData)data).uuid, new ModelEntity((ModelEntity.ModelEntityData)data));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        folder = new File(Main.INSTANCE.getDataFolder(), "bbmodels");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        fileArray = folder.listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            try {
                data = (BBModelFile)SLAPI.load(file);
                bbModels.put(((BBModelFile)data).id, (BBModelFile)data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        ConnectionClientHandler.requestPacketListeners.put("custommodelslist", new RequestPacketListener("custommodelslist"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                JsonObject json = new JsonObject();
                json.addProperty("page", (Number)1);
                json.addProperty("maxpage", (Number)1);
                json.addProperty("sessionid", (Number)data.get("sessionid").getAsInt());
                json.addProperty("createlink", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/model/" + ConnectionClientHandler.serverID + "?file=" + String.valueOf(uuidCounter));
                JsonArray elements = new JsonArray();
                String name = data.get("text").getAsString();
                for (CustomModel model : models.values()) {
                    if (!model.data.name.toLowerCase().contains(name.toLowerCase())) continue;
                    JsonObject element = new JsonObject();
                    element.addProperty("image", "/images/invsee/items/stone.png");
                    element.addProperty("name", model.data.name);
                    element.addProperty("id", model.data.uuid.toString());
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/model/" + ConnectionClientHandler.serverID + "?file=" + model.data.uuid.toString());
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                ConnectionClientHandler.sendInfoPacket("custommodelslist", json);
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("modeleditor", new RequestPacketListener("modeleditor"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid;
                try {
                    uuid = UUID.fromString(packet.get("info").getAsJsonObject().get("id").getAsString());
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                CustomModel model = models.get(uuid);
                if (model == null && uuid.equals(uuidCounter)) {
                    if (Main.upgrade == null && models.size() >= 6) {
                        return;
                    }
                    model = new CustomModel(uuid);
                    model.save();
                    models.put(uuid, model);
                    uuidCounter = UUID.randomUUID();
                    ModelEditor.saveUUIDCounter();
                }
                if (model != null) {
                    JsonObject json = new JsonObject();
                    json.addProperty("name", model.data.name);
                    json.addProperty("key", model.data.uuid.toString());
                    json.addProperty("id", model.data.uuid.toString());
                    model.data.toJson();
                    json.add("data", (JsonElement)model.data.toJson());
                    json.addProperty("sessionid", sessionid);
                    json.addProperty("datatype", "data");
                    ConnectionClientHandler.sendInfoPacket("modeleditor", json);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("modeleditor", new InfoPacketListener("modeleditor"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject().get("data").getAsJsonObject();
                UUID uuid = UUID.fromString(packet.get("info").getAsJsonObject().get("id").getAsString());
                CustomModel model = models.get(uuid);
                if (model != null) {
                    String type = data.get("type").getAsString();
                    if (type.equals("deletemodel")) {
                        String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                        JsonObject json2 = new JsonObject();
                        json2.addProperty("datatype", "deletefiles");
                        json2.addProperty("key", model.data.uuid.toString());
                        json2.addProperty("sessionid", sessionid);
                        JsonArray files = new JsonArray();
                        files.add(data.get("modelid").getAsString());
                        json2.add("files", (JsonElement)files);
                        ConnectionClientHandler.sendInfoPacket("modeleditor", json2);
                    } else if (type.equals("newmodeljson")) {
                        String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                        JsonObject json = new JsonObject();
                        json.addProperty("datatype", "newmodeljson");
                        json.addProperty("key", model.data.uuid.toString());
                        json.addProperty("sessionid", sessionid);
                        json.addProperty("fileid", (Number)(idCounter - 2000000));
                        ConnectionClientHandler.sendInfoPacket("modeleditor", json);
                        idCounter = idCounter + 1;
                        ModelEditor.saveIDCounter();
                    } else if (type.equals("changename")) {
                        model.data.name = data.get("name").getAsString();
                        model.save();
                    } else if (type.equals("update")) {
                        String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                        CustomModelData obj = CustomModelData.fromJson(data);
                        model.data.outline = obj.outline;
                        model.data.models = obj.models;
                        model.data.animations = obj.animations;
                        model.save();
                        JsonObject json = new JsonObject();
                        json.addProperty("datatype", "save_feedback");
                        json.addProperty("key", model.data.uuid.toString());
                        json.addProperty("sessionid", sessionid);
                        ConnectionClientHandler.sendInfoPacket("modeleditor", json);
                    } else if (type.equals("deleteall")) {
                        String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                        model.remove();
                        JsonArray jsons = new JsonArray();
                        JsonArray bbs = new JsonArray();
                        JsonArray bbmodels = new JsonArray();
                        for (ModelFile file : model.data.models) {
                            if (!ModelEditor.removeModel(file)) continue;
                            if (file.type.equals("bbmodel")) {
                                UUID id = UUID.fromString(file.id);
                                if (!bbModels.containsKey(id)) continue;
                                BBModelFile bbModel = bbModels.remove(id);
                                bbModel.getIds(bbmodels);
                                bbModel.remove();
                                bbs.add(bbModel.id.toString());
                                continue;
                            }
                            jsons.add(file.id);
                        }
                        JsonObject json2 = new JsonObject();
                        json2.addProperty("datatype", "deleteall");
                        json2.addProperty("key", model.data.uuid.toString());
                        json2.addProperty("sessionid", sessionid);
                        json2.add("jsons", (JsonElement)jsons);
                        json2.add("bbs", (JsonElement)bbs);
                        json2.add("bbmodels", (JsonElement)bbmodels);
                        ConnectionClientHandler.sendInfoPacket("modeleditor", json2);
                    } else if (type.equals("uploadbbmodel")) {
                        String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                        UUID id = UUID.fromString(data.get("id").getAsString());
                        JsonArray ids = new JsonArray();
                        if (bbModels.containsKey(id)) {
                            BBModelFile bbModel = bbModels.get(id);
                            bbModel.getIds(ids);
                        }
                        BBModelFile.optimizeJson(data);
                        JsonArray models = data.getAsJsonArray("models");
                        int i = 0;
                        while (i < Math.min(models.size(), ids.size())) {
                            models.get(i).getAsJsonObject().addProperty("model_id", (Number)ids.get(i).getAsInt());
                            ++i;
                        }
                        i = ids.size();
                        while (i < models.size()) {
                            models.get(i).getAsJsonObject().addProperty("model_id", (Number)idCounter);
                            ids.add((Number)idCounter);
                            idCounter = idCounter + 1;
                            ++i;
                        }
                        BBModelFile bbModel = BBModelFile.fromJson(data);
                        bbModel.save();
                        bbModels.put(bbModel.id, bbModel);
                        JsonObject json = new JsonObject();
                        json.addProperty("datatype", "newmodelbbmodel");
                        json.addProperty("key", model.data.uuid.toString());
                        json.addProperty("sessionid", sessionid);
                        json.add("models", (JsonElement)data.getAsJsonArray("models"));
                        json.add("bbfile", (JsonElement)bbModel.toJson());
                        json.add("textures", (JsonElement)data.getAsJsonArray("textures"));
                        json.add("deleteids", (JsonElement)ids);
                        json.addProperty("bbid", bbModel.id.toString());
                        ConnectionClientHandler.sendInfoPacket("modeleditor", json);
                        ModelEditor.saveIDCounter();
                    } else if (type.equals("deletebbmodel")) {
                        String sessionid = packet.get("info").getAsJsonObject().get("sessionid").getAsString();
                        UUID id = UUID.fromString(data.get("id").getAsString());
                        JsonArray ids = new JsonArray();
                        if (bbModels.containsKey(id)) {
                            BBModelFile bbModel = bbModels.remove(id);
                            bbModel.getIds(ids);
                            bbModel.remove();
                        }
                        JsonObject json = new JsonObject();
                        json.addProperty("datatype", "newmodelbbmodel");
                        json.addProperty("key", model.data.uuid.toString());
                        json.addProperty("sessionid", sessionid);
                        json.add("models", (JsonElement)new JsonArray());
                        json.add("textures", (JsonElement)new JsonArray());
                        json.add("deleteids", (JsonElement)ids);
                        json.addProperty("bbid", id.toString());
                        ConnectionClientHandler.sendInfoPacket("modeleditor", json);
                        ModelEditor.saveIDCounter();
                    }
                }
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("editormodels", new RequestPacketListener("editormodels"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid;
                String key = packet.get("info").getAsJsonObject().get("id").getAsString();
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                EditorFile file = Scripts.scripts.get(uuid);
                if (file != null) {
                    CustomModel model = null;
                    for (CustomModel i : models.values()) {
                        if (!i.data.scripts.contains(uuid)) continue;
                        model = i;
                        break;
                    }
                    if (model == null) {
                        return;
                    }
                    JsonObject json = file.serialize();
                    json.addProperty("key", key);
                    json.addProperty("filename", model.data.name);
                    json.addProperty("infoid", model.data.uuid.toString());
                    CustomNodes.addCustomNodes(json);
                    ConnectionClientHandler.sendInfoPacket("editormodels", json);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("editormodels", new InfoPacketListener("editormodels"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid;
                JsonObject data = packet.get("info").getAsJsonObject();
                String key = data.get("id").getAsString();
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                EditorFile file = Scripts.scripts.get(uuid);
                if (file != null) {
                    Scripts.save(uuid, EditorFile2.deserialize(data));
                    EditorFile2.sendSavedSuccess("editormodels", key);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("custommodelmodeleditor", new InfoPacketListener("custommodelmodeleditor"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                String action = data.get("action").getAsString();
                String sessionid = data.get("sessionid").getAsString();
                if (action.equals("add")) {
                    JsonObject json = new JsonObject();
                    json.addProperty("action", "add");
                    json.addProperty("fileid", (Number)idCounter);
                    json.addProperty("sessionid", sessionid);
                    ConnectionClientHandler.sendInfoPacket("custommodelmodeleditor", json);
                    idCounter = idCounter + 1;
                    ModelEditor.saveIDCounter();
                }
            }
        });
        CrashScheduler.runTaskTimer((Plugin)Main.INSTANCE, () -> {
            for (ModelEntity ent : entities.values()) {
                if (!ent.dirty && ent.data.currentAnimations.size() <= 0) continue;
                for (ModelEntity.ModelEntityAnimationData d2 : ent.data.currentAnimations) {
                    ++d2.counter;
                    if (d2.tick <= 0) continue;
                    --d2.tick;
                }
                ent.data.currentAnimations.removeIf(d -> d.tick == 0);
                ent.update();
                ent.dirty = false;
            }
        }, 40L, 1L);
        CrashScheduler.runTaskTimerAsynchronously((Plugin)Main.INSTANCE, () -> {
            for (ModelEntity ent : entities.values()) {
                if (ent.removed || !ent.toSave) continue;
                ent.saveThreadSafe();
            }
            entities.entrySet().removeIf(entry -> ((ModelEntity)entry.getValue()).removed);
        }, 40L, 1L);
        CrashScheduler.runTaskTimer((Plugin)Main.INSTANCE, new Runnable(){
            int timer = 0;

            @Override
            public void run() {
                for (ModelEntity ent : entities.values()) {
                    for (CompiledScript.Node node : Scripts.getCompiledScript((UUID)ent.getScriptUUID()).startingNodes) {
                        int period;
                        if (!node.type.equals("model_tickaction") || (period = Double.valueOf(((CompiledScript.Data)node.input[0]).data).intValue()) == 0 || this.timer % period != 0) continue;
                        node.start(new HashMap<CompiledScript.Node, Pins>(), new Object[]{ent});
                    }
                }
                ++this.timer;
            }
        }, 40L, 1L);
    }

    public static void saveIDCounter() {
        try {
            SLAPI.save((Object)idCounter, new File(Main.INSTANCE.getDataFolder(), "modelcomponent.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveUUIDCounter() {
        try {
            SLAPI.save((Object)uuidCounter, new File(Main.INSTANCE.getDataFolder(), "modeluuid.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean removeModel(ModelFile model) {
        for (CustomModel m : models.values()) {
            for (ModelFile mf : m.data.models) {
                if (!mf.id.equals(model.id)) continue;
                return false;
            }
        }
        return true;
    }
}

