/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.model;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.editor.EditorFile;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.model.CompiledScript;
import com.crashstudios.crashcore.script.CompiledScriptRules;
import com.crashstudios.crashcore.storage.SLAPI;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;

public class Scripts {
    public static HashMap<UUID, EditorFile> scripts = new HashMap();
    public static HashMap<UUID, CompiledScript> compiledScripts = new HashMap();
    public static CompiledScriptRules scriptRules = new CompiledScriptRules();

    static {
        Scripts.scriptRules.listeners.add("model_leftinteract");
        Scripts.scriptRules.listeners.add("model_rightinteract");
        Scripts.scriptRules.listeners.add("model_damageaction");
        Scripts.scriptRules.listeners.add("model_createaction");
        Scripts.scriptRules.listeners.add("model_tickaction");
        Scripts.scriptRules.listeners.add("model_receivedata");
        Scripts.scriptRules.listeners.add("model_entersensor");
        Scripts.scriptRules.listeners.add("model_leavesensor");
    }

    public static CompiledScript getCompiledScript(UUID uuid) {
        CompiledScript script = compiledScripts.get(uuid);
        if (script == null) {
            script = CompiledScript.NULL_SCRIPT;
        }
        return script;
    }

    public static void load() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "modelscripts");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                EditorFile editorFile = (EditorFile)SLAPI.load(file);
                if (!(editorFile instanceof EditorFile2)) {
                    EditorFile2 newFile = new EditorFile2();
                    newFile.nodes = editorFile.nodes;
                    editorFile = newFile;
                }
                UUID uuid = UUID.fromString(file.getName());
                scripts.put(uuid, editorFile);
                compiledScripts.put(uuid, new CompiledScript(scriptRules, editorFile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static void save(UUID uuid, EditorFile editorFile) {
        File folder = new File(Main.INSTANCE.getDataFolder(), "modelscripts");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        scripts.put(uuid, editorFile);
        CompiledScript compiledScript = compiledScripts.get(uuid);
        if (compiledScript == null) {
            compiledScripts.put(uuid, new CompiledScript(scriptRules, editorFile));
        } else {
            compiledScript.update(scriptRules, editorFile);
        }
        try {
            SLAPI.save((Object)editorFile, new File(folder, uuid.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void remove(UUID uuid) {
        scripts.remove(uuid);
        compiledScripts.remove(uuid);
        File folder = new File(Main.INSTANCE.getDataFolder(), "modelscripts");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            new File(folder, uuid.toString()).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

