/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.particles;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.folia.CrashScheduler;
import com.crashstudios.crashcore.particles.ParticleEmitter;
import com.crashstudios.crashcore.particles.ParticleInstance;
import com.crashstudios.crashcore.script.miscellaneous.ParticleUtils;
import com.crashstudios.crashcore.utilities.MathUtil;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class ParticleEngine {
    public int currentTick;
    private List<ParticleInstance> activeEmitters;
    private int ticks;
    public Location location;
    public double yaw;
    public double pitch;
    public double roll;
    private Consumer<ParticleEngine> updater;

    public ParticleEngine(Location loc, double yaw, double pitch, double roll, int ticks, List<ParticleInstance> emitters, Consumer<ParticleEngine> updater) {
        this.location = loc;
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.activeEmitters = emitters;
        this.ticks = ticks;
        this.updater = updater;
    }

    public void start(int duration) {
        int d = duration + 1;
        CrashScheduler.runTaskTimer((Plugin)Main.INSTANCE, task -> {
            if (this.currentTick >= d) {
                task.cancel();
            } else {
                this.update();
            }
        }, 0L, 1L);
    }

    public void update() {
        ++this.currentTick;
        if (this.updater != null) {
            this.updater.accept(this);
        }
        for (ParticleInstance instance : this.activeEmitters) {
            this.performEmission(instance);
        }
    }

    private void performEmission(ParticleInstance instance) {
        int amount = ((Number)instance.getEmitter().getProperty("amount", this.currentTick % this.ticks)).intValue();
        int speed = ((Number)instance.getEmitter().getProperty("speed", this.currentTick % this.ticks)).intValue();
        instance.setT0(instance.getT1());
        instance.setT1(instance.getT1() + (double)((float)speed / (float)amount) * 0.05);
        int point0 = Math.max((int)Math.floor(instance.getT0() * (double)amount - 1.0E-6), 0);
        int point1 = (int)Math.ceil(instance.getT1() * (double)amount - 1.0E-6);
        if (point0 >= point1 - 1) {
            return;
        }
        switch (instance.getEmitter().emitter) {
            case "point": {
                this.performPointEmission(instance.getEmitter(), point0, point1, amount);
                break;
            }
            case "line": {
                this.performLineEmission(instance.getEmitter(), point0, point1, amount);
                break;
            }
            case "ring": {
                this.performRingEmission(instance.getEmitter(), point0, point1, amount);
                break;
            }
            case "circle": {
                this.performCircleEmission(instance.getEmitter(), point0, point1, amount);
                break;
            }
            case "sphere": {
                this.performSphereEmission(instance.getEmitter(), point0, point1, amount);
                break;
            }
            case "semi_sphere": {
                this.performSemiSphereEmission(instance.getEmitter(), point0, point1, amount);
                break;
            }
            case "surface": {
                this.performSurfaceEmission(instance.getEmitter(), point0, point1, amount);
            }
        }
    }

    private MathUtil.Vector3D getOrigin(ParticleEmitter emitter, MathUtil.Vector3D rotation) {
        MathUtil.Vector3D position = (MathUtil.Vector3D)emitter.getProperty("position", this.currentTick % this.ticks);
        MathUtil.Vector3D offset = (MathUtil.Vector3D)emitter.getProperty("offset", this.currentTick % this.ticks);
        return MathUtil.Vector3D.add(position, MathUtil.Vector3D.rotate(offset, rotation));
    }

    public void performPointEmission(ParticleEmitter emitter, int point0, int point1, int amount) {
        String type = (String)emitter.getProperty("type", this.currentTick % this.ticks);
        int segmentLength = point1 - point0 - 1;
        if (segmentLength <= 0) {
            return;
        }
        double tick = this.currentTick % this.ticks;
        double deltaTick = 1.0 / (double)segmentLength;
        int i = point0 + 1;
        while (i < point1) {
            MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
            rotation = this.toPI(rotation);
            MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
            MathUtil.Vector3D zeroVelocity = new MathUtil.Vector3D(0.0, 0.0, 0.0);
            this.addParticle(origin, zeroVelocity, type, rotation, emitter, tick);
            tick += deltaTick;
            ++i;
        }
    }

    public void performLineEmission(ParticleEmitter emitter, int point0, int point1, int amount) {
        if (amount <= 1) {
            this.performPointEmission(emitter, point0, point1, amount);
            return;
        }
        String type = (String)emitter.getProperty("type", this.currentTick % this.ticks);
        double tick = this.currentTick % this.ticks;
        double deltaTick = 1.0 / (double)(point1 - point0 - 1);
        String placement = (String)emitter.getProperty("placement", this.currentTick % this.ticks);
        if ("random".equals(placement)) {
            int i = point0 + 1;
            while (i < point1) {
                MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                rotation = this.toPI(rotation);
                MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                double length = scale.z * 3.0;
                MathUtil.Vector3D direction = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                double t = Math.random();
                double offsetPoint = (t - 0.5) * length;
                this.addParticle(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(direction, offsetPoint)), new MathUtil.Vector3D(0.0, 0.0, 0.0), type, rotation, emitter, tick);
                tick += deltaTick;
                ++i;
            }
        } else if ("progress".equals(placement)) {
            int i = point0 + 1;
            while (i < point1) {
                MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                rotation = this.toPI(rotation);
                MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                double length = scale.z * 3.0;
                MathUtil.Vector3D direction = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                double t = (double)((i - 1) % amount) / (double)(amount - 1);
                double offsetPoint = (t - 0.5) * length;
                this.addParticle(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(direction, offsetPoint)), new MathUtil.Vector3D(0.0, 0.0, 0.0), type, rotation, emitter, tick);
                tick += deltaTick;
                ++i;
            }
        } else {
            int activation = point0 + 1;
            while (activation < point1) {
                if (activation % amount == 0) {
                    MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                    rotation = this.toPI(rotation);
                    MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                    MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                    double length = scale.z * 3.0;
                    MathUtil.Vector3D direction = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                    int i = 1;
                    while (i <= amount) {
                        double t = (double)((i - 1) % amount) / (double)(amount - 1);
                        double offsetPoint = (t - 0.5) * length;
                        this.addParticle(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(direction, offsetPoint)), new MathUtil.Vector3D(0.0, 0.0, 0.0), type, rotation, emitter, tick);
                        ++i;
                    }
                }
                tick += deltaTick;
                ++activation;
            }
        }
    }

    public void performRingEmission(ParticleEmitter emitter, int point0, int point1, int amount) {
        if (amount <= 1) {
            this.performPointEmission(emitter, point0, point1, amount);
            return;
        }
        String type = (String)emitter.getProperty("type", this.currentTick % this.ticks);
        double tick = this.currentTick % this.ticks;
        double deltaTick = 1.0 / (double)(point1 - point0 - 1);
        String placement = (String)emitter.getProperty("placement", this.currentTick % this.ticks);
        if ("random".equals(placement)) {
            int i = point0 + 1;
            while (i < point1) {
                MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                rotation = this.toPI(rotation);
                MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                double t = Math.random() * Math.PI * 2.0;
                double z = Math.sin(t) * scale.z;
                double x = Math.cos(t) * scale.x;
                MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, 0.0), type, rotation, emitter, tick);
                tick += deltaTick;
                ++i;
            }
        } else if ("progress".equals(placement)) {
            int i = point0 + 1;
            while (i < point1) {
                MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                rotation = this.toPI(rotation);
                MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                double t = (double)((i - 1) % amount) / (double)(amount - 1) * Math.PI * 2.0;
                double z = Math.sin(t) * scale.z;
                double x = Math.cos(t) * scale.x;
                MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, 0.0), type, rotation, emitter, tick);
                tick += deltaTick;
                ++i;
            }
        } else {
            int activation = point0 + 1;
            while (activation < point1) {
                if (activation % amount == 0) {
                    MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                    rotation = this.toPI(rotation);
                    MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                    MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                    MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                    MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                    int i = 1;
                    while (i <= amount) {
                        double t = (double)((i - 1) % amount) / (double)(amount - 1) * Math.PI * 2.0;
                        double z = Math.sin(t) * scale.z;
                        double x = Math.cos(t) * scale.x;
                        MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                        this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, 0.0), type, rotation, emitter, tick);
                        ++i;
                    }
                }
                tick += deltaTick;
                ++activation;
            }
        }
    }

    public void performCircleEmission(ParticleEmitter emitter, int point0, int point1, int amount) {
        if (amount <= 1) {
            this.performPointEmission(emitter, point0, point1, amount);
            return;
        }
        String type = (String)emitter.getProperty("type", this.currentTick % this.ticks);
        double tick = this.currentTick % this.ticks;
        double deltaTick = 1.0 / (double)(point1 - point0 - 1);
        String placement = (String)emitter.getProperty("placement", this.currentTick % this.ticks);
        if ("random".equals(placement)) {
            int i = point0 + 1;
            while (i < point1) {
                MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                rotation = this.toPI(rotation);
                MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                double t = Math.random() * Math.PI * 2.0;
                double r = Math.random();
                double z = Math.sin(t) * scale.z * r;
                double x = Math.cos(t) * scale.x * r;
                MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, 0.0), type, rotation, emitter, tick);
                tick += deltaTick;
                ++i;
            }
        } else {
            int detail = ((Double)emitter.getProperty("detail", this.currentTick % this.ticks)).intValue();
            int activation = point0 + 1;
            while (activation < point1) {
                if (activation % amount == 0) {
                    MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                    rotation = this.toPI(rotation);
                    MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                    MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                    MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                    MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                    double r = 1.0;
                    while (r > 0.0) {
                        int newAmount = (int)((double)(amount - 1) * r) + 1;
                        int i = 1;
                        while (i <= newAmount) {
                            double t = (double)(i - 1) / (double)(newAmount - 1) * Math.PI * 2.0;
                            double z = Math.sin(t) * scale.z * r;
                            double x = Math.cos(t) * scale.x * r;
                            MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                            this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, 0.0), type, rotation, emitter, tick);
                            ++i;
                        }
                        r -= 1.0 / (double)detail;
                    }
                }
                tick += deltaTick;
                ++activation;
            }
        }
    }

    public void performSphereEmission(ParticleEmitter emitter, int point0, int point1, int amount) {
        if (amount <= 1) {
            this.performPointEmission(emitter, point0, point1, amount);
            return;
        }
        String type = (String)emitter.getProperty("type", this.currentTick % this.ticks);
        double tick = this.currentTick % this.ticks;
        double deltaTick = 1.0 / (double)(point1 - point0 - 1);
        String placement = (String)emitter.getProperty("placement", this.currentTick % this.ticks);
        if ("random".equals(placement)) {
            int i = point0 + 1;
            while (i < point1) {
                MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                rotation = this.toPI(rotation);
                MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                MathUtil.Vector3D directionY = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 1.0, 0.0), rotation);
                MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                double t = Math.random() * Math.PI * 2.0;
                double t2 = (Math.random() - 0.5) * Math.PI * 2.0;
                double r_xz = Math.cos(t2);
                double z = Math.sin(t) * scale.z * r_xz;
                double x = Math.cos(t) * scale.x * r_xz;
                double y = Math.sin(t2) * scale.y;
                MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionY, y)), MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, t2), type, rotation, emitter, tick);
                tick += deltaTick;
                ++i;
            }
        } else {
            int detail = ((Double)emitter.getProperty("detail", this.currentTick % this.ticks)).intValue() + 2;
            int activation = point0 + 1;
            while (activation < point1) {
                if (activation % amount == 0) {
                    MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                    rotation = this.toPI(rotation);
                    MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                    MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                    MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                    MathUtil.Vector3D directionY = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 1.0, 0.0), rotation);
                    MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                    double t2_pre = 0.5;
                    while (t2_pre > -0.5000001) {
                        double t2 = t2_pre * Math.PI * 2.0;
                        double r_xz = Math.cos(t2);
                        double y = Math.sin(t2) * scale.y;
                        int newAmount = (int)((double)(amount - 1) * r_xz) + 1;
                        int i = 1;
                        while (i <= newAmount) {
                            double t = (double)(i - 1) / (double)(newAmount - 1) * Math.PI * 2.0;
                            double z = Math.sin(t) * scale.z * r_xz;
                            double x = Math.cos(t) * scale.x * r_xz;
                            MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionY, y)), MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                            this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, t2), type, rotation, emitter, tick);
                            ++i;
                        }
                        t2_pre -= 1.0 / (double)detail;
                    }
                }
                tick += deltaTick;
                ++activation;
            }
        }
    }

    public void performSemiSphereEmission(ParticleEmitter emitter, int point0, int point1, int amount) {
        if (amount <= 1) {
            this.performPointEmission(emitter, point0, point1, amount);
            return;
        }
        String type = (String)emitter.getProperty("type", this.currentTick % this.ticks);
        double tick = this.currentTick % this.ticks;
        double deltaTick = 1.0 / (double)(point1 - point0 - 1);
        String placement = (String)emitter.getProperty("placement", this.currentTick % this.ticks);
        if ("random".equals(placement)) {
            int i = point0 + 1;
            while (i < point1) {
                MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                rotation = this.toPI(rotation);
                MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                MathUtil.Vector3D directionY = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 1.0, 0.0), rotation);
                MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                double t = Math.random() * Math.PI * 2.0;
                double t2 = Math.random() * 0.5 * Math.PI * 2.0;
                double r_xz = Math.cos(t2);
                double z = Math.sin(t) * scale.z * r_xz;
                double x = Math.cos(t) * scale.x * r_xz;
                double y = Math.sin(t2) * scale.y;
                MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionY, y)), MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, t2), type, rotation, emitter, tick);
                tick += deltaTick;
                ++i;
            }
        } else {
            int detail = ((Double)emitter.getProperty("detail", this.currentTick % this.ticks)).intValue() + 2;
            int activation = point0 + 1;
            while (activation < point1) {
                if (activation % amount == 0) {
                    MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                    rotation = this.toPI(rotation);
                    MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                    MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                    MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                    MathUtil.Vector3D directionY = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 1.0, 0.0), rotation);
                    MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                    double t2_pre = 0.5;
                    while (t2_pre > -1.0E-6) {
                        double t2 = t2_pre * Math.PI * 2.0;
                        double r_xz = Math.cos(t2);
                        double y = Math.sin(t2) * scale.y;
                        int newAmount = (int)((double)(amount - 1) * r_xz) + 1;
                        int i = 1;
                        while (i <= newAmount) {
                            double t = (double)(i - 1) / (double)(newAmount - 1) * Math.PI * 2.0;
                            double z = Math.sin(t) * scale.z * r_xz;
                            double x = Math.cos(t) * scale.x * r_xz;
                            MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionY, y)), MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                            this.addParticle(particlePos, new MathUtil.Vector3D(0.0, -t, t2), type, rotation, emitter, tick);
                            ++i;
                        }
                        t2_pre -= 0.5 / (double)detail;
                    }
                }
                tick += deltaTick;
                ++activation;
            }
        }
    }

    public void performSurfaceEmission(ParticleEmitter emitter, int point0, int point1, int amount) {
        if (amount <= 1) {
            this.performPointEmission(emitter, point0, point1, amount);
            return;
        }
        String type = (String)emitter.getProperty("type", this.currentTick % this.ticks);
        double tick = this.currentTick % this.ticks;
        double deltaTick = 1.0 / (double)(point1 - point0 - 1);
        String placement = (String)emitter.getProperty("placement", this.currentTick % this.ticks);
        if ("random".equals(placement)) {
            int i = point0 + 1;
            while (i < point1) {
                MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                rotation = this.toPI(rotation);
                MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                double z = (Math.random() - 0.5) * scale.z * 2.0;
                double x = (Math.random() - 0.5) * scale.x * 2.0;
                MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                this.addParticle(particlePos, new MathUtil.Vector3D(0.0, 0.0, 0.0), type, rotation, emitter, tick);
                tick += deltaTick;
                ++i;
            }
        } else {
            int activation = point0 + 1;
            while (activation < point1) {
                if (activation % amount == 0) {
                    MathUtil.Vector3D rotation = (MathUtil.Vector3D)emitter.getProperty("rotation", tick);
                    rotation = this.toPI(rotation);
                    MathUtil.Vector3D origin = this.getOrigin(emitter, rotation);
                    MathUtil.Vector3D scale = (MathUtil.Vector3D)emitter.getProperty("scale", tick);
                    MathUtil.Vector3D directionZ = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(0.0, 0.0, 1.0), rotation);
                    MathUtil.Vector3D directionX = MathUtil.Vector3D.rotate(new MathUtil.Vector3D(1.0, 0.0, 0.0), rotation);
                    int newAmount = (int)Math.sqrt(amount);
                    double i = -1.0;
                    while (i < 1.00001) {
                        double j = -1.0;
                        while (j < 1.00001) {
                            double z = i * scale.z;
                            double x = j * scale.x;
                            MathUtil.Vector3D particlePos = MathUtil.Vector3D.add(MathUtil.Vector3D.add(origin, MathUtil.Vector3D.multiply(directionZ, z)), MathUtil.Vector3D.multiply(directionX, x));
                            this.addParticle(particlePos, new MathUtil.Vector3D(0.0, 0.0, 0.0), type, rotation, emitter, tick);
                            j += 2.0 / (double)newAmount;
                        }
                        i += 2.0 / (double)newAmount;
                    }
                }
                tick += deltaTick;
                ++activation;
            }
        }
    }

    private MathUtil.Vector3D toPI(MathUtil.Vector3D rotation) {
        return new MathUtil.Vector3D(Math.toRadians(rotation.x), Math.toRadians(rotation.y), Math.toRadians(rotation.z));
    }

    private void addParticle(MathUtil.Vector3D position, MathUtil.Vector3D radialRot, String type, MathUtil.Vector3D rotation, ParticleEmitter emitter, double tick) {
        String category = this.getParticleCategory(type);
        if (category.equals("directional")) {
            this.addDirectionalParticle(position, radialRot, type, rotation, emitter);
        } else if (category.equals("scalable")) {
            this.addScalableParticle(position, radialRot, type, rotation, emitter);
        } else if (category.equals("custom")) {
            this.addCustomParticle(position, radialRot, type, rotation, emitter);
        }
    }

    private void addDirectionalParticle(MathUtil.Vector3D position, MathUtil.Vector3D radialRot, String type, MathUtil.Vector3D rotation, ParticleEmitter emitter) {
        Double velocity = (Double)emitter.getProperty("velocity", this.currentTick % this.ticks);
        MathUtil.Vector3D direction = (MathUtil.Vector3D)emitter.getProperty("direction", this.currentTick % this.ticks);
        String direction_system = (String)emitter.getProperty("direction_system", this.currentTick % this.ticks);
        if (direction_system.equals("global")) {
            this.spawnDirectionalParticle(position, type, direction, velocity);
        } else if (direction_system.equals("local")) {
            this.spawnDirectionalParticle(position, type, MathUtil.Vector3D.rotate(direction, rotation), velocity);
        } else if (direction_system.equals("radial")) {
            this.spawnDirectionalParticle(position, type, MathUtil.Vector3D.rotate(MathUtil.Vector3D.rotate(MathUtil.Vector3D.rotate(direction, new MathUtil.Vector3D(0.0, 0.0, radialRot.z)), new MathUtil.Vector3D(0.0, radialRot.y, 0.0)), rotation), velocity);
        } else if (direction_system.equals("random")) {
            this.spawnDirectionalParticle(position, type, MathUtil.Vector3D.rotate(direction, new MathUtil.Vector3D(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5)), velocity);
        }
    }

    private void spawnDirectionalParticle(MathUtil.Vector3D position, String type, MathUtil.Vector3D direction, double velocity) {
        World world = this.location.getWorld();
        Particle particle = this.getParticle(type);
        MathUtil.Vector3D newPos = MathUtil.Vector3D.rotate(position, new MathUtil.Vector3D(this.pitch, this.yaw, this.roll));
        MathUtil.Vector3D newDir = MathUtil.Vector3D.rotate(direction, new MathUtil.Vector3D(this.pitch, this.yaw, this.roll));
        world.spawnParticle(particle, this.location.getX() + newPos.x, this.location.getY() + newPos.y, this.location.getZ() + newPos.z, 0, newDir.x, newDir.y, newDir.z, velocity);
    }

    private void addScalableParticle(MathUtil.Vector3D position, MathUtil.Vector3D radialRot, String type, MathUtil.Vector3D rotation, ParticleEmitter emitter) {
        Double size = (Double)emitter.getProperty("size", this.currentTick % this.ticks);
        this.spawnScalableParticle(position, type, size);
    }

    private void spawnScalableParticle(MathUtil.Vector3D position, String type, double size) {
        World world = this.location.getWorld();
        Particle particle = this.getParticle(type);
        MathUtil.Vector3D newPos = MathUtil.Vector3D.rotate(position, new MathUtil.Vector3D(this.pitch, this.yaw, this.roll));
        world.spawnParticle(particle, this.location.getX() + newPos.x, this.location.getY() + newPos.y, this.location.getZ() + newPos.z, 0, 0.0, 0.0, 0.0, size);
    }

    private void addCustomParticle(MathUtil.Vector3D position, MathUtil.Vector3D radialRot, String type, MathUtil.Vector3D rotation, ParticleEmitter emitter) {
        World world = this.location.getWorld();
        MathUtil.Vector3D newPos = MathUtil.Vector3D.rotate(position, new MathUtil.Vector3D(this.pitch, this.yaw, this.roll));
        switch (type) {
            case "entity_effect": {
                MathUtil.Vector3D color = (MathUtil.Vector3D)emitter.getProperty("color", this.currentTick % this.ticks);
                world.spawnParticle(ParticleUtils.getParticle("ENTITY_EFFECT"), this.location.getX() + newPos.x, this.location.getY() + newPos.y, this.location.getZ() + newPos.z, 0, color.x, color.y, color.z, 0.00390625);
                break;
            }
            case "dust": {
                MathUtil.Vector3D color = (MathUtil.Vector3D)emitter.getProperty("color", this.currentTick % this.ticks);
                Double size = (Double)emitter.getProperty("size", this.currentTick % this.ticks);
                Particle.DustOptions options = new Particle.DustOptions(Color.fromRGB((int)((int)color.x), (int)((int)color.y), (int)((int)color.z)), size.floatValue());
                world.spawnParticle(ParticleUtils.getParticle("DUST"), this.location.getX() + newPos.x, this.location.getY() + newPos.y, this.location.getZ() + newPos.z, 0, (Object)options);
                break;
            }
            case "heart": {
                world.spawnParticle(Particle.HEART, this.location.getX() + newPos.x, this.location.getY() + newPos.y, this.location.getZ() + newPos.z, 0);
            }
        }
    }

    private String getParticleCategory(String type) {
        switch (type) {
            case "dragon_breath": 
            case "enchant": 
            case "end_rod": 
            case "soul_fire_flame": 
            case "portal": 
            case "electric_spark": 
            case "firework": 
            case "crit": 
            case "cloud": 
            case "flame": 
            case "smoke": 
            case "damage_indicator": {
                return "directional";
            }
            case "explosion": 
            case "sweep_attack": {
                return "scalable";
            }
            case "entity_effect": 
            case "dust": 
            case "heart": {
                return "custom";
            }
        }
        return "";
    }

    private Particle getParticle(String type) {
        return ParticleUtils.getParticle(type);
    }
}

