/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.pkg;

import com.crashstudios.crashblock.data.NormalBlock;
import com.crashstudios.crashblock.data.NormalBlocks;
import com.crashstudios.crashblock.world.WorldGenerator;
import com.crashstudios.crashblock.world.WorldManager;
import com.crashstudios.crashcommand.data.Command;
import com.crashstudios.crashcommand.data.Commands;
import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.model.CustomModel;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.particles.CustomParticle;
import com.crashstudios.crashcore.particles.ParticleEditor;
import com.crashstudios.crashcore.pkg.PackageData5;
import com.crashstudios.crashcore.script.CustomEvent;
import com.crashstudios.crashcore.script.CustomNode;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.storage.SLAPI;
import com.crashstudios.crashitem.data.Item;
import com.crashstudios.crashitem.data.Items;
import com.crashstudios.crashitem.data.emote.Emote;
import com.crashstudios.crashitem.data.emote.Emotes;
import com.crashstudios.crashitem.data.gui.Gui;
import com.crashstudios.crashitem.data.gui.Guis;
import com.crashstudios.crashitem.data.loottable.LootTable;
import com.crashstudios.crashitem.data.loottable.LootTables;
import com.crashstudios.crashmob.data.Mob;
import com.crashstudios.crashmob.data.Mobs;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.UUID;
import org.bukkit.Material;

public class Package {
    public PackageData5 data;
    public boolean local;

    public Package(boolean local) {
        this.local = local;
        this.data = new PackageData5();
        this.data.uuid = UUID.randomUUID();
        this.data.title = "Untitled";
        this.data.description = "";
    }

    public Package(PackageData5 data, boolean local) {
        this.data = data;
        this.local = local;
    }

    public void getObjects(JsonArray elements) {
        JsonObject element;
        int i = 0;
        while (i < this.data.customModels.size()) {
            CustomModel model = ModelEditor.models.get(this.data.customModels.get(i));
            if (model != null) {
                element = new JsonObject();
                element.addProperty("id", model.data.uuid.toString());
                element.addProperty("image", "/images/invsee/items/stone.png");
                element.addProperty("title", model.data.name);
                element.addProperty("type", "Custom Model");
                element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/model/" + ConnectionClientHandler.serverID + "?file=" + model.data.uuid.toString());
                elements.add((JsonElement)element);
            }
            ++i;
        }
        if (ConnectionClientHandler.addons.contains("crashitems")) {
            i = 0;
            while (i < this.data.items.size()) {
                Item item = Items.getItem((int)((Integer)this.data.items.get(i)), null);
                if (item != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)item.data.id);
                    String minecrafthead = (String)item.data.attributes.get("customskull");
                    if (item.data.type == Material.PLAYER_HEAD && minecrafthead != null) {
                        element.addProperty("modeltype", "minecrafthead:" + minecrafthead);
                    } else if (item.data.textureType == 0) {
                        element.addProperty("image", "/images/invsee/items/" + item.data.type.toString().toLowerCase() + ".png");
                    } else if (item.data.textureType == 3) {
                        element.addProperty("modeltype", "minecraft:" + item.data.type.toString().toLowerCase());
                    } else {
                        element.addProperty("image", "/serverdata/" + ConnectionClientHandler.serverID + "/resourcepack/assets/crashplugin/textures/item/" + item.data.id + ".png");
                    }
                    element.addProperty("title", item.data.name);
                    element.addProperty("type", "Item");
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/iteminformation/" + item.data.id);
                    elements.add((JsonElement)element);
                }
                ++i;
            }
            i = 0;
            while (i < this.data.guis.size()) {
                Gui gui = (Gui)Guis.guis.get(this.data.guis.get(i));
                if (gui != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)gui.data.id);
                    element.addProperty("image", "/serverdata/" + ConnectionClientHandler.serverID + "/resourcepack/assets/crashplugin/textures/gui/" + gui.data.id + ".png");
                    element.addProperty("title", "Gui N." + gui.data.id);
                    element.addProperty("type", "Gui");
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/guiinformation/" + gui.data.id);
                    elements.add((JsonElement)element);
                }
                ++i;
            }
            i = 0;
            while (i < this.data.emotes.size()) {
                Emote emote = (Emote)Emotes.emotes.get(this.data.emotes.get(i));
                if (emote != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)emote.data.id);
                    element.addProperty("image", "/serverdata/" + ConnectionClientHandler.serverID + "/resourcepack/assets/crashplugin/textures/font/" + emote.data.id + ".png");
                    element.addProperty("title", emote.data.name);
                    element.addProperty("type", "Emote");
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/emoteinformation/" + emote.data.id);
                    elements.add((JsonElement)element);
                }
                ++i;
            }
            i = 0;
            while (i < this.data.armors.size()) {
                int id = (Integer)this.data.armors.get(i);
                element = new JsonObject();
                element.addProperty("id", (Number)id);
                element.addProperty("image", "/serverdata/" + ConnectionClientHandler.serverID + "/armors/" + id + "_1.png");
                element.addProperty("title", "Armor N." + id);
                element.addProperty("type", "Armor");
                element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/armorinformation/" + id);
                elements.add((JsonElement)element);
                ++i;
            }
            i = 0;
            while (i < this.data.lootTables.size()) {
                UUID id = (UUID)this.data.lootTables.get(i);
                LootTable lootTable = LootTables.getLootTable((UUID)id);
                if (lootTable != null) {
                    JsonObject element2 = new JsonObject();
                    element2.addProperty("id", id.toString());
                    element2.addProperty("image", "/images/invsee/items/chest.png");
                    element2.addProperty("title", lootTable.data.name);
                    element2.addProperty("type", "LootTable");
                    element2.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/loottableinformation/" + String.valueOf(id));
                    elements.add((JsonElement)element2);
                }
                ++i;
            }
        }
        if (ConnectionClientHandler.addons.contains("crashblock")) {
            i = 0;
            while (i < this.data.blocks.size()) {
                NormalBlock block = NormalBlocks.getNormalBlock((int)((Integer)this.data.blocks.get(i)), null);
                if (block != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)block.data.id);
                    element.addProperty("modeltype", "minecraft:" + block.data.type.toString().toLowerCase());
                    element.addProperty("title", block.data.name);
                    element.addProperty("type", "Block");
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/normalblockinformation/" + block.data.id);
                    elements.add((JsonElement)element);
                }
                ++i;
            }
            i = 0;
            while (i < this.data.worldGenerators.size()) {
                WorldGenerator generator = WorldManager.getWorldGenerator((UUID)((UUID)this.data.worldGenerators.get(i)), null);
                if (generator != null) {
                    element = new JsonObject();
                    element.addProperty("id", generator.data.uuid.toString());
                    element.addProperty("image", "/images/crashcommand/CommandBlock.webp");
                    element.addProperty("title", generator.data.name);
                    element.addProperty("type", "World Generator");
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/generatorinformation/" + generator.data.uuid.toString());
                    elements.add((JsonElement)element);
                }
                ++i;
            }
        }
        if (ConnectionClientHandler.addons.contains("crashmob")) {
            i = 0;
            while (i < this.data.mobs.size()) {
                Mob mob = Mobs.getMob((int)((Integer)this.data.mobs.get(i)), null);
                if (mob != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)mob.data.id);
                    element.addProperty("image", "/images/invsee/items/zombie_head.png");
                    element.addProperty("title", mob.data.name);
                    element.addProperty("type", "Mob");
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/mobinformation/" + mob.data.id);
                    elements.add((JsonElement)element);
                }
                ++i;
            }
        }
        if (ConnectionClientHandler.addons.contains("crashcommand")) {
            i = 0;
            while (i < this.data.commands.size()) {
                Command command = Commands.getCommand((int)((Integer)this.data.commands.get(i)), null);
                if (command != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)command.data.id);
                    element.addProperty("image", "/images/crashcommand/CommandBlock.webp");
                    element.addProperty("title", command.data.name);
                    element.addProperty("type", "Command");
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/commandinformation/" + command.data.id);
                    elements.add((JsonElement)element);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.data.customNodes.size()) {
            CustomNode node = CustomNodes.nodes.get(this.data.customNodes.get(i));
            if (node != null) {
                element = new JsonObject();
                element.addProperty("id", node.data.uuid.toString());
                element.addProperty("image", "/images/invsee/items/bedrock.png");
                element.addProperty("title", node.data.name);
                element.addProperty("type", "Custom Node");
                element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/editor/" + ConnectionClientHandler.serverID + "/customnodes?file=" + node.data.uuid.toString());
                elements.add((JsonElement)element);
            }
            ++i;
        }
        i = 0;
        while (i < this.data.customListeners.size()) {
            CustomEvent event = CustomNodes.customevent.get(this.data.customListeners.get(i));
            if (event != null) {
                element = new JsonObject();
                element.addProperty("id", event.data.uuid.toString());
                element.addProperty("image", "/images/invsee/items/paper.png");
                element.addProperty("title", event.data.name);
                element.addProperty("type", "Listeners");
                element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/editor/" + ConnectionClientHandler.serverID + "/customevents?file=" + event.data.uuid.toString());
                elements.add((JsonElement)element);
            }
            ++i;
        }
        i = 0;
        while (i < this.data.sounds.size()) {
            String sound = (String)this.data.sounds.get(i);
            if (sound != null) {
                element = new JsonObject();
                element.addProperty("id", sound);
                element.addProperty("image", "/images/invsee/items/note_block.png");
                element.addProperty("title", sound);
                element.addProperty("type", "Sound");
                element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/server/" + ConnectionClientHandler.serverID + "/resourcepack");
                elements.add((JsonElement)element);
            }
            ++i;
        }
        i = 0;
        while (i < this.data.customParticles.size()) {
            CustomParticle particles = ParticleEditor.particles.get(this.data.customParticles.get(i));
            if (particles != null) {
                element = new JsonObject();
                element.addProperty("id", particles.data.id.toString());
                element.addProperty("image", "/serverdata/" + ConnectionClientHandler.serverID + "/particleimgs/" + particles.data.id.toString() + ".gif");
                element.addProperty("title", particles.data.name);
                element.addProperty("type", "Custom Particles");
                element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/particles/" + ConnectionClientHandler.serverID + "?file=" + particles.data.id.toString());
                elements.add((JsonElement)element);
            }
            ++i;
        }
    }

    public void save() {
        File folder = new File(Main.INSTANCE.getDataFolder(), this.local ? "serverpackages" : "purchasedpackages");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            SLAPI.save((Object)this.data, new File(folder, this.data.uuid.toString() + ".dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        File folder = new File(Main.INSTANCE.getDataFolder(), this.local ? "serverpackages" : "purchasedpackages");
        try {
            new File(folder, this.data.uuid.toString() + ".dat").delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

