/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.pkg;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.net.InfoPacketListener;
import com.crashstudios.crashcore.net.RequestPacketListener;
import com.crashstudios.crashcore.pkg.Package;
import com.crashstudios.crashcore.pkg.PackageData;
import com.crashstudios.crashcore.pkg.PackageData2;
import com.crashstudios.crashcore.pkg.PackageData3;
import com.crashstudios.crashcore.pkg.PackageData4;
import com.crashstudios.crashcore.pkg.PackageData5;
import com.crashstudios.crashcore.pkg.PackagePublisher;
import com.crashstudios.crashcore.storage.SLAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;

public class PackageManager {
    public static HashMap<UUID, Package> serverPackage = new HashMap();

    public static void load() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "serverpackages");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                Object obj = SLAPI.load(file);
                PackageData5 data = null;
                if (obj instanceof PackageData5) {
                    data = (PackageData5)obj;
                } else if (obj instanceof PackageData4) {
                    data = ((PackageData4)obj).toV5();
                } else if (obj instanceof PackageData3) {
                    data = ((PackageData3)obj).toV4().toV5();
                } else if (obj instanceof PackageData2) {
                    data = ((PackageData2)obj).toV3().toV4().toV5();
                } else if (obj instanceof PackageData) {
                    data = ((PackageData)obj).toV2().toV3().toV4().toV5();
                }
                serverPackage.put(data.uuid, new Package(data, true));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        folder = new File(Main.INSTANCE.getDataFolder(), "purchasedpackages");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        ConnectionClientHandler.requestPacketListeners.put("serverpackages", new RequestPacketListener("serverpackages"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                JsonObject json = new JsonObject();
                json.addProperty("type", "update");
                json.addProperty("page", (Number)1);
                json.addProperty("maxpage", (Number)1);
                json.addProperty("sessionid", (Number)data.get("sessionid").getAsInt());
                JsonArray elements = new JsonArray();
                ArrayList<Package> list = new ArrayList<Package>(serverPackage.values());
                list.sort((a, b) -> a.data.title.compareTo(b.data.title));
                for (Package item : list) {
                    JsonObject element = new JsonObject();
                    element.addProperty("id", item.data.uuid.toString());
                    element.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/serverpackage/" + item.data.uuid.toString());
                    element.addProperty("title", item.data.title);
                    element.addProperty("createdby", item.data.createdBy.toString());
                    element.addProperty("createdon", (Number)item.data.createdOn);
                    element.addProperty("description", item.data.description);
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                ConnectionClientHandler.sendInfoPacket("serverpackages", json);
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("serverpackages", new InfoPacketListener("serverpackages"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                Package pkg = new Package(true);
                pkg.data.createdBy = UUID.fromString(data.get("userid").getAsString());
                pkg.data.createdOn = Instant.now().getEpochSecond();
                pkg.save();
                serverPackage.put(pkg.data.uuid, pkg);
                JsonObject json = new JsonObject();
                json.addProperty("type", "redirect");
                json.addProperty("link", "/crashpanel/network/" + ConnectionClientHandler.networkID + "/serverdata/" + ConnectionClientHandler.serverID + "/serverpackage/" + pkg.data.uuid.toString());
                json.addProperty("sessionid", (Number)data.get("sessionid").getAsInt());
                ConnectionClientHandler.sendInfoPacket("serverpackages", json);
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("serverpackageinfo", new RequestPacketListener("serverpackageinfo"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid;
                JsonObject data = packet.get("info").getAsJsonObject();
                try {
                    uuid = UUID.fromString(data.get("id").getAsString());
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                Package pkg = serverPackage.get(uuid);
                if (pkg != null) {
                    JsonObject json = new JsonObject();
                    json.addProperty("key", pkg.data.uuid.toString());
                    json.addProperty("title", pkg.data.title);
                    json.addProperty("description", pkg.data.description);
                    json.addProperty("createdby", pkg.data.createdBy.toString());
                    json.addProperty("createdon", (Number)pkg.data.createdOn);
                    JsonArray elements = new JsonArray();
                    pkg.getObjects(elements);
                    json.add("elements", (JsonElement)elements);
                    ConnectionClientHandler.sendInfoPacket("serverpackageinfo", json);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("serverpackageinfo", new InfoPacketListener("serverpackageinfo"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                block66: {
                    UUID uuid;
                    JsonObject data = packet.get("info").getAsJsonObject();
                    try {
                        uuid = UUID.fromString(data.get("id").getAsString());
                    }
                    catch (IllegalArgumentException e) {
                        return;
                    }
                    Package pkg = serverPackage.get(uuid);
                    if (pkg == null) break block66;
                    switch (data.get("type").getAsString()) {
                        case "delete": {
                            serverPackage.remove(uuid);
                            pkg.remove();
                            break;
                        }
                        case "setting": {
                            pkg.data.title = data.get("title").getAsString();
                            pkg.data.description = data.get("description").getAsString();
                            pkg.save();
                            break;
                        }
                        case "add": {
                            String objectid = data.get("objectid").getAsString();
                            try {
                                switch (data.get("objecttype").getAsString()) {
                                    case "item": {
                                        PackageManager.toggleElements(pkg.data.items, Integer.parseInt(objectid));
                                        break;
                                    }
                                    case "gui": {
                                        PackageManager.toggleElements(pkg.data.guis, Integer.parseInt(objectid));
                                        break;
                                    }
                                    case "emote": {
                                        PackageManager.toggleElements(pkg.data.emotes, Integer.parseInt(objectid));
                                        break;
                                    }
                                    case "block": {
                                        PackageManager.toggleElements(pkg.data.blocks, Integer.parseInt(objectid));
                                        break;
                                    }
                                    case "mob": {
                                        PackageManager.toggleElements(pkg.data.mobs, Integer.parseInt(objectid));
                                        break;
                                    }
                                    case "command": {
                                        PackageManager.toggleElements(pkg.data.commands, Integer.parseInt(objectid));
                                        break;
                                    }
                                    case "customnodes": {
                                        PackageManager.toggleElements(pkg.data.customNodes, UUID.fromString(objectid));
                                        break;
                                    }
                                    case "listeners": {
                                        PackageManager.toggleElements(pkg.data.customListeners, UUID.fromString(objectid));
                                        break;
                                    }
                                    case "custommodel": {
                                        PackageManager.toggleElements(pkg.data.customModels, UUID.fromString(objectid));
                                        break;
                                    }
                                    case "armor": {
                                        PackageManager.toggleElements(pkg.data.armors, Integer.parseInt(objectid));
                                        break;
                                    }
                                    case "worldgenerator": {
                                        PackageManager.toggleElements(pkg.data.worldGenerators, UUID.fromString(objectid));
                                        break;
                                    }
                                    case "sound": {
                                        PackageManager.toggleElements(pkg.data.sounds, objectid);
                                        break;
                                    }
                                    case "loottable": {
                                        PackageManager.toggleElements(pkg.data.lootTables, UUID.fromString(objectid));
                                        break;
                                    }
                                    case "customparticles": {
                                        PackageManager.toggleElements(pkg.data.customParticles, UUID.fromString(objectid));
                                    }
                                }
                            }
                            catch (IllegalArgumentException e) {
                                break;
                            }
                            pkg.save();
                            break;
                        }
                        case "publish": {
                            String pass = data.get("pass").getAsString();
                            PackagePublisher.publish(pkg, pass);
                            return;
                        }
                    }
                    JsonObject json = new JsonObject();
                    json.addProperty("key", pkg.data.uuid.toString());
                    json.addProperty("image", "/packageimgs/" + pkg.data.uuid.toString() + ".png");
                    json.addProperty("title", pkg.data.title);
                    json.addProperty("description", pkg.data.description);
                    json.addProperty("createdby", pkg.data.createdBy.toString());
                    json.addProperty("createdon", (Number)pkg.data.createdOn);
                    JsonArray elements = new JsonArray();
                    pkg.getObjects(elements);
                    json.add("elements", (JsonElement)elements);
                    ConnectionClientHandler.sendInfoPacket("serverpackageinfo", json);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("marketplaceinfo", new InfoPacketListener("marketplaceinfo"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                JsonObject info = data.get("info").getAsJsonObject();
                UUID key = UUID.fromString(info.get("id").getAsString());
                Package pkg = serverPackage.get(key);
                if (pkg == null) {
                    String check = PackagePublisher.checkPackage(info);
                    if (check != null) {
                        Bukkit.getConsoleSender().sendMessage("\u00a7c" + check);
                        JsonObject p = new JsonObject();
                        p.addProperty("key", key.toString());
                        p.addProperty("type", "warning");
                        p.addProperty("pass", data.get("pass").getAsString());
                        p.addProperty("data", check);
                        ConnectionClientHandler.sendInfoPacket("marketplaceinfo", p);
                        return;
                    }
                    PackagePublisher.installPackage(info, data.get("pass").getAsString());
                } else {
                    Bukkit.getConsoleSender().sendMessage("\u00a7cYou already have a package with this ID. Remove that package (" + pkg.data.title + ").");
                    JsonObject p = new JsonObject();
                    p.addProperty("key", key.toString());
                    p.addProperty("type", "warning");
                    p.addProperty("pass", data.get("pass").getAsString());
                    p.addProperty("data", "You already have a package with this ID. Remove that package.");
                    ConnectionClientHandler.sendInfoPacket("marketplaceinfo", p);
                }
            }
        });
    }

    public static <T> void toggleElements(List<T> list, T element) {
        if (list.contains(element)) {
            list.remove(element);
        } else {
            list.add(element);
        }
    }
}

