/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.pkg;

import com.crashstudios.crashblock.data.NormalBlock;
import com.crashstudios.crashblock.data.NormalBlocks;
import com.crashstudios.crashblock.world.WorldGenerator;
import com.crashstudios.crashblock.world.WorldManager;
import com.crashstudios.crashblock.world.WorldScripts;
import com.crashstudios.crashcommand.data.Command;
import com.crashstudios.crashcommand.data.Commands;
import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.editor.EditorFile;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.editor.EditorGroup;
import com.crashstudios.crashcore.editor.EditorNode;
import com.crashstudios.crashcore.model.BBModelFile;
import com.crashstudios.crashcore.model.CustomModel;
import com.crashstudios.crashcore.model.CustomModelData;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.particles.CustomParticle;
import com.crashstudios.crashcore.particles.ParticleEditor;
import com.crashstudios.crashcore.particles.ParticleEmitter;
import com.crashstudios.crashcore.particles.ParticlePropertyValue;
import com.crashstudios.crashcore.pkg.Package;
import com.crashstudios.crashcore.pkg.PackageIdsChange;
import com.crashstudios.crashcore.pkg.PackageManager;
import com.crashstudios.crashcore.script.CustomEvent;
import com.crashstudios.crashcore.script.CustomNode;
import com.crashstudios.crashcore.script.CustomNodeData;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.utilities.gson.ParticlePropertyValueDeserializer;
import com.crashstudios.crashitem.data.FurnaceRecipe;
import com.crashstudios.crashitem.data.IRecipe;
import com.crashstudios.crashitem.data.Item;
import com.crashstudios.crashitem.data.Items;
import com.crashstudios.crashitem.data.Recipe;
import com.crashstudios.crashitem.data.StonecutterRecipe;
import com.crashstudios.crashitem.data.emote.Emote;
import com.crashstudios.crashitem.data.emote.Emotes;
import com.crashstudios.crashitem.data.gui.Gui;
import com.crashstudios.crashitem.data.gui.Guis;
import com.crashstudios.crashitem.data.gui.Scripts;
import com.crashstudios.crashitem.data.loottable.LootTable;
import com.crashstudios.crashitem.data.loottable.LootTables;
import com.crashstudios.crashmob.data.Mob;
import com.crashstudios.crashmob.data.Mobs;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class PackagePublisher {
    /*
     * WARNING - void declaration
     */
    public static void publish(Package pkg, String pass) {
        void var15_41;
        int l232;
        JsonObject json = new JsonObject();
        json.addProperty("id", pkg.data.uuid.toString());
        json.addProperty("title", pkg.data.title);
        json.addProperty("description", pkg.data.description);
        json.addProperty("createdby", pkg.data.createdBy.toString());
        JsonArray items = new JsonArray();
        JsonArray guis = new JsonArray();
        JsonArray emotes = new JsonArray();
        JsonArray armors = new JsonArray();
        JsonArray lootTables = new JsonArray();
        if (ConnectionClientHandler.addons.contains("crashitems")) {
            JsonObject element;
            int i = 0;
            while (i < pkg.data.items.size()) {
                Item item = Items.getItem((int)((Integer)pkg.data.items.get(i)), null);
                if (item != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)item.data.id);
                    element.addProperty("name", item.data.name);
                    element.addProperty("type", item.data.type.toString());
                    element.addProperty("displayName", item.data.displayName);
                    element.addProperty("lore", item.data.lore);
                    element.addProperty("enchantments", item.data.enchantments);
                    JsonArray properties = new JsonArray();
                    for (String p : item.data.properties) {
                        properties.add(p);
                    }
                    element.add("properties", (JsonElement)properties);
                    EditorFile file = (EditorFile)com.crashstudios.crashitem.data.Scripts.scripts.get(item.data.scripts.get(0));
                    element.add("script", (JsonElement)file.serialize());
                    JsonArray attributes = new JsonArray();
                    for (Map.Entry p : item.data.attributes.entrySet()) {
                        JsonObject pp = new JsonObject();
                        pp.addProperty("k", (String)p.getKey());
                        pp.addProperty("v", (String)p.getValue());
                        attributes.add((JsonElement)pp);
                    }
                    element.add("attributes", (JsonElement)attributes);
                    element.addProperty("textureType", (Number)item.data.textureType);
                    JsonArray recipes = new JsonArray();
                    for (Map.Entry entry : item.data.recipes.entrySet()) {
                        Recipe recipe;
                        JsonObject obj;
                        IRecipe ir = (IRecipe)entry.getValue();
                        if (ir instanceof Recipe) {
                            obj = new JsonObject();
                            recipe = (Recipe)ir;
                            obj.addProperty("type", "crafting");
                            obj.addProperty("index", ((UUID)entry.getKey()).toString());
                            l232 = 0;
                            while (l232 < 9) {
                                obj.addProperty("item" + (l232 + 1), recipe.items[l232]);
                                ++l232;
                            }
                            obj.addProperty("active", Boolean.valueOf(recipe.active));
                            obj.addProperty("shapeless", Boolean.valueOf(recipe.shapeless));
                            obj.addProperty("amount", (Number)recipe.amount);
                            obj.addProperty("unlocks", Boolean.valueOf(recipe.unlocks));
                            recipes.add((JsonElement)obj);
                            continue;
                        }
                        if (ir instanceof FurnaceRecipe) {
                            obj = new JsonObject();
                            recipe = (FurnaceRecipe)ir;
                            obj.addProperty("type", "cooking");
                            obj.addProperty("index", ((UUID)entry.getKey()).toString());
                            obj.addProperty("input", recipe.input);
                            obj.addProperty("active", Boolean.valueOf(recipe.active));
                            obj.addProperty("amount", (Number)recipe.amount);
                            obj.addProperty("time", (Number)recipe.time);
                            obj.addProperty("experience", (Number)Float.valueOf(recipe.experience));
                            obj.addProperty("smoker", Boolean.valueOf(recipe.smoker));
                            obj.addProperty("blasting", Boolean.valueOf(recipe.blasting));
                            obj.addProperty("campfire", Boolean.valueOf(recipe.campfire));
                            obj.addProperty("furnace", Boolean.valueOf(recipe.furnace));
                            obj.addProperty("unlocks", Boolean.valueOf(recipe.unlocks));
                            recipes.add((JsonElement)obj);
                            continue;
                        }
                        if (!(ir instanceof StonecutterRecipe)) continue;
                        obj = new JsonObject();
                        recipe = (StonecutterRecipe)ir;
                        obj.addProperty("type", "stonecutter");
                        obj.addProperty("index", ((UUID)entry.getKey()).toString());
                        obj.addProperty("input", recipe.input);
                        obj.addProperty("active", Boolean.valueOf(recipe.active));
                        obj.addProperty("amount", (Number)recipe.amount);
                        recipes.add((JsonElement)obj);
                    }
                    element.add("recipes", (JsonElement)recipes);
                    items.add((JsonElement)element);
                }
                ++i;
            }
            i = 0;
            while (i < pkg.data.guis.size()) {
                Gui gui = (Gui)Guis.guis.get(pkg.data.guis.get(i));
                if (gui != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)gui.data.id);
                    element.addProperty("size", (Number)gui.data.size);
                    EditorFile file = (EditorFile)Scripts.scripts.get(gui.data.scripts.get(0));
                    element.add("script", (JsonElement)file.serialize());
                    element.add("elements", (JsonElement)gui.getJsonElements());
                    element.addProperty("disabletexture", Boolean.valueOf(gui.data.disabletexture));
                    guis.add((JsonElement)element);
                }
                ++i;
            }
            i = 0;
            while (i < pkg.data.emotes.size()) {
                Emote emote = Emotes.getEmote((int)((Integer)pkg.data.emotes.get(i)), null);
                if (emote != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)emote.data.id);
                    element.addProperty("name", emote.data.name);
                    element.addProperty("width", (Number)emote.data.width);
                    element.addProperty("height", (Number)emote.data.height);
                    emotes.add((JsonElement)element);
                }
                ++i;
            }
            i = 0;
            while (i < pkg.data.armors.size()) {
                JsonObject element2 = new JsonObject();
                element2.addProperty("id", (Number)pkg.data.armors.get(i));
                armors.add((JsonElement)element2);
                ++i;
            }
            i = 0;
            while (i < pkg.data.lootTables.size()) {
                LootTable lootTable = LootTables.getLootTable((UUID)((UUID)pkg.data.lootTables.get(i)));
                if (lootTable != null) {
                    element = new JsonObject();
                    element.addProperty("id", lootTable.data.id.toString());
                    element.addProperty("name", lootTable.data.name);
                    element.add("pools", (JsonElement)lootTable.getPools(false));
                    lootTables.add((JsonElement)element);
                }
                ++i;
            }
        }
        json.add("items", (JsonElement)items);
        json.add("guis", (JsonElement)guis);
        json.add("emotes", (JsonElement)emotes);
        json.add("armors", (JsonElement)armors);
        json.add("lootTables", (JsonElement)lootTables);
        JsonArray blocks = new JsonArray();
        JsonArray worldgenerators = new JsonArray();
        if (ConnectionClientHandler.addons.contains("crashblock")) {
            EditorFile file;
            JsonObject element;
            int i = 0;
            while (i < pkg.data.blocks.size()) {
                NormalBlock block = NormalBlocks.getNormalBlock((int)((Integer)pkg.data.blocks.get(i)), null);
                if (block != null) {
                    element = new JsonObject();
                    element.addProperty("id", (Number)block.data.id);
                    element.addProperty("name", block.data.name);
                    element.addProperty("type", block.data.type.toString());
                    element.addProperty("customDurability", Boolean.valueOf(block.data.customDurability));
                    element.addProperty("durability", (Number)Float.valueOf(block.data.durability));
                    element.addProperty("customModel", Boolean.valueOf(block.data.customModel));
                    element.addProperty("customModelRotation", (Number)Float.valueOf(block.data.customModelRotation));
                    file = (EditorFile)com.crashstudios.crashblock.data.Scripts.scripts.get(block.data.scripts.get(0));
                    element.add("script", (JsonElement)file.serialize());
                    blocks.add((JsonElement)element);
                }
                ++i;
            }
            i = 0;
            while (i < pkg.data.worldGenerators.size()) {
                WorldGenerator generator = WorldManager.getWorldGenerator((UUID)((UUID)pkg.data.worldGenerators.get(i)), null);
                if (generator != null) {
                    element = new JsonObject();
                    element.addProperty("id", generator.data.uuid.toString());
                    element.addProperty("name", generator.data.name);
                    file = (EditorFile)WorldScripts.scripts.get(generator.data.scripts.get(0));
                    element.add("script", (JsonElement)file.serialize());
                    worldgenerators.add((JsonElement)element);
                }
                ++i;
            }
        }
        json.add("blocks", (JsonElement)blocks);
        json.add("worldGenerators", (JsonElement)worldgenerators);
        JsonArray commands = new JsonArray();
        if (ConnectionClientHandler.addons.contains("crashcommand")) {
            int i = 0;
            while (i < pkg.data.commands.size()) {
                Command command = Commands.getCommand((int)((Integer)pkg.data.commands.get(i)), null);
                if (command != null) {
                    JsonObject element = new JsonObject();
                    element.addProperty("id", (Number)command.data.id);
                    element.addProperty("name", command.data.name);
                    JsonArray aliases = new JsonArray();
                    for (String string : command.data.aliases) {
                        aliases.add(string);
                    }
                    element.add("aliases", (JsonElement)aliases);
                    EditorFile editorFile = (EditorFile)com.crashstudios.crashcommand.data.Scripts.scripts.get(command.data.scripts.get(0));
                    element.add("script", (JsonElement)editorFile.serialize());
                    commands.add((JsonElement)element);
                }
                ++i;
            }
        }
        json.add("commands", (JsonElement)commands);
        JsonArray mobs = new JsonArray();
        if (ConnectionClientHandler.addons.contains("crashmob")) {
            int i = 0;
            while (i < pkg.data.mobs.size()) {
                Mob mob = Mobs.getMob((int)((Integer)pkg.data.mobs.get(i)), null);
                if (mob != null) {
                    JsonObject element = new JsonObject();
                    element.addProperty("id", (Number)mob.data.id);
                    element.addProperty("name", mob.data.name);
                    element.addProperty("type", mob.data.type.toString());
                    JsonArray jsonArray = new JsonArray();
                    for (Map.Entry p : mob.data.properties.entrySet()) {
                        JsonObject pp = new JsonObject();
                        pp.addProperty("k", (String)p.getKey());
                        pp.addProperty("v", (String)p.getValue());
                        jsonArray.add((JsonElement)pp);
                    }
                    element.add("properties", (JsonElement)jsonArray);
                    EditorFile file = (EditorFile)com.crashstudios.crashmob.data.Scripts.scripts.get(mob.data.scripts.get(0));
                    element.add("script", (JsonElement)file.serialize());
                    mobs.add((JsonElement)element);
                }
                ++i;
            }
        }
        json.add("mobs", (JsonElement)mobs);
        JsonArray customNodes = new JsonArray();
        int i = 0;
        while (i < pkg.data.customNodes.size()) {
            CustomNode node = CustomNodes.nodes.get(pkg.data.customNodes.get(i));
            if (node != null) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("id", node.data.uuid.toString());
                jsonObject.addProperty("name", node.data.name);
                JsonArray labels = new JsonArray();
                String[] l232 = node.data.labels;
                int recipe = node.data.labels.length;
                int pp = 0;
                while (pp < recipe) {
                    String p = l232[pp];
                    labels.add(p);
                    ++pp;
                }
                jsonObject.add("labels", (JsonElement)labels);
                JsonArray inputs = new JsonArray();
                String[] stringArray = node.data.inputs;
                l232 = node.data.inputs.length;
                recipe = 0;
                while (recipe < l232) {
                    String p = stringArray[recipe];
                    inputs.add(p);
                    ++recipe;
                }
                jsonObject.add("inputs", (JsonElement)inputs);
                JsonArray outputs = new JsonArray();
                String[] stringArray2 = node.data.outputs;
                int n = node.data.outputs.length;
                l232 = 0;
                while (l232 < n) {
                    String p = stringArray2[l232];
                    outputs.add(p);
                    ++l232;
                }
                jsonObject.add("outputs", (JsonElement)outputs);
                jsonObject.add("script", (JsonElement)node.data.script.serialize());
                customNodes.add((JsonElement)jsonObject);
            }
            ++i;
        }
        json.add("customNodes", (JsonElement)customNodes);
        JsonArray customListeners = new JsonArray();
        int i2 = 0;
        while (i2 < pkg.data.customListeners.size()) {
            CustomEvent customEvent = CustomNodes.customevent.get(pkg.data.customListeners.get(i2));
            if (customEvent != null) {
                JsonObject element = new JsonObject();
                element.addProperty("id", customEvent.data.uuid.toString());
                element.addProperty("name", customEvent.data.name);
                element.add("script", (JsonElement)customEvent.data.script.serialize());
                customListeners.add((JsonElement)element);
            }
            ++i2;
        }
        json.add("customListeners", (JsonElement)customListeners);
        JsonArray customModels = new JsonArray();
        boolean bl = false;
        while (var15_41 < pkg.data.customModels.size()) {
            CustomModel model = ModelEditor.models.get(pkg.data.customModels.get((int)var15_41));
            if (model != null) {
                JsonObject element = new JsonObject();
                element.add("data", (JsonElement)model.data.toJson());
                EditorFile file = com.crashstudios.crashcore.model.Scripts.scripts.get(model.data.scripts.get(0));
                element.add("script", (JsonElement)file.serialize());
                customModels.add((JsonElement)element);
            }
            ++var15_41;
        }
        json.add("customModels", (JsonElement)customModels);
        JsonArray jsonArray = new JsonArray();
        int i4 = 0;
        while (i4 < pkg.data.sounds.size()) {
            String sound = (String)pkg.data.sounds.get(i4);
            if (sound != null) {
                JsonObject element = new JsonObject();
                element.addProperty("id", sound);
                jsonArray.add((JsonElement)element);
            }
            ++i4;
        }
        json.add("sounds", (JsonElement)jsonArray);
        JsonArray customParticles = new JsonArray();
        int i5 = 0;
        while (i5 < pkg.data.customParticles.size()) {
            CustomParticle particles = ParticleEditor.particles.get(pkg.data.customParticles.get(i5));
            if (particles != null) {
                JsonObject element = new JsonObject();
                element.addProperty("id", particles.data.id.toString());
                element.addProperty("name", particles.data.name);
                element.addProperty("ticks", (Number)particles.data.ticks);
                JsonArray emitters = new Gson().toJsonTree(particles.data.emitters).getAsJsonArray();
                element.add("emitters", (JsonElement)emitters);
                customParticles.add((JsonElement)element);
            }
            ++i5;
        }
        json.add("customParticles", (JsonElement)customParticles);
        JsonObject packet = new JsonObject();
        packet.addProperty("key", pkg.data.uuid.toString());
        packet.addProperty("type", "publish");
        packet.addProperty("pass", pass);
        packet.add("package", (JsonElement)json);
        ConnectionClientHandler.sendInfoPacket("serverpackageinfo", packet);
    }

    public static JsonArray toArray(float[] ff) {
        JsonArray array = new JsonArray();
        int i = 0;
        while (i < ff.length) {
            array.add((Number)Float.valueOf(ff[i]));
            ++i;
        }
        return array;
    }

    public static String checkPackage(JsonObject json) {
        JsonArray lootTables;
        JsonArray items = json.get("items").getAsJsonArray();
        JsonArray guis = json.get("guis").getAsJsonArray();
        JsonArray emotes = json.has("emotes") ? json.get("emotes").getAsJsonArray() : new JsonArray();
        int totalarmors = json.has("totalarmors") ? json.get("totalarmors").getAsInt() : 0;
        JsonArray jsonArray = lootTables = json.has("lootTables") ? json.get("lootTables").getAsJsonArray() : new JsonArray();
        if (ConnectionClientHandler.addons.contains("crashitems")) {
            if (Main.upgrade == null) {
                if (Items.items.size() + items.size() > 16) {
                    int slot = Items.items.size() + items.size() - 16;
                    return "The 'items' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
                }
                if (Guis.guis.size() + guis.size() > 6) {
                    int slot = Guis.guis.size() + guis.size() - 6;
                    return "The 'guis' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
                }
                if (Emotes.emotes.size() + emotes.size() > 6) {
                    int slot = Emotes.emotes.size() + emotes.size() - 6;
                    return "The 'emotes' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
                }
                if (totalarmors > 6) {
                    int slot = totalarmors - 6;
                    return "The 'armors' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
                }
                if (LootTables.lootTables.size() + lootTables.size() > 12) {
                    int slot = LootTables.lootTables.size() + lootTables.size() - 12;
                    return "The 'loot tables' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
                }
            }
        } else if (items.size() > 0 || guis.size() > 0 || emotes.size() > 0 || lootTables.size() > 0) {
            return "You need 'CrashItems' to install this package.";
        }
        JsonArray blocks = json.get("blocks").getAsJsonArray();
        if (ConnectionClientHandler.addons.contains("crashblock")) {
            if (Main.upgrade == null && NormalBlocks.blocks.size() + blocks.size() > 16) {
                int slot = NormalBlocks.blocks.size() + blocks.size() - 16;
                return "The 'blocks' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
            }
        } else if (blocks.size() > 0) {
            return "You need 'CrashBlock' to install this package.";
        }
        JsonArray commands = json.get("commands").getAsJsonArray();
        if (ConnectionClientHandler.addons.contains("crashcommand")) {
            if (Main.upgrade == null && Commands.commands.size() + commands.size() > 8) {
                int slot = Commands.commands.size() + commands.size() - 8;
                return "The 'commands' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
            }
        } else if (commands.size() > 0) {
            return "You need 'CrashCommand' to install this package.";
        }
        JsonArray mobs = json.get("mobs").getAsJsonArray();
        if (ConnectionClientHandler.addons.contains("crashmob")) {
            if (Main.upgrade == null && Mobs.mobs.size() + mobs.size() > 12) {
                int slot = Mobs.mobs.size() + mobs.size() - 12;
                return "The 'mobs' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
            }
        } else if (mobs.size() > 0) {
            return "You need 'CrashMob' to install this package.";
        }
        if (Main.upgrade == null) {
            JsonArray customModels;
            JsonArray jsonArray2 = customModels = json.has("customModels") ? json.get("customModels").getAsJsonArray() : new JsonArray();
            if (ModelEditor.models.size() + customModels.size() > 6) {
                int slot = ModelEditor.models.size() + customModels.size() - 6;
                return "The 'custom models' limit does not allow you to install this package. Free up '" + slot + "' slots or buy a subscription.";
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void installPackage(JsonObject json, String pass) {
        int i;
        JsonArray worldGenerators;
        JsonArray lootTables;
        PackageIdsChange change = new PackageIdsChange();
        Package pkg = new Package(true);
        pkg.data.uuid = UUID.fromString(json.get("id").getAsString());
        pkg.data.title = json.get("title").getAsString();
        pkg.data.description = json.get("description").getAsString();
        pkg.data.createdBy = UUID.fromString(json.get("createdby").getAsString());
        pkg.data.createdOn = Instant.now().getEpochSecond();
        JsonArray items = json.get("items").getAsJsonArray();
        JsonArray guis = json.get("guis").getAsJsonArray();
        JsonArray emotes = json.has("emotes") ? json.get("emotes").getAsJsonArray() : new JsonArray();
        JsonArray armors = json.has("armors") ? json.get("armors").getAsJsonArray() : new JsonArray();
        JsonArray jsonArray = lootTables = json.has("lootTables") ? json.get("lootTables").getAsJsonArray() : new JsonArray();
        if (ConnectionClientHandler.addons.contains("crashitems")) {
            JsonObject element;
            int i2 = 0;
            while (i2 < items.size()) {
                element = items.get(i2).getAsJsonObject();
                Item item = Items.getItem((int)Items.idCounter, (UUID)pkg.data.createdBy);
                change.items.put(element.get("id").getAsInt(), item.data.id);
                item.data.name = element.get("name").getAsString();
                item.data.type = Material.valueOf((String)element.get("type").getAsString());
                item.data.displayName = element.get("displayName").getAsString();
                item.data.lore = element.get("lore").getAsString();
                item.data.enchantments = element.get("enchantments").getAsString();
                JsonArray properties = element.get("properties").getAsJsonArray();
                int l = 0;
                while (l < properties.size()) {
                    item.data.properties.add(properties.get(l).getAsString());
                    ++l;
                }
                JsonArray attributes = element.get("attributes").getAsJsonArray();
                int l2 = 0;
                while (l2 < attributes.size()) {
                    JsonObject pp = attributes.get(l2).getAsJsonObject();
                    item.data.attributes.put(pp.get("k").getAsString(), pp.get("v").getAsString());
                    ++l2;
                }
                item.data.textureType = element.get("textureType").getAsInt();
                if (element.has("recipes")) {
                    JsonArray recipes = element.get("recipes").getAsJsonArray();
                    int l3 = 0;
                    while (l3 < recipes.size()) {
                        Recipe recipe;
                        JsonObject recipeObj = recipes.get(l3).getAsJsonObject();
                        String recipeType = recipeObj.get("type").getAsString();
                        UUID recipeIndex = UUID.fromString(recipeObj.get("index").getAsString());
                        if ("crafting".equals(recipeType)) {
                            recipe = new Recipe();
                            int j = 0;
                            while (j < 9) {
                                recipe.items[j] = recipeObj.get("item" + (j + 1)).getAsString();
                                ++j;
                            }
                            recipe.active = recipeObj.get("active").getAsBoolean();
                            recipe.shapeless = recipeObj.get("shapeless").getAsBoolean();
                            recipe.amount = recipeObj.get("amount").getAsInt();
                            if (recipeObj.has("unlocks")) {
                                recipe.unlocks = recipeObj.get("unlocks").getAsBoolean();
                            }
                            item.data.recipes.put(recipeIndex, recipe);
                        } else if ("cooking".equals(recipeType)) {
                            recipe = new FurnaceRecipe();
                            recipe.input = recipeObj.get("input").getAsString();
                            recipe.active = recipeObj.get("active").getAsBoolean();
                            recipe.amount = recipeObj.get("amount").getAsInt();
                            recipe.time = recipeObj.get("time").getAsInt();
                            recipe.experience = recipeObj.get("experience").getAsFloat();
                            recipe.smoker = recipeObj.get("smoker").getAsBoolean();
                            recipe.blasting = recipeObj.get("blasting").getAsBoolean();
                            recipe.campfire = recipeObj.get("campfire").getAsBoolean();
                            recipe.furnace = recipeObj.get("furnace").getAsBoolean();
                            if (recipeObj.has("unlocks")) {
                                recipe.unlocks = recipeObj.get("unlocks").getAsBoolean();
                            }
                            item.data.recipes.put(recipeIndex, recipe);
                        } else if ("stonecutter".equals(recipeType)) {
                            recipe = new StonecutterRecipe();
                            recipe.input = recipeObj.get("input").getAsString();
                            recipe.active = recipeObj.get("active").getAsBoolean();
                            recipe.amount = recipeObj.get("amount").getAsInt();
                            item.data.recipes.put(recipeIndex, recipe);
                        }
                        ++l3;
                    }
                }
                item.save();
                pkg.data.items.add(item.data.id);
                ++i2;
            }
            i2 = 0;
            while (i2 < guis.size()) {
                element = guis.get(i2).getAsJsonObject();
                Gui gui = Guis.getGui((int)Guis.idCounter);
                change.guis.put(element.get("id").getAsInt(), gui.data.id);
                gui.data.size = element.get("size").getAsInt();
                gui.data.disabletexture = element.get("disabletexture").getAsBoolean();
                gui.setJsonElements(element.get("elements").getAsJsonArray());
                gui.save();
                pkg.data.guis.add(gui.data.id);
                ++i2;
            }
            i2 = 0;
            while (i2 < emotes.size()) {
                element = emotes.get(i2).getAsJsonObject();
                Emote emote = Emotes.getEmote((int)Emotes.idCounter, (UUID)pkg.data.createdBy);
                change.emotes.put(element.get("id").getAsInt(), emote.data.id);
                emote.data.name = element.get("name").getAsString();
                emote.data.height = element.get("height").getAsInt();
                emote.data.width = element.get("width").getAsInt();
                emote.save();
                pkg.data.emotes.add(emote.data.id);
                ++i2;
            }
            i2 = 0;
            while (i2 < armors.size()) {
                element = armors.get(i2).getAsJsonObject();
                int newid = element.get("newid").getAsInt();
                change.armors.put(element.get("id").getAsInt(), newid);
                pkg.data.armors.add(newid);
                ++i2;
            }
            i2 = 0;
            while (i2 < lootTables.size()) {
                element = lootTables.get(i2).getAsJsonObject();
                LootTable lootTable = new LootTable(UUID.fromString(element.get("id").getAsString()));
                LootTables.lootTables.put(lootTable.data.id, lootTable);
                lootTable.data.name = element.get("name").getAsString();
                lootTable.setPools(element.get("pools").getAsJsonArray());
                lootTable.save();
                pkg.data.lootTables.add(lootTable.data.id);
                ++i2;
            }
        }
        JsonArray blocks = json.get("blocks").getAsJsonArray();
        JsonArray jsonArray2 = worldGenerators = json.has("worldGenerators") ? json.get("worldGenerators").getAsJsonArray() : new JsonArray();
        if (ConnectionClientHandler.addons.contains("crashblock")) {
            JsonObject element;
            int i3 = 0;
            while (i3 < blocks.size()) {
                element = blocks.get(i3).getAsJsonObject();
                NormalBlock block = NormalBlocks.getNormalBlock((int)NormalBlocks.idCounter, (UUID)pkg.data.createdBy);
                change.blocks.put(element.get("id").getAsInt(), block.data.id);
                block.data.name = element.get("name").getAsString();
                block.data.type = Material.valueOf((String)element.get("type").getAsString());
                block.data.customDurability = element.get("customDurability").getAsBoolean();
                block.data.durability = element.get("durability").getAsFloat();
                block.data.customModel = element.get("customModel").getAsBoolean();
                if (element.has("customModelRotation")) {
                    block.data.customModelRotation = element.get("customModelRotation").getAsFloat();
                }
                block.save();
                pkg.data.blocks.add(block.data.id);
                ++i3;
            }
            i3 = 0;
            while (i3 < worldGenerators.size()) {
                element = worldGenerators.get(i3).getAsJsonObject();
                WorldGenerator generator = new WorldGenerator(UUID.fromString(element.get("id").getAsString()), pkg.data.createdBy);
                WorldManager.generators.put(generator.data.uuid, generator);
                generator.data.name = element.get("name").getAsString();
                generator.save();
                pkg.data.worldGenerators.add(generator.data.uuid);
                ++i3;
            }
        }
        JsonArray commands = json.get("commands").getAsJsonArray();
        if (ConnectionClientHandler.addons.contains("crashcommand")) {
            int i4 = 0;
            while (i4 < commands.size()) {
                JsonObject element = commands.get(i4).getAsJsonObject();
                Command command = Commands.getCommand((int)Commands.idCounter, (UUID)pkg.data.createdBy);
                change.commands.put(element.get("id").getAsInt(), command.data.id);
                command.data.name = element.get("name").getAsString();
                JsonArray aliases = element.get("aliases").getAsJsonArray();
                int l = 0;
                while (l < aliases.size()) {
                    command.data.aliases.add(aliases.get(l).getAsString());
                    ++l;
                }
                command.save();
                pkg.data.commands.add(command.data.id);
                ++i4;
            }
        }
        JsonArray mobs = json.get("mobs").getAsJsonArray();
        if (ConnectionClientHandler.addons.contains("crashmob")) {
            int i5 = 0;
            while (i5 < mobs.size()) {
                JsonObject element = mobs.get(i5).getAsJsonObject();
                Mob mob = Mobs.getMob((int)Mobs.idCounter, (UUID)pkg.data.createdBy);
                change.mobs.put(element.get("id").getAsInt(), mob.data.id);
                mob.data.name = element.get("name").getAsString();
                mob.data.type = EntityType.valueOf((String)element.get("type").getAsString());
                if (element.has("properties")) {
                    JsonArray properties = element.get("properties").getAsJsonArray();
                    int l = 0;
                    while (l < properties.size()) {
                        JsonObject pp = properties.get(l).getAsJsonObject();
                        mob.data.properties.put(pp.get("k").getAsString(), pp.get("v").getAsString());
                        ++l;
                    }
                }
                mob.save();
                pkg.data.mobs.add(mob.data.id);
                ++i5;
            }
        }
        JsonArray sounds = json.has("sounds") ? json.get("sounds").getAsJsonArray() : new JsonArray();
        int i6 = 0;
        while (i6 < sounds.size()) {
            JsonObject element = sounds.get(i6).getAsJsonObject();
            String id = element.get("id").getAsString();
            String newid = element.get("newid").getAsString();
            change.sounds.put(id, newid);
            pkg.data.sounds.add(newid);
            ++i6;
        }
        JsonArray customNodes = json.get("customNodes").getAsJsonArray();
        int i2 = 0;
        while (i2 < customNodes.size()) {
            JsonObject element = customNodes.get(i2).getAsJsonObject();
            CustomNodeData data = new CustomNodeData();
            data.name = element.get("name").getAsString();
            JsonArray labels = element.get("labels").getAsJsonArray();
            data.labels = new String[labels.size()];
            int l = 0;
            while (l < labels.size()) {
                data.labels[l] = labels.get(l).getAsString();
                ++l;
            }
            JsonArray inputs = element.get("inputs").getAsJsonArray();
            data.inputs = new String[inputs.size()];
            int l4 = 0;
            while (l4 < inputs.size()) {
                data.inputs[l4] = inputs.get(l4).getAsString();
                ++l4;
            }
            JsonArray outputs = element.get("outputs").getAsJsonArray();
            data.outputs = new String[outputs.size()];
            int l5 = 0;
            while (l5 < outputs.size()) {
                data.outputs[l5] = outputs.get(l5).getAsString();
                ++l5;
            }
            data.createdOn = Instant.now().getEpochSecond();
            data.modifiedOn = Instant.now().getEpochSecond();
            data.modifiedBy = data.createdBy = pkg.data.createdBy;
            data.script = PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change);
            data.uuid = UUID.fromString(element.get("id").getAsString());
            CustomNode n = new CustomNode(data);
            n.save();
            CustomNodes.nodes.put(data.uuid, n);
            pkg.data.customNodes.add(data.uuid);
            ++i2;
        }
        JsonArray customListeners = json.get("customListeners").getAsJsonArray();
        int i3 = 0;
        while (i3 < customListeners.size()) {
            JsonObject element = customListeners.get(i3).getAsJsonObject();
            CustomEvent listener = new CustomEvent(UUID.fromString(element.get("id").getAsString()));
            listener.data.name = element.get("name").getAsString();
            listener.data.script = PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change);
            CustomNodes.customevent.put(listener.data.uuid, listener);
            listener.save();
            pkg.data.customListeners.add(listener.data.uuid);
            ++i3;
        }
        JsonArray customModels = json.has("customModels") ? json.get("customModels").getAsJsonArray() : new JsonArray();
        JsonArray customModelsBBIds = new JsonArray();
        int i4 = 0;
        while (i4 < customModels.size()) {
            JsonObject element = customModels.get(i4).getAsJsonObject();
            JsonObject data = element.get("data").getAsJsonObject();
            if (data.has("models")) {
                JsonArray modelsArray = data.getAsJsonArray("models");
                int j = 0;
                while (j < modelsArray.size()) {
                    JsonObject modelFileJson = modelsArray.get(j).getAsJsonObject();
                    if (modelFileJson.has("type")) {
                        if ("bbmodel".equals(modelFileJson.get("type").getAsString())) {
                            if (modelFileJson.has("id")) {
                                UUID uUID = UUID.fromString(modelFileJson.get("id").getAsString());
                                customModelsBBIds.add(uUID.toString());
                                BBModelFile bBModelFile = new BBModelFile(uUID);
                                bBModelFile.deserializeContentAndChange(modelFileJson.get("content").getAsJsonArray(), change);
                                bBModelFile.save();
                                ModelEditor.bbModels.put(uUID, bBModelFile);
                            }
                        } else if (modelFileJson.has("id")) {
                            int n = Integer.parseInt(modelFileJson.get("id").getAsString());
                            change.models.put(n + 2000000, ModelEditor.idCounter);
                            modelFileJson.addProperty("id", "" + (ModelEditor.idCounter - 2000000));
                            ModelEditor.idCounter = ModelEditor.idCounter + 1;
                        }
                    }
                    ++j;
                }
            }
            ModelEditor.saveIDCounter();
            CustomModel model = new CustomModel(CustomModelData.fromJson(data));
            model.updateModelId(change);
            com.crashstudios.crashcore.model.Scripts.save(model.data.scripts.get(0), PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change));
            model.save();
            ModelEditor.models.put(model.data.uuid, model);
            pkg.data.customModels.add(model.data.uuid);
            ++i4;
        }
        GsonBuilder customParticlesGsonBuilder = new GsonBuilder();
        customParticlesGsonBuilder.registerTypeAdapter(ParticlePropertyValue.class, (Object)new ParticlePropertyValueDeserializer());
        Gson customParticlesGson = customParticlesGsonBuilder.create();
        JsonArray customParticles = json.has("customParticles") ? json.get("customParticles").getAsJsonArray() : new JsonArray();
        int i5 = 0;
        while (i5 < customParticles.size()) {
            JsonObject element = customParticles.get(i5).getAsJsonObject();
            CustomParticle particles = new CustomParticle(UUID.fromString(element.get("id").getAsString()));
            particles.data.name = element.get("name").getAsString();
            particles.data.ticks = element.get("ticks").getAsInt();
            JsonArray jsonArray3 = element.get("emitters").getAsJsonArray();
            particles.data.emitters = (List)customParticlesGson.fromJson((JsonElement)jsonArray3, (TypeToken)new TypeToken<List<ParticleEmitter>>(){});
            ParticleEditor.particles.put(particles.data.id, particles);
            particles.save();
            pkg.data.customParticles.add(particles.data.id);
            ++i5;
        }
        pkg.save();
        PackageManager.serverPackage.put(pkg.data.uuid, pkg);
        if (ConnectionClientHandler.addons.contains("crashitems")) {
            i = 0;
            while (i < items.size()) {
                JsonObject element = items.get(i).getAsJsonObject();
                int id = change.items.get(element.get("id").getAsInt());
                Item item = Items.getItem((int)id, null);
                com.crashstudios.crashitem.data.Scripts.save((UUID)((UUID)item.data.scripts.get(0)), (EditorFile)PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change));
                ++i;
            }
            i = 0;
            while (i < guis.size()) {
                JsonObject element = guis.get(i).getAsJsonObject();
                int id = change.guis.get(element.get("id").getAsInt());
                Gui gui = Guis.getGui((int)id);
                Scripts.save((UUID)((UUID)gui.data.scripts.get(0)), (EditorFile)PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change));
                ++i;
            }
        }
        if (ConnectionClientHandler.addons.contains("crashblock")) {
            i = 0;
            while (i < blocks.size()) {
                JsonObject element = blocks.get(i).getAsJsonObject();
                int id = change.blocks.get(element.get("id").getAsInt());
                NormalBlock normalBlock = NormalBlocks.getNormalBlock((int)id, null);
                com.crashstudios.crashblock.data.Scripts.save((UUID)((UUID)normalBlock.data.scripts.get(0)), (EditorFile)PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change));
                ++i;
            }
            i = 0;
            while (i < worldGenerators.size()) {
                JsonObject element = worldGenerators.get(i).getAsJsonObject();
                WorldGenerator worldGenerator = WorldManager.getWorldGenerator((UUID)UUID.fromString(element.get("id").getAsString()), null);
                WorldScripts.save((UUID)((UUID)worldGenerator.data.scripts.get(0)), (EditorFile)PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change));
                ++i;
            }
        }
        if (ConnectionClientHandler.addons.contains("crashcommand")) {
            i = 0;
            while (i < commands.size()) {
                JsonObject element = commands.get(i).getAsJsonObject();
                int id = change.commands.get(element.get("id").getAsInt());
                Command command = Commands.getCommand((int)id, null);
                com.crashstudios.crashcommand.data.Scripts.save((UUID)((UUID)command.data.scripts.get(0)), (EditorFile)PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change));
                ++i;
            }
        }
        if (ConnectionClientHandler.addons.contains("crashmob")) {
            i = 0;
            while (i < mobs.size()) {
                JsonObject element = mobs.get(i).getAsJsonObject();
                int id = change.mobs.get(element.get("id").getAsInt());
                Mob mob = Mobs.getMob((int)id, null);
                com.crashstudios.crashmob.data.Scripts.save((UUID)((UUID)mob.data.scripts.get(0)), (EditorFile)PackagePublisher.changeIds(EditorFile2.deserialize(element.get("script").getAsJsonObject()), change));
                ++i;
            }
        }
        JsonObject packet = new JsonObject();
        packet.addProperty("key", pkg.data.uuid.toString());
        packet.addProperty("type", "resource");
        packet.addProperty("pass", pass);
        JsonObject data = new JsonObject();
        JsonArray itemIds = new JsonArray();
        for (Map.Entry<Integer, Integer> entry : change.items.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("k", (Number)entry.getKey());
            jsonObject.addProperty("v", (Number)entry.getValue());
            Item item = (Item)Items.items.get(entry.getValue());
            if (item != null && item.data.textureType != 0) {
                void var28_107;
                jsonObject.addProperty("type", item.data.type.toString().toLowerCase());
                String string = "minecraft:item/generated";
                switch (item.data.textureType) {
                    case 2: {
                        String string2 = "minecraft:item/handheld";
                        break;
                    }
                    case 3: {
                        String string3 = "crashplugin:item/" + item.data.id + "/model";
                    }
                }
                jsonObject.addProperty("base", (String)var28_107);
            }
            itemIds.add((JsonElement)jsonObject);
        }
        data.add("items", (JsonElement)itemIds);
        JsonArray jsonArray4 = new JsonArray();
        for (Map.Entry<Integer, Integer> entry : change.guis.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("k", (Number)entry.getKey());
            jsonObject.addProperty("v", (Number)entry.getValue());
            jsonArray4.add((JsonElement)jsonObject);
        }
        data.add("guis", (JsonElement)jsonArray4);
        JsonArray jsonArray5 = new JsonArray();
        for (Map.Entry<Integer, Integer> entry : change.emotes.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("k", (Number)entry.getKey());
            jsonObject.addProperty("v", (Number)entry.getValue());
            jsonArray5.add((JsonElement)jsonObject);
        }
        data.add("emotes", (JsonElement)jsonArray5);
        JsonArray jsonArray6 = new JsonArray();
        for (Map.Entry<Integer, Integer> entry : change.armors.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("k", (Number)entry.getKey());
            jsonObject.addProperty("v", (Number)entry.getValue());
            jsonArray6.add((JsonElement)jsonObject);
        }
        data.add("armors", (JsonElement)jsonArray6);
        JsonArray jsonArray7 = new JsonArray();
        for (Map.Entry<Integer, Integer> entry : change.blocks.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("k", (Number)entry.getKey());
            jsonObject.addProperty("v", (Number)entry.getValue());
            jsonArray7.add((JsonElement)jsonObject);
        }
        data.add("blocks", (JsonElement)jsonArray7);
        JsonArray jsonArray8 = new JsonArray();
        for (Map.Entry<Integer, Integer> entry : change.mobs.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("k", (Number)entry.getKey());
            jsonObject.addProperty("v", (Number)entry.getValue());
            jsonArray8.add((JsonElement)jsonObject);
        }
        data.add("mobs", (JsonElement)jsonArray8);
        JsonArray jsonArray9 = new JsonArray();
        for (Map.Entry<Integer, Integer> entry : change.models.entrySet()) {
            JsonObject pp = new JsonObject();
            pp.addProperty("k", (Number)entry.getKey());
            pp.addProperty("v", (Number)entry.getValue());
            jsonArray9.add((JsonElement)pp);
        }
        data.add("models", (JsonElement)jsonArray9);
        data.add("custommodelsbbids", (JsonElement)customModelsBBIds);
        JsonArray jsonArray10 = new JsonArray();
        for (Map.Entry entry : change.sounds.entrySet()) {
            JsonObject pp = new JsonObject();
            pp.addProperty("k", (String)entry.getKey());
            pp.addProperty("v", (String)entry.getValue());
            jsonArray10.add((JsonElement)pp);
        }
        data.add("sounds", (JsonElement)jsonArray10);
        JsonArray jsonArray11 = new JsonArray();
        int i62 = 0;
        while (i62 < customParticles.size()) {
            JsonObject element = customParticles.get(i62).getAsJsonObject();
            JsonObject pp = new JsonObject();
            pp.addProperty("id", element.get("id").getAsString());
            jsonArray11.add((JsonElement)pp);
            ++i62;
        }
        data.add("customParticles", (JsonElement)jsonArray11);
        packet.add("data", (JsonElement)data);
        ConnectionClientHandler.sendInfoPacket("marketplaceinfo", packet);
    }

    public static float[] toArray(JsonArray array) {
        float[] ff = new float[array.size()];
        int i = 0;
        while (i < ff.length) {
            ff[i] = array.get(i).getAsFloat();
            ++i;
        }
        return ff;
    }

    private static EditorFile2 changeIds(EditorFile2 file, PackageIdsChange change) {
        for (EditorNode node : file.nodes.values()) {
            EditorNode.InputData data;
            EditorNode.InputData data2;
            EditorNode input;
            if (node.type.equals("newcrashitem")) {
                input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[0]).nodeID);
                if (!input.type.equals("newnumber")) continue;
                data2 = (EditorNode.InputData)input.inputs[0];
                data2.data = String.valueOf(change.items.get(Double.valueOf(data2.data).intValue()));
                continue;
            }
            if (node.type.equals("custominventory")) {
                input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[1]).nodeID);
                if (!input.type.equals("newnumber")) continue;
                data2 = (EditorNode.InputData)input.inputs[0];
                data2.data = String.valueOf(change.guis.get(Double.valueOf(data2.data).intValue()));
                continue;
            }
            if (node.type.equals("custominventorydata")) {
                input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[1]).nodeID);
                if (!input.type.equals("newnumber")) continue;
                data2 = (EditorNode.InputData)input.inputs[0];
                data2.data = String.valueOf(change.guis.get(Double.valueOf(data2.data).intValue()));
                continue;
            }
            if (node.type.equals("spawncrashmob")) {
                input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[0]).nodeID);
                if (!input.type.equals("newnumber")) continue;
                data2 = (EditorNode.InputData)input.inputs[0];
                data2.data = String.valueOf(change.mobs.get(Double.valueOf(data2.data).intValue()));
                continue;
            }
            if (node.type.equals("setcrashblock")) {
                input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[0]).nodeID);
                if (!input.type.equals("newnumber")) continue;
                data2 = (EditorNode.InputData)input.inputs[0];
                data2.data = String.valueOf(change.blocks.get(Double.valueOf(data2.data).intValue()));
                continue;
            }
            if (node.type.equals("setcustomarmor")) {
                input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[0]).nodeID);
                if (!input.type.equals("newnumber")) continue;
                data2 = (EditorNode.InputData)input.inputs[0];
                data2.data = String.valueOf(change.armors.get(Double.valueOf(data2.data).intValue()));
                continue;
            }
            if (node.type.equals("playsound2")) {
                input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[1]).nodeID);
                if (!input.type.equals("newtext")) continue;
                data2 = (EditorNode.InputData)input.inputs[0];
                data2.data = change.sounds.get(data2.data);
                continue;
            }
            if (node.type.equals("playsound")) {
                data = (EditorNode.InputData)node.inputs[1];
                data.data = change.sounds.get(data.data);
                continue;
            }
            if (node.type.equals("worldplaysound2")) {
                input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[2]).nodeID);
                if (!input.type.equals("newtext")) continue;
                data2 = (EditorNode.InputData)input.inputs[0];
                data2.data = change.sounds.get(data2.data);
                continue;
            }
            if (!node.type.equals("worldplaysound")) continue;
            data = (EditorNode.InputData)node.inputs[2];
            data.data = change.sounds.get(data.data);
        }
        for (EditorGroup group : file.groups.values()) {
            for (EditorNode node : group.file.nodes.values()) {
                EditorNode.InputData data;
                EditorNode.InputData data3;
                EditorNode input;
                if (node.type.equals("newcrashitem")) {
                    input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[0]).nodeID);
                    if (!input.type.equals("newnumber")) continue;
                    data3 = (EditorNode.InputData)input.inputs[0];
                    data3.data = String.valueOf(change.items.get(Double.valueOf(data3.data).intValue()));
                    continue;
                }
                if (node.type.equals("custominventory")) {
                    input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[1]).nodeID);
                    if (!input.type.equals("newnumber")) continue;
                    data3 = (EditorNode.InputData)input.inputs[0];
                    data3.data = String.valueOf(change.guis.get(Double.valueOf(data3.data).intValue()));
                    continue;
                }
                if (node.type.equals("custominventorydata")) {
                    input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[1]).nodeID);
                    if (!input.type.equals("newnumber")) continue;
                    data3 = (EditorNode.InputData)input.inputs[0];
                    data3.data = String.valueOf(change.guis.get(Double.valueOf(data3.data).intValue()));
                    continue;
                }
                if (node.type.equals("spawncrashmob")) {
                    input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[0]).nodeID);
                    if (!input.type.equals("newnumber")) continue;
                    data3 = (EditorNode.InputData)input.inputs[0];
                    data3.data = String.valueOf(change.mobs.get(Double.valueOf(data3.data).intValue()));
                    continue;
                }
                if (node.type.equals("setcrashblock")) {
                    input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[0]).nodeID);
                    if (!input.type.equals("newnumber")) continue;
                    data3 = (EditorNode.InputData)input.inputs[0];
                    data3.data = String.valueOf(change.blocks.get(Double.valueOf(data3.data).intValue()));
                    continue;
                }
                if (node.type.equals("setcustomarmor")) {
                    input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[0]).nodeID);
                    if (!input.type.equals("newnumber")) continue;
                    data3 = (EditorNode.InputData)input.inputs[0];
                    data3.data = String.valueOf(change.armors.get(Double.valueOf(data3.data).intValue()));
                    continue;
                }
                if (node.type.equals("playsound2")) {
                    input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[1]).nodeID);
                    if (!input.type.equals("newtext")) continue;
                    data3 = (EditorNode.InputData)input.inputs[0];
                    data3.data = change.sounds.get(data3.data);
                    continue;
                }
                if (node.type.equals("playsound")) {
                    data = (EditorNode.InputData)node.inputs[1];
                    data.data = change.sounds.get(data.data);
                    continue;
                }
                if (node.type.equals("worldplaysound2")) {
                    input = (EditorNode)file.nodes.get(((EditorNode.InputConnection)node.inputs[2]).nodeID);
                    if (!input.type.equals("newtext")) continue;
                    data3 = (EditorNode.InputData)input.inputs[0];
                    data3.data = change.sounds.get(data3.data);
                    continue;
                }
                if (!node.type.equals("worldplaysound")) continue;
                data = (EditorNode.InputData)node.inputs[2];
                data.data = change.sounds.get(data.data);
            }
        }
        return file;
    }
}

