/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.player;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.player.PlayerLog;
import com.crashstudios.crashcore.player.PlayerMessages;
import com.crashstudios.crashcore.player.PlayerProperties;
import com.crashstudios.crashcore.player.PlayerProperty;
import com.crashstudios.crashcore.storage.SLAPI;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.UUID;

public class PlayerData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final UUID uuid;
    private final PlayerMessages messages;
    private final PlayerLog log;
    private LocalDateTime lastTimeOnline;
    private long lastPlayTime;
    private long totalPlayTime;
    private final PlayerProperties properties;
    public static DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(' ').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('/').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('/').appendValue(ChronoField.YEAR, 4).toFormatter();

    public PlayerData(UUID uuid) {
        this.uuid = uuid;
        this.messages = new PlayerMessages();
        this.log = new PlayerLog();
        this.lastTimeOnline = LocalDateTime.now(ZoneOffset.UTC);
        this.lastPlayTime = 0L;
        this.totalPlayTime = 0L;
        this.properties = new PlayerProperties();
        this.properties.getProperties().put("displayname", new PlayerProperty(0, PlayerProperties.getters.get("displayname").apply(uuid)));
        this.properties.getProperties().put("health", new PlayerProperty(1, PlayerProperties.getters.get("health").apply(uuid)));
        this.properties.getProperties().put("maxhealth", new PlayerProperty(2, PlayerProperties.getters.get("maxhealth").apply(uuid)));
        this.properties.getProperties().put("hunger", new PlayerProperty(3, PlayerProperties.getters.get("hunger").apply(uuid)));
        this.properties.getProperties().put("saturation", new PlayerProperty(4, PlayerProperties.getters.get("saturation").apply(uuid)));
        this.properties.getProperties().put("fly", new PlayerProperty(5, PlayerProperties.getters.get("fly").apply(uuid)));
        this.properties.getProperties().put("absorption", new PlayerProperty(6, PlayerProperties.getters.get("absorption").apply(uuid)));
        this.properties.getProperties().put("walkspeed", new PlayerProperty(7, PlayerProperties.getters.get("walkspeed").apply(uuid)));
        this.properties.getProperties().put("flyspeed", new PlayerProperty(8, PlayerProperties.getters.get("flyspeed").apply(uuid)));
        this.properties.getProperties().put("experience", new PlayerProperty(9, PlayerProperties.getters.get("experience").apply(uuid)));
        this.properties.getProperties().put("opped", new PlayerProperty(10, PlayerProperties.getters.get("opped").apply(uuid)));
        this.properties.getProperties().put("banned", new PlayerProperty(11, PlayerProperties.getters.get("banned").apply(uuid)));
        this.properties.getProperties().put("visible", new PlayerProperty(12, PlayerProperties.getters.get("visible").apply(uuid)));
        this.properties.getProperties().put("gamemode", new PlayerProperty(13, PlayerProperties.getters.get("gamemode").apply(uuid)));
        this.properties.getProperties().put("whitelisted", new PlayerProperty(14, PlayerProperties.getters.get("whitelisted").apply(uuid)));
    }

    public PlayerMessages getMessages() {
        return this.messages;
    }

    public PlayerLog getLog() {
        return this.log;
    }

    public void save() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerdatas");
        try {
            SLAPI.save((Object)this, new File(folder, this.uuid.toString() + ".dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LocalDateTime getLastTimeOnline() {
        return this.lastTimeOnline;
    }

    public String getLastTimeOnlineFormatted() {
        return this.lastTimeOnline.format(formatter);
    }

    public void setLastTimeOnline(LocalDateTime lastTimeOnline) {
        this.lastTimeOnline = lastTimeOnline;
    }

    public long getLastPlayTime() {
        return this.lastPlayTime;
    }

    public String getLastPlayTimeFormatted() {
        return this.lastPlayTime / 3600L + "h " + this.lastPlayTime % 3600L / 60L + "m " + this.lastPlayTime % 60L + "s";
    }

    public void setLastPlayTime(long lastPlayTime) {
        this.lastPlayTime = lastPlayTime;
    }

    public long getTotalPlayTime() {
        return this.totalPlayTime;
    }

    public String getTotalPlayTimeFormatted() {
        return this.totalPlayTime / 3600L + "h " + this.totalPlayTime % 3600L / 60L + "m " + this.totalPlayTime % 60L + "s";
    }

    public void setTotalPlayTime(long totalPlayTime) {
        this.totalPlayTime = totalPlayTime;
    }

    public PlayerProperties getProperties() {
        return this.properties;
    }
}

