/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.player;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.storage.SLAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlayerList {
    public static HashMap<UUID, String> names = new HashMap();
    public static List<UUID> recent = new ArrayList<UUID>();
    public static HashMap<UUID, Integer> playtime = new HashMap();
    public static List<UUID> alphabetic = new ArrayList<UUID>();

    public static void addName(UUID uuid, String name) {
        String nm = names.get(uuid);
        if (!name.equals(nm)) {
            names.put(uuid, name);
            int i = 0;
            while (i < alphabetic.size()) {
                if (name.compareTo(names.get(alphabetic.get(i))) < 0) break;
                ++i;
            }
            alphabetic.add(i, uuid);
            PlayerList.saveNames();
            PlayerList.saveAlphabetic();
        }
    }

    public static void saveNames() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerlist");
        try {
            SLAPI.save(names, new File(folder, "names.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadNames() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerlist");
        try {
            names = (HashMap)SLAPI.load(new File(folder, "names.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (names == null) {
            names = new HashMap();
        }
    }

    public static void saveRecent() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerlist");
        try {
            SLAPI.save(recent, new File(folder, "recent.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadRecent() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerlist");
        try {
            recent = (List)SLAPI.load(new File(folder, "recent.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (recent == null) {
            recent = new ArrayList<UUID>();
        }
    }

    public static void savePlaytime() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerlist");
        try {
            SLAPI.save(playtime, new File(folder, "playtime.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadPlaytime() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerlist");
        try {
            playtime = (HashMap)SLAPI.load(new File(folder, "playtime.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (playtime == null) {
            playtime = new HashMap();
        }
    }

    public static void saveAlphabetic() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerlist");
        try {
            SLAPI.save(alphabetic, new File(folder, "alphabetic.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadAlphabetic() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "playerlist");
        try {
            alphabetic = (List)SLAPI.load(new File(folder, "alphabetic.dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (alphabetic == null) {
            alphabetic = new ArrayList<UUID>();
        }
    }

    public static HashMap<UUID, Integer> sortByValue(Map<UUID, Integer> unsortMap) {
        LinkedList<Map.Entry<UUID, Integer>> list = new LinkedList<Map.Entry<UUID, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<UUID, Integer>>(){

            @Override
            public int compare(Map.Entry<UUID, Integer> o1, Map.Entry<UUID, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<UUID, Integer> sortedMap = new LinkedHashMap<UUID, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((UUID)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }
}

