/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.player;

import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.player.PlayerData;
import com.crashstudios.crashcore.player.PlayerDatas;
import com.crashstudios.crashcore.player.PlayerList;
import com.crashstudios.crashcore.player.PlayerMessage;
import com.crashstudios.crashcore.player.PlayerProperties;
import com.crashstudios.crashcore.player.PlayerProperty;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.ServerCommandEvent;

public class PlayerListener
implements Listener {
    public static boolean resourcePackChanged = false;
    public static String resourcePackUrl;
    public static boolean resourcePack;

    static {
        resourcePack = true;
    }

    @EventHandler
    public void onCommand(ServerCommandEvent e) {
        if (e.getCommand().startsWith("/crashconnect")) {
            e.setCommand(e.getCommand().substring(1));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChat(AsyncPlayerChatEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        PlayerData dat = PlayerDatas.getPlayerData(uuid);
        PlayerMessage mex = new PlayerMessage(e.getMessage(), LocalDateTime.now(ZoneOffset.UTC));
        dat.getMessages().getMessages().add(mex);
        dat.save();
        JsonObject json = new JsonObject();
        json.addProperty("key", uuid.toString());
        json.addProperty("init", Boolean.valueOf(false));
        JsonArray datas = new JsonArray();
        JsonObject message = new JsonObject();
        message.addProperty("dt", (Number)mex.getDatetime().toInstant(ZoneOffset.UTC).toEpochMilli());
        message.addProperty("mx", mex.getMessage());
        datas.add((JsonElement)message);
        json.add("data", (JsonElement)datas);
        ConnectionClientHandler.sendInfoPacket("playermessages", json);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoinMonitor(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        PlayerListener.log(player.getUniqueId(), "Joined");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (resourcePackUrl != null && resourcePack) {
            player.setResourcePack(resourcePackUrl);
        }
    }

    @EventHandler
    public void onResourcePackStatus(PlayerResourcePackStatusEvent e) {
        Player player = e.getPlayer();
        if (e.getStatus() == PlayerResourcePackStatusEvent.Status.DECLINED) {
            player.kickPlayer("Server requires a custom resource pack");
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void loadPlayerProperties(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        if (PlayerDatas.isRegistered(uuid)) {
            PlayerData dat = PlayerDatas.getPlayerData(uuid);
            HashMap<String, PlayerProperty> properties = dat.getProperties().getProperties();
            properties.get("fly").setUnsetted(true);
            for (Map.Entry<String, PlayerProperty> property : properties.entrySet()) {
                if (!property.getValue().isUnsetted() || !PlayerProperties.onlineProperty.contains(property.getKey())) continue;
                PlayerProperties.setters.get(property.getKey()).accept(uuid, property.getValue().getValueWithoutSync());
                property.getValue().setUnsetted(false);
            }
            dat.setLastPlayTime(0L);
            dat.setLastTimeOnline(LocalDateTime.of(1970, 1, 1, 0, 2));
        } else {
            PlayerDatas.getPlayerData(uuid);
        }
        PlayerList.addName(uuid, player.getName());
        PlayerList.recent.remove(uuid);
        PlayerList.recent.add(uuid);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        PlayerData dat = PlayerDatas.getPlayerData(uuid);
        dat.setLastTimeOnline(LocalDateTime.now(ZoneOffset.UTC));
        PlayerListener.log(uuid, "Quitted");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChangedWorld(PlayerChangedWorldEvent e) {
        PlayerListener.log(e.getPlayer().getUniqueId(), "World changed (" + e.getFrom().getName() + " -> " + e.getPlayer().getWorld().getName() + ")");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(PlayerDeathEvent e) {
        PlayerListener.log(e.getEntity().getUniqueId(), "Death (" + e.getDeathMessage() + ")");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGamemodeChange(PlayerGameModeChangeEvent e) {
        GameMode newGameMode = e.getNewGameMode();
        UUID uuid = e.getPlayer().getUniqueId();
        PlayerListener.log(uuid, "Gamemode changed (" + e.getPlayer().getGameMode().name() + " -> " + newGameMode.name() + ")");
        if (newGameMode == GameMode.SURVIVAL || newGameMode == GameMode.ADVENTURE) {
            PlayerDatas.getPlayerData(uuid).getProperties().getProperties().get("fly").setValue(uuid, "false");
        } else {
            PlayerDatas.getPlayerData(uuid).getProperties().getProperties().get("fly").setValue(uuid, "true");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onKick(PlayerKickEvent e) {
        PlayerListener.log(e.getPlayer().getUniqueId(), "Kicked");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent e) {
        double fromX = (double)((int)(e.getFrom().getX() * 10.0)) / 10.0;
        double fromY = (double)((int)(e.getFrom().getY() * 10.0)) / 10.0;
        double fromZ = (double)((int)(e.getFrom().getZ() * 10.0)) / 10.0;
        double toX = (double)((int)(e.getTo().getX() * 10.0)) / 10.0;
        double toY = (double)((int)(e.getTo().getY() * 10.0)) / 10.0;
        double toZ = (double)((int)(e.getTo().getZ() * 10.0)) / 10.0;
        if (fromX == toX && fromY == toY && fromZ == toZ) {
            return;
        }
        PlayerListener.log(e.getPlayer().getUniqueId(), "Teleported (" + fromX + " " + fromY + " " + fromZ + " -> " + toX + " " + toY + " " + toZ + ")");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        PlayerListener.log(e.getPlayer().getUniqueId(), e.getMessage());
    }

    public static void log(UUID uuid, String str) {
        if (Bukkit.getPlayer((UUID)uuid) == null) {
            return;
        }
        PlayerData dat = PlayerDatas.getPlayerData(uuid);
        PlayerMessage mex = new PlayerMessage(str, LocalDateTime.now(ZoneOffset.UTC));
        dat.getLog().getMessages().add(mex);
        dat.save();
        JsonObject json = new JsonObject();
        json.addProperty("key", uuid.toString());
        json.addProperty("init", Boolean.valueOf(false));
        JsonArray datas = new JsonArray();
        JsonObject message = new JsonObject();
        message.addProperty("dt", (Number)mex.getDatetime().toInstant(ZoneOffset.UTC).toEpochMilli());
        message.addProperty("mx", mex.getMessage());
        datas.add((JsonElement)message);
        json.add("data", (JsonElement)datas);
        ConnectionClientHandler.sendInfoPacket("playerlog", json);
    }
}

