/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.player;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.folia.CrashScheduler;
import com.crashstudios.crashcore.player.PlayerProperty;
import com.crashstudios.crashcore.player.PlayerPropertyInfo;
import com.crashstudios.crashcore.utilities.ColorUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class PlayerProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, PlayerProperty> properties = new HashMap();
    public static List<String> priorities = new ArrayList<String>();
    public static HashMap<Integer, PlayerPropertyInfo> propertyInfos = new HashMap();
    public static HashSet<String> onlineProperty = new HashSet();
    public static HashMap<String, BiConsumer<UUID, String>> setters = new HashMap();
    public static HashMap<String, Function<UUID, String>> getters = new HashMap();

    static {
        priorities.add("displayname");
        priorities.add("health");
        priorities.add("maxhealth");
        priorities.add("hunger");
        priorities.add("saturation");
        priorities.add("fly");
        priorities.add("absorption");
        priorities.add("walkspeed");
        priorities.add("flyspeed");
        priorities.add("experience");
        priorities.add("opped");
        priorities.add("banned");
        priorities.add("visible");
        priorities.add("gamemode");
        priorities.add("whitelisted");
        propertyInfos.put(0, new PlayerPropertyInfo("displayname", "Display Name", 1));
        propertyInfos.put(1, new PlayerPropertyInfo("health", "Health", 1));
        propertyInfos.put(2, new PlayerPropertyInfo("maxhealth", "Max Health", 1));
        propertyInfos.put(3, new PlayerPropertyInfo("hunger", "Hunger", 1));
        propertyInfos.put(4, new PlayerPropertyInfo("saturation", "Saturation", 1));
        propertyInfos.put(5, new PlayerPropertyInfo("fly", "Fly", 0));
        propertyInfos.put(6, new PlayerPropertyInfo("absorption", "Absorption", 1));
        propertyInfos.put(7, new PlayerPropertyInfo("walkspeed", "Walk Speed", 1));
        propertyInfos.put(8, new PlayerPropertyInfo("flyspeed", "Fly Speed", 1));
        propertyInfos.put(9, new PlayerPropertyInfo("experience", "Experience", 1));
        propertyInfos.put(10, new PlayerPropertyInfo("opped", "Opped", 0));
        propertyInfos.put(11, new PlayerPropertyInfo("banned", "Banned", 0));
        propertyInfos.put(12, new PlayerPropertyInfo("visible", "Visible", 0));
        propertyInfos.put(13, new PlayerPropertyInfo("gamemode", "Gamemode", 1));
        propertyInfos.put(14, new PlayerPropertyInfo("whitelisted", "Whitelisted", 0));
        onlineProperty.add("displayname");
        onlineProperty.add("health");
        onlineProperty.add("maxhealth");
        onlineProperty.add("hunger");
        onlineProperty.add("saturation");
        onlineProperty.add("fly");
        onlineProperty.add("absorption");
        onlineProperty.add("walkspeed");
        onlineProperty.add("flyspeed");
        onlineProperty.add("experience");
        onlineProperty.add("visible");
        onlineProperty.add("gamemode");
        setters.put("displayname", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setDisplayName(ColorUtils.color(v)));
        getters.put("displayname", uuid -> Bukkit.getPlayer((UUID)uuid).getDisplayName().replace('\u00a7', '&'));
        setters.put("health", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setHealth(Double.parseDouble(v)));
        getters.put("health", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getHealth());
        setters.put("maxhealth", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setMaxHealth(Double.parseDouble(v)));
        getters.put("maxhealth", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getMaxHealth());
        setters.put("hunger", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setFoodLevel(Integer.parseInt(v)));
        getters.put("hunger", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getFoodLevel());
        setters.put("saturation", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setSaturation((float)Double.parseDouble(v)));
        getters.put("saturation", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getSaturation());
        setters.put("fly", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setAllowFlight(Boolean.parseBoolean(v)));
        getters.put("fly", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getAllowFlight());
        setters.put("absorption", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setAbsorptionAmount(Double.parseDouble(v)));
        getters.put("absorption", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getAbsorptionAmount());
        setters.put("walkspeed", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setWalkSpeed((float)Double.parseDouble(v)));
        getters.put("walkspeed", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getWalkSpeed());
        setters.put("flyspeed", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setFlySpeed((float)Double.parseDouble(v)));
        getters.put("flyspeed", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getFlySpeed());
        setters.put("experience", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setTotalExperience(Integer.parseInt(v)));
        getters.put("experience", uuid -> "" + Bukkit.getPlayer((UUID)uuid).getTotalExperience());
        setters.put("opped", (uuid, v) -> Bukkit.getOfflinePlayer((UUID)uuid).setOp(Boolean.parseBoolean(v)));
        getters.put("opped", uuid -> "" + Bukkit.getOfflinePlayer((UUID)uuid).isOp());
        setters.put("banned", (uuid, v) -> {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            if (Boolean.parseBoolean(v)) {
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(offlinePlayer.getName(), null, null, "CrashPanel");
                if (offlinePlayer.isOnline()) {
                    CrashScheduler.runTask((Plugin)Main.INSTANCE, () -> offlinePlayer.getPlayer().kickPlayer("You have been banned."));
                }
            } else {
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(offlinePlayer.getName());
            }
        });
        getters.put("banned", uuid -> "" + Bukkit.getOfflinePlayer((UUID)uuid).isBanned());
        setters.put("visible", (uuid, v) -> Bukkit.getPlayer((UUID)uuid).setInvisible(!Boolean.parseBoolean(v)));
        getters.put("visible", uuid -> "" + !Bukkit.getPlayer((UUID)uuid).isInvisible());
        setters.put("gamemode", (uuid, v) -> {
            try {
                int gmnum = Integer.parseInt(v);
                if (gmnum >= 0 && gmnum <= 3) {
                    CrashScheduler.runTask((Plugin)Main.INSTANCE, () -> Bukkit.getPlayer((UUID)uuid).setGameMode(GameMode.getByValue((int)gmnum)));
                    return;
                }
            }
            catch (NumberFormatException gmnum) {
                // empty catch block
            }
            try {
                GameMode g = GameMode.valueOf((String)v.toUpperCase());
                if (g != null) {
                    CrashScheduler.runTask((Plugin)Main.INSTANCE, () -> Bukkit.getPlayer((UUID)uuid).setGameMode(g));
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        getters.put("gamemode", uuid -> Bukkit.getPlayer((UUID)uuid).getGameMode().name().toLowerCase());
        setters.put("whitelisted", (uuid, v) -> Bukkit.getOfflinePlayer((UUID)uuid).setWhitelisted(Boolean.parseBoolean(v)));
        getters.put("whitelisted", uuid -> "" + Bukkit.getOfflinePlayer((UUID)uuid).isWhitelisted());
    }

    public HashMap<String, PlayerProperty> getProperties() {
        return this.properties;
    }
}

