/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.player;

import com.crashstudios.crashcore.player.PlayerProperties;
import com.crashstudios.crashcore.player.PlayerPropertyInfo;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.Bukkit;

public class PlayerProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int infoId;
    private String value;
    private boolean unsetted;

    public PlayerProperty(int infoId, String value) {
        this.infoId = infoId;
        this.value = value;
        this.unsetted = false;
    }

    public String getValue(UUID uuid) {
        PlayerPropertyInfo info = PlayerProperties.propertyInfos.get(this.infoId);
        if (PlayerProperties.onlineProperty.contains(info.getId())) {
            Function<UUID, String> getter;
            if (Bukkit.getOfflinePlayer((UUID)uuid).isOnline() && (getter = PlayerProperties.getters.get(info.getId())) != null) {
                try {
                    this.value = getter.apply(uuid);
                }
                catch (Exception exception) {}
            }
        } else {
            Function<UUID, String> getter = PlayerProperties.getters.get(info.getId());
            if (getter != null) {
                try {
                    this.value = getter.apply(uuid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.value;
    }

    public void setValue(UUID uuid, String value) {
        this.value = value;
        PlayerPropertyInfo info = PlayerProperties.propertyInfos.get(this.infoId);
        if (PlayerProperties.onlineProperty.contains(info.getId())) {
            if (Bukkit.getOfflinePlayer((UUID)uuid).isOnline()) {
                BiConsumer<UUID, String> setter = PlayerProperties.setters.get(info.getId());
                if (setter != null) {
                    try {
                        setter.accept(uuid, value);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.unsetted = true;
            }
        } else {
            BiConsumer<UUID, String> setter = PlayerProperties.setters.get(info.getId());
            if (setter != null) {
                try {
                    setter.accept(uuid, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public int getInfoId() {
        return this.infoId;
    }

    public String getValueWithoutSync() {
        return this.value;
    }

    public boolean isUnsetted() {
        return this.unsetted;
    }

    public void setUnsetted(boolean unsetted) {
        this.unsetted = unsetted;
    }
}

