/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script;

import java.io.Serializable;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.joml.Vector3i;

public class BlockVolume
implements Serializable {
    private static final long serialVersionUID = 1L;
    public HashSet<Vector3i> blocks = new HashSet();

    public BlockVolume() {
    }

    public BlockVolume(int x1, int y1, int z1, int x2, int y2, int z2) {
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minY = Math.min(y1, y2);
        int maxY = Math.max(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    this.blocks.add(new Vector3i(x, y, z));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void addBlock(int x, int y, int z) {
        this.blocks.add(new Vector3i(x, y, z));
    }

    public void removeBlock(int x, int y, int z) {
        this.blocks.remove(new Vector3i(x, y, z));
    }

    public boolean containsBlock(int x, int y, int z) {
        return this.blocks.contains(new Vector3i(x, y, z));
    }

    public int size() {
        return this.blocks.size();
    }

    public BlockVolume join(BlockVolume other) {
        BlockVolume result = new BlockVolume();
        result.blocks.addAll(this.blocks);
        result.blocks.addAll(other.blocks);
        return result;
    }

    public String copy(World world, int originX, int originY, int originZ) {
        StringBuilder sb = new StringBuilder();
        for (Vector3i pos : this.blocks) {
            int relX = pos.x - originX;
            int relY = pos.y - originY;
            int relZ = pos.z - originZ;
            Block block = world.getBlockAt(pos.x, pos.y, pos.z);
            String blockType = block.getType().toString();
            sb.append(relX).append(",").append(relY).append(",").append(relZ).append(",").append(blockType).append(";");
        }
        return sb.toString();
    }

    public static void paste(World world, int originX, int originY, int originZ, String clipped) {
        String[] entries;
        if (clipped.isEmpty()) {
            return;
        }
        String[] stringArray = entries = clipped.split(";");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parts;
            String entry = stringArray[n2];
            if (!entry.isEmpty() && (parts = entry.split(",")).length == 4) {
                int x = Integer.parseInt(parts[0]) + originX;
                int y = Integer.parseInt(parts[1]) + originY;
                int z = Integer.parseInt(parts[2]) + originZ;
                String blockType = parts[3];
                try {
                    world.getBlockAt(x, y, z).setType(Material.valueOf((String)blockType));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }
}

