/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.editor.EditorFile;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.editor.EditorGroup;
import com.crashstudios.crashcore.editor.EditorNode;
import com.crashstudios.crashcore.folia.CrashScheduler;
import com.crashstudios.crashcore.model.CustomModel;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.ModelEntity;
import com.crashstudios.crashcore.script.CompiledScriptRules;
import com.crashstudios.crashcore.script.CustomNode;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.script.FunctionPayload;
import com.crashstudios.crashcore.script.FunctionsManager;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.script.Vector;
import com.crashstudios.crashcore.script.interaction.InteractionListener;
import com.crashstudios.crashcore.script.interaction.LeftClickListener;
import com.crashstudios.crashcore.script.interaction.RightClickListener;
import com.crashstudios.crashcore.script.inv.ClickListener;
import com.crashstudios.crashcore.script.inv.CloseListener;
import com.crashstudios.crashcore.script.inv.InventoryListener;
import com.crashstudios.crashcore.script.miscellaneous.CrashMobScripts;
import com.crashstudios.crashcore.script.miscellaneous.ProjectileData;
import com.crashstudios.crashcore.script.player.PlayerListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CompiledScript {
    public static CompiledScript NULL_SCRIPT = new CompiledScript();
    public HashSet<Node> startingNodes = new HashSet();
    public int hash;
    public HashMap<Integer, Node> temp = new HashMap();

    @Deprecated
    public CompiledScript() {
    }

    public CompiledScript(CompiledScriptRules rules, EditorFile file) {
        this.update(rules, file);
    }

    public void update(CompiledScriptRules rules, EditorFile file) {
        if (this.hash != file.hashCode()) {
            this.hash = file.hashCode();
            if (file instanceof EditorFile2) {
                EditorFile2 file2 = (EditorFile2)file;
                for (EditorGroup group : file2.groups.values()) {
                    CompiledScriptRules groupRules = new CompiledScriptRules();
                    groupRules.listeners.add("in_" + group.id);
                    CompiledScript script = new CompiledScript(groupRules, group.file);
                    FunctionsManager.specialFunctions.put(group.id, payload -> {
                        FunctionsManager.specialFunctions.put("out_" + editorGroup.id, payload2 -> {
                            functionPayload.execution.put(functionPayload.instance, payload2.inputPins);
                            for (Node output : functionPayload.execOutput) {
                                output.run(functionPayload.execution);
                            }
                        });
                        script.run("in_" + editorGroup.id, payload.inputPins.values);
                    });
                }
            }
            this.startingNodes.clear();
            for (EditorNode n : file.nodes.values()) {
                if (!CompiledScript.isListener(rules, n)) continue;
                this.startingNodes.add(this.createNode(file, n));
            }
            this.temp.clear();
        }
    }

    public Node createNode(EditorFile file, EditorNode n) {
        Node node = this.temp.get(n.id);
        if (node != null) {
            return node;
        }
        node = new Node();
        node.type = n.type;
        node.value = FunctionsManager.functions.get(n.type);
        if (node.value == null && node.type.startsWith("connector_")) {
            node.value = pins -> pins;
        }
        node.exec = CompiledScript.isExec(n);
        node.input = new Input[n.inputs.length];
        int i = 0;
        while (i < n.inputs.length) {
            EditorNode.Input input = n.inputs[i];
            if (input != null) {
                if (input instanceof EditorNode.InputConnection) {
                    EditorNode.InputConnection inputConnection = (EditorNode.InputConnection)input;
                    node.input[i] = new Connection(this.createNode(file, file.nodes.get(inputConnection.nodeID)), inputConnection.pinPos);
                } else if (input instanceof EditorNode.InputData) {
                    EditorNode.InputData inputData = (EditorNode.InputData)input;
                    node.input[i] = new Data(inputData.data);
                }
            }
            ++i;
        }
        this.temp.put(n.id, node);
        int[] nArray = n.execOutput;
        int n2 = n.execOutput.length;
        int n3 = 0;
        while (n3 < n2) {
            int id = nArray[n3];
            node.execOutput.add(this.createNode(file, file.nodes.get(id)));
            ++n3;
        }
        return node;
    }

    public void run(String type, Object[] data) {
        for (Node node : this.startingNodes) {
            if (!node.type.equals(type)) continue;
            node.start(new HashMap<Node, Pins>(), data);
        }
    }

    public static boolean isListener(CompiledScriptRules rules, EditorNode n) {
        return rules.listeners.contains(n.type);
    }

    public static boolean isExec(EditorNode n) {
        return n.execOutput.length > 0;
    }

    public static class Connection
    implements Input {
        public Node node;
        public int index;

        public Connection(Node node, int index) {
            this.node = node;
            this.index = index;
        }
    }

    public static class Data
    implements Input {
        public String data;

        public Data(String data) {
            this.data = data;
        }
    }

    public static interface Input {
    }

    public static class Node {
        public HashSet<Node> execOutput = new HashSet();
        public Input[] input;
        public Function<Pins, Pins> value;
        public String type;
        public boolean exec;

        public void start(HashMap<Node, Pins> execution, Object[] data) {
            execution.put(this, new Pins(data));
            for (Node output : this.execOutput) {
                output.run(execution);
            }
        }

        public void run(final HashMap<Node, Pins> execution) {
            block98: {
                Consumer<FunctionPayload> consumer;
                Pins inputPins;
                block97: {
                    inputPins = new Pins(new Object[this.input.length]);
                    int i = 0;
                    while (i < this.input.length) {
                        inputPins.values[i] = this.getSingleOutput(execution, this.input[i]);
                        ++i;
                    }
                    if (this.value == null) break block97;
                    Object pp = this.value.apply(inputPins);
                    if (pp == null) {
                        return;
                    }
                    execution.put(this, (Pins)pp);
                    break block98;
                }
                switch (this.type) {
                    case "wait": {
                        CrashScheduler.runTaskLater((Plugin)Main.INSTANCE, new Runnable(){

                            @Override
                            public void run() {
                                for (Node output : execOutput) {
                                    output.run(execution);
                                }
                            }
                        }, ((Double)inputPins.values[0]).intValue());
                        return;
                    }
                    case "if": {
                        if (((Boolean)inputPins.values[0]).booleanValue()) {
                            for (Node output : this.execOutput) {
                                if (output.type.equalsIgnoreCase("else")) continue;
                                output.run(execution);
                            }
                        } else {
                            for (Node output : this.execOutput) {
                                if (!output.type.equalsIgnoreCase("else")) continue;
                                output.run(execution);
                            }
                        }
                        return;
                    }
                    case "timer": {
                        final int ticks = ((Double)inputPins.values[0]).intValue();
                        final int duration = ((Double)inputPins.values[1]).intValue();
                        final Node instance = this;
                        CrashScheduler.runTaskTimer((Plugin)Main.INSTANCE, new Consumer<CrashScheduler.CancelHandle>(){
                            private int currentTicks = 0;

                            @Override
                            public void accept(CrashScheduler.CancelHandle task) {
                                this.currentTicks += ticks;
                                if (this.currentTicks > duration) {
                                    task.cancel();
                                    return;
                                }
                                execution.put(instance, new Pins(this.currentTicks));
                                for (Node output : execOutput) {
                                    output.run(execution);
                                }
                            }
                        }, (long)ticks, (long)ticks);
                        return;
                    }
                    case "repeat": {
                        int ticks = ((Double)inputPins.values[0]).intValue();
                        int i = 0;
                        while (i < ticks) {
                            execution.put(this, new Pins(i));
                            for (Node output : this.execOutput) {
                                output.run(execution);
                            }
                            ++i;
                        }
                        return;
                    }
                    case "clickinventoryevent": {
                        Inventory inv = (Inventory)inputPins.values[0];
                        final Node instance = this;
                        InventoryListener.clickslistener.put(inv, new ClickListener(){

                            @Override
                            public void onClick(Player player, int slot, ItemStack itemstack, Cancellable e, boolean isPrimaryInventory) {
                                if (itemstack == null) {
                                    itemstack = new ItemStack(Material.STONE);
                                }
                                execution.put(instance, new Pins(player, slot, itemstack, e, isPrimaryInventory));
                                for (Node output : execOutput) {
                                    output.run(execution);
                                }
                            }
                        });
                        return;
                    }
                    case "closeinventoryevent": {
                        Inventory inv = (Inventory)inputPins.values[0];
                        final Node instance = this;
                        InventoryListener.closelistener.put(inv, new CloseListener(){

                            @Override
                            public void onClose(Player player) {
                                execution.put(instance, new Pins(player));
                                for (Node output : execOutput) {
                                    output.run(execution);
                                }
                            }
                        });
                        return;
                    }
                    case "foreachlist": {
                        List list = (List)inputPins.values[0];
                        Node instance = this;
                        int i = 0;
                        while (i < list.size()) {
                            String str = (String)list.get(i);
                            execution.put(instance, new Pins(str));
                            for (Node output : this.execOutput) {
                                output.run(execution);
                            }
                            ++i;
                        }
                        return;
                    }
                    case "foreachinv": {
                        Inventory inventory = (Inventory)inputPins.values[0];
                        Node instance = this;
                        int i = 0;
                        while (i < inventory.getSize()) {
                            ItemStack item = inventory.getItem(i);
                            if (item != null) {
                                execution.put(instance, new Pins(item));
                                for (Node output : this.execOutput) {
                                    output.run(execution);
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                    case "onleftclickinteraction": {
                        Interaction interaction = (Interaction)inputPins.values[0];
                        final Node instance = this;
                        InteractionListener.leftClicksListener.put(interaction, new LeftClickListener(){

                            @Override
                            public void onClick(Player player, ItemStack itemstack) {
                                execution.put(instance, new Pins(player, itemstack));
                                for (Node output : execOutput) {
                                    output.run(execution);
                                }
                            }
                        });
                        return;
                    }
                    case "onrightclickinteraction": {
                        Interaction interaction = (Interaction)inputPins.values[0];
                        final Node instance = this;
                        InteractionListener.rightClicksListener.put(interaction, new RightClickListener(){

                            @Override
                            public void onClick(Player player, ItemStack itemstack) {
                                execution.put(instance, new Pins(player, itemstack));
                                for (Node output : execOutput) {
                                    output.run(execution);
                                }
                            }
                        });
                        return;
                    }
                    case "playerchatevent": {
                        Player player = (Player)inputPins.values[0];
                        Node instance = this;
                        PlayerListener.chatlistener.put(player, pins -> {
                            execution.put(instance, (Pins)pins);
                            for (Node output : this.execOutput) {
                                output.run(execution);
                            }
                        });
                        return;
                    }
                    case "playershiftevent": {
                        Player player = (Player)inputPins.values[0];
                        Node instance = this;
                        Boolean bool = (Boolean)inputPins.values[1];
                        Consumer<Pins> cons = pins -> {
                            execution.put(instance, (Pins)pins);
                            for (Node output : this.execOutput) {
                                output.run(execution);
                            }
                        };
                        if (bool.booleanValue()) {
                            PlayerListener.shiftlisteneron.put(player, cons);
                        } else {
                            PlayerListener.shiftlisteneroff.put(player, cons);
                        }
                        return;
                    }
                    case "playerjumpevent": {
                        Player player = (Player)inputPins.values[0];
                        Node instance = this;
                        PlayerListener.jumplistener.put(player, pins -> {
                            execution.put(instance, (Pins)pins);
                            for (Node output : this.execOutput) {
                                output.run(execution);
                            }
                        });
                        return;
                    }
                    case "foreachworld": {
                        Node instance = this;
                        List worlds = Bukkit.getWorlds();
                        int i = 0;
                        while (i < worlds.size()) {
                            World world = (World)worlds.get(i);
                            if (world != null) {
                                execution.put(instance, new Pins(world));
                                for (Node output : this.execOutput) {
                                    output.run(execution);
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                    case "foreachplayer": {
                        World world = (World)inputPins.values[0];
                        Node instance = this;
                        List players = world.getPlayers();
                        int i = 0;
                        while (i < players.size()) {
                            Player player = (Player)players.get(i);
                            if (player != null) {
                                execution.put(instance, new Pins(player));
                                for (Node output : this.execOutput) {
                                    output.run(execution);
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                    case "shotprojectile": {
                        Entity entity = (Entity)inputPins.values[0];
                        Vector velocity = ((Vector)inputPins.values[1]).copy();
                        Double gravity = (Double)inputPins.values[2];
                        Double duration = (Double)inputPins.values[3];
                        Double spread = (Double)inputPins.values[4];
                        if (spread != 0.0) {
                            double rad = Math.toRadians(spread);
                            velocity.rotateVector(new float[]{1.0f, 0.0f, 0.0f}, (Math.random() - 0.5) * rad);
                            velocity.rotateVector(new float[]{0.0f, 1.0f, 0.0f}, (Math.random() - 0.5) * rad);
                            velocity.rotateVector(new float[]{0.0f, 0.0f, 1.0f}, (Math.random() - 0.5) * rad);
                        }
                        final Node instance = this;
                        ProjectileData data = new ProjectileData(entity, velocity, gravity, duration.intValue()){

                            @Override
                            public void exec(Entity entity, Block block) {
                                execution.put(instance, new Pins(entity != null, entity, block != null, block));
                                for (Node output : execOutput) {
                                    output.run(execution);
                                }
                            }
                        };
                        data.launch();
                        return;
                    }
                    case "pfnearentitiesfilter": {
                        Node instance = this;
                        CrashMobScripts.pfnearentitiesfilter(inputPins, this.execOutput, execution, instance);
                        return;
                    }
                    case "foreachmodelelements": {
                        ModelEntity model = (ModelEntity)inputPins.values[0];
                        String filter = (String)inputPins.values[1];
                        Node instance = this;
                        CustomModel customModel = ModelEditor.models.get(model.data.customModel);
                        if (customModel == null) {
                            return;
                        }
                        for (Map.Entry<String, UUID> entry : model.data.uuids.entrySet()) {
                            String name = customModel.getElementName(entry.getKey());
                            if (name == null || !name.toLowerCase().contains(filter.toLowerCase())) continue;
                            Entity ent = Bukkit.getEntity((UUID)entry.getValue());
                            execution.put(instance, new Pins(ent, name));
                            for (Node output : this.execOutput) {
                                output.run(execution);
                            }
                        }
                        return;
                    }
                }
                if (this.type.length() == 36) {
                    try {
                        UUID uuid = UUID.fromString(this.type);
                        CustomNode node = CustomNodes.nodes.get(uuid);
                        if (node != null) {
                            node.updateScript();
                            ArrayList<Node> nodeLayer = new ArrayList<Node>(node.getScript().startingNodes);
                            ArrayList<Node> nextNodeLayer = new ArrayList<Node>();
                            while (nodeLayer.size() != 0) {
                                for (Node n : nodeLayer) {
                                    for (Node n2 : n.execOutput) {
                                        if (n2.type.equals("output")) {
                                            Node instance = this;
                                            n2.value = p -> {
                                                execution.put(instance, (Pins)p);
                                                for (Node output : node.execOutput) {
                                                    output.run(execution);
                                                }
                                                return p;
                                            };
                                            continue;
                                        }
                                        nextNodeLayer.add(n2);
                                    }
                                }
                                nodeLayer = nextNodeLayer;
                                nextNodeLayer = new ArrayList();
                            }
                            int i = 0;
                            while (i < node.data.inputs.length) {
                                if (node.data.inputs[i].equals("intinput")) {
                                    inputPins.values[i] = Double.valueOf((String)inputPins.values[i]);
                                }
                                ++i;
                            }
                            node.getScript().run("input", inputPins.values);
                        }
                        return;
                    }
                    catch (IllegalArgumentException uuid) {
                        // empty catch block
                    }
                }
                if ((consumer = FunctionsManager.specialFunctions.get(this.type)) != null) {
                    consumer.accept(new FunctionPayload(inputPins, this, execution, this.execOutput));
                    return;
                }
                this.value = FunctionsManager.functions.get(this.type);
                if (this.value != null) {
                    Pins pp = this.value.apply(inputPins);
                    if (pp == null) {
                        return;
                    }
                    execution.put(this, pp);
                }
            }
            for (Node output : this.execOutput) {
                output.run(execution);
            }
        }

        public Object getSingleOutput(HashMap<Node, Pins> execution, Input input) {
            if (input instanceof Connection) {
                Connection connection = (Connection)input;
                if (connection.node.exec) {
                    return execution.get((Object)connection.node).values[connection.index];
                }
                Pins inputPins = new Pins(new Object[connection.node.input.length]);
                int i = 0;
                while (i < connection.node.input.length) {
                    inputPins.values[i] = this.getSingleOutput(execution, connection.node.input[i]);
                    ++i;
                }
                if (connection.node.value == null) {
                    connection.node.value = FunctionsManager.functions.get(connection.node.type);
                }
                return connection.node.value.apply((Pins)inputPins).values[connection.index];
            }
            if (input instanceof Data) {
                return ((Data)input).data;
            }
            return null;
        }
    }
}

