/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.editor.EditorFile;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.CompiledScriptRules;
import com.crashstudios.crashcore.script.CustomEventData;
import com.crashstudios.crashcore.storage.SLAPI;
import java.io.File;
import java.util.UUID;

public class CustomEvent {
    public static CompiledScriptRules scriptRules = new CompiledScriptRules();
    public CustomEventData data;
    private CompiledScript script;

    public CustomEvent(UUID uuid) {
        CustomEvent.scriptRules.listeners.add("leftclickinteraction");
        CustomEvent.scriptRules.listeners.add("rightclickinteraction");
        CustomEvent.scriptRules.listeners.add("damageaction");
        CustomEvent.scriptRules.listeners.add("deathaction");
        CustomEvent.scriptRules.listeners.add("attackedaction");
        CustomEvent.scriptRules.listeners.add("attackaction");
        CustomEvent.scriptRules.listeners.add("joinaction");
        CustomEvent.scriptRules.listeners.add("quitaction");
        CustomEvent.scriptRules.listeners.add("chataction");
        CustomEvent.scriptRules.listeners.add("tickaction");
        CustomEvent.scriptRules.listeners.add("respawnaction");
        CustomEvent.scriptRules.listeners.add("startupaction");
        CustomEvent.scriptRules.listeners.add("moveaction");
        CustomEvent.scriptRules.listeners.add("explodeaction");
        CustomEvent.scriptRules.listeners.add("marker_enterevent");
        CustomEvent.scriptRules.listeners.add("marker_leaveevent");
        CustomEvent.scriptRules.listeners.add("discord_onmessage");
        CustomEvent.scriptRules.listeners.add("discord_onmemberjoin");
        CustomEvent.scriptRules.listeners.add("discord_onmemberleave");
        CustomEvent.scriptRules.listeners.add("discord_onmemberupdate");
        CustomEvent.scriptRules.listeners.add("discord_onreact");
        CustomEvent.scriptRules.listeners.add("discord_oncommand");
        this.data = new CustomEventData();
        this.data.uuid = uuid;
        this.data.name = "New Script File";
        this.data.script = new EditorFile2();
    }

    public CustomEvent(CustomEventData data) {
        CustomEvent.scriptRules.listeners.add("leftclickinteraction");
        CustomEvent.scriptRules.listeners.add("rightclickinteraction");
        CustomEvent.scriptRules.listeners.add("damageaction");
        CustomEvent.scriptRules.listeners.add("deathaction");
        CustomEvent.scriptRules.listeners.add("attackedaction");
        CustomEvent.scriptRules.listeners.add("attackaction");
        CustomEvent.scriptRules.listeners.add("joinaction");
        CustomEvent.scriptRules.listeners.add("quitaction");
        CustomEvent.scriptRules.listeners.add("chataction");
        CustomEvent.scriptRules.listeners.add("tickaction");
        CustomEvent.scriptRules.listeners.add("respawnaction");
        CustomEvent.scriptRules.listeners.add("startupaction");
        CustomEvent.scriptRules.listeners.add("moveaction");
        CustomEvent.scriptRules.listeners.add("explodeaction");
        CustomEvent.scriptRules.listeners.add("marker_enterevent");
        CustomEvent.scriptRules.listeners.add("marker_leaveevent");
        CustomEvent.scriptRules.listeners.add("discord_onmessage");
        CustomEvent.scriptRules.listeners.add("discord_onmemberjoin");
        CustomEvent.scriptRules.listeners.add("discord_onmemberleave");
        CustomEvent.scriptRules.listeners.add("discord_onmemberupdate");
        CustomEvent.scriptRules.listeners.add("discord_onreact");
        CustomEvent.scriptRules.listeners.add("discord_oncommand");
        this.data = data;
        if (!(this.data.script instanceof EditorFile2)) {
            EditorFile oldFile = this.data.script;
            this.data.script = new EditorFile2();
            this.data.script.nodes = oldFile.nodes;
        }
    }

    public CompiledScript getScript() {
        if (this.script == null) {
            this.updateScript();
        }
        return this.script;
    }

    public void updateScript() {
        this.script = new CompiledScript(scriptRules, this.data.script);
    }

    public void save() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "customevents");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            SLAPI.save((Object)this.data, new File(folder, this.data.uuid.toString() + ".dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "customevents");
        try {
            new File(folder, this.data.uuid.toString() + ".dat").delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

