/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.CompiledScriptRules;
import com.crashstudios.crashcore.script.CustomNodeData;
import com.crashstudios.crashcore.storage.SLAPI;
import java.io.File;

public class CustomNode {
    public static CompiledScriptRules scriptRules = new CompiledScriptRules();
    public CustomNodeData data;
    private CompiledScript script;

    public CustomNode(CustomNodeData data) {
        CustomNode.scriptRules.listeners.add("input");
        this.data = data;
        if (!(this.data.script instanceof EditorFile2)) {
            EditorFile2 newFile = new EditorFile2();
            newFile.nodes = this.data.script.nodes;
            this.data.script = newFile;
        }
    }

    public CompiledScript getScript() {
        if (this.script == null) {
            this.updateScript();
        }
        return this.script;
    }

    public void updateScript() {
        this.script = new CompiledScript(scriptRules, this.data.script);
    }

    public void save() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "customnodes");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            SLAPI.save((Object)this.data, new File(folder, this.data.uuid.toString() + ".dat"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        File folder = new File(Main.INSTANCE.getDataFolder(), "customnodes");
        try {
            new File(folder, this.data.uuid.toString() + ".dat").delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

