/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.editor.EditorFile;
import com.crashstudios.crashcore.editor.EditorFile2;
import com.crashstudios.crashcore.editor.EditorNode;
import com.crashstudios.crashcore.folia.CrashScheduler;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.net.InfoPacketListener;
import com.crashstudios.crashcore.net.RequestPacketListener;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.CustomEvent;
import com.crashstudios.crashcore.script.CustomEventData;
import com.crashstudios.crashcore.script.CustomNode;
import com.crashstudios.crashcore.script.CustomNodeData;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.script.interaction.InteractionListener;
import com.crashstudios.crashcore.storage.SLAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;

public class CustomNodes {
    public static HashMap<UUID, CustomNode> nodes = new HashMap();
    public static HashMap<UUID, CustomEvent> customevent = new HashMap();
    public static NamespacedKey CUSTOMEVENTKEY = new NamespacedKey((Plugin)Main.INSTANCE, "customlisteners");

    public static void load() {
        Serializable data;
        File file;
        File folder = new File(Main.INSTANCE.getDataFolder(), "customnodes");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            try {
                data = (CustomNodeData)SLAPI.load(file);
                nodes.put(data.uuid, new CustomNode((CustomNodeData)data));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        folder = new File(Main.INSTANCE.getDataFolder(), "customevents");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        fileArray = folder.listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            try {
                data = (CustomEventData)SLAPI.load(file);
                customevent.put(((CustomEventData)data).uuid, new CustomEvent((CustomEventData)data));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        ConnectionClientHandler.requestPacketListeners.put("customnodeslist", new RequestPacketListener("customnodeslist"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                JsonObject json = new JsonObject();
                json.addProperty("page", (Number)1);
                json.addProperty("maxpage", (Number)1);
                json.addProperty("sessionid", (Number)data.get("sessionid").getAsInt());
                JsonArray elements = new JsonArray();
                ArrayList<CustomNode> list = new ArrayList<CustomNode>(nodes.values());
                list.sort((a, b) -> a.data.name.compareTo(b.data.name));
                for (CustomNode item : list) {
                    JsonObject element = new JsonObject();
                    element.addProperty("name", item.data.name);
                    element.addProperty("id", item.data.uuid.toString());
                    element.addProperty("createdon", (Number)item.data.createdOn);
                    element.addProperty("createdby", item.data.createdBy.toString());
                    element.addProperty("modifiedon", (Number)item.data.modifiedOn);
                    element.addProperty("modifiedby", item.data.modifiedBy.toString());
                    StringBuilder inputs = new StringBuilder();
                    int i = 0;
                    int l = 0;
                    while (l < item.data.inputs.length) {
                        inputs.append(item.data.labels[i]);
                        inputs.append(" (");
                        inputs.append(item.data.inputs[l]);
                        inputs.append(")");
                        if (l != item.data.inputs.length - 1) {
                            inputs.append(", ");
                        }
                        ++i;
                        ++l;
                    }
                    element.addProperty("inputs", inputs.toString());
                    StringBuilder outputs = new StringBuilder();
                    int l2 = 0;
                    while (l2 < item.data.outputs.length) {
                        outputs.append(item.data.labels[i]);
                        outputs.append(" (");
                        outputs.append(item.data.outputs[l2]);
                        outputs.append(")");
                        if (l2 != item.data.outputs.length - 1) {
                            outputs.append(", ");
                        }
                        ++i;
                        ++l2;
                    }
                    element.addProperty("outputs", outputs.toString());
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                ConnectionClientHandler.sendInfoPacket("customnodeslist", json);
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("customnodeslist", new InfoPacketListener("customnodeslist"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                String type = data.get("type").getAsString();
                if (type.equals("delete")) {
                    UUID uuid;
                    String id = data.get("delete").getAsString();
                    try {
                        uuid = UUID.fromString(id);
                    }
                    catch (IllegalArgumentException e) {
                        return;
                    }
                    CustomNode node = nodes.remove(uuid);
                    if (node != null) {
                        node.remove();
                    }
                } else if (type.equals("add")) {
                    JsonObject obj;
                    String name = data.get("name").getAsString();
                    JsonArray inputsArray = data.get("inputs").getAsJsonArray();
                    CustomNodeData node = new CustomNodeData();
                    node.name = name;
                    node.inputs = new String[inputsArray.size()];
                    JsonArray outputsArray = data.get("outputs").getAsJsonArray();
                    node.outputs = new String[outputsArray.size()];
                    node.labels = new String[node.inputs.length + node.outputs.length];
                    int l = 0;
                    int i = 0;
                    while (i < node.inputs.length) {
                        obj = inputsArray.get(i).getAsJsonObject();
                        node.inputs[i] = obj.get("type").getAsString();
                        node.labels[l] = obj.get("label").getAsString();
                        ++l;
                        ++i;
                    }
                    i = 0;
                    while (i < node.outputs.length) {
                        obj = outputsArray.get(i).getAsJsonObject();
                        node.outputs[i] = obj.get("type").getAsString();
                        node.labels[l] = obj.get("label").getAsString();
                        ++l;
                        ++i;
                    }
                    node.createdOn = Instant.now().getEpochSecond();
                    node.modifiedOn = Instant.now().getEpochSecond();
                    node.modifiedBy = node.createdBy = UUID.fromString(data.get("user").getAsString());
                    node.script = new EditorFile();
                    EditorNode inputNode = new EditorNode();
                    inputNode.x = 0.0f;
                    inputNode.y = 0.0f;
                    inputNode.type = "input";
                    inputNode.execOutput = new int[0];
                    inputNode.inputs = new EditorNode.Input[0];
                    inputNode.id = 0;
                    node.script.nodes.put(0, inputNode);
                    node.uuid = UUID.randomUUID();
                    CustomNode n = new CustomNode(node);
                    n.save();
                    nodes.put(node.uuid, n);
                }
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("editorcustomnodes", new RequestPacketListener("editorcustomnodes"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid;
                String key = packet.get("info").getAsJsonObject().get("id").getAsString();
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                CustomNode file = nodes.get(uuid);
                if (file != null) {
                    JsonObject json = file.data.script.serialize();
                    json.addProperty("key", key);
                    json.addProperty("filename", file.data.name);
                    json.addProperty("infoid", file.data.uuid.toString());
                    JsonObject moduleinfos = new JsonObject();
                    JsonObject input = new JsonObject();
                    input.addProperty("title", "Input");
                    input.addProperty("header", "#1A5B2B");
                    input.addProperty("hasExecInput", (Number)0);
                    input.addProperty("hasExecOutput", (Number)1);
                    JsonArray labels = new JsonArray();
                    JsonArray types = new JsonArray();
                    int i = 0;
                    while (i < file.data.inputs.length) {
                        labels.add(file.data.labels[i]);
                        types.add(file.data.inputs[i].replace("intinput", "number").replace("strinput", "string"));
                        ++i;
                    }
                    input.add("labels", (JsonElement)labels);
                    input.add("inputsType", (JsonElement)new JsonArray());
                    input.add("outputsType", (JsonElement)types);
                    moduleinfos.add("input", (JsonElement)input);
                    JsonObject output = new JsonObject();
                    output.addProperty("title", "Output");
                    output.addProperty("header", "#1A5B2B");
                    output.addProperty("hasExecInput", (Number)1);
                    output.addProperty("hasExecOutput", (Number)0);
                    JsonArray labels2 = new JsonArray();
                    JsonArray types2 = new JsonArray();
                    int i2 = 0;
                    while (i2 < file.data.outputs.length) {
                        labels2.add(file.data.labels[file.data.inputs.length + i2]);
                        types2.add(file.data.outputs[i2]);
                        ++i2;
                    }
                    output.add("labels", (JsonElement)labels2);
                    output.add("inputsType", (JsonElement)types2);
                    output.add("outputsType", (JsonElement)new JsonArray());
                    moduleinfos.add("output", (JsonElement)output);
                    json.add("moduleinfos", (JsonElement)moduleinfos);
                    JsonObject menuinfos = new JsonObject();
                    JsonObject category = new JsonObject();
                    JsonObject output2 = new JsonObject();
                    output2.addProperty("desc", "Indicates the end of the custom node. If it is not called, the custom node will not call any node after it. If it is called more than once, the custom node will call many times the nodes after it.");
                    output2.add("input", (JsonElement)labels2);
                    output2.add("output", (JsonElement)new JsonArray());
                    category.add("output", (JsonElement)output2);
                    menuinfos.add("Custom Module", (JsonElement)category);
                    json.add("menuinfos", (JsonElement)menuinfos);
                    CustomNodes.addCustomNodes(json);
                    ConnectionClientHandler.sendInfoPacket("editorcustomnodes", json);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("editorcustomnodes", new InfoPacketListener("editorcustomnodes"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid;
                JsonObject data = packet.get("info").getAsJsonObject();
                String key = data.get("id").getAsString();
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                CustomNode file = nodes.get(uuid);
                if (file != null) {
                    file.data.modifiedBy = UUID.fromString(data.get("uuid").getAsString());
                    file.data.modifiedOn = Instant.now().getEpochSecond();
                    file.data.script = EditorFile2.deserialize(data);
                    file.updateScript();
                    file.save();
                    EditorFile2.sendSavedSuccess("editorcustomnodes", key);
                }
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("customeventslist", new RequestPacketListener("customeventslist"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                JsonObject json = new JsonObject();
                json.addProperty("page", (Number)1);
                json.addProperty("maxpage", (Number)1);
                json.addProperty("sessionid", (Number)data.get("sessionid").getAsInt());
                JsonArray elements = new JsonArray();
                for (CustomEvent item : customevent.values()) {
                    JsonObject element = new JsonObject();
                    element.addProperty("name", item.data.name);
                    element.addProperty("id", item.data.uuid.toString());
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                ConnectionClientHandler.sendInfoPacket("customeventslist", json);
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("customeventslist", new InfoPacketListener("customeventslist"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                JsonObject data = packet.get("info").getAsJsonObject();
                if (data.has("create")) {
                    CustomEvent customEvent = new CustomEvent(UUID.randomUUID());
                    customEvent.save();
                    customevent.put(customEvent.data.uuid, customEvent);
                } else {
                    CustomEvent item;
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(data.get("id").getAsString());
                    }
                    catch (IllegalArgumentException e) {
                        return;
                    }
                    if (data.has("name")) {
                        item = customevent.get(uuid);
                        if (item != null) {
                            String name;
                            item.data.name = name = data.get("name").getAsString();
                            item.save();
                        }
                    } else if (data.has("delete") && (item = customevent.remove(uuid)) != null) {
                        item.remove();
                    }
                }
                JsonObject json = new JsonObject();
                json.addProperty("page", (Number)1);
                json.addProperty("maxpage", (Number)1);
                json.addProperty("sessionid", (Number)data.get("sessionid").getAsInt());
                JsonArray elements = new JsonArray();
                for (CustomEvent item : customevent.values()) {
                    JsonObject element = new JsonObject();
                    element.addProperty("name", item.data.name);
                    element.addProperty("id", item.data.uuid.toString());
                    elements.add((JsonElement)element);
                }
                json.add("elements", (JsonElement)elements);
                ConnectionClientHandler.sendInfoPacket("customeventslist", json);
            }
        });
        ConnectionClientHandler.requestPacketListeners.put("editorcustomevents", new RequestPacketListener("editorcustomevents"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid;
                String key = packet.get("info").getAsJsonObject().get("id").getAsString();
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                CustomEvent file = customevent.get(uuid);
                if (file != null) {
                    JsonObject json = file.data.script.serialize();
                    json.addProperty("key", key);
                    json.addProperty("filename", file.data.name);
                    json.addProperty("infoid", file.data.uuid.toString());
                    CustomNodes.addCustomNodes(json);
                    ConnectionClientHandler.sendInfoPacket("editorcustomevents", json);
                }
            }
        });
        ConnectionClientHandler.infoPacketListeners.put("editorcustomevents", new InfoPacketListener("editorcustomevents"){

            @Override
            public void onPacket(ChannelHandlerContext ctx, JsonObject packet) {
                UUID uuid;
                JsonObject data = packet.get("info").getAsJsonObject();
                String key = data.get("id").getAsString();
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                CustomEvent file = customevent.get(uuid);
                if (file != null) {
                    file.data.script = EditorFile2.deserialize(data);
                    file.updateScript();
                    file.save();
                    EditorFile2.sendSavedSuccess("editorcustomevents", key);
                }
            }
        });
        CrashScheduler.runTaskTimer((Plugin)Main.INSTANCE, new Runnable(){
            int timer = 0;

            @Override
            public void run() {
                for (CustomEvent file : customevent.values()) {
                    for (CompiledScript.Node node : file.getScript().startingNodes) {
                        int ticks;
                        if (!node.type.equals("tickaction") || (ticks = Double.valueOf(((CompiledScript.Data)node.input[0]).data).intValue()) != 0 && this.timer % ticks != 0) continue;
                        node.start(new HashMap<CompiledScript.Node, Pins>(), new Object[0]);
                    }
                }
                ++this.timer;
            }
        }, 40L, 1L);
        CrashScheduler.runTaskLater((Plugin)Main.INSTANCE, () -> InteractionListener.callEvent(new Object[0], "startupaction"), 5L);
    }

    public static void addCustomNodes(JsonObject json) {
        JsonObject moduleinfos = new JsonObject();
        JsonObject menuinfos = new JsonObject();
        JsonObject category = new JsonObject();
        if (json.has("moduleinfos")) {
            moduleinfos = json.get("moduleinfos").getAsJsonObject();
        }
        if (json.has("menuinfos")) {
            menuinfos = json.get("menuinfos").getAsJsonObject();
        }
        for (CustomNode node : nodes.values()) {
            JsonObject module = new JsonObject();
            module.addProperty("title", node.data.name);
            module.addProperty("header", "#1A5B2B");
            module.addProperty("hasExecInput", (Number)1);
            module.addProperty("hasExecOutput", (Number)1);
            JsonArray labels = new JsonArray();
            JsonArray inputs = new JsonArray();
            JsonArray outputs = new JsonArray();
            int i = 0;
            while (i < node.data.inputs.length) {
                inputs.add(node.data.inputs[i]);
                ++i;
            }
            i = 0;
            while (i < node.data.outputs.length) {
                outputs.add(node.data.outputs[i]);
                ++i;
            }
            i = 0;
            while (i < node.data.labels.length) {
                labels.add(node.data.labels[i]);
                ++i;
            }
            module.add("labels", (JsonElement)labels);
            module.add("inputsType", (JsonElement)inputs);
            module.add("outputsType", (JsonElement)outputs);
            moduleinfos.add(node.data.uuid.toString(), (JsonElement)module);
            JsonObject menu = new JsonObject();
            menu.addProperty("desc", "Custom Node");
            JsonArray inputs2 = new JsonArray();
            JsonArray outputs2 = new JsonArray();
            int i2 = 0;
            while (i2 < node.data.inputs.length) {
                inputs2.add(node.data.labels[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < node.data.outputs.length) {
                outputs2.add(node.data.labels[node.data.inputs.length + i2]);
                ++i2;
            }
            menu.add("input", (JsonElement)inputs2);
            menu.add("output", (JsonElement)outputs2);
            category.add(node.data.uuid.toString(), (JsonElement)menu);
        }
        if (category.size() > 0) {
            menuinfos.add("Custom Modules", (JsonElement)category);
        }
        json.add("moduleinfos", (JsonElement)moduleinfos);
        json.add("menuinfos", (JsonElement)menuinfos);
    }
}

