/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.config.ConfigFile;
import com.crashstudios.crashcore.config.ConfigInstance;
import com.crashstudios.crashcore.config.CustomConfigManager;
import com.crashstudios.crashcore.config.CustomConfigUtils;
import com.crashstudios.crashcore.discord.DiscordBotManager;
import com.crashstudios.crashcore.discord.ScriptChannelData;
import com.crashstudios.crashcore.discord.ScriptCommandData;
import com.crashstudios.crashcore.discord.ScriptMemberData;
import com.crashstudios.crashcore.folia.CrashScheduler;
import com.crashstudios.crashcore.model.CustomModel;
import com.crashstudios.crashcore.model.ModelEditor;
import com.crashstudios.crashcore.model.ModelEntity;
import com.crashstudios.crashcore.net.ConnectionClientHandler;
import com.crashstudios.crashcore.particles.CustomParticle;
import com.crashstudios.crashcore.particles.ParticleEditor;
import com.crashstudios.crashcore.particles.ParticleEmitter;
import com.crashstudios.crashcore.particles.ParticleEngine;
import com.crashstudios.crashcore.particles.ParticleInstance;
import com.crashstudios.crashcore.script.BlockVolume;
import com.crashstudios.crashcore.script.CompiledScript;
import com.crashstudios.crashcore.script.CustomNodes;
import com.crashstudios.crashcore.script.FunctionPayload;
import com.crashstudios.crashcore.script.Pins;
import com.crashstudios.crashcore.script.Vector;
import com.crashstudios.crashcore.script.miscellaneous.ParticleUtils;
import com.crashstudios.crashcore.script.miscellaneous.TagManager;
import com.crashstudios.crashcore.script.player.PlayerListener;
import com.crashstudios.crashcore.storage.SItemStack;
import com.crashstudios.crashcore.storage.SLAPI;
import com.crashstudios.crashcore.storage.SerializationManager;
import com.crashstudios.crashcore.utilities.ColorUtils;
import com.crashstudios.crashcore.utilities.DisplayUtils;
import com.crashstudios.crashcore.utilities.HexUtils;
import com.crashstudios.crashcore.utilities.ItemStackBuilder;
import com.crashstudios.crashcore.utilities.MathUtil;
import com.crashstudios.crashcore.utilities.RandomStringUtils;
import com.crashstudios.crashcore.utilities.SkullUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Rotation;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Cancellable;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.consumable.ConsumableComponent;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class FunctionsManager {
    public static HashMap<String, Function<Pins, Pins>> functions = new HashMap();
    public static HashMap<String, Object> serverData = new HashMap();
    public static HashSet<Player> playerBreaker = new HashSet();
    public static HashSet<Block> brokenBlocks = new HashSet();
    public static HashMap<String, Consumer<FunctionPayload>> specialFunctions = new HashMap();
    private static Attribute generic_max_health = null;
    public static HashMap<ItemStack, CrashScheduler.CancelHandle> cooldownTasks = new HashMap();

    public static void addFunction(String id, Function<Pins, Pins> func) {
        functions.put(id, func);
    }

    public static void loadBase() {
        functions.put("cancelevent", pins -> {
            Cancellable event = (Cancellable)pins.values[0];
            event.setCancelled(true);
            return new Pins(new Object[0]);
        });
        functions.put("else", pins -> new Pins(new Object[0]));
        functions.put("entitypos", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Location loc = entity.getLocation();
            return new Pins(new Vector(loc.getX(), loc.getY(), loc.getZ()));
        });
        functions.put("entityeyepos", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                Location loc = ((LivingEntity)entity).getEyeLocation();
                return new Pins(new Vector(loc.getX(), loc.getY(), loc.getZ()));
            }
            return new Pins(new Vector(0.0f, 0.0f, 0.0f));
        });
        functions.put("entitydir", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            org.bukkit.util.Vector loc = entity.getLocation().getDirection();
            return new Pins(new Vector(loc.getX(), loc.getY(), loc.getZ()));
        });
        functions.put("entityhealth", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return new Pins(living.getHealth());
            }
            return new Pins(0.0);
        });
        try {
            generic_max_health = Main.utils.getAttribute("generic_max_health");
        }
        catch (Exception exception) {
            // empty catch block
        }
        functions.put("entitymaxhealth", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return new Pins(living.getAttribute(generic_max_health).getValue());
            }
            return new Pins(0.0);
        });
        functions.put("entityvelocity", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            org.bukkit.util.Vector loc = entity.getVelocity();
            return new Pins(new Vector(loc.getX(), loc.getY(), loc.getZ()));
        });
        functions.put("entityproperty", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String name = (String)pins.values[1];
            if (!name.isEmpty() && (container = entity.getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name), PersistentDataType.DOUBLE)) {
                return new Pins(container.get(key, PersistentDataType.DOUBLE));
            }
            return new Pins(0.0);
        });
        functions.put("setentityproperty", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String name = (String)pins.values[1];
            Double value = (Double)pins.values[2];
            if (!name.isEmpty()) {
                PersistentDataContainer container = entity.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name);
                if (value == 0.0) {
                    container.remove(key);
                } else {
                    container.set(key, PersistentDataType.DOUBLE, (Object)value);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("entitypropertystr", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String name = (String)pins.values[1];
            if (!name.isEmpty() && (container = entity.getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name), PersistentDataType.STRING)) {
                return new Pins(container.get(key, PersistentDataType.STRING));
            }
            return new Pins("");
        });
        functions.put("setentitypropertystr", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String name = (String)pins.values[1];
            String value = (String)pins.values[2];
            if (!name.isEmpty()) {
                PersistentDataContainer container = entity.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name);
                if (value.isEmpty()) {
                    container.remove(key);
                } else {
                    container.set(key, PersistentDataType.STRING, (Object)value);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("entityworld", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.getWorld());
        });
        functions.put("entitytype", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity.getType() != null) {
                return new Pins(entity.getType().toString().toLowerCase());
            }
            return new Pins("undefined");
        });
        functions.put("dimteleport", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Vector dest = (Vector)pins.values[1];
            World world = (World)pins.values[2];
            CrashScheduler.teleport(entity, new Location(world, (double)dest.values[0], (double)dest.values[1], (double)dest.values[2], entity.getLocation().getYaw(), entity.getLocation().getPitch()));
            return new Pins(new Object[0]);
        });
        functions.put("teleport", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Vector dest = (Vector)pins.values[1];
            CrashScheduler.teleport(entity, new Location(entity.getWorld(), (double)dest.values[0], (double)dest.values[1], (double)dest.values[2], entity.getLocation().getYaw(), entity.getLocation().getPitch()));
            return new Pins(new Object[0]);
        });
        functions.put("push", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            float[] direction = ((Vector)pins.values[1]).values;
            entity.setVelocity(entity.getVelocity().clone().add(new org.bukkit.util.Vector(direction[0], direction[1], direction[2])));
            return new Pins(new Object[0]);
        });
        functions.put("setvelocity", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            float[] direction = ((Vector)pins.values[1]).values;
            entity.setVelocity(new org.bukkit.util.Vector(direction[0], direction[1], direction[2]));
            return new Pins(new Object[0]);
        });
        functions.put("setdirection", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            float[] direction = ((Vector)pins.values[1]).values;
            if (entity instanceof Fireball) {
                ((Fireball)entity).setDirection(new org.bukkit.util.Vector(direction[0], direction[1], direction[2]));
            } else {
                Location loc = entity.getLocation();
                loc.setDirection(new org.bukkit.util.Vector(direction[0], direction[1], direction[2]));
                CrashScheduler.teleport(entity, loc);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setrotation", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            float yaw = ((Double)pins.values[1]).floatValue();
            float pitch = ((Double)pins.values[2]).floatValue();
            if (entity.getType() == EntityType.PLAYER) {
                Location loc = entity.getLocation();
                loc.setYaw(yaw);
                loc.setPitch(pitch);
                CrashScheduler.teleport(entity, loc);
            } else {
                entity.setRotation(yaw, pitch);
            }
            return new Pins(new Object[0]);
        });
        functions.put("damage", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double value = (Double)pins.values[1];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.damage(value.doubleValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("sethealth", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double value = (Double)pins.values[1];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.setHealth(value.doubleValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("raytraceblock", pins -> {
            Block block;
            LivingEntity living;
            RayTraceResult result;
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double maxDistance = (Double)pins.values[1];
            if (entity instanceof LivingEntity && (result = (living = (LivingEntity)entity).rayTraceBlocks(maxDistance.doubleValue())) != null && (block = result.getHitBlock()) != null) {
                BlockFace face = result.getHitBlockFace();
                Vector faceVect = new Vector(face.getModX(), face.getModY(), face.getModZ());
                return new Pins(block, faceVect, true);
            }
            return new Pins(entity.getLocation().getBlock(), new Vector(0.0f, 0.0f, 0.0f), false);
        });
        functions.put("raytraceentity", pins -> {
            org.bukkit.entity.Entity ent2;
            LivingEntity living;
            RayTraceResult result;
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double maxDistance = (Double)pins.values[1];
            if (entity instanceof LivingEntity && (result = (living = (LivingEntity)entity).getWorld().rayTraceEntities(living.getEyeLocation(), living.getEyeLocation().getDirection(), maxDistance.doubleValue(), ent -> ent != entity)) != null && (ent2 = result.getHitEntity()) != null) {
                return new Pins(ent2, true);
            }
            return new Pins(entity, false);
        });
        functions.put("raytracevect", pins -> {
            org.bukkit.util.Vector loc;
            LivingEntity living;
            RayTraceResult result;
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double maxDistance = (Double)pins.values[1];
            if (entity instanceof LivingEntity && (result = (living = (LivingEntity)entity).getWorld().rayTrace(living.getEyeLocation(), living.getEyeLocation().getDirection(), maxDistance.doubleValue(), FluidCollisionMode.ALWAYS, false, 0.1, ent -> ent != entity)) != null && (loc = result.getHitPosition()) != null) {
                return new Pins(new Vector(loc.getX(), loc.getY(), loc.getZ()), true);
            }
            return new Pins(new Vector(0.0f, 0.0f, 0.0f), false);
        });
        functions.put("removeentity", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (!(entity instanceof Player)) {
                entity.remove();
            }
            return new Pins(new Object[0]);
        });
        functions.put("setinvisible", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.setInvisible(value.booleanValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("setai", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.setAI(value.booleanValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("entityai", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return new Pins(living.hasAI());
            }
            return new Pins(Boolean.FALSE);
        });
        functions.put("setgravity", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            entity.setGravity(value.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("entitygravity", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.hasGravity());
        });
        functions.put("entityuuid", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.getUniqueId().toString());
        });
        functions.put("getentity", pins -> {
            UUID uuid;
            String str = (String)pins.values[0];
            try {
                uuid = UUID.fromString(str);
            }
            catch (IllegalArgumentException e) {
                return new Pins(Boolean.FALSE, null);
            }
            org.bukkit.entity.Entity ent = Bukkit.getEntity((UUID)uuid);
            if (ent == null) {
                return new Pins(Boolean.FALSE, null);
            }
            return new Pins(Boolean.TRUE, ent);
        });
        functions.put("attachlistenerentity", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            String str = (String)pins.values[1];
            Object data = "";
            PersistentDataContainer cont = ent.getPersistentDataContainer();
            if (cont.has(CustomNodes.CUSTOMEVENTKEY, PersistentDataType.STRING)) {
                data = (String)cont.get(CustomNodes.CUSTOMEVENTKEY, PersistentDataType.STRING);
                if (!((String)data).contains("\ue315" + str + "\ue315")) {
                    data = (String)data + "\ue315" + str + "\ue315";
                }
            } else {
                data = "\ue315" + str + "\ue315";
            }
            cont.set(CustomNodes.CUSTOMEVENTKEY, PersistentDataType.STRING, data);
            return new Pins(new Object[0]);
        });
        functions.put("detachlistenerentity", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            String str = (String)pins.values[1];
            String data = "";
            PersistentDataContainer cont = ent.getPersistentDataContainer();
            if (cont.has(CustomNodes.CUSTOMEVENTKEY, PersistentDataType.STRING)) {
                data = (String)cont.get(CustomNodes.CUSTOMEVENTKEY, PersistentDataType.STRING);
                if ((data = data.replace("\ue315" + str + "\ue315", "")).isEmpty()) {
                    cont.remove(CustomNodes.CUSTOMEVENTKEY);
                } else {
                    cont.set(CustomNodes.CUSTOMEVENTKEY, PersistentDataType.STRING, (Object)data);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("getentities", pins -> {
            World world = (World)pins.values[0];
            float[] v1 = ((Vector)pins.values[1]).values;
            float[] v2 = ((Vector)pins.values[2]).values;
            ArrayList<String> list = new ArrayList<String>();
            for (org.bukkit.entity.Entity ent : world.getNearbyEntities(new Location(world, (double)v1[0], (double)v1[1], (double)v1[2]), (double)v2[0], (double)v2[1], (double)v2[2])) {
                list.add(ent.getUniqueId().toString());
            }
            return new Pins(list);
        });
        functions.put("settarget", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            org.bukkit.entity.Entity target = (org.bukkit.entity.Entity)pins.values[1];
            if (entity instanceof Mob && target instanceof LivingEntity) {
                ((Mob)entity).setTarget((LivingEntity)target);
            }
            return new Pins(new Object[0]);
        });
        functions.put("cleartarget", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof Mob) {
                ((Mob)entity).setTarget(null);
            }
            return new Pins(new Object[0]);
        });
        functions.put("entitytarget", pins -> {
            LivingEntity target;
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof Mob && (target = ((Mob)entity).getTarget()) != null) {
                return new Pins(Boolean.TRUE, target);
            }
            return new Pins(Boolean.FALSE, entity);
        });
        functions.put("setdisplayname", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String name = (String)pins.values[1];
            entity.setCustomName(ColorUtils.color(name));
            entity.setCustomNameVisible(true);
            return new Pins(new Object[0]);
        });
        functions.put("setage", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double age = (Double)pins.values[1];
            if (entity instanceof Ageable) {
                ((Ageable)entity).setAge(age.intValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("entityage", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof Ageable) {
                return new Pins(((Ageable)entity).getAge());
            }
            return new Pins(0.0);
        });
        functions.put("addpassenger", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            org.bukkit.entity.Entity passenger = (org.bukkit.entity.Entity)pins.values[1];
            entity.addPassenger(passenger);
            return new Pins(new Object[0]);
        });
        functions.put("removepassenger", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            org.bukkit.entity.Entity passenger = (org.bukkit.entity.Entity)pins.values[1];
            entity.removePassenger(passenger);
            return new Pins(new Object[0]);
        });
        functions.put("entitypassengers", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            ArrayList<String> list = new ArrayList<String>();
            for (org.bukkit.entity.Entity e : entity.getPassengers()) {
                list.add(e.getUniqueId().toString());
            }
            return new Pins(list);
        });
        functions.put("setsilent", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean silent = (Boolean)pins.values[1];
            entity.setSilent(silent.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("entitysilent", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.isSilent());
        });
        functions.put("setinvulnerable", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean invulnerable = (Boolean)pins.values[1];
            entity.setInvulnerable(invulnerable.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("entityinvulnerable", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.isInvulnerable());
        });
        functions.put("setpersistent", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean persistent = (Boolean)pins.values[1];
            entity.setPersistent(persistent.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("entitypersistent", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.isPersistent());
        });
        functions.put("setfireticks", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double ticks = (Double)pins.values[1];
            entity.setFireTicks(ticks.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("entityfireticks", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.getFireTicks());
        });
        functions.put("setfreezeticks", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double ticks = (Double)pins.values[1];
            entity.setFreezeTicks(ticks.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("entityfreezeticks", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.getFreezeTicks());
        });
        functions.put("entitydead", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.isDead());
        });
        functions.put("entityonground", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.isOnGround());
        });
        functions.put("entityinwater", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.isInWater());
        });
        functions.put("setglowing", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean glowing = (Boolean)pins.values[1];
            entity.setGlowing(glowing.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("entityglowing", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            return new Pins(entity.isGlowing());
        });
        functions.put("setremainingair", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Double ticks = (Double)pins.values[1];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setRemainingAir(ticks.intValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("entityremainingair", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return new Pins(livingEntity.getRemainingAir());
            }
            return new Pins(0.0);
        });
        functions.put("setcanpickupitems", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean canPickup = (Boolean)pins.values[1];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setCanPickupItems(canPickup.booleanValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("entitycanpickupitems", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return new Pins(livingEntity.getCanPickupItems());
            }
            return new Pins(Boolean.FALSE);
        });
        functions.put("entitysleeping", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return new Pins(livingEntity.isSleeping());
            }
            return new Pins(Boolean.FALSE);
        });
        functions.put("entityclimbing", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return new Pins(livingEntity.isClimbing());
            }
            return new Pins(Boolean.FALSE);
        });
        functions.put("setswimming", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean swimming = (Boolean)pins.values[1];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setSwimming(swimming.booleanValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("entityswimming", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return new Pins(livingEntity.isSwimming());
            }
            return new Pins(Boolean.FALSE);
        });
        functions.put("swingmainhand", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.swingMainHand();
            }
            return new Pins(new Object[0]);
        });
        functions.put("swingoffhand", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.swingOffHand();
            }
            return new Pins(new Object[0]);
        });
        functions.put("setgliding", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            Boolean gliding = (Boolean)pins.values[1];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setGliding(gliding.booleanValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("entitygliding", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return new Pins(livingEntity.isGliding());
            }
            return new Pins(Boolean.FALSE);
        });
        functions.put("entitycooldown", pins -> {
            NamespacedKey key;
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            int cooldown = (int)((Double)pins.values[1] * 1000.0);
            String id = (String)pins.values[2];
            PersistentDataContainer container = entity.getPersistentDataContainer();
            if (container.has(key = new NamespacedKey((Plugin)Main.INSTANCE, "entcldwn" + id), PersistentDataType.LONG)) {
                long last = (Long)container.get(key, PersistentDataType.LONG);
                if (System.currentTimeMillis() - last < (long)cooldown) {
                    return null;
                }
            }
            container.set(key, PersistentDataType.LONG, (Object)System.currentTimeMillis());
            return new Pins(new Object[0]);
        });
        functions.put("entitycooldown2", pins -> {
            NamespacedKey key;
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            int cooldown = (int)((Double)pins.values[1] * 1000.0);
            String id = (String)pins.values[2];
            PersistentDataContainer container = entity.getPersistentDataContainer();
            if (container.has(key = new NamespacedKey((Plugin)Main.INSTANCE, "entcldwn" + id), PersistentDataType.LONG)) {
                long last = (Long)container.get(key, PersistentDataType.LONG);
                if (System.currentTimeMillis() - last < (long)cooldown) {
                    return new Pins(Boolean.FALSE);
                }
            }
            container.set(key, PersistentDataType.LONG, (Object)System.currentTimeMillis());
            return new Pins(Boolean.TRUE);
        });
        functions.put("resetentitycooldown", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String id = (String)pins.values[1];
            PersistentDataContainer container = entity.getPersistentDataContainer();
            NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "entcldwn" + id);
            container.remove(key);
            return new Pins(new Object[0]);
        });
        functions.put("setentityattribute", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String attr = (String)pins.values[1];
            Double value = (Double)pins.values[2];
            if (entity instanceof Attributable) {
                Attributable living = (Attributable)entity;
                Attribute attribute = Main.utils.getAttribute(attr);
                if (attribute == null) {
                    return new Pins(new Object[0]);
                }
                AttributeInstance instance = living.getAttribute(attribute);
                if (instance == null) {
                    return new Pins(new Object[0]);
                }
                instance.setBaseValue(value.doubleValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("getentityattribute", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String attr = (String)pins.values[1];
            if (entity instanceof Attributable) {
                Attributable living = (Attributable)entity;
                Attribute attribute = Main.utils.getAttribute(attr);
                if (attribute == null) {
                    return new Pins(0.0);
                }
                AttributeInstance instance = living.getAttribute(attribute);
                if (instance == null) {
                    return new Pins(0.0);
                }
                return new Pins(instance.getValue());
            }
            return new Pins(0.0);
        });
        functions.put("playerlevel", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getLevel());
        });
        functions.put("playertotalxp", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getTotalExperience());
        });
        functions.put("playerexpbar", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getExp());
        });
        functions.put("setplayerlevel", pins -> {
            Player player = (Player)pins.values[0];
            Double value = (Double)pins.values[1];
            player.setLevel(value.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("setplayertotalxp", pins -> {
            Player player = (Player)pins.values[0];
            Double value = (Double)pins.values[1];
            player.setTotalExperience(value.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("setplayerexpbar", pins -> {
            Player player = (Player)pins.values[0];
            Double value = (Double)pins.values[1];
            player.setExp((float)value.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("playerfood", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getFoodLevel());
        });
        functions.put("playersaturation", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getSaturation());
        });
        functions.put("playername", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getName());
        });
        functions.put("entityplayer", pins -> new Pins(pins.values[0]));
        functions.put("playerentity", pins -> new Pins(pins.values[0]));
        functions.put("haspermission", pins -> {
            Player player = (Player)pins.values[0];
            String perm = (String)pins.values[1];
            return new Pins(player.hasPermission(perm));
        });
        functions.put("setpermission", pins -> {
            Player player = (Player)pins.values[0];
            String perm = (String)pins.values[1];
            Boolean value = (Boolean)pins.values[2];
            player.addAttachment((Plugin)Main.INSTANCE, perm, value.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("unsetpermission", pins -> {
            Player player = (Player)pins.values[0];
            String perm = (String)pins.values[1];
            player.getEffectivePermissions().forEach(permAttach -> {
                PermissionAttachment attachment = permAttach.getAttachment();
                if (attachment != null && attachment.getPlugin() == Main.INSTANCE && permAttach.getPermission().equals(perm)) {
                    attachment.unsetPermission(perm);
                }
            });
            return new Pins(new Object[0]);
        });
        functions.put("isop", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.isOp());
        });
        functions.put("setop", pins -> {
            Player player = (Player)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            player.setOp(value.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("isshifting", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.isSneaking());
        });
        functions.put("getplayerinventory", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getInventory());
        });
        functions.put("getequipment", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityEquipment equipment = living.getEquipment();
                return new Pins(equipment.getItemInMainHand(), equipment.getItemInOffHand(), equipment.getHelmet(), equipment.getChestplate(), equipment.getLeggings(), equipment.getBoots());
            }
            ItemStack air = ItemStackBuilder.Builder(Material.AIR).build();
            return new Pins(air, air, air, air, air, air);
        });
        functions.put("setequipmentmainhand", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack item = (ItemStack)pins.values[1];
                living.getEquipment().setItemInMainHand(item);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setequipmentoffhand", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack item = (ItemStack)pins.values[1];
                living.getEquipment().setItemInOffHand(item);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setequipmenthelmet", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack item = (ItemStack)pins.values[1];
                living.getEquipment().setHelmet(item);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setequipmentchestplate", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack item = (ItemStack)pins.values[1];
                living.getEquipment().setChestplate(item);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setequipmentleggings", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack item = (ItemStack)pins.values[1];
                living.getEquipment().setLeggings(item);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setequipmentboots", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack item = (ItemStack)pins.values[1];
                living.getEquipment().setBoots(item);
            }
            return new Pins(new Object[0]);
        });
        functions.put("getopeninventory", pins -> {
            Player player = (Player)pins.values[0];
            Inventory inv = player.getOpenInventory().getTopInventory();
            if (inv == null) {
                inv = Bukkit.createInventory(null, (int)9);
            }
            return new Pins(inv);
        });
        functions.put("setfood", pins -> {
            Player player = (Player)pins.values[0];
            Double value = (Double)pins.values[1];
            player.setFoodLevel(value.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("setsaturation", pins -> {
            Player player = (Player)pins.values[0];
            Double value = (Double)pins.values[1];
            player.setSaturation(value.floatValue());
            return new Pins(new Object[0]);
        });
        functions.put("actionbar", pins -> {
            Player player = (Player)pins.values[0];
            String value = (String)pins.values[1];
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ColorUtils.color(value)));
            return new Pins(new Object[0]);
        });
        functions.put("sendmessage", pins -> {
            Player player = (Player)pins.values[0];
            String value = (String)pins.values[1];
            player.sendMessage(ColorUtils.color(value));
            return new Pins(new Object[0]);
        });
        functions.put("newcustommessage", pins -> {
            String value = (String)pins.values[0];
            TextComponent message = new TextComponent(ColorUtils.color(value));
            return new Pins(message);
        });
        functions.put("sethovertextevent", pins -> {
            TextComponent message = (TextComponent)pins.values[0];
            String value = (String)pins.values[1];
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(ColorUtils.color(value))}));
            return new Pins(new Object[0]);
        });
        functions.put("sethoveritemevent", pins -> {
            TextComponent message = (TextComponent)pins.values[0];
            ItemStack value = (ItemStack)pins.values[1];
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new Content[]{new Item("minecraft:" + value.getType().toString().toLowerCase(), value.getAmount(), ItemTag.ofNbt((String)value.getItemMeta().getAsString()))}));
            return new Pins(new Object[0]);
        });
        functions.put("sethoverentityevent", pins -> {
            TextComponent message = (TextComponent)pins.values[0];
            String type = (String)pins.values[1];
            String id = (String)pins.values[2];
            String name = (String)pins.values[3];
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ENTITY, new Content[]{new Entity(type, id, (BaseComponent)new TextComponent(ColorUtils.color(name)))}));
            return new Pins(new Object[0]);
        });
        functions.put("setclickevent", pins -> {
            TextComponent message = (TextComponent)pins.values[0];
            String action = (String)pins.values[1];
            String value = (String)pins.values[2];
            message.setClickEvent(new ClickEvent(ClickEvent.Action.valueOf((String)action.toUpperCase()), ColorUtils.color(value)));
            return new Pins(new Object[0]);
        });
        functions.put("sendcustommessage", pins -> {
            Player player = (Player)pins.values[0];
            TextComponent message = (TextComponent)pins.values[1];
            player.spigot().sendMessage((BaseComponent)message);
            return new Pins(new Object[0]);
        });
        functions.put("playsound", pins -> {
            Player player = (Player)pins.values[0];
            String value = (String)pins.values[1];
            Double volume = Double.valueOf((String)pins.values[2]);
            Double pitch = Double.valueOf((String)pins.values[3]);
            player.playSound(player.getLocation(), value.strip().toLowerCase(), volume.floatValue(), pitch.floatValue());
            return new Pins(new Object[0]);
        });
        functions.put("playsound2", pins -> {
            Player player = (Player)pins.values[0];
            String value = (String)pins.values[1];
            Double volume = (Double)pins.values[2];
            Double pitch = (Double)pins.values[3];
            player.playSound(player.getLocation(), value.strip().toLowerCase(), volume.floatValue(), pitch.floatValue());
            return new Pins(new Object[0]);
        });
        functions.put("stopsound", pins -> {
            Player player = (Player)pins.values[0];
            String value = (String)pins.values[1];
            player.stopSound(value.strip().toLowerCase());
            return new Pins(new Object[0]);
        });
        functions.put("stopallsound", pins -> {
            Player player = (Player)pins.values[0];
            player.stopAllSounds();
            return new Pins(new Object[0]);
        });
        functions.put("kick", pins -> {
            Player player = (Player)pins.values[0];
            String value = (String)pins.values[1];
            player.kickPlayer(ColorUtils.color(value));
            return new Pins(new Object[0]);
        });
        functions.put("ban", pins -> {
            Player player = (Player)pins.values[0];
            String reason = (String)pins.values[1];
            reason = ColorUtils.color(reason);
            Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), reason, null, "");
            player.kickPlayer(reason);
            return new Pins(new Object[0]);
        });
        functions.put("tempban", pins -> {
            Player player = (Player)pins.values[0];
            String reason = (String)pins.values[1];
            Double duration = (Double)pins.values[2];
            reason = ColorUtils.color(reason);
            Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), reason, Date.from(Instant.now().plusSeconds(duration.intValue())), "");
            player.kickPlayer(reason);
            return new Pins(new Object[0]);
        });
        functions.put("playercommand", pins -> {
            Player player = (Player)pins.values[0];
            String command = (String)pins.values[1];
            Bukkit.dispatchCommand((CommandSender)player, (String)command);
            return new Pins(new Object[0]);
        });
        functions.put("playercommandignoreperm", pins -> {
            Player player = (Player)pins.values[0];
            String command = (String)pins.values[1];
            boolean previous = player.isOp();
            if (!previous) {
                player.setOp(true);
            }
            try {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
            }
            catch (CommandException commandException) {
                // empty catch block
            }
            if (!previous) {
                player.setOp(false);
            }
            return new Pins(new Object[0]);
        });
        functions.put("openinv", pins -> {
            Player player = (Player)pins.values[0];
            Inventory inv = (Inventory)pins.values[1];
            player.openInventory(inv);
            return new Pins(new Object[0]);
        });
        functions.put("closeinv", pins -> {
            Player player = (Player)pins.values[0];
            player.closeInventory();
            return new Pins(new Object[0]);
        });
        functions.put("playerbreakblock", pins -> {
            Player player = (Player)pins.values[0];
            Block block = (Block)pins.values[1];
            if (playerBreaker.contains(player)) {
                brokenBlocks.add(block);
            }
            player.breakBlock(block);
            return new Pins(new Object[0]);
        });
        functions.put("playerscoreboard", pins -> {
            Player player = (Player)pins.values[0];
            Objective obj = player.getScoreboard().getObjective("crashcorescoreboard");
            if (obj != null) {
                HashSet<Score> list = new HashSet<Score>();
                for (String entry : player.getScoreboard().getEntries()) {
                    Score score = obj.getScore(entry);
                    if (!score.isScoreSet()) continue;
                    list.add(score);
                }
                String[] strs = new String[list.size()];
                for (Score score : list) {
                    strs[score.getScore()] = score.getEntry();
                }
                return new Pins(Boolean.TRUE, obj.getDisplayName(), Arrays.asList(strs));
            }
            return new Pins(Boolean.FALSE, "", new ArrayList());
        });
        functions.put("setplayerscoreboard", pins -> {
            Player player = (Player)pins.values[0];
            Boolean active = (Boolean)pins.values[1];
            String title = (String)pins.values[2];
            List list = (List)pins.values[3];
            if (active.booleanValue()) {
                Objective obj = player.getScoreboard().getObjective("crashcorescoreboard");
                if (obj != null) {
                    obj.unregister();
                    player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR);
                    player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
                }
                obj = player.getScoreboard().registerNewObjective("crashcorescoreboard", Criteria.DUMMY, ColorUtils.color(title));
                obj.setDisplaySlot(DisplaySlot.SIDEBAR);
                int i = 0;
                while (i < list.size()) {
                    obj.getScore(ColorUtils.color((String)list.get(i))).setScore(i);
                    ++i;
                }
            } else {
                Objective obj = player.getScoreboard().getObjective("crashcorescoreboard");
                if (obj != null) {
                    obj.unregister();
                }
                player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR);
                player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
            }
            return new Pins(new Object[0]);
        });
        functions.put("sendtitle", pins -> {
            Player player = (Player)pins.values[0];
            String title = (String)pins.values[1];
            String subtitle = (String)pins.values[2];
            Double fadeIn = (Double)pins.values[3];
            Double stay = (Double)pins.values[4];
            Double fadeOut = (Double)pins.values[5];
            player.sendTitle(ColorUtils.color(title), ColorUtils.color(subtitle), fadeIn.intValue(), stay.intValue(), fadeOut.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("sendtitle2", pins -> {
            Player player = (Player)pins.values[0];
            String title = (String)pins.values[1];
            String subtitle = (String)pins.values[2];
            player.sendTitle(ColorUtils.color(title), ColorUtils.color(subtitle), 10, 70, 20);
            return new Pins(new Object[0]);
        });
        functions.put("setname", pins -> {
            Player player = (Player)pins.values[0];
            String name = (String)pins.values[1];
            player.setDisplayName(ColorUtils.color(name));
            return new Pins(new Object[0]);
        });
        functions.put("setbossbar", pins -> {
            Player player = (Player)pins.values[0];
            String ID = (String)pins.values[1];
            String title = (String)pins.values[2];
            String barStyle = (String)pins.values[3];
            String barColor = (String)pins.values[4];
            Double progress = (Double)pins.values[5];
            BarStyle style = BarStyle.SOLID;
            try {
                style = BarStyle.valueOf((String)barStyle.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            BarColor color = BarColor.WHITE;
            try {
                color = BarColor.valueOf((String)barColor.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            KeyedBossBar bar = Bukkit.getBossBar((NamespacedKey)new NamespacedKey((Plugin)Main.INSTANCE, "cp" + player.getUniqueId().toString() + ID));
            if (bar == null) {
                bar = Bukkit.createBossBar((NamespacedKey)new NamespacedKey((Plugin)Main.INSTANCE, "cp" + player.getUniqueId().toString() + ID), (String)title, (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
                bar.addPlayer(player);
            } else {
                bar.setTitle(title);
                bar.setStyle(style);
                bar.setColor(color);
            }
            bar.setProgress(progress.doubleValue());
            return new Pins(new Object[0]);
        });
        functions.put("playerbossbar", pins -> {
            Player player = (Player)pins.values[0];
            String ID = (String)pins.values[1];
            KeyedBossBar bar = Bukkit.getBossBar((NamespacedKey)new NamespacedKey((Plugin)Main.INSTANCE, "cp" + player.getUniqueId().toString() + ID));
            if (bar != null) {
                return new Pins(bar.getTitle(), bar.getStyle().toString(), bar.getColor().toString(), bar.getProgress());
            }
            return new Pins("", "", "", 0.0);
        });
        functions.put("removebossbar", pins -> {
            Player player = (Player)pins.values[0];
            String ID = (String)pins.values[1];
            NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + player.getUniqueId().toString() + ID);
            KeyedBossBar bar = Bukkit.getBossBar((NamespacedKey)key);
            if (bar != null) {
                bar.removePlayer(player);
                if (bar.getPlayers().size() == 0) {
                    bar.removeAll();
                    Bukkit.removeBossBar((NamespacedKey)key);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("getplayergamemode", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getGameMode().getValue());
        });
        functions.put("setplayergamemode", pins -> {
            Player player = (Player)pins.values[0];
            Double d = (Double)pins.values[1];
            GameMode mode = GameMode.getByValue((int)d.intValue());
            if (mode != null) {
                player.setGameMode(mode);
            }
            return new Pins(new Object[0]);
        });
        functions.put("getiteminhand", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getInventory().getItemInMainHand(), player.getInventory().getHeldItemSlot());
        });
        functions.put("setiteminhand", pins -> {
            Player player = (Player)pins.values[0];
            ItemStack item = (ItemStack)pins.values[1];
            player.getInventory().setItemInMainHand(item);
            return new Pins(new Object[0]);
        });
        functions.put("playerspawnpoint", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getBedSpawnLocation().getWorld(), new Vector(player.getBedSpawnLocation()));
        });
        functions.put("setspawnpoint", pins -> {
            Player player = (Player)pins.values[0];
            World world = (World)pins.values[1];
            Vector spawnpoint = (Vector)pins.values[2];
            player.setBedSpawnLocation(spawnpoint.getLocation(world), true);
            return new Pins(new Object[0]);
        });
        functions.put("resetchatevent", pins -> {
            Player player = (Player)pins.values[0];
            PlayerListener.chatlistener.remove(player);
            return new Pins(new Object[0]);
        });
        functions.put("resetshiftevent", pins -> {
            Player player = (Player)pins.values[0];
            PlayerListener.shiftlisteneroff.remove(player);
            PlayerListener.shiftlisteneron.remove(player);
            return new Pins(new Object[0]);
        });
        functions.put("resetjumpevent", pins -> {
            Player player = (Player)pins.values[0];
            PlayerListener.jumplistener.remove(player);
            return new Pins(new Object[0]);
        });
        functions.put("setlistname", pins -> {
            Player player = (Player)pins.values[0];
            String name = (String)pins.values[1];
            player.setPlayerListName(ColorUtils.color(name));
            return new Pins(new Object[0]);
        });
        functions.put("getlistname", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getPlayerListName());
        });
        functions.put("setlistinfo", pins -> {
            Player player = (Player)pins.values[0];
            String footer = (String)pins.values[1];
            String header = (String)pins.values[2];
            player.setPlayerListHeaderFooter(ColorUtils.color(header), ColorUtils.color(footer));
            return new Pins(new Object[0]);
        });
        functions.put("getlistinfo", pins -> {
            Player player = (Player)pins.values[0];
            String footer = player.getPlayerListFooter();
            String header = player.getPlayerListHeader();
            if (footer == null) {
                footer = "";
            }
            if (header == null) {
                header = "";
            }
            return new Pins(footer, header);
        });
        functions.put("setcompasstarget", pins -> {
            Player player = (Player)pins.values[0];
            Vector target = (Vector)pins.values[1];
            player.setCompassTarget(target.getLocation(player.getWorld()));
            return new Pins(new Object[0]);
        });
        functions.put("playerchat", pins -> {
            Player player = (Player)pins.values[0];
            String message = (String)pins.values[1];
            player.chat(ColorUtils.color(message));
            return new Pins(new Object[0]);
        });
        functions.put("setsprinting", pins -> {
            Player player = (Player)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            player.setSprinting(value.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("issprinting", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.isSprinting());
        });
        functions.put("sendfakeblock", pins -> {
            Player player = (Player)pins.values[0];
            Vector position = (Vector)pins.values[1];
            String material = (String)pins.values[2];
            Material mat = Material.getMaterial((String)material.replace(" ", "_").toUpperCase());
            player.sendBlockChange(position.getLocation(player.getWorld()), mat.createBlockData());
            return new Pins(new Object[0]);
        });
        functions.put("sendfakeblockdamage", pins -> {
            Player player = (Player)pins.values[0];
            Vector position = (Vector)pins.values[1];
            Double damage = (Double)pins.values[2];
            if (damage >= 0.0 && damage <= 1.0) {
                player.sendBlockDamage(position.getLocation(player.getWorld()), damage.floatValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("sendfakesign", pins -> {
            Player player = (Player)pins.values[0];
            Vector position = (Vector)pins.values[1];
            List content = (List)pins.values[2];
            if (content.size() == 4) {
                ArrayList<String> translatedContent = new ArrayList<String>();
                for (String c : content) {
                    translatedContent.add(ColorUtils.color(c));
                }
                player.sendSignChange(position.getLocation(player.getWorld()), translatedContent.toArray(new String[4]));
            }
            return new Pins(new Object[0]);
        });
        functions.put("sendfakehurt", pins -> {
            Player player = (Player)pins.values[0];
            Double yaw = (Double)pins.values[1];
            player.sendHurtAnimation(yaw.floatValue());
            return new Pins(new Object[0]);
        });
        functions.put("addchatcompletions", pins -> {
            Player player = (Player)pins.values[0];
            String completion = (String)pins.values[1];
            player.addCustomChatCompletions(Collections.singleton(completion));
            return new Pins(new Object[0]);
        });
        functions.put("removechatcompletions", pins -> {
            Player player = (Player)pins.values[0];
            String completion = (String)pins.values[1];
            player.removeCustomChatCompletions(Collections.singleton(completion));
            return new Pins(new Object[0]);
        });
        functions.put("setallowflight", pins -> {
            Player player = (Player)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            player.setAllowFlight(value.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("playerallowflight", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getAllowFlight());
        });
        functions.put("setflying", pins -> {
            Player player = (Player)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            player.setFlying(value.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("isflying", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.isFlying());
        });
        functions.put("hideentity", pins -> {
            Player player = (Player)pins.values[0];
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[1];
            player.hideEntity((Plugin)Main.INSTANCE, entity);
            return new Pins(new Object[0]);
        });
        functions.put("showentity", pins -> {
            Player player = (Player)pins.values[0];
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[1];
            player.showEntity((Plugin)Main.INSTANCE, entity);
            return new Pins(new Object[0]);
        });
        functions.put("setflyspeed", pins -> {
            Player player = (Player)pins.values[0];
            Double value = (Double)pins.values[1];
            if (value >= -1.0 && value <= 1.0) {
                player.setFlySpeed(value.floatValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("getflyspeed", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getFlySpeed());
        });
        functions.put("setwalkspeed", pins -> {
            Player player = (Player)pins.values[0];
            Double value = (Double)pins.values[1];
            if (value >= -1.0 && value <= 1.0) {
                player.setWalkSpeed(value.floatValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("getwalkspeed", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getWalkSpeed());
        });
        functions.put("isonline", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.isOnline());
        });
        functions.put("setwhitelisted", pins -> {
            Player player = (Player)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            player.setWhitelisted(value.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("iswhitelisted", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.isWhitelisted());
        });
        functions.put("playerlastdeathlocation", pins -> {
            Player player = (Player)pins.values[0];
            Location lastDeathLocation = player.getLastDeathLocation();
            if (lastDeathLocation == null) {
                lastDeathLocation = player.getLocation();
            }
            return new Pins(new Vector(lastDeathLocation), lastDeathLocation.getWorld());
        });
        functions.put("playerenderchest", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.getEnderChest());
        });
        functions.put("openworkbench", pins -> {
            Player player = (Player)pins.values[0];
            player.openWorkbench(null, true);
            return new Pins(new Object[0]);
        });
        functions.put("playerwakeup", pins -> {
            Player player = (Player)pins.values[0];
            if (player.isSleeping()) {
                player.wakeup(false);
            }
            return new Pins(new Object[0]);
        });
        functions.put("isblocking", pins -> {
            Player player = (Player)pins.values[0];
            return new Pins(player.isBlocking());
        });
        functions.put("playerdropitem", pins -> {
            Player player = (Player)pins.values[0];
            Boolean dropAll = (Boolean)pins.values[1];
            player.dropItem(dropAll.booleanValue());
            player.updateInventory();
            return new Pins(new Object[0]);
        });
        functions.put("getplayer", pins -> {
            UUID uuid;
            String str = (String)pins.values[0];
            try {
                uuid = UUID.fromString(str);
            }
            catch (IllegalArgumentException e) {
                return new Pins(Boolean.FALSE, null);
            }
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            if (player.isOnline()) {
                return new Pins(Boolean.TRUE, player);
            }
            return new Pins(Boolean.FALSE, player);
        });
        functions.put("getplayerbyname", pins -> {
            String str = (String)pins.values[0];
            Player player = Bukkit.getPlayer((String)str);
            if (player == null) {
                return new Pins(Boolean.FALSE, null);
            }
            return new Pins(Boolean.TRUE, player);
        });
        functions.put("discoverrecipe", pins -> {
            Player player = (Player)pins.values[0];
            String str = (String)pins.values[1];
            player.discoverRecipe(NamespacedKey.fromString((String)str));
            return new Pins(new Object[0]);
        });
        functions.put("newvect", pins -> {
            Float x = Float.valueOf(Float.parseFloat((String)pins.values[0]));
            Float y = Float.valueOf(Float.parseFloat((String)pins.values[1]));
            Float z = Float.valueOf(Float.parseFloat((String)pins.values[2]));
            return new Pins(new Vector(x.floatValue(), y.floatValue(), z.floatValue()));
        });
        functions.put("sumvect", pins -> {
            float[] vect1 = ((Vector)pins.values[0]).values;
            float[] vect2 = ((Vector)pins.values[1]).values;
            return new Pins(new Vector(vect1[0] + vect2[0], vect1[1] + vect2[1], vect1[2] + vect2[2]));
        });
        functions.put("diffvect", pins -> {
            float[] vect1 = ((Vector)pins.values[0]).values;
            float[] vect2 = ((Vector)pins.values[1]).values;
            return new Pins(new Vector(vect1[0] - vect2[0], vect1[1] - vect2[1], vect1[2] - vect2[2]));
        });
        functions.put("mulvect", pins -> {
            float[] vect1 = ((Vector)pins.values[0]).values;
            float[] vect2 = ((Vector)pins.values[1]).values;
            return new Pins(new Vector(vect1[0] * vect2[0], vect1[1] * vect2[1], vect1[2] * vect2[2]));
        });
        functions.put("distancevect", pins -> {
            float[] vect1 = ((Vector)pins.values[0]).values;
            float[] vect2 = ((Vector)pins.values[1]).values;
            return new Pins(Math.sqrt(Math.pow(vect2[0] - vect1[0], 2.0) + Math.pow(vect2[1] - vect1[1], 2.0) + Math.pow(vect2[2] - vect1[2], 2.0)));
        });
        functions.put("sqddistancevect", pins -> {
            float[] vect1 = ((Vector)pins.values[0]).values;
            float[] vect2 = ((Vector)pins.values[1]).values;
            return new Pins(Math.pow(vect2[0] - vect1[0], 2.0) + Math.pow(vect2[1] - vect1[1], 2.0) + Math.pow(vect2[2] - vect1[2], 2.0));
        });
        functions.put("anglebetweenvectors", pins -> {
            float[] vect1 = ((Vector)pins.values[0]).values;
            float[] vect2 = ((Vector)pins.values[1]).values;
            return new Pins(MathUtil.angleBetween(vect1, vect2));
        });
        functions.put("createvect", pins -> {
            Double x = (Double)pins.values[0];
            Double y = (Double)pins.values[1];
            Double z = (Double)pins.values[2];
            return new Pins(new Vector(x, y, z));
        });
        functions.put("getcomponentsvect", pins -> {
            float[] vect = ((Vector)pins.values[0]).values;
            return new Pins(vect[0], vect[1], vect[2]);
        });
        functions.put("vecttostring", pins -> {
            float[] vect1 = ((Vector)pins.values[0]).values;
            return new Pins(vect1[0] + " " + vect1[1] + " " + vect1[2]);
        });
        functions.put("stringtovect", pins -> {
            String str = (String)pins.values[0];
            String[] strs = str.split(" ");
            if (strs.length == 3) {
                float[] fs = new float[3];
                int i = 0;
                while (i < 3) {
                    try {
                        fs[i] = Float.parseFloat(strs[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++i;
                }
                return new Pins(new Vector(fs));
            }
            return new Pins(new Vector(0.0f, 0.0f, 0.0f));
        });
        functions.put("rotatevect", pins -> {
            Vector vect = new Vector(((Vector)pins.values[0]).values);
            float[] axis = ((Vector)pins.values[1]).values;
            Double angle = (Double)pins.values[2];
            return new Pins(vect.rotateVector(axis, Math.toRadians(angle)));
        });
        functions.put("vectoryawpitch", pins -> {
            float[] vect1 = ((Vector)pins.values[0]).values;
            float pitch = -((float)Math.toDegrees(Math.asin(vect1[1])));
            float yaw = -((float)Math.toDegrees(Math.atan2(vect1[0], vect1[2])));
            return new Pins(yaw, pitch);
        });
        functions.put("yawpitchvector", pins -> {
            float yaw = ((Double)pins.values[0]).floatValue();
            float pitch = ((Double)pins.values[1]).floatValue();
            return new Pins(new Vector(Math.toRadians(yaw), Math.toRadians(pitch)));
        });
        functions.put("getblock", pins -> {
            World world = (World)pins.values[0];
            float[] vect = ((Vector)pins.values[1]).values;
            return new Pins(world.getBlockAt((int)Math.floor(vect[0]), (int)Math.floor(vect[1]), (int)Math.floor(vect[2])));
        });
        functions.put("breakblock", pins -> {
            Block block = (Block)pins.values[0];
            block.breakNaturally();
            return new Pins(new Object[0]);
        });
        functions.put("breakwithtool", pins -> {
            Block block = (Block)pins.values[0];
            String material = (String)pins.values[1];
            Material mat = Material.getMaterial((String)material.replace(" ", "_").toUpperCase());
            if (mat != null) {
                block.breakNaturally(new ItemStack(mat));
            }
            return new Pins(new Object[0]);
        });
        functions.put("removeblock", pins -> {
            Block block = (Block)pins.values[0];
            block.setType(Material.AIR);
            return new Pins(new Object[0]);
        });
        functions.put("settype", pins -> {
            Block block = (Block)pins.values[0];
            String material = (String)pins.values[1];
            Material mat = Material.getMaterial((String)material.replace(" ", "_").toUpperCase());
            if (mat != null) {
                block.setType(mat);
            }
            return new Pins(new Object[0]);
        });
        functions.put("blocktype", pins -> {
            Block block = (Block)pins.values[0];
            return new Pins(block.getType().toString().toLowerCase());
        });
        functions.put("blockhardness", pins -> {
            Block block = (Block)pins.values[0];
            return new Pins(block.getType().getHardness());
        });
        functions.put("blockposition", pins -> {
            Block block = (Block)pins.values[0];
            Location loc = block.getLocation();
            return new Pins(new Vector(loc.getX(), loc.getY(), loc.getZ()));
        });
        functions.put("blockdirection", pins -> {
            Block block = (Block)pins.values[0];
            BlockData data = block.getBlockData();
            if (data instanceof Directional) {
                Directional dir = (Directional)data;
                BlockFace face = dir.getFacing();
                return new Pins(new Vector(face.getModX(), face.getModY(), face.getModZ()));
            }
            return new Pins(new Vector(0.0f, 0.0f, 0.0f));
        });
        functions.put("setblockdirection", pins -> {
            Block block = (Block)pins.values[0];
            float[] vect = ((Vector)pins.values[1]).values;
            BlockData data = block.getBlockData();
            if (data instanceof Directional) {
                Directional dir = (Directional)data;
                int biggerIndex = 0;
                int i = 0;
                while (i < vect.length) {
                    if (Math.abs(vect[i]) > Math.abs(vect[biggerIndex])) {
                        biggerIndex = i;
                    }
                    ++i;
                }
                i = 0;
                while (i < vect.length) {
                    if (i != biggerIndex) {
                        vect[i] = 0.0f;
                    }
                    ++i;
                }
                if (vect[0] > 0.0f) {
                    dir.setFacing(BlockFace.EAST);
                } else if (vect[0] < 0.0f) {
                    dir.setFacing(BlockFace.WEST);
                } else if (vect[1] > 0.0f) {
                    dir.setFacing(BlockFace.UP);
                } else if (vect[1] < 0.0f) {
                    dir.setFacing(BlockFace.DOWN);
                } else if (vect[2] > 0.0f) {
                    dir.setFacing(BlockFace.SOUTH);
                } else if (vect[2] < 0.0f) {
                    dir.setFacing(BlockFace.NORTH);
                }
                block.setBlockData(data);
            }
            return new Pins(new Object[0]);
        });
        functions.put("blockworld", pins -> {
            Block block = (Block)pins.values[0];
            return new Pins(block.getWorld());
        });
        functions.put("blockhalf", pins -> {
            Block block = (Block)pins.values[0];
            BlockData data = block.getBlockData();
            if (data instanceof Bisected) {
                Bisected dir = (Bisected)data;
                return new Pins(dir.getHalf() == Bisected.Half.TOP);
            }
            if (data instanceof Slab) {
                Slab dir = (Slab)data;
                return new Pins(dir.getType() == Slab.Type.TOP);
            }
            return new Pins(Boolean.FALSE);
        });
        functions.put("setblockhalf", pins -> {
            Block block = (Block)pins.values[0];
            Boolean value = (Boolean)pins.values[1];
            BlockData data = block.getBlockData();
            if (data instanceof Bisected) {
                Bisected dir = (Bisected)data;
                dir.setHalf(value != false ? Bisected.Half.TOP : Bisected.Half.BOTTOM);
            } else if (data instanceof Slab) {
                Slab dir = (Slab)data;
                dir.setType(value != false ? Slab.Type.TOP : Slab.Type.BOTTOM);
            }
            return new Pins(new Object[0]);
        });
        functions.put("updateblock", pins -> {
            Block block = (Block)pins.values[0];
            BlockData data = block.getBlockData();
            if (data instanceof MultipleFacing) {
                MultipleFacing multiple = (MultipleFacing)data;
                for (BlockFace face : multiple.getAllowedFaces()) {
                    BlockData d;
                    Block b = block.getRelative(face);
                    if (!b.isPassable()) {
                        multiple.setFace(face, true);
                    }
                    if (!((d = b.getBlockData()) instanceof MultipleFacing)) continue;
                    MultipleFacing m = (MultipleFacing)d;
                    m.setFace(face.getOppositeFace(), true);
                    b.setBlockData((BlockData)m);
                }
                block.setBlockData((BlockData)multiple);
            }
            return new Pins(new Object[0]);
        });
        functions.put("adjacentblock", pins -> {
            Block block = (Block)pins.values[0];
            Vector r = (Vector)pins.values[1];
            return new Pins(block.getRelative((int)r.values[0], (int)r.values[1], (int)r.values[2]));
        });
        functions.put("fillblocks", pins -> {
            World world = (World)pins.values[0];
            float[] v1 = ((Vector)pins.values[1]).values;
            float[] v2 = ((Vector)pins.values[2]).values;
            String type = (String)pins.values[3];
            Material mat = Material.getMaterial((String)type.replace(" ", "_").toUpperCase());
            if (mat != null) {
                int max0 = (int)Math.max(v1[0], v2[0]);
                int x = (int)Math.min(v1[0], v2[0]);
                while (x < max0) {
                    int max1 = (int)Math.max(v1[1], v2[1]);
                    int y = (int)Math.min(v1[1], v2[1]);
                    while (y < max1) {
                        int max2 = (int)Math.max(v1[2], v2[2]);
                        int z = (int)Math.min(v1[2], v2[2]);
                        while (z < max2) {
                            world.getBlockAt(x, y, z).setType(mat);
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("blockinventory", pins -> {
            Block block = (Block)pins.values[0];
            BlockState data = block.getState();
            if (data instanceof Container) {
                Container container = (Container)data;
                return new Pins(Boolean.TRUE, container.getInventory());
            }
            return new Pins(Boolean.FALSE, null);
        });
        functions.put("replaceblocks", pins -> {
            World world = (World)pins.values[0];
            float[] v1 = ((Vector)pins.values[1]).values;
            float[] v2 = ((Vector)pins.values[2]).values;
            String from = (String)pins.values[3];
            String to = (String)pins.values[4];
            Material matfrom = Material.getMaterial((String)from.replace(" ", "_").toUpperCase());
            Material matto = Material.getMaterial((String)to.replace(" ", "_").toUpperCase());
            if (matfrom != null && matto != null) {
                int max0 = (int)Math.max(v1[0], v2[0]);
                int x = (int)Math.min(v1[0], v2[0]);
                while (x < max0) {
                    int max1 = (int)Math.max(v1[1], v2[1]);
                    int y = (int)Math.min(v1[1], v2[1]);
                    while (y < max1) {
                        int max2 = (int)Math.max(v1[2], v2[2]);
                        int z = (int)Math.min(v1[2], v2[2]);
                        while (z < max2) {
                            Block b = world.getBlockAt(x, y, z);
                            if (b.getType() == matfrom) {
                                b.setType(matto);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("isblockempty", pins -> {
            Block block = (Block)pins.values[0];
            return new Pins(block.isEmpty());
        });
        functions.put("isblockliquid", pins -> {
            Block block = (Block)pins.values[0];
            return new Pins(block.isLiquid());
        });
        functions.put("isblockpassable", pins -> {
            Block block = (Block)pins.values[0];
            return new Pins(block.isPassable());
        });
        functions.put("isblockpowered", pins -> {
            Block block = (Block)pins.values[0];
            return new Pins(block.isBlockPowered());
        });
        functions.put("setsigntext", pins -> {
            Block block = (Block)pins.values[0];
            Boolean front = (Boolean)pins.values[1];
            int line = ((Double)pins.values[2]).intValue();
            String text = (String)pins.values[3];
            if (line < 0 || line > 3) {
                line = 0;
            }
            if (block.getState() instanceof Sign) {
                Sign sign = (Sign)block.getState();
                try {
                    sign.getSide(front != false ? Side.FRONT : Side.BACK).setLine(line, text);
                    sign.update();
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("getsigntext", pins -> {
            Block block = (Block)pins.values[0];
            Boolean front = (Boolean)pins.values[1];
            int line = ((Double)pins.values[2]).intValue();
            String text = "";
            if (line < 0 || line > 3) {
                line = 0;
            }
            if (block.getState() instanceof Sign) {
                Sign sign = (Sign)block.getState();
                try {
                    text = sign.getSide(front != false ? Side.FRONT : Side.BACK).getLine(line);
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            return new Pins(text);
        });
        functions.put("setsigndata", pins -> {
            Block block = (Block)pins.values[0];
            Boolean front = (Boolean)pins.values[1];
            String color = (String)pins.values[2];
            Boolean glowing = (Boolean)pins.values[3];
            Boolean waxed = (Boolean)pins.values[4];
            if (block.getState() instanceof Sign) {
                Sign sign = (Sign)block.getState();
                try {
                    SignSide side = sign.getSide(front != false ? Side.FRONT : Side.BACK);
                    try {
                        side.setColor(DyeColor.valueOf((String)color.toUpperCase()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    side.setGlowingText(glowing.booleanValue());
                    try {
                        sign.setWaxed(waxed.booleanValue());
                    }
                    catch (NoSuchMethodError e) {
                        sign.setEditable(waxed == false);
                    }
                    sign.update();
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("getsigndata", pins -> {
            Block block = (Block)pins.values[0];
            Boolean front = (Boolean)pins.values[1];
            if (block.getState() instanceof Sign) {
                Sign sign = (Sign)block.getState();
                try {
                    SignSide side = sign.getSide(front != false ? Side.FRONT : Side.BACK);
                    return new Pins(side.getColor().toString(), side.isGlowingText(), sign.isWaxed());
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
            }
            return new Pins("", Boolean.FALSE, Boolean.FALSE);
        });
        functions.put("setspawnerdata", pins -> {
            Block block = (Block)pins.values[0];
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[1];
            int range = ((Double)pins.values[2]).intValue();
            int count = ((Double)pins.values[3]).intValue();
            int playerRange = ((Double)pins.values[4]).intValue();
            int minDelay = ((Double)pins.values[5]).intValue();
            int maxDelay = ((Double)pins.values[6]).intValue();
            int maxNearby = ((Double)pins.values[7]).intValue();
            if (block.getState() instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)block.getState();
                try {
                    spawner.setSpawnedEntity(entity.createSnapshot());
                }
                catch (NoSuchMethodError e) {
                    spawner.setSpawnedType(entity.getType());
                }
                spawner.setRequiredPlayerRange(playerRange);
                spawner.setSpawnCount(count);
                spawner.setSpawnRange(range);
                spawner.setMinSpawnDelay(minDelay);
                spawner.setMaxSpawnDelay(maxDelay);
                spawner.setMaxNearbyEntities(maxNearby);
                spawner.update();
            }
            return new Pins(new Object[0]);
        });
        functions.put("getspawnerdata", pins -> {
            Block block = (Block)pins.values[0];
            if (block.getState() instanceof CreatureSpawner) {
                String entityType;
                CreatureSpawner spawner;
                block4: {
                    spawner = (CreatureSpawner)block.getState();
                    entityType = null;
                    try {
                        if (spawner.getSpawnedEntity() != null) {
                            entityType = spawner.getSpawnedEntity().getEntityType().toString();
                        }
                    }
                    catch (NoSuchMethodError e) {
                        if (spawner.getSpawnedType() == null) break block4;
                        entityType = spawner.getSpawnedType().toString();
                    }
                }
                return new Pins(entityType != null, entityType != null ? entityType : "", spawner.getSpawnRange(), spawner.getSpawnCount(), spawner.getRequiredPlayerRange(), spawner.getMinSpawnDelay(), spawner.getMaxSpawnDelay(), spawner.getMaxNearbyEntities());
            }
            return new Pins(Boolean.FALSE, "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        });
        functions.put("spawnspawnerentity", pins -> {
            block4: {
                Block block = (Block)pins.values[0];
                Vector position = (Vector)pins.values[1];
                World world = (World)pins.values[2];
                if (block.getState() instanceof CreatureSpawner) {
                    CreatureSpawner spawner = (CreatureSpawner)block.getState();
                    try {
                        if (spawner.getSpawnedEntity() != null) {
                            spawner.getSpawnedEntity().createEntity(position.getLocation(world));
                        }
                    }
                    catch (NoSuchMethodError e) {
                        if (spawner.getSpawnedType() == null) break block4;
                        world.spawnEntity(position.getLocation(world), spawner.getSpawnedType());
                    }
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("setitemframe", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            ItemStack item = (ItemStack)pins.values[1];
            Boolean visible = (Boolean)pins.values[2];
            Boolean fixed = (Boolean)pins.values[3];
            Double degrees = (Double)pins.values[4];
            if (entity instanceof ItemFrame) {
                ItemFrame frame = (ItemFrame)entity;
                frame.setItem(item);
                frame.setVisible(visible.booleanValue());
                frame.setFixed(fixed.booleanValue());
                frame.setRotation(Rotation.values()[degrees.intValue() / 45 % 8]);
            }
            return new Pins(new Object[0]);
        });
        functions.put("getitemframe", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            if (entity instanceof ItemFrame) {
                ItemFrame frame = (ItemFrame)entity;
                return new Pins(Boolean.TRUE, frame.getItem(), frame.isVisible(), frame.isFixed(), frame.getRotation().ordinal() * 45);
            }
            return new Pins(Boolean.FALSE, null, Boolean.FALSE, Boolean.FALSE, 0.0);
        });
        functions.put("getblockvolume", pins -> {
            float[] pos1 = ((Vector)pins.values[0]).values;
            float[] pos2 = ((Vector)pins.values[1]).values;
            int minX = Math.min((int)pos1[0], (int)pos2[0]);
            int minY = Math.min((int)pos1[1], (int)pos2[1]);
            int minZ = Math.min((int)pos1[2], (int)pos2[2]);
            int maxX = Math.max((int)pos1[0], (int)pos2[0]);
            int maxY = Math.max((int)pos1[1], (int)pos2[1]);
            int maxZ = Math.max((int)pos1[2], (int)pos2[2]);
            BlockVolume volume = new BlockVolume();
            int x = minX;
            while (x <= maxX) {
                int y = minY;
                while (y <= maxY) {
                    int z = minZ;
                    while (z <= maxZ) {
                        volume.addBlock(x, y, z);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return new Pins(volume);
        });
        functions.put("emptyblockvolume", pins -> new Pins(new BlockVolume()));
        functions.put("addblocktovolume", pins -> {
            BlockVolume volume = (BlockVolume)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            volume.addBlock((int)pos[0], (int)pos[1], (int)pos[2]);
            return new Pins(new Object[0]);
        });
        functions.put("removeblocktovolume", pins -> {
            BlockVolume volume = (BlockVolume)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            volume.removeBlock((int)pos[0], (int)pos[1], (int)pos[2]);
            return new Pins(new Object[0]);
        });
        specialFunctions.put("foreachblockvolume", payload -> {
            BlockVolume volume = (BlockVolume)payload.inputPins.values[0];
            World world = (World)payload.inputPins.values[1];
            for (Vector3i vi : volume.blocks) {
                Block block = world.getBlockAt(vi.x, vi.y, vi.z);
                if (block == null) continue;
                payload.execution.put(payload.instance, new Pins(block));
                for (CompiledScript.Node output : payload.execOutput) {
                    output.run(payload.execution);
                }
            }
        });
        functions.put("volumecontains", pins -> {
            BlockVolume volume = (BlockVolume)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            return new Pins(volume.containsBlock((int)pos[0], (int)pos[1], (int)pos[2]));
        });
        functions.put("blockvolumesize", pins -> {
            BlockVolume volume = (BlockVolume)pins.values[0];
            return new Pins(volume.size());
        });
        functions.put("copyblockvolume", pins -> {
            BlockVolume volume = (BlockVolume)pins.values[0];
            Block block = (Block)pins.values[1];
            String clipped = volume.copy(block.getWorld(), block.getX(), block.getY(), block.getZ());
            return new Pins(clipped);
        });
        functions.put("pasteblockvolume", pins -> {
            Block block = (Block)pins.values[0];
            String clipped = (String)pins.values[1];
            BlockVolume.paste(block.getWorld(), block.getX(), block.getY(), block.getZ(), clipped);
            return new Pins(new Object[0]);
        });
        functions.put("blockvolumetotext", pins -> {
            BlockVolume volume = (BlockVolume)pins.values[0];
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    Pins pins2;
                    ObjectOutputStream so;
                    ByteArrayOutputStream bo;
                    block18: {
                        block17: {
                            bo = new ByteArrayOutputStream();
                            so = new ObjectOutputStream(bo);
                            so.writeObject(volume);
                            so.flush();
                            pins2 = new Pins(Base64.getEncoder().encodeToString(bo.toByteArray()));
                            if (so == null) break block17;
                            so.close();
                        }
                        if (bo == null) break block18;
                        bo.close();
                    }
                    return pins2;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (so != null) {
                                    so.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (bo != null) {
                                    bo.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return new Pins("");
            }
        });
        functions.put("texttoblockvolume", pins -> {
            String str = (String)pins.values[0];
            byte[] b = Base64.getDecoder().decode(str);
            ByteArrayInputStream bi = new ByteArrayInputStream(b);
            try {
                ObjectInputStream si = new ObjectInputStream(bi);
                return new Pins(BlockVolume.class.cast(si.readObject()));
            }
            catch (IOException | ClassCastException | ClassNotFoundException exception) {
                return new Pins(new BlockVolume());
            }
        });
        functions.put("joinblockvolumes", pins -> {
            BlockVolume volume1 = (BlockVolume)pins.values[0];
            BlockVolume volume2 = (BlockVolume)pins.values[1];
            return new Pins(volume1.join(volume2));
        });
        functions.put("booleanvalue", pins -> {
            Double num = Double.valueOf((String)pins.values[0]);
            return new Pins(num != 0.0);
        });
        functions.put("lessthan", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(num1 < num2);
        });
        functions.put("greaterthan", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(num1 > num2);
        });
        functions.put("equalto", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(num1.doubleValue() == num2.doubleValue());
        });
        functions.put("equalstext", pins -> {
            String str1 = (String)pins.values[0];
            String str2 = (String)pins.values[1];
            return new Pins(str1.equalsIgnoreCase(str2));
        });
        functions.put("containstext", pins -> {
            String str1 = (String)pins.values[0];
            String str2 = (String)pins.values[1];
            return new Pins(str1.contains(str2));
        });
        functions.put("logicand", pins -> {
            Boolean b1 = (Boolean)pins.values[0];
            Boolean b2 = (Boolean)pins.values[1];
            return new Pins(b1 != false && b2 != false);
        });
        functions.put("logicor", pins -> {
            Boolean b1 = (Boolean)pins.values[0];
            Boolean b2 = (Boolean)pins.values[1];
            return new Pins(b1 != false || b2 != false);
        });
        functions.put("logicnot", pins -> {
            Boolean b1 = (Boolean)pins.values[0];
            return new Pins(b1 == false);
        });
        functions.put("booleantotext", pins -> {
            Boolean b1 = (Boolean)pins.values[0];
            return new Pins(b1.toString());
        });
        functions.put("newnumber", pins -> {
            Double num = Double.parseDouble((String)pins.values[0]);
            return new Pins(num);
        });
        functions.put("randomnumber", pins -> {
            Double min = (Double)pins.values[0];
            Double max = (Double)pins.values[1];
            return new Pins(min + Math.random() * (max - min));
        });
        functions.put("randomnumber2", pins -> {
            Double min = (Double)pins.values[0];
            Double max = (Double)pins.values[1];
            return new Pins(min + Math.random() * (max - min));
        });
        functions.put("incrementnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            return new Pins(num1 + 1.0);
        });
        functions.put("decrementnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            return new Pins(num1 - 1.0);
        });
        functions.put("sumnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(num1 + num2);
        });
        functions.put("diffnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(num1 - num2);
        });
        functions.put("mulnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(num1 * num2);
        });
        functions.put("rationumber", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(num1 / num2);
        });
        functions.put("powernumber", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(Math.pow(num1, num2));
        });
        functions.put("sqrtnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            return new Pins(Math.sqrt(num1));
        });
        functions.put("modulusnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(num1 % num2);
        });
        functions.put("maxnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(Math.max(num1, num2));
        });
        functions.put("minnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            Double num2 = (Double)pins.values[1];
            return new Pins(Math.min(num1, num2));
        });
        functions.put("absnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            return new Pins(Math.abs(num1));
        });
        functions.put("floornumber", pins -> {
            Double num1 = (Double)pins.values[0];
            return new Pins(Math.floor(num1));
        });
        functions.put("ceilnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            return new Pins(Math.ceil(num1));
        });
        functions.put("roundnumber", pins -> {
            Double num1 = (Double)pins.values[0];
            return new Pins(Math.round(num1));
        });
        functions.put("numbertotext", pins -> {
            Double number = (Double)pins.values[0];
            if (Math.floor(number) == number) {
                return new Pins(String.valueOf(number.longValue()));
            }
            return new Pins(number.toString());
        });
        functions.put("texttonumber", pins -> {
            String number = (String)pins.values[0];
            if (!number.isEmpty()) {
                try {
                    return new Pins(Double.parseDouble(number));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new Pins(0.0);
        });
        functions.put("neweffect", pins -> {
            String effect = ((String)pins.values[0]).toLowerCase().strip();
            Double duration = Double.parseDouble((String)pins.values[1]);
            Double amplifier = Double.parseDouble((String)pins.values[2]);
            String[] effects = effect.split(":");
            NamespacedKey key = effects.length == 2 ? new NamespacedKey(effects[0], effects[1]) : NamespacedKey.minecraft((String)effect);
            PotionEffectType type = PotionEffectType.getByKey((NamespacedKey)key);
            if (type != null) {
                return new Pins(new PotionEffect(type, duration.intValue(), amplifier.intValue()));
            }
            return new Pins(new PotionEffect(PotionEffectType.getById((int)1), 0, 0));
        });
        functions.put("neweffect2", pins -> {
            String effect = ((String)pins.values[0]).toLowerCase().strip();
            Double duration = Double.parseDouble((String)pins.values[1]);
            Double amplifier = Double.parseDouble((String)pins.values[2]);
            Boolean ambient = (Boolean)pins.values[3];
            Boolean particles = (Boolean)pins.values[4];
            Boolean icon = (Boolean)pins.values[5];
            String[] effects = effect.split(":");
            NamespacedKey key = effects.length == 2 ? new NamespacedKey(effects[0], effects[1]) : NamespacedKey.minecraft((String)effect);
            PotionEffectType type = PotionEffectType.getByKey((NamespacedKey)key);
            if (type != null) {
                return new Pins(new PotionEffect(type, duration.intValue(), amplifier.intValue(), ambient.booleanValue(), particles.booleanValue(), icon.booleanValue()));
            }
            return new Pins(new PotionEffect(PotionEffectType.getById((int)1), 0, 0));
        });
        functions.put("addeffect", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            PotionEffect effect = (PotionEffect)pins.values[1];
            if (ent instanceof LivingEntity) {
                ((LivingEntity)ent).addPotionEffect(effect);
            }
            return new Pins(new Object[0]);
        });
        functions.put("seteffect", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            PotionEffect effect = (PotionEffect)pins.values[1];
            if (ent instanceof LivingEntity) {
                ((LivingEntity)ent).addPotionEffect(effect, true);
            }
            return new Pins(new Object[0]);
        });
        functions.put("removeeffect", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            String effect = (String)pins.values[1];
            PotionEffectType type = PotionEffectType.getByName((String)effect);
            if (type != null && ent instanceof LivingEntity) {
                ((LivingEntity)ent).removePotionEffect(type);
            }
            return new Pins(new Object[0]);
        });
        functions.put("cleareffects", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            if (ent instanceof LivingEntity) {
                ((LivingEntity)ent).getActivePotionEffects().clear();
            }
            return new Pins(new Object[0]);
        });
        functions.put("geteffect", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            String effect = (String)pins.values[1];
            PotionEffectType type = PotionEffectType.getByName((String)effect);
            if (type != null && ent instanceof LivingEntity) {
                PotionEffect potion = ((LivingEntity)ent).getPotionEffect(type);
                if (potion != null) {
                    return new Pins(potion);
                }
                return new Pins(new PotionEffect(type, 0, 0));
            }
            return new Pins(new PotionEffect(PotionEffectType.getById((int)1), 0, 0));
        });
        functions.put("effectduration", pins -> {
            PotionEffect effect = (PotionEffect)pins.values[0];
            return new Pins(effect.getDuration());
        });
        functions.put("effectamplifier", pins -> {
            PotionEffect effect = (PotionEffect)pins.values[0];
            return new Pins(effect.getAmplifier());
        });
        functions.put("setpotioneffect", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            PotionEffect effect = (PotionEffect)pins.values[1];
            if (!item.hasItemMeta()) {
                return new Pins(new Object[0]);
            }
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof PotionMeta) {
                PotionMeta pmeta = (PotionMeta)meta;
                pmeta.addCustomEffect(effect, true);
                item.setItemMeta((ItemMeta)pmeta);
            }
            return new Pins(new Object[0]);
        });
        functions.put("getpotioneffect", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String effect = (String)pins.values[1];
            PotionEffectType type = PotionEffectType.getByName((String)effect);
            if (!item.hasItemMeta()) {
                return new Pins(new PotionEffect(PotionEffectType.getById((int)1), 0, 0));
            }
            ItemMeta meta = item.getItemMeta();
            if (type != null && meta instanceof PotionMeta) {
                PotionMeta pmeta = (PotionMeta)meta;
                if (pmeta.hasCustomEffects()) {
                    return new Pins(new PotionEffect(type, 0, 0));
                }
                PotionEffect potion = pmeta.getCustomEffects().stream().filter(e -> e.getType().equals(type)).findFirst().orElse(null);
                if (potion != null) {
                    return new Pins(potion);
                }
                return new Pins(new PotionEffect(type, 0, 0));
            }
            return new Pins(new PotionEffect(PotionEffectType.getById((int)1), 0, 0));
        });
        functions.put("removepotioneffect", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String effect = (String)pins.values[1];
            PotionEffectType type = PotionEffectType.getByName((String)effect);
            if (!item.hasItemMeta()) {
                return new Pins(new Object[0]);
            }
            ItemMeta meta = item.getItemMeta();
            if (type != null && meta instanceof PotionMeta) {
                PotionMeta pmeta = (PotionMeta)meta;
                pmeta.removeCustomEffect(type);
                item.setItemMeta((ItemMeta)pmeta);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setbasepotiontype", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String effect = (String)pins.values[1];
            PotionType type = PotionType.valueOf((String)effect.replace("minecraft:", "").toUpperCase().replace(" ", "_"));
            if (type == null) {
                return new Pins(new Object[0]);
            }
            if (!item.hasItemMeta()) {
                return new Pins(new Object[0]);
            }
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof PotionMeta) {
                PotionMeta pmeta = (PotionMeta)meta;
                try {
                    pmeta.setBasePotionType(type);
                    item.setItemMeta((ItemMeta)pmeta);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("getbasepotiontype", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            if (!item.hasItemMeta()) {
                return new Pins(Boolean.FALSE, "");
            }
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof PotionMeta) {
                PotionMeta pmeta = (PotionMeta)meta;
                try {
                    if (!pmeta.hasBasePotionType()) {
                        return new Pins(Boolean.FALSE, "");
                    }
                    return new Pins(Boolean.TRUE, pmeta.getBasePotionType().toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            return new Pins(Boolean.FALSE, "");
        });
        functions.put("setpotioncolor", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String color = (String)pins.values[1];
            Color col = Color.fromRGB((int)Integer.parseInt(color.replace("#", ""), 16));
            if (!item.hasItemMeta()) {
                return new Pins(new Object[0]);
            }
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof PotionMeta) {
                PotionMeta pmeta = (PotionMeta)meta;
                pmeta.setColor(col);
                item.setItemMeta((ItemMeta)pmeta);
            }
            return new Pins(new Object[0]);
        });
        functions.put("getpotioncolor", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            if (!item.hasItemMeta()) {
                return new Pins("");
            }
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof PotionMeta) {
                PotionMeta pmeta = (PotionMeta)meta;
                if (!pmeta.hasColor()) {
                    return new Pins("");
                }
                Color col = pmeta.getColor();
                String color = String.format("#%06X", 0xFFFFFF & col.asRGB());
                return new Pins(color);
            }
            return new Pins("");
        });
        functions.put("newtext", pins -> new Pins(pins.values[0]));
        functions.put("textreplace", pins -> {
            String text = (String)pins.values[0];
            String seq1 = (String)pins.values[1];
            String seq2 = (String)pins.values[2];
            return new Pins(text.replace(seq1, seq2));
        });
        functions.put("textconcat", pins -> {
            String text1 = (String)pins.values[0];
            String text2 = (String)pins.values[1];
            return new Pins(text1.concat(text2));
        });
        functions.put("textsubstring", pins -> {
            String text = (String)pins.values[0];
            Double start = (Double)pins.values[1];
            Double end = (Double)pins.values[2];
            return new Pins(text.substring(start.intValue(), end.intValue()));
        });
        functions.put("textrepeat", pins -> {
            String text = (String)pins.values[0];
            Double times = (Double)pins.values[1];
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while ((double)i < times) {
                builder.append(text);
                ++i;
            }
            return new Pins(builder.toString());
        });
        functions.put("textindexof", pins -> {
            String text = (String)pins.values[0];
            String seq = (String)pins.values[1];
            return new Pins(text.indexOf(seq));
        });
        functions.put("textlength", pins -> {
            String text = (String)pins.values[0];
            return new Pins(text.length());
        });
        functions.put("lowercasetext", pins -> {
            String text = (String)pins.values[0];
            return new Pins(text.toLowerCase());
        });
        functions.put("uppercasetext", pins -> {
            String text = (String)pins.values[0];
            return new Pins(text.toUpperCase());
        });
        functions.put("randomtext", pins -> {
            Double length = (Double)pins.values[0];
            String text = RandomStringUtils.randomString(length.intValue());
            return new Pins(text);
        });
        functions.put("randomuuid", pins -> new Pins(UUID.randomUUID().toString()));
        functions.put("formattext", pins -> {
            String text = (String)pins.values[0];
            String arg = (String)pins.values[1];
            return new Pins(text.replaceFirst("%s", arg));
        });
        functions.put("execcommand", pins -> {
            String command = (String)pins.values[0];
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            return new Pins(new Object[0]);
        });
        functions.put("createexplosion", pins -> {
            World world = (World)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            Double power = (Double)pins.values[2];
            Boolean setFire = (Boolean)pins.values[3];
            Boolean breakBlock = (Boolean)pins.values[4];
            world.createExplosion(new Location(world, (double)vect.values[0], (double)vect.values[1], (double)vect.values[2]), power.floatValue(), setFire.booleanValue(), breakBlock.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("createexplosion2", pins -> {
            World world = (World)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            Double power = (Double)pins.values[2];
            Boolean setFire = (Boolean)pins.values[3];
            Boolean breakBlock = (Boolean)pins.values[4];
            org.bukkit.entity.Entity source = (org.bukkit.entity.Entity)pins.values[5];
            world.createExplosion(new Location(world, (double)vect.values[0], (double)vect.values[1], (double)vect.values[2]), power.floatValue(), setFire.booleanValue(), breakBlock.booleanValue(), source);
            return new Pins(new Object[0]);
        });
        functions.put("createexplosion3", pins -> {
            EntityType type;
            World world = (World)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            Double yield = (Double)pins.values[2];
            Boolean setFire = (Boolean)pins.values[3];
            Double fuseTicks = (Double)pins.values[4];
            try {
                type = EntityType.valueOf((String)"TNT");
            }
            catch (IllegalArgumentException e) {
                try {
                    type = EntityType.valueOf((String)"PRIMED_TNT");
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }
            TNTPrimed tntPrimed = (TNTPrimed)world.spawnEntity(vect.getLocation(world), type);
            tntPrimed.setFuseTicks(fuseTicks.intValue());
            tntPrimed.setIsIncendiary(setFire.booleanValue());
            tntPrimed.setYield(yield.floatValue());
            return new Pins(tntPrimed);
        });
        functions.put("createexplosion4", pins -> {
            EntityType type;
            World world = (World)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            Double yield = (Double)pins.values[2];
            Boolean setFire = (Boolean)pins.values[3];
            Double fuseTicks = (Double)pins.values[4];
            org.bukkit.entity.Entity source = (org.bukkit.entity.Entity)pins.values[5];
            try {
                type = EntityType.valueOf((String)"TNT");
            }
            catch (IllegalArgumentException e) {
                try {
                    type = EntityType.valueOf((String)"PRIMED_TNT");
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }
            TNTPrimed tntPrimed = (TNTPrimed)world.spawnEntity(vect.getLocation(world), type);
            tntPrimed.setFuseTicks(fuseTicks.intValue());
            tntPrimed.setIsIncendiary(setFire.booleanValue());
            tntPrimed.setYield(yield.floatValue());
            tntPrimed.setSource(source);
            return new Pins(tntPrimed);
        });
        functions.put("summonentity", pins -> {
            World world = (World)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            String type = (String)pins.values[2];
            EntityType entityType = null;
            try {
                entityType = EntityType.valueOf((String)type.toUpperCase().replace("minecraft:", ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (entityType == null) {
                return null;
            }
            return new Pins(world.spawnEntity(new Location(world, (double)vect.values[0], (double)vect.values[1], (double)vect.values[2]), entityType));
        });
        functions.put("dropitem", pins -> {
            World world = (World)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            ItemStack item = (ItemStack)pins.values[2];
            return new Pins(world.dropItem(new Location(world, (double)vect.values[0], (double)vect.values[1], (double)vect.values[2]), item));
        });
        functions.put("worldid", pins -> {
            World world = (World)pins.values[0];
            return new Pins(world.getUID().toString());
        });
        functions.put("getworld", pins -> {
            String str = (String)pins.values[0];
            try {
                UUID uuid = UUID.fromString(str);
                World world = Bukkit.getWorld((UUID)uuid);
                if (world != null) {
                    return new Pins(world);
                }
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
            World world = Bukkit.getWorld((String)str);
            if (world != null) {
                return new Pins(world);
            }
            return new Pins(Bukkit.getWorlds().get(0));
        });
        functions.put("spawnparticle", pins -> {
            if (pins.values.length != 6) {
                return new Pins(new Object[0]);
            }
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            String particleID = (String)pins.values[2];
            String particleData = (String)pins.values[3];
            Double count = (Double)pins.values[4];
            Double speed = (Double)pins.values[5];
            Particle p = ParticleUtils.getParticle(particleID);
            if (p != null) {
                Object data = ParticleUtils.getParticleData(p, particleData);
                world.spawnParticle(p, new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]), count.intValue(), 0.0, 0.0, 0.0, speed.doubleValue(), data);
            }
            return new Pins(new Object[0]);
        });
        functions.put("spawnparticlebox", pins -> {
            if (pins.values.length != 7) {
                return new Pins(new Object[0]);
            }
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            String particleID = (String)pins.values[2];
            String particleData = (String)pins.values[3];
            float[] offset = ((Vector)pins.values[4]).values;
            Double count = (Double)pins.values[5];
            Double speed = (Double)pins.values[6];
            Particle p = null;
            try {
                p = ParticleUtils.getParticle(particleID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (p != null) {
                world.spawnParticle(p, new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]), count.intValue(), (double)offset[0], (double)offset[1], (double)offset[2], speed.doubleValue(), ParticleUtils.getParticleData(p, particleData));
            }
            return new Pins(new Object[0]);
        });
        functions.put("spawnparticleline", pins -> {
            if (pins.values.length != 8) {
                return new Pins(new Object[0]);
            }
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            String particleID = (String)pins.values[2];
            String particleData = (String)pins.values[3];
            float[] direction = ((Vector)pins.values[4]).normalize().values;
            Double distance = (Double)pins.values[5];
            Double count = (Double)pins.values[6];
            Double speed = (Double)pins.values[7];
            Particle p = null;
            try {
                p = ParticleUtils.getParticle(particleID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (p != null) {
                Location dir = new Location(world, (double)direction[0], (double)direction[1], (double)direction[2]);
                double increment = 0.0;
                if (count > 1.0) {
                    increment = distance / (count - 1.0);
                }
                Object obj = ParticleUtils.getParticleData(p, particleData);
                int i = 0;
                while (i < count.intValue()) {
                    Location loc = new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]);
                    world.spawnParticle(p, loc.add(dir.clone().multiply(increment * (double)i)), 1, 0.0, 0.0, 0.0, speed.doubleValue(), obj);
                    ++i;
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("spawnparticledirection", pins -> {
            if (pins.values.length != 6) {
                return new Pins(new Object[0]);
            }
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            String particleID = (String)pins.values[2];
            String particleData = (String)pins.values[3];
            float[] dir = ((Vector)pins.values[4]).normalize().values;
            Double speed = (Double)pins.values[5];
            Particle p = null;
            try {
                p = ParticleUtils.getParticle(particleID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (p != null) {
                world.spawnParticle(p, new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]), 0, (double)dir[0], (double)dir[1], (double)dir[2], speed.doubleValue(), ParticleUtils.getParticleData(p, particleData));
            }
            return new Pins(new Object[0]);
        });
        functions.put("spawnparticledirectionrandom", pins -> {
            if (pins.values.length != 8) {
                return new Pins(new Object[0]);
            }
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            String particleID = (String)pins.values[2];
            String particleData = (String)pins.values[3];
            float[] dir = ((Vector)pins.values[4]).normalize().values;
            Double count = (Double)pins.values[5];
            Double speed = (Double)pins.values[6];
            Double angle = (Double)pins.values[7];
            Particle p = null;
            try {
                p = ParticleUtils.getParticle(particleID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (p != null) {
                Object obj = ParticleUtils.getParticleData(p, particleData);
                int i = 0;
                while (i < count.intValue()) {
                    Vector v = new Vector(dir);
                    v.rotateVector(new float[]{(float)(Math.random() * 2.0 - 1.0), (float)(Math.random() * 2.0 - 1.0), (float)(Math.random() * 2.0 - 1.0)}, Math.toRadians((Math.random() * 2.0 - 1.0) * angle));
                    float[] dir2 = v.values;
                    world.spawnParticle(p, new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]), 0, (double)dir2[0], (double)dir2[1], (double)dir2[2], speed.doubleValue(), obj);
                    ++i;
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("spawncustomparticles", pins -> {
            World world = (World)pins.values[0];
            Vector pos = (Vector)pins.values[1];
            String particleID = (String)pins.values[2];
            int ticks = ((Double)pins.values[3]).intValue();
            Vector dir = ((Vector)pins.values[4]).normalize();
            CustomParticle particle = null;
            try {
                particle = ParticleEditor.particles.get(UUID.fromString(particleID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (particle != null) {
                Location loc = pos.getLocation(world);
                loc.setDirection(dir.getVector());
                ArrayList<ParticleInstance> instances = new ArrayList<ParticleInstance>();
                for (ParticleEmitter emitter : particle.data.emitters) {
                    ParticleInstance instance = new ParticleInstance();
                    instance.setEmitter(emitter);
                    instances.add(instance);
                }
                ParticleEngine engine = new ParticleEngine(loc, -Math.toRadians(loc.getYaw()), Math.toRadians(loc.getPitch()), 0.0, particle.data.ticks, instances, e -> {});
                if (ticks > 0) {
                    engine.start(ticks);
                } else {
                    engine.start(particle.data.ticks);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("spawncustomparticles2", pins -> {
            World world = (World)pins.values[0];
            Vector pos = (Vector)pins.values[1];
            String particleID = (String)pins.values[2];
            int ticks = ((Double)pins.values[3]).intValue();
            Double yaw = (Double)pins.values[4];
            Double pitch = (Double)pins.values[5];
            Double roll = (Double)pins.values[6];
            CustomParticle particle = null;
            try {
                particle = ParticleEditor.particles.get(UUID.fromString(particleID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (particle != null) {
                Location loc = pos.getLocation(world);
                ArrayList<ParticleInstance> instances = new ArrayList<ParticleInstance>();
                for (ParticleEmitter emitter : particle.data.emitters) {
                    ParticleInstance instance = new ParticleInstance();
                    instance.setEmitter(emitter);
                    instances.add(instance);
                }
                ParticleEngine engine = new ParticleEngine(loc, -Math.toRadians(yaw), Math.toRadians(pitch), Math.toRadians(roll), particle.data.ticks, instances, e -> {});
                if (ticks > 0) {
                    engine.start(ticks);
                } else {
                    engine.start(particle.data.ticks);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("attachcustomparticles", pins -> {
            org.bukkit.entity.Entity entity = (org.bukkit.entity.Entity)pins.values[0];
            String particleID = (String)pins.values[1];
            int ticks = ((Double)pins.values[2]).intValue();
            CustomParticle particle = null;
            try {
                particle = ParticleEditor.particles.get(UUID.fromString(particleID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (particle != null) {
                Location loc = entity.getLocation();
                ArrayList<ParticleInstance> instances = new ArrayList<ParticleInstance>();
                for (ParticleEmitter emitter : particle.data.emitters) {
                    ParticleInstance instance = new ParticleInstance();
                    instance.setEmitter(emitter);
                    instances.add(instance);
                }
                ParticleEngine engine = new ParticleEngine(loc, -Math.toRadians(loc.getYaw()), 0.0, 0.0, particle.data.ticks, instances, e -> {
                    e.location = entity.getLocation();
                    e.yaw = -Math.toRadians(e.location.getYaw());
                });
                if (ticks > 0) {
                    engine.start(ticks);
                } else {
                    engine.start(particle.data.ticks);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("attachcustomparticleseye", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            if (!(ent instanceof LivingEntity)) {
                return new Pins(new Object[0]);
            }
            LivingEntity entity = (LivingEntity)ent;
            String particleID = (String)pins.values[1];
            int ticks = ((Double)pins.values[2]).intValue();
            CustomParticle particle = null;
            try {
                particle = ParticleEditor.particles.get(UUID.fromString(particleID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (particle != null) {
                Location loc = entity.getEyeLocation();
                ArrayList<ParticleInstance> instances = new ArrayList<ParticleInstance>();
                for (ParticleEmitter emitter : particle.data.emitters) {
                    ParticleInstance instance = new ParticleInstance();
                    instance.setEmitter(emitter);
                    instances.add(instance);
                }
                ParticleEngine engine = new ParticleEngine(loc, -Math.toRadians(loc.getYaw()), Math.toRadians(loc.getPitch()), 0.0, particle.data.ticks, instances, e -> {
                    e.location = entity.getEyeLocation();
                    e.yaw = -Math.toRadians(e.location.getYaw());
                    e.pitch = Math.toRadians(e.location.getPitch());
                });
                if (ticks > 0) {
                    engine.start(ticks);
                } else {
                    engine.start(particle.data.ticks);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("raytraceblockworld", pins -> {
            Block block;
            Location direction;
            World world = (World)pins.values[0];
            Double maxDistance = (Double)pins.values[1];
            Location position = ((Vector)pins.values[2]).getLocation(world);
            RayTraceResult result = world.rayTraceBlocks(position, (direction = ((Vector)pins.values[3]).getLocation(world)).toVector(), maxDistance.doubleValue());
            if (result != null && (block = result.getHitBlock()) != null) {
                BlockFace face = result.getHitBlockFace();
                Vector faceVect = new Vector(face.getModX(), face.getModY(), face.getModZ());
                return new Pins(block, faceVect, true);
            }
            return new Pins(position.getBlock(), new Vector(0.0f, 0.0f, 0.0f), false);
        });
        functions.put("raytraceentityworld", pins -> {
            org.bukkit.entity.Entity ent2;
            Location direction;
            World world = (World)pins.values[0];
            Double maxDistance = (Double)pins.values[1];
            Location position = ((Vector)pins.values[2]).getLocation(world);
            RayTraceResult result = world.rayTraceEntities(position, (direction = ((Vector)pins.values[3]).getLocation(world)).toVector(), maxDistance.doubleValue(), ent -> !ent.getBoundingBox().contains(position.toVector()));
            if (result != null && (ent2 = result.getHitEntity()) != null) {
                return new Pins(ent2, true);
            }
            return new Pins(null, false);
        });
        functions.put("raytracevectworld", pins -> {
            org.bukkit.util.Vector loc;
            Location direction;
            World world = (World)pins.values[0];
            Double maxDistance = (Double)pins.values[1];
            Location position = ((Vector)pins.values[2]).getLocation(world);
            RayTraceResult result = world.rayTrace(position, (direction = ((Vector)pins.values[3]).getLocation(world)).toVector(), maxDistance.doubleValue(), FluidCollisionMode.ALWAYS, false, 0.1, ent -> !ent.getBoundingBox().contains(position.toVector()));
            if (result != null && (loc = result.getHitPosition()) != null) {
                return new Pins(new Vector(loc.getX(), loc.getY(), loc.getZ()), true);
            }
            return new Pins(new Vector(0.0f, 0.0f, 0.0f), false);
        });
        functions.put("serverproperty", pins -> {
            Object value;
            String name = (String)pins.values[0];
            if (!name.isEmpty() && (value = serverData.get(name)) != null && value instanceof Double) {
                return new Pins(value);
            }
            return new Pins(0.0);
        });
        functions.put("setserverproperty", pins -> {
            String name = (String)pins.values[0];
            Double value = (Double)pins.values[1];
            if (!name.isEmpty()) {
                if (value == 0.0) {
                    serverData.remove(name);
                } else {
                    serverData.put(name, value);
                }
                File serverDataFile = new File(Main.INSTANCE.getDataFolder(), "ServerProperties.dat");
                try {
                    SLAPI.save(serverData, serverDataFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("serverpropertystr", pins -> {
            Object value;
            String name = (String)pins.values[0];
            if (!name.isEmpty() && (value = serverData.get(name)) != null && value instanceof String) {
                return new Pins(value);
            }
            return new Pins("");
        });
        functions.put("setserverpropertystr", pins -> {
            String name = (String)pins.values[0];
            String value = (String)pins.values[1];
            if (!name.isEmpty()) {
                if (value.isEmpty()) {
                    serverData.remove(name);
                } else {
                    serverData.put(name, value);
                }
                File serverDataFile = new File(Main.INSTANCE.getDataFolder(), "ServerProperties.dat");
                try {
                    SLAPI.save(serverData, serverDataFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("worldproperty", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            World entity = (World)pins.values[0];
            String name = (String)pins.values[1];
            if (!name.isEmpty() && (container = entity.getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name), PersistentDataType.DOUBLE)) {
                return new Pins(container.get(key, PersistentDataType.DOUBLE));
            }
            return new Pins(0.0);
        });
        functions.put("setworldproperty", pins -> {
            World entity = (World)pins.values[0];
            String name = (String)pins.values[1];
            Double value = (Double)pins.values[2];
            if (!name.isEmpty()) {
                PersistentDataContainer container = entity.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name);
                if (value == 0.0) {
                    container.remove(key);
                } else {
                    container.set(key, PersistentDataType.DOUBLE, (Object)value);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("worldpropertystr", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            World entity = (World)pins.values[0];
            String name = (String)pins.values[1];
            if (!name.isEmpty() && (container = entity.getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name), PersistentDataType.STRING)) {
                return new Pins(container.get(key, PersistentDataType.STRING));
            }
            return new Pins("");
        });
        functions.put("setworldpropertystr", pins -> {
            World entity = (World)pins.values[0];
            String name = (String)pins.values[1];
            String value = (String)pins.values[2];
            if (!name.isEmpty()) {
                PersistentDataContainer container = entity.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name);
                if (value.isEmpty()) {
                    container.remove(key);
                } else {
                    container.set(key, PersistentDataType.STRING, (Object)value);
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("debug", pins -> {
            String message = (String)pins.values[0];
            Main.INSTANCE.getLogger().info(message);
            return new Pins(new Object[0]);
        });
        functions.put("worldplaysound", pins -> {
            World world = (World)pins.values[0];
            Location loc = ((Vector)pins.values[1]).getLocation(world);
            String value = (String)pins.values[2];
            Double volume = Double.valueOf((String)pins.values[3]);
            Double pitch = Double.valueOf((String)pins.values[4]);
            world.playSound(loc, value.strip().toLowerCase(), volume.floatValue(), pitch.floatValue());
            return new Pins(new Object[0]);
        });
        functions.put("worldplaysound2", pins -> {
            World world = (World)pins.values[0];
            Location loc = ((Vector)pins.values[1]).getLocation(world);
            String value = (String)pins.values[2];
            Double volume = (Double)pins.values[3];
            Double pitch = (Double)pins.values[4];
            world.playSound(loc, value.strip().toLowerCase(), volume.floatValue(), pitch.floatValue());
            return new Pins(new Object[0]);
        });
        functions.put("currenttimemillis", pins -> new Pins(System.currentTimeMillis()));
        functions.put("broadcast", pins -> {
            String message = (String)pins.values[0];
            Bukkit.broadcastMessage((String)ColorUtils.color(message));
            return new Pins(new Object[0]);
        });
        functions.put("broadcastperm", pins -> {
            String message = (String)pins.values[0];
            String permission = (String)pins.values[1];
            Bukkit.broadcast((String)ColorUtils.color(message), (String)permission);
            return new Pins(new Object[0]);
        });
        functions.put("servercooldown", pins -> {
            int cooldown = (int)((Double)pins.values[0] * 1000.0);
            String id = (String)pins.values[1];
            Object value = serverData.get("srvcldwn" + id);
            if (value != null && value instanceof Long && System.currentTimeMillis() - (Long)value < (long)cooldown) {
                return null;
            }
            serverData.put("srvcldwn" + id, System.currentTimeMillis());
            return new Pins(new Object[0]);
        });
        functions.put("servercooldown2", pins -> {
            int cooldown = (int)((Double)pins.values[0] * 1000.0);
            String id = (String)pins.values[1];
            Object value = serverData.get("srvcldwn" + id);
            if (value != null && value instanceof Long && System.currentTimeMillis() - (Long)value < (long)cooldown) {
                return new Pins(Boolean.FALSE);
            }
            serverData.put("srvcldwn" + id, System.currentTimeMillis());
            return new Pins(Boolean.TRUE);
        });
        functions.put("resetservercooldown", pins -> {
            String id = (String)pins.values[0];
            serverData.remove("srvcldwn" + id);
            return new Pins(new Object[0]);
        });
        functions.put("getplayerscount", pins -> new Pins(Bukkit.getOnlinePlayers().size()));
        functions.put("setitemname", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String name = (String)pins.values[1];
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            meta.setDisplayName(ColorUtils.color(name));
            item.setItemMeta(meta);
            return new Pins(item);
        });
        functions.put("getitemname", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            ItemMeta meta = item.getItemMeta();
            if (meta != null && meta.hasDisplayName()) {
                return new Pins(meta.getDisplayName());
            }
            return new Pins("");
        });
        functions.put("setitemtype", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String type = (String)pins.values[1];
            Material material = null;
            try {
                material = Material.getMaterial((String)type.replace(" ", "_").toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (material != null) {
                item.setType(material);
            }
            return new Pins(item);
        });
        functions.put("getitemtype", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            return new Pins(item.getType().toString().toLowerCase());
        });
        functions.put("hasitemtag", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String tag = (String)pins.values[1];
            return new Pins(TagManager.checkItemTags(item, tag));
        });
        functions.put("setloreline", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            int line = ((Double)pins.values[1]).intValue();
            String text = ColorUtils.color((String)pins.values[2]);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            if (meta.hasLore()) {
                if (meta.getLore().size() > line) {
                    List lore = meta.getLore();
                    lore.set(line, text);
                    meta.setLore(lore);
                } else {
                    List lore = meta.getLore();
                    int i = lore.size();
                    while (i < line) {
                        lore.add("");
                        ++i;
                    }
                    lore.add(text);
                    meta.setLore(lore);
                }
            } else {
                ArrayList<String> lore = new ArrayList<String>();
                int i = 0;
                while (i < line) {
                    lore.add("");
                    ++i;
                }
                lore.add(text);
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            return new Pins(item);
        });
        functions.put("getloreline", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            int line = ((Double)pins.values[1]).intValue();
            ItemMeta meta = item.getItemMeta();
            if (meta != null && meta.hasLore() && meta.getLore().size() > line) {
                return new Pins(meta.getLore().get(line));
            }
            return new Pins("");
        });
        functions.put("addenchantment", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String enchantment = ((String)pins.values[1]).toLowerCase();
            int level = ((Double)pins.values[2]).intValue();
            Enchantment ench = null;
            String[] name = enchantment.split(":");
            if (name.length == 1) {
                ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name[0]));
            } else if (name.length == 2) {
                ench = Enchantment.getByKey((NamespacedKey)new NamespacedKey(name[0], name[1]));
            }
            if (ench != null) {
                item.addUnsafeEnchantment(ench, level);
            }
            return new Pins(item);
        });
        functions.put("removeenchantment", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String enchantment = (String)pins.values[1];
            Enchantment ench = null;
            String[] name = enchantment.split(":");
            if (name.length == 1) {
                ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name[0]));
            } else if (name.length == 2) {
                ench = Enchantment.getByKey((NamespacedKey)new NamespacedKey(name[0], name[1]));
            }
            if (ench != null) {
                item.removeEnchantment(ench);
            }
            return new Pins(item);
        });
        functions.put("getenchantment", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String enchantment = (String)pins.values[1];
            Enchantment ench = null;
            String[] name = enchantment.split(":");
            if (name.length == 1) {
                ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name[0]));
            } else if (name.length == 2) {
                ench = Enchantment.getByKey((NamespacedKey)new NamespacedKey(name[0], name[1]));
            }
            if (ench != null) {
                return new Pins(item.getEnchantmentLevel(ench));
            }
            return new Pins(0.0);
        });
        functions.put("setitemamount", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            int amount = ((Double)pins.values[1]).intValue();
            if (amount >= 0 && amount <= item.getMaxStackSize()) {
                item.setAmount(amount);
            }
            return new Pins(item);
        });
        functions.put("itemconsume", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            item.setAmount(item.getAmount() - 1);
            return new Pins(new Object[0]);
        });
        functions.put("itemamount", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            return new Pins(item.getAmount());
        });
        functions.put("setitemdamage", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            int damage = ((Double)pins.values[1]).intValue();
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                damageable.setDamage(damage);
                item.setItemMeta((ItemMeta)damageable);
            }
            return new Pins(item);
        });
        functions.put("getitemdamage", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            ItemMeta meta = item.getItemMeta();
            if (meta != null && meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                return new Pins(damageable.getDamage());
            }
            return new Pins(0.0);
        });
        functions.put("additemdamage", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            int damage = ((Double)pins.values[1]).intValue();
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                damageable.setDamage(damageable.getDamage() + damage);
                item.setItemMeta((ItemMeta)damageable);
            }
            return new Pins(new Object[0]);
        });
        functions.put("newitem", pins -> {
            String type = (String)pins.values[0];
            int amount = ((Double)pins.values[1]).intValue();
            Material material = null;
            try {
                material = Material.getMaterial((String)type.replace(" ", "_").toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (material != null && material.isItem() && amount >= 0 && (amount <= material.getMaxStackSize() || material == Material.AIR)) {
                return new Pins(new ItemStack(material, amount));
            }
            return new Pins(new ItemStack(Material.STONE));
        });
        functions.put("itemproperty", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            ItemStack item = (ItemStack)pins.values[0];
            String name = (String)pins.values[1];
            if (!name.isEmpty() && item.hasItemMeta() && (container = item.getItemMeta().getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name), PersistentDataType.DOUBLE)) {
                return new Pins(container.get(key, PersistentDataType.DOUBLE));
            }
            return new Pins(0.0);
        });
        functions.put("setitemproperty", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String name = (String)pins.values[1];
            Double value = (Double)pins.values[2];
            if (!name.isEmpty()) {
                ItemMeta meta = item.getItemMeta();
                if (meta == null) {
                    meta = Bukkit.getItemFactory().getItemMeta(item.getType());
                }
                PersistentDataContainer container = meta.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name);
                if (value == 0.0) {
                    container.remove(key);
                } else {
                    container.set(key, PersistentDataType.DOUBLE, (Object)value);
                }
                item.setItemMeta(meta);
            }
            return new Pins(new Object[0]);
        });
        functions.put("itempropertystr", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            ItemStack item = (ItemStack)pins.values[0];
            String name = (String)pins.values[1];
            if (!name.isEmpty() && item.hasItemMeta() && (container = item.getItemMeta().getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name), PersistentDataType.STRING)) {
                return new Pins(container.get(key, PersistentDataType.STRING));
            }
            return new Pins("");
        });
        functions.put("setitempropertystr", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String name = (String)pins.values[1];
            String value = (String)pins.values[2];
            if (!name.isEmpty()) {
                ItemMeta meta = item.getItemMeta();
                if (meta == null) {
                    meta = Bukkit.getItemFactory().getItemMeta(item.getType());
                }
                PersistentDataContainer container = meta.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "cp" + name);
                if (value.isEmpty()) {
                    container.remove(key);
                } else {
                    container.set(key, PersistentDataType.STRING, (Object)value);
                }
                item.setItemMeta(meta);
            }
            return new Pins(new Object[0]);
        });
        functions.put("itemtotext", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            Map<String, Object> map = SerializationManager.serialize((ConfigurationSerializable)item);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    Pins pins2;
                    ObjectOutputStream so;
                    ByteArrayOutputStream bo;
                    block18: {
                        block17: {
                            bo = new ByteArrayOutputStream();
                            so = new ObjectOutputStream(bo);
                            so.writeObject(map);
                            so.flush();
                            pins2 = new Pins(Base64.getEncoder().encodeToString(bo.toByteArray()));
                            if (so == null) break block17;
                            so.close();
                        }
                        if (bo == null) break block18;
                        bo.close();
                    }
                    return pins2;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (so != null) {
                                    so.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (bo != null) {
                                    bo.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return new Pins("");
            }
        });
        functions.put("texttoitem", pins -> {
            String str = (String)pins.values[0];
            byte[] b = Base64.getDecoder().decode(str);
            ByteArrayInputStream bi = new ByteArrayInputStream(b);
            try {
                ObjectInputStream si = new ObjectInputStream(bi);
                return new Pins(SerializationManager.deserialize((Map)HashMap.class.cast(si.readObject())));
            }
            catch (IOException | ClassCastException | ClassNotFoundException exception) {
                return new Pins(new ItemStack(Material.AIR));
            }
        });
        functions.put("itemclone", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            return new Pins(item.clone());
        });
        functions.put("itemcooldown", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            ItemStack item = (ItemStack)pins.values[0];
            int cooldown = (int)((Double)pins.values[1] * 1000.0);
            String id = (String)pins.values[2];
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            if ((container = meta.getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "itmcldwn" + id), PersistentDataType.LONG)) {
                long last = (Long)container.get(key, PersistentDataType.LONG);
                if (System.currentTimeMillis() - last < (long)cooldown) {
                    return null;
                }
            }
            container.set(key, PersistentDataType.LONG, (Object)System.currentTimeMillis());
            item.setItemMeta(meta);
            return new Pins(new Object[0]);
        });
        functions.put("itemcooldown2", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            ItemStack item = (ItemStack)pins.values[0];
            int cooldown = (int)((Double)pins.values[1] * 1000.0);
            String id = (String)pins.values[2];
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            if ((container = meta.getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "itmcldwn" + id), PersistentDataType.LONG)) {
                long last = (Long)container.get(key, PersistentDataType.LONG);
                if (System.currentTimeMillis() - last < (long)cooldown) {
                    return new Pins(Boolean.FALSE);
                }
            }
            container.set(key, PersistentDataType.LONG, (Object)System.currentTimeMillis());
            item.setItemMeta(meta);
            return new Pins(Boolean.TRUE);
        });
        functions.put("resetitemcooldown", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            String id = (String)pins.values[1];
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            PersistentDataContainer container = meta.getPersistentDataContainer();
            NamespacedKey key = new NamespacedKey((Plugin)Main.INSTANCE, "itmcldwn" + id);
            container.remove(key);
            item.setItemMeta(meta);
            return new Pins(new Object[0]);
        });
        functions.put("itemcooldownanim", pins -> {
            NamespacedKey key;
            PersistentDataContainer container;
            ItemStack item = (ItemStack)pins.values[0];
            int cooldown = (int)((Double)pins.values[1] * 1000.0);
            Player player = (Player)pins.values[2];
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            if ((container = meta.getPersistentDataContainer()).has(key = new NamespacedKey((Plugin)Main.INSTANCE, "animitmcldwn"), PersistentDataType.LONG)) {
                long last = (Long)container.get(key, PersistentDataType.LONG);
                if (System.currentTimeMillis() - last < (long)cooldown) {
                    return null;
                }
            }
            container.set(key, PersistentDataType.LONG, (Object)System.currentTimeMillis());
            item.setItemMeta(meta);
            CrashScheduler.CancelHandle t = cooldownTasks.get(item);
            if (t != null) {
                t.cancel();
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
            }
            CrashScheduler.runTaskTimer((Plugin)Main.INSTANCE, task -> {
                cooldownTasks.put(item, (CrashScheduler.CancelHandle)task);
                if (container.has(key, PersistentDataType.LONG)) {
                    long last = (Long)container.get(key, PersistentDataType.LONG);
                    long passedTime = System.currentTimeMillis() - last;
                    if (passedTime < (long)cooldown) {
                        ItemStack mainHand = player.getInventory().getItemInMainHand();
                        if (mainHand.equals((Object)item) || player.getInventory().getItemInOffHand().equals((Object)item) && (mainHand == null || !mainHand.hasItemMeta() || mainHand.getItemMeta() == null || !mainHand.getItemMeta().getPersistentDataContainer().has(key, PersistentDataType.LONG))) {
                            float progress = (float)passedTime / (float)cooldown * 20.0f;
                            StringBuilder str = new StringBuilder();
                            str.append("\u00a7e\u00a7l");
                            int i = 0;
                            while ((float)i < progress) {
                                str.append("|");
                                ++i;
                            }
                            str.append("\u00a77\u00a7l");
                            while (i < 20) {
                                str.append("|");
                                ++i;
                            }
                            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(str.toString()));
                        } else {
                            ItemStack offHand = player.getInventory().getItemInOffHand();
                            if (!(mainHand != null && mainHand.hasItemMeta() && mainHand.getItemMeta() != null && mainHand.getItemMeta().getPersistentDataContainer().has(key, PersistentDataType.LONG) || offHand != null && offHand.hasItemMeta() && offHand.getItemMeta() != null && offHand.getItemMeta().getPersistentDataContainer().has(key, PersistentDataType.LONG))) {
                                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                            }
                        }
                    } else {
                        task.cancel();
                        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
                        ItemMeta m = item.getItemMeta();
                        m.getPersistentDataContainer().remove(key);
                        item.setItemMeta(m);
                    }
                }
            }, 0L, 2L);
            return new Pins(new Object[0]);
        });
        functions.put("similaritems", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            ItemStack item2 = (ItemStack)pins.values[1];
            return new Pins(item.isSimilar(item2));
        });
        functions.put("getskullfromplayer", pins -> {
            Player player = (Player)pins.values[0];
            ItemStack item = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)item.getItemMeta();
            meta.setOwningPlayer((OfflinePlayer)player);
            item.setItemMeta((ItemMeta)meta);
            return new Pins(item);
        });
        functions.put("getskullfromurl", pins -> {
            String url = (String)pins.values[0];
            ItemStack item = SkullUtils.getSkull(url);
            return new Pins(item);
        });
        functions.put("setarmorcolor", pins -> {
            ItemMeta meta;
            ItemStack item = (ItemStack)pins.values[0];
            int r = ((Double)pins.values[1]).intValue();
            int g = ((Double)pins.values[2]).intValue();
            int b = ((Double)pins.values[3]).intValue();
            if (r < 0) {
                r = 0;
            }
            if (r > 255) {
                r = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if (g > 255) {
                g = 255;
            }
            if (b < 0) {
                b = 0;
            }
            if (b > 255) {
                b = 255;
            }
            if ((meta = item.getItemMeta()) instanceof LeatherArmorMeta) {
                LeatherArmorMeta armor = (LeatherArmorMeta)meta;
                armor.setColor(Color.fromRGB((int)r, (int)g, (int)b));
                item.setItemMeta((ItemMeta)armor);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setfoodcomponent", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            Double nutrition = (Double)pins.values[1];
            Double saturation = (Double)pins.values[2];
            Boolean canalwayseat = (Boolean)pins.values[3];
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            try {
                FoodComponent food = meta.getFood();
                food.setNutrition(nutrition.intValue());
                food.setSaturation(saturation.floatValue());
                food.setCanAlwaysEat(canalwayseat.booleanValue());
                meta.setFood(food);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            item.setItemMeta(meta);
            return new Pins(new Object[0]);
        });
        functions.put("getfoodcomponent", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                try {
                    FoodComponent food = meta.getFood();
                    return new Pins(food.getNutrition(), food.getSaturation(), food.canAlwaysEat());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            return new Pins(0.0, 0.0, Boolean.FALSE);
        });
        functions.put("setconsumablecomponent", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            Double seconds = (Double)pins.values[1];
            Boolean particles = (Boolean)pins.values[2];
            String sound = (String)pins.values[3];
            String animation = (String)pins.values[4];
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(item.getType());
            }
            try {
                ConsumableComponent.Animation a;
                ConsumableComponent consumable = meta.getConsumable();
                Sound s = (Sound)Bukkit.getRegistry(Sound.class).get(NamespacedKey.fromString((String)sound));
                if (s != null) {
                    consumable.setSound(s);
                }
                if ((a = ConsumableComponent.Animation.valueOf((String)animation.toUpperCase().replace(" ", "_"))) != null) {
                    consumable.setAnimation(a);
                }
                consumable.setConsumeSeconds(seconds.floatValue());
                consumable.setConsumeParticles(particles.booleanValue());
                meta.setConsumable(consumable);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            item.setItemMeta(meta);
            return new Pins(new Object[0]);
        });
        functions.put("getconsumablecomponent", pins -> {
            ItemStack item = (ItemStack)pins.values[0];
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                try {
                    ConsumableComponent consumable = meta.getConsumable();
                    return new Pins(consumable.getConsumeSeconds(), consumable.hasConsumeParticles(), consumable.getSound() == null ? "" : (consumable.getSound().getKeyOrNull() == null ? "" : consumable.getSound().getKeyOrNull().getKey()), consumable.getAnimation().toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            return new Pins(0.0, Boolean.FALSE, "", "");
        });
        functions.put("istypeblock", pins -> {
            String m = (String)pins.values[0];
            Material mat = Material.getMaterial((String)m.replace(" ", "_").toUpperCase());
            if (mat == null) {
                return new Pins(Boolean.FALSE);
            }
            return new Pins(mat.isBlock());
        });
        functions.put("istypeburnable", pins -> {
            String m = (String)pins.values[0];
            Material mat = Material.getMaterial((String)m.replace(" ", "_").toUpperCase());
            if (mat == null) {
                return new Pins(Boolean.FALSE);
            }
            return new Pins(mat.isBurnable());
        });
        functions.put("istypefuel", pins -> {
            String m = (String)pins.values[0];
            Material mat = Material.getMaterial((String)m.replace(" ", "_").toUpperCase());
            if (mat == null) {
                return new Pins(Boolean.FALSE);
            }
            return new Pins(mat.isFuel());
        });
        functions.put("istypeoccluding", pins -> {
            String m = (String)pins.values[0];
            Material mat = Material.getMaterial((String)m.replace(" ", "_").toUpperCase());
            if (mat == null) {
                return new Pins(Boolean.FALSE);
            }
            return new Pins(mat.isOccluding());
        });
        functions.put("istypesolid", pins -> {
            String m = (String)pins.values[0];
            Material mat = Material.getMaterial((String)m.replace(" ", "_").toUpperCase());
            if (mat == null) {
                return new Pins(Boolean.FALSE);
            }
            return new Pins(mat.isSolid());
        });
        functions.put("newinventory", pins -> {
            String title = (String)pins.values[0];
            int size = ((Double)pins.values[1]).intValue();
            if (size < 9) {
                size = 9;
            }
            if (size > 54) {
                size = 54;
            }
            if (size % 9 != 0) {
                size -= size % 9;
            }
            return new Pins(Bukkit.createInventory(null, (int)size, (String)ColorUtils.color(title)));
        });
        functions.put("setinventorytitle", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            String title = (String)pins.values[1];
            if (inv.getType() == InventoryType.CHEST) {
                Inventory inv2 = Bukkit.createInventory(null, (int)inv.getSize(), (String)ColorUtils.color(title));
                inv2.setContents(inv.getContents());
                return new Pins(inv2);
            }
            return new Pins(inv);
        });
        functions.put("setitemslot", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            int slot = ((Double)pins.values[1]).intValue();
            ItemStack item = (ItemStack)pins.values[2];
            if (slot >= 0 && slot < inv.getSize()) {
                inv.setItem(slot, item);
            }
            return new Pins(new Object[0]);
        });
        functions.put("getitemslot", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            int slot = ((Double)pins.values[1]).intValue();
            ItemStack item = null;
            if (slot >= 0 && slot < inv.getSize()) {
                item = inv.getItem(slot);
            }
            if (item == null) {
                item = new ItemStack(Material.AIR);
            }
            return new Pins(item);
        });
        functions.put("getinvsize", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            return new Pins(inv.getSize());
        });
        functions.put("additeminv", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            ItemStack item = (ItemStack)pins.values[1];
            ItemStack itemNotGiven = new ItemStack(Material.AIR, 0);
            Iterator iterator = inv.addItem(new ItemStack[]{item}).values().iterator();
            if (iterator.hasNext()) {
                ItemStack i;
                itemNotGiven = i = (ItemStack)iterator.next();
            }
            return new Pins(itemNotGiven);
        });
        functions.put("removeiteminv", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            ItemStack item = (ItemStack)pins.values[1];
            inv.removeItem(new ItemStack[]{item});
            return new Pins(new Object[0]);
        });
        functions.put("finditemininv", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            ItemStack item = (ItemStack)pins.values[1];
            int i = 0;
            while (i < inv.getSize()) {
                ItemStack it = inv.getItem(i);
                if (item.isSimilar(it)) {
                    int sum = it.getAmount();
                    int l = i + 1;
                    while (l < inv.getSize()) {
                        ItemStack it2 = inv.getItem(l);
                        if (item.isSimilar(it2)) {
                            sum += it2.getAmount();
                        }
                        ++l;
                    }
                    return new Pins(Boolean.TRUE, it, i, sum);
                }
                ++i;
            }
            return new Pins(Boolean.FALSE, item, 0.0, 0.0);
        });
        functions.put("finditemininv2", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            String type = (String)pins.values[1];
            Material material = null;
            try {
                material = Material.getMaterial((String)type.replace(" ", "_").toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            int i = 0;
            while (i < inv.getSize()) {
                ItemStack it = inv.getItem(i);
                if (it != null && it.getType() == material) {
                    int sum = it.getAmount();
                    int l = i + 1;
                    while (l < inv.getSize()) {
                        ItemStack it2 = inv.getItem(l);
                        if (it2 != null && it2.getType() == material) {
                            sum += it2.getAmount();
                        }
                        ++l;
                    }
                    return new Pins(Boolean.TRUE, it, i, sum);
                }
                ++i;
            }
            return new Pins(Boolean.FALSE, null, 0.0, 0.0);
        });
        functions.put("invtotext", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            SItemStack[] list = new SItemStack[inv.getSize()];
            int i = 0;
            while (i < inv.getSize()) {
                ItemStack item = inv.getItem(i);
                if (item != null) {
                    list[i] = new SItemStack(item);
                }
                ++i;
            }
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try {
                    Pins pins2;
                    ObjectOutputStream so;
                    ByteArrayOutputStream bo;
                    block20: {
                        block19: {
                            bo = new ByteArrayOutputStream();
                            so = new ObjectOutputStream(bo);
                            so.writeObject(list);
                            so.flush();
                            pins2 = new Pins(Base64.getEncoder().encodeToString(bo.toByteArray()));
                            if (so == null) break block19;
                            so.close();
                        }
                        if (bo == null) break block20;
                        bo.close();
                    }
                    return pins2;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (so != null) {
                                    so.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (bo != null) {
                                    bo.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return new Pins("");
            }
        });
        functions.put("texttoinv", pins -> {
            String str = (String)pins.values[0];
            byte[] b = Base64.getDecoder().decode(str);
            ByteArrayInputStream bi = new ByteArrayInputStream(b);
            try {
                ObjectInputStream si = new ObjectInputStream(bi);
                SItemStack[] list = (SItemStack[])SItemStack[].class.cast(si.readObject());
                Inventory inv = Bukkit.createInventory(null, (int)((int)(Math.ceil((double)list.length / 9.0) * 9.0)));
                int i = 0;
                while (i < list.length) {
                    if (list[i] != null) {
                        inv.setItem(i, list[i].getItemStack());
                    }
                    ++i;
                }
                return new Pins(inv);
            }
            catch (IOException | ClassCastException | ClassNotFoundException exception) {
                return new Pins(Bukkit.createInventory(null, (int)9));
            }
        });
        functions.put("swapiteminv", pins -> {
            Inventory inv = (Inventory)pins.values[0];
            int slotA = ((Double)pins.values[1]).intValue();
            int slotB = ((Double)pins.values[2]).intValue();
            if (slotA >= 0 && slotA < inv.getSize() && slotB >= 0 && slotB < inv.getSize()) {
                ItemStack A = inv.getItem(slotA);
                ItemStack B = inv.getItem(slotB);
                inv.setItem(slotA, B);
                inv.setItem(slotB, A);
            }
            return new Pins(new Object[0]);
        });
        functions.put("swapiteminv2", pins -> {
            Inventory invA = (Inventory)pins.values[0];
            int slotA = ((Double)pins.values[1]).intValue();
            Inventory invB = (Inventory)pins.values[2];
            int slotB = ((Double)pins.values[3]).intValue();
            if (slotA >= 0 && slotA < invA.getSize() && slotB >= 0 && slotB < invB.getSize()) {
                ItemStack A = invA.getItem(slotA);
                ItemStack B = invB.getItem(slotB);
                invA.setItem(slotA, B);
                invB.setItem(slotB, A);
            }
            return new Pins(new Object[0]);
        });
        functions.put("newlist", pins -> new Pins(new ArrayList()));
        functions.put("addtolist", pins -> {
            List list = (List)pins.values[0];
            String element = (String)pins.values[1];
            list.add(element);
            return new Pins(new Object[0]);
        });
        functions.put("removefromlist", pins -> {
            List list = (List)pins.values[0];
            Double index = (Double)pins.values[1];
            if (index < (double)list.size() && index >= 0.0) {
                list.remove(index.intValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("removefromlist2", pins -> {
            List list = (List)pins.values[0];
            String element = (String)pins.values[1];
            list.remove(element);
            return new Pins(new Object[0]);
        });
        functions.put("putinlist", pins -> {
            List list = (List)pins.values[0];
            Double index = (Double)pins.values[1];
            String element = (String)pins.values[2];
            if (index < (double)list.size() && index >= 0.0) {
                list.set(index.intValue(), element);
            } else {
                list.add(element);
            }
            return new Pins(new Object[0]);
        });
        functions.put("getfromlist", pins -> {
            List list = (List)pins.values[0];
            Double index = (Double)pins.values[1];
            if (index < (double)list.size() && index >= 0.0) {
                return new Pins(list.get(index.intValue()));
            }
            return new Pins("");
        });
        functions.put("indexoflist", pins -> {
            List list = (List)pins.values[0];
            String element = (String)pins.values[1];
            return new Pins(list.indexOf(element));
        });
        functions.put("listcontains", pins -> {
            List list = (List)pins.values[0];
            String element = (String)pins.values[1];
            return new Pins(list.contains(element));
        });
        functions.put("listsize", pins -> {
            List list = (List)pins.values[0];
            return new Pins(list.size());
        });
        functions.put("listtostring", pins -> {
            List list = (List)pins.values[0];
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    Pins pins2;
                    ObjectOutputStream so;
                    ByteArrayOutputStream bo;
                    block18: {
                        block17: {
                            bo = new ByteArrayOutputStream();
                            so = new ObjectOutputStream(bo);
                            so.writeObject(list);
                            so.flush();
                            pins2 = new Pins(Base64.getEncoder().encodeToString(bo.toByteArray()));
                            if (so == null) break block17;
                            so.close();
                        }
                        if (bo == null) break block18;
                        bo.close();
                    }
                    return pins2;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (so != null) {
                                    so.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (bo != null) {
                                    bo.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return new Pins("");
            }
        });
        functions.put("stringtolist", pins -> {
            String str = (String)pins.values[0];
            byte[] b = Base64.getDecoder().decode(str);
            ByteArrayInputStream bi = new ByteArrayInputStream(b);
            try {
                ObjectInputStream si = new ObjectInputStream(bi);
                return new Pins(ArrayList.class.cast(si.readObject()));
            }
            catch (IOException | ClassCastException | ClassNotFoundException exception) {
                return new Pins(new ArrayList());
            }
        });
        functions.put("listtojson", pins -> {
            List list = (List)pins.values[0];
            JsonArray array = new JsonArray();
            for (String s : list) {
                array.add(s);
            }
            return new Pins(array.toString());
        });
        functions.put("jsontolist", pins -> {
            String str = (String)pins.values[0];
            try {
                JsonArray array = JsonParser.parseString((String)str).getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                int i = 0;
                while (i < array.size()) {
                    list.add(array.get(i).getAsString());
                    ++i;
                }
                return new Pins(list);
            }
            catch (JsonParseException | IllegalStateException throwable) {
                return new Pins(new ArrayList());
            }
        });
        functions.put("newmap", pins -> new Pins(new HashMap()));
        functions.put("putinmap", pins -> {
            HashMap map = (HashMap)pins.values[0];
            String key = (String)pins.values[1];
            String element = (String)pins.values[2];
            map.put(key, element);
            return new Pins(new Object[0]);
        });
        functions.put("getfrommap", pins -> {
            HashMap map = (HashMap)pins.values[0];
            String key = (String)pins.values[1];
            String element = (String)map.get(key);
            if (element != null) {
                return new Pins(element);
            }
            return new Pins("");
        });
        functions.put("removefrommap", pins -> {
            HashMap map = (HashMap)pins.values[0];
            String key = (String)pins.values[1];
            String element = (String)map.remove(key);
            if (element != null) {
                return new Pins(element);
            }
            return new Pins("");
        });
        functions.put("mapsize", pins -> {
            HashMap map = (HashMap)pins.values[0];
            return new Pins(map.size());
        });
        functions.put("mapkeys", pins -> {
            HashMap map = (HashMap)pins.values[0];
            return new Pins(new ArrayList(map.keySet()));
        });
        functions.put("mapvalues", pins -> {
            HashMap map = (HashMap)pins.values[0];
            return new Pins(new ArrayList(map.values()));
        });
        functions.put("maptostring", pins -> {
            HashMap map = (HashMap)pins.values[0];
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    Pins pins2;
                    ObjectOutputStream so;
                    ByteArrayOutputStream bo;
                    block18: {
                        block17: {
                            bo = new ByteArrayOutputStream();
                            so = new ObjectOutputStream(bo);
                            so.writeObject(map);
                            so.flush();
                            pins2 = new Pins(Base64.getEncoder().encodeToString(bo.toByteArray()));
                            if (so == null) break block17;
                            so.close();
                        }
                        if (bo == null) break block18;
                        bo.close();
                    }
                    return pins2;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (so != null) {
                                    so.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (bo != null) {
                                    bo.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return new Pins("");
            }
        });
        functions.put("stringtomap", pins -> {
            String str = (String)pins.values[0];
            byte[] b = Base64.getDecoder().decode(str);
            ByteArrayInputStream bi = new ByteArrayInputStream(b);
            try {
                ObjectInputStream si = new ObjectInputStream(bi);
                return new Pins(HashMap.class.cast(si.readObject()));
            }
            catch (IOException | ClassCastException | ClassNotFoundException exception) {
                return new Pins(new HashMap());
            }
        });
        functions.put("maptojson", pins -> {
            HashMap map = (HashMap)pins.values[0];
            JsonObject json = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                json.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return new Pins(json.toString());
        });
        functions.put("jsontomap", pins -> {
            String str = (String)pins.values[0];
            try {
                JsonObject json = JsonParser.parseString((String)str).getAsJsonObject();
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry entry : json.entrySet()) {
                    map.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                return new Pins(map);
            }
            catch (JsonParseException | IllegalStateException throwable) {
                return new Pins(new HashMap());
            }
        });
        functions.put("createdisplayentity", pins -> {
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            ItemStack item = (ItemStack)pins.values[2];
            ItemDisplay display = (ItemDisplay)world.spawnEntity(new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]), EntityType.ITEM_DISPLAY);
            display.setItemStack(item);
            display.setInterpolationDelay(4);
            return new Pins(display);
        });
        functions.put("createdisplayentityblock", pins -> {
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            Block block = (Block)pins.values[2];
            BlockDisplay display = (BlockDisplay)world.spawnEntity(new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]), EntityType.BLOCK_DISPLAY);
            display.setBlock(block.getBlockData());
            display.setInterpolationDelay(4);
            return new Pins(display);
        });
        functions.put("createdisplayentitytext", pins -> {
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            String str = (String)pins.values[2];
            TextDisplay display = (TextDisplay)world.spawnEntity(new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]), EntityType.TEXT_DISPLAY);
            display.setText(ColorUtils.color(str.replace("\\n", "\n")));
            display.setInterpolationDelay(4);
            return new Pins(display);
        });
        functions.put("setdisplayinterpolation", pins -> {
            Display display = (Display)pins.values[0];
            Double delay = (Double)pins.values[1];
            Double duration = (Double)pins.values[2];
            display.setInterpolationDelay(delay.intValue() + 4);
            display.setInterpolationDuration(duration.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("displayinterpolation", pins -> {
            Display display = (Display)pins.values[0];
            return new Pins(display.getInterpolationDelay(), display.getInterpolationDuration());
        });
        functions.put("setdisplaytranslation", pins -> {
            Display display = (Display)pins.values[0];
            float[] offset = ((Vector)pins.values[1]).values;
            Transformation t = display.getTransformation();
            t.getTranslation().set((float[])offset.clone());
            display.setTransformation(t);
            return new Pins(new Object[0]);
        });
        functions.put("displaytranslation", pins -> {
            Display display = (Display)pins.values[0];
            Transformation t = display.getTransformation();
            Vector3f v = t.getTranslation();
            return new Pins(new Vector(v.x, v.y, v.z));
        });
        functions.put("setdisplayrotation", pins -> {
            Display display = (Display)pins.values[0];
            float[] axis = ((Vector)pins.values[1]).values;
            Double angle = (Double)pins.values[2];
            Transformation t = display.getTransformation();
            t.getRightRotation().setAngleAxis(Math.toRadians(angle.floatValue()), (double)axis[0], (double)axis[1], (double)axis[2]);
            display.setTransformation(t);
            return new Pins(new Object[0]);
        });
        functions.put("displayrotation", pins -> {
            Display display = (Display)pins.values[0];
            Transformation t = display.getTransformation();
            AxisAngle4f q = t.getRightRotation().get(new AxisAngle4f());
            return new Pins(new Vector(q.x, q.y, q.z), Math.toDegrees(q.angle));
        });
        functions.put("setdisplayscale", pins -> {
            Display display = (Display)pins.values[0];
            float[] scale = ((Vector)pins.values[1]).values;
            Transformation t = display.getTransformation();
            t.getScale().set((float[])scale.clone());
            display.setTransformation(t);
            return new Pins(new Object[0]);
        });
        functions.put("displayscale", pins -> {
            Display display = (Display)pins.values[0];
            Transformation t = display.getTransformation();
            Vector3f v = t.getScale();
            return new Pins(new Vector(v.x, v.y, v.z));
        });
        functions.put("setdisplayshadow", pins -> {
            Display display = (Display)pins.values[0];
            Double radius = (Double)pins.values[1];
            Double strength = (Double)pins.values[2];
            display.setShadowRadius((float)radius.intValue());
            display.setShadowStrength((float)strength.intValue());
            return new Pins(new Object[0]);
        });
        functions.put("displayshadow", pins -> {
            Display display = (Display)pins.values[0];
            return new Pins(display.getShadowRadius(), display.getShadowStrength());
        });
        functions.put("setdisplayitem", pins -> {
            Display display = (Display)pins.values[0];
            ItemStack item = (ItemStack)pins.values[1];
            if (display instanceof ItemDisplay) {
                ItemDisplay i = (ItemDisplay)display;
                i.setItemStack(item);
            }
            return new Pins(new Object[0]);
        });
        functions.put("setdisplayitem2", pins -> {
            Display display = (Display)pins.values[0];
            String type = (String)pins.values[1];
            if (display instanceof ItemDisplay) {
                ItemDisplay i = (ItemDisplay)display;
                Material material = null;
                try {
                    material = Material.getMaterial((String)type.replace(" ", "_").toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (material != null && material.isItem()) {
                    i.setItemStack(new ItemStack(material));
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("displayitem", pins -> {
            Display display = (Display)pins.values[0];
            if (display instanceof ItemDisplay) {
                ItemDisplay i = (ItemDisplay)display;
                return new Pins(i.getItemStack());
            }
            return new Pins(new ItemStack(Material.STONE));
        });
        functions.put("setdisplaytext", pins -> {
            Display display = (Display)pins.values[0];
            String str = (String)pins.values[1];
            if (display instanceof TextDisplay) {
                TextDisplay i = (TextDisplay)display;
                i.setText(ColorUtils.color(str.replace("\\n", "\n")));
            }
            return new Pins(new Object[0]);
        });
        functions.put("displaytext", pins -> {
            Display display = (Display)pins.values[0];
            if (display instanceof TextDisplay) {
                TextDisplay i = (TextDisplay)display;
                return new Pins(i.getText());
            }
            return new Pins("");
        });
        functions.put("setdisplaytextoption", pins -> {
            block15: {
                Display display = (Display)pins.values[0];
                Double width = (Double)pins.values[1];
                Double opacity = (Double)pins.values[2];
                Boolean shadow = (Boolean)pins.values[3];
                Boolean seeTrough = (Boolean)pins.values[4];
                Boolean defaultBackground = (Boolean)pins.values[5];
                String alignment = (String)pins.values[6];
                if (opacity > 127.0) {
                    opacity = 127.0;
                } else if (opacity < -1.0) {
                    opacity = -1.0;
                }
                if (!(display instanceof TextDisplay)) break block15;
                TextDisplay i = (TextDisplay)display;
                i.setLineWidth(width.intValue());
                i.setTextOpacity(opacity.byteValue());
                i.setShadowed(shadow.booleanValue());
                i.setSeeThrough(seeTrough.booleanValue());
                i.setDefaultBackground(defaultBackground.booleanValue());
                try {
                    TextDisplay.TextAlignment align = TextDisplay.TextAlignment.CENTER;
                    switch (alignment.toUpperCase().strip()) {
                        case "LEFT": {
                            align = TextDisplay.TextAlignment.LEFT;
                            break;
                        }
                        case "RIGHT": {
                            align = TextDisplay.TextAlignment.RIGHT;
                        }
                    }
                    i.setAlignment(align);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            return new Pins(new Object[0]);
        });
        functions.put("displaytextoption", pins -> {
            Display display = (Display)pins.values[0];
            if (display instanceof TextDisplay) {
                TextDisplay i = (TextDisplay)display;
                return new Pins(i.getLineWidth(), i.getTextOpacity(), i.isShadowed(), i.isSeeThrough(), i.isDefaultBackground(), i.getAlignment().toString());
            }
            return new Pins(0.0, 0.0, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, "");
        });
        functions.put("placedisplayentity", pins -> {
            Display display = (Display)pins.values[0];
            Player player = (Player)pins.values[1];
            Double rot = (Double)pins.values[2];
            float f = DisplayUtils.rotateBlock(display, player.getEyeLocation().getYaw(), rot.floatValue());
            return new Pins(f);
        });
        functions.put("displaytoentity", pins -> pins);
        functions.put("entitytodisplay", pins -> pins);
        functions.put("createinteractionentity", pins -> {
            World world = (World)pins.values[0];
            float[] pos = ((Vector)pins.values[1]).values;
            Interaction interaction = (Interaction)world.spawnEntity(new Location(world, (double)pos[0], (double)pos[1], (double)pos[2]), EntityType.INTERACTION);
            interaction.setResponsive(true);
            return new Pins(interaction);
        });
        functions.put("setinteractionsize", pins -> {
            Interaction interaction = (Interaction)pins.values[0];
            Double width = (Double)pins.values[1];
            Double height = (Double)pins.values[2];
            interaction.setInteractionWidth(width.floatValue());
            interaction.setInteractionHeight(height.floatValue());
            return new Pins(new Object[0]);
        });
        functions.put("interactionsize", pins -> {
            Interaction interaction = (Interaction)pins.values[0];
            return new Pins(interaction.getInteractionWidth(), interaction.getInteractionHeight());
        });
        functions.put("setinteractionresponse", pins -> {
            Interaction interaction = (Interaction)pins.values[0];
            Boolean response = (Boolean)pins.values[1];
            interaction.setResponsive(response.booleanValue());
            return new Pins(new Object[0]);
        });
        functions.put("interactionresponse", pins -> {
            Interaction interaction = (Interaction)pins.values[0];
            return new Pins(interaction.isResponsive());
        });
        functions.put("interactiontoentity", pins -> pins);
        functions.put("entitytointeraction", pins -> pins);
        functions.put("spawncustommodel", pins -> {
            World world = (World)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            String id = (String)pins.values[2];
            CustomModel model = null;
            try {
                UUID uuid = UUID.fromString(id);
                model = ModelEditor.models.get(uuid);
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
            if (model == null) {
                return null;
            }
            Location loc = vect.getLocation(world);
            ModelEntity entity = new ModelEntity(UUID.randomUUID(), model.data.uuid);
            entity.spawn(model, loc);
            return new Pins(entity, entity.data.uuid.toString());
        });
        functions.put("removecustommodel", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            if (model.removed) {
                return null;
            }
            model.remove();
            return new Pins(new Object[0]);
        });
        functions.put("getcustommodel", pins -> {
            UUID id = UUID.fromString((String)pins.values[0]);
            ModelEntity model = ModelEditor.entities.get(id);
            if (model == null) {
                return null;
            }
            return new Pins(model);
        });
        functions.put("custommodeluuid", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            return new Pins(model.data.uuid.toString());
        });
        functions.put("playanimationcustommodel", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            String animationID = (String)pins.values[1];
            int duration = ((Double)pins.values[2]).intValue();
            for (ModelEntity.ModelEntityAnimationData data : model.data.currentAnimations) {
                if (!data.anim.equals(animationID)) continue;
                data.tick = duration;
                model.toSave = true;
                return new Pins(new Object[0]);
            }
            model.data.currentAnimations.add(new ModelEntity.ModelEntityAnimationData(animationID, duration));
            model.toSave = true;
            return new Pins(new Object[0]);
        });
        functions.put("removeanimationcustommodel", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            String animationID = (String)pins.values[1];
            for (ModelEntity.ModelEntityAnimationData data : model.data.currentAnimations) {
                if (!data.anim.equals(animationID)) continue;
                model.data.currentAnimations.remove(data);
                break;
            }
            model.toSave = true;
            return new Pins(new Object[0]);
        });
        functions.put("clearanimationcustommodel", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            model.data.currentAnimations.clear();
            model.toSave = true;
            return new Pins(new Object[0]);
        });
        functions.put("setcustommodelpersistent", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            Boolean bool = (Boolean)pins.values[1];
            model.setPersistent(bool);
            return new Pins(new Object[0]);
        });
        functions.put("teleportcustommodel", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            model.data.origin[0] = vect.values[0];
            model.data.origin[1] = vect.values[1];
            model.data.origin[2] = vect.values[2];
            model.dirty = true;
            return new Pins(new Object[0]);
        });
        functions.put("rotatecustommodel", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            float yaw = ((Double)pins.values[1]).floatValue();
            float pitch = ((Double)pins.values[2]).floatValue();
            model.data.rotation[0] = yaw;
            model.data.rotation[1] = pitch;
            model.dirty = true;
            return new Pins(new Object[0]);
        });
        functions.put("transmitcustommodeldata", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            String key = (String)pins.values[1];
            String value = (String)pins.values[2];
            boolean cancelled = model.sendData(key, value);
            return new Pins(cancelled);
        });
        functions.put("getmodelposition", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            return new Pins(new Vector(model.data.origin), Bukkit.getWorld((UUID)model.data.worldUID));
        });
        functions.put("getmodelrotation", pins -> {
            ModelEntity model = (ModelEntity)pins.values[0];
            return new Pins(model.data.rotation[0], model.data.rotation[1]);
        });
        functions.put("getmodelfromelement", pins -> {
            org.bukkit.entity.Entity ent = (org.bukkit.entity.Entity)pins.values[0];
            if (!ent.getPersistentDataContainer().has(ModelEditor.MODEL, PersistentDataType.STRING)) {
                return new Pins(Boolean.FALSE, null);
            }
            try {
                ModelEntity model = ModelEditor.entities.get(UUID.fromString((String)ent.getPersistentDataContainer().get(ModelEditor.MODEL, PersistentDataType.STRING)));
                if (model == null) {
                    return new Pins(Boolean.FALSE, null);
                }
                return new Pins(Boolean.TRUE, model);
            }
            catch (IllegalArgumentException e) {
                return new Pins(Boolean.FALSE, null);
            }
        });
        functions.put("spawnfirework", pins -> {
            World world = (World)pins.values[0];
            Vector vect = (Vector)pins.values[1];
            Double power = (Double)pins.values[2];
            if (power < 0.0) {
                power = 0.0;
            } else if (power > 127.0) {
                power = 127.0;
            }
            Location loc = vect.getLocation(world);
            Firework f = (Firework)world.spawn(loc, Firework.class);
            FireworkMeta meta = f.getFireworkMeta();
            meta.setPower(power.intValue());
            f.setFireworkMeta(meta);
            return new Pins(f);
        });
        functions.put("addfireworkeffect", pins -> {
            Firework f = (Firework)pins.values[0];
            String type = (String)pins.values[1];
            Boolean flicker = (Boolean)pins.values[2];
            Boolean trail = (Boolean)pins.values[3];
            String color = (String)pins.values[4];
            String fade = (String)pins.values[5];
            FireworkEffect.Builder builder = FireworkEffect.builder();
            try {
                FireworkEffect.Type t = FireworkEffect.Type.valueOf((String)type);
                if (t != null) {
                    builder = builder.with(t);
                }
            }
            catch (IllegalArgumentException t) {
                // empty catch block
            }
            builder = builder.flicker(flicker.booleanValue()).trail(trail.booleanValue());
            if (color.length() == 7) {
                builder = builder.withColor(HexUtils.hex2Rgb(color));
            } else if (color.length() == 9) {
                builder = builder.withColor(HexUtils.hex2Argb(color));
            }
            if (fade.length() == 7) {
                builder = builder.withFade(HexUtils.hex2Rgb(fade));
            } else if (fade.length() == 9) {
                builder = builder.withFade(HexUtils.hex2Argb(fade));
            }
            FireworkMeta meta = f.getFireworkMeta();
            meta.addEffect(builder.build());
            f.setFireworkMeta(meta);
            return new Pins(new Object[0]);
        });
        functions.put("addfireworkeffect2", pins -> {
            Firework f = (Firework)pins.values[0];
            String type = (String)pins.values[1];
            Boolean flicker = (Boolean)pins.values[2];
            Boolean trail = (Boolean)pins.values[3];
            List colors = (List)pins.values[4];
            List fades = (List)pins.values[5];
            FireworkEffect.Builder builder = FireworkEffect.builder();
            try {
                FireworkEffect.Type t = FireworkEffect.Type.valueOf((String)type);
                if (t != null) {
                    builder = builder.with(t);
                }
            }
            catch (IllegalArgumentException t) {
                // empty catch block
            }
            builder = builder.flicker(flicker.booleanValue()).trail(trail.booleanValue());
            ArrayList<Color> color = new ArrayList<Color>();
            for (String c : colors) {
                if (c.length() == 7) {
                    color.add(HexUtils.hex2Rgb(c));
                    continue;
                }
                if (c.length() != 9) continue;
                color.add(HexUtils.hex2Argb(c));
            }
            builder = builder.withColor(color);
            ArrayList<Color> fade = new ArrayList<Color>();
            for (String c : fades) {
                if (c.length() == 7) {
                    fade.add(HexUtils.hex2Rgb(c));
                    continue;
                }
                if (c.length() != 9) continue;
                fade.add(HexUtils.hex2Argb(c));
            }
            builder = builder.withColor(fade);
            FireworkMeta meta = f.getFireworkMeta();
            meta.addEffect(builder.build());
            f.setFireworkMeta(meta);
            return new Pins(new Object[0]);
        });
        functions.put("discord_sendresponse", pins -> {
            ScriptCommandData command = (ScriptCommandData)pins.values[0];
            String response = (String)pins.values[1];
            JsonObject json = new JsonObject();
            json.addProperty("t", "sendresponse");
            json.addProperty("c", command.command_id);
            json.addProperty("r", response);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        functions.put("discord_sendephemeralresponse", pins -> {
            ScriptCommandData command = (ScriptCommandData)pins.values[0];
            String response = (String)pins.values[1];
            JsonObject json = new JsonObject();
            json.addProperty("t", "sendephemeralresponse");
            json.addProperty("c", command.command_id);
            json.addProperty("r", response);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        functions.put("discord_senddirectmessage", pins -> {
            ScriptMemberData member = (ScriptMemberData)pins.values[0];
            String message = (String)pins.values[1];
            JsonObject json = new JsonObject();
            json.addProperty("t", "senddirectmessage");
            json.addProperty("u", member.user_id);
            json.addProperty("m", message);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        functions.put("discord_kickmember", pins -> {
            ScriptMemberData member = (ScriptMemberData)pins.values[0];
            String reason = (String)pins.values[1];
            JsonObject json = new JsonObject();
            json.addProperty("t", "kickmember");
            json.addProperty("u", member.user_id);
            json.addProperty("g", member.guild_id);
            json.addProperty("r", reason);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        functions.put("discord_banmember", pins -> {
            ScriptMemberData member = (ScriptMemberData)pins.values[0];
            String reason = (String)pins.values[1];
            JsonObject json = new JsonObject();
            json.addProperty("t", "banmember");
            json.addProperty("u", member.user_id);
            json.addProperty("g", member.guild_id);
            json.addProperty("r", reason);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        functions.put("discord_addrole", pins -> {
            ScriptMemberData member = (ScriptMemberData)pins.values[0];
            String role = (String)pins.values[1];
            JsonObject json = new JsonObject();
            json.addProperty("t", "addrole");
            json.addProperty("u", member.user_id);
            json.addProperty("g", member.guild_id);
            json.addProperty("r", role);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        functions.put("discord_removerole", pins -> {
            ScriptMemberData member = (ScriptMemberData)pins.values[0];
            String role = (String)pins.values[1];
            JsonObject json = new JsonObject();
            json.addProperty("t", "removerole");
            json.addProperty("u", member.user_id);
            json.addProperty("g", member.guild_id);
            json.addProperty("r", role);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        specialFunctions.put("discord_checkrole", payload -> {
            ScriptMemberData member = (ScriptMemberData)payload.inputPins.values[0];
            String role = (String)payload.inputPins.values[1];
            int session = (int)(Math.random() * 2.147483647E9);
            JsonObject json = new JsonObject();
            json.addProperty("t", "checkrole");
            json.addProperty("u", member.user_id);
            json.addProperty("g", member.guild_id);
            json.addProperty("r", role);
            json.addProperty("s", (Number)session);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            DiscordBotManager.callbacks.put(session, response -> {
                functionPayload.execution.put(functionPayload.instance, new Pins(response.get("f").getAsBoolean()));
                for (CompiledScript.Node output : functionPayload.execOutput) {
                    output.run(functionPayload.execution);
                }
            });
        });
        functions.put("discord_memberid", pins -> {
            ScriptMemberData command = (ScriptMemberData)pins.values[0];
            return new Pins(command.user_id);
        });
        specialFunctions.put("discord_membername", payload -> {
            ScriptMemberData member = (ScriptMemberData)payload.inputPins.values[0];
            int session = (int)(Math.random() * 2.147483647E9);
            JsonObject json = new JsonObject();
            json.addProperty("t", "membername");
            json.addProperty("u", member.user_id);
            json.addProperty("s", (Number)session);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            DiscordBotManager.callbacks.put(session, response -> {
                functionPayload.execution.put(functionPayload.instance, new Pins(response.get("n").getAsString()));
                for (CompiledScript.Node output : functionPayload.execOutput) {
                    output.run(functionPayload.execution);
                }
            });
        });
        specialFunctions.put("discord_displayedmembername", payload -> {
            ScriptMemberData member = (ScriptMemberData)payload.inputPins.values[0];
            int session = (int)(Math.random() * 2.147483647E9);
            JsonObject json = new JsonObject();
            json.addProperty("t", "displayedmembername");
            json.addProperty("u", member.user_id);
            json.addProperty("g", member.guild_id);
            json.addProperty("s", (Number)session);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            DiscordBotManager.callbacks.put(session, response -> {
                functionPayload.execution.put(functionPayload.instance, new Pins(response.get("n").getAsString()));
                for (CompiledScript.Node output : functionPayload.execOutput) {
                    output.run(functionPayload.execution);
                }
            });
        });
        specialFunctions.put("discord_sendmessage", payload -> {
            ScriptChannelData channel = (ScriptChannelData)payload.inputPins.values[0];
            String message = (String)payload.inputPins.values[1];
            int session = (int)(Math.random() * 2.147483647E9);
            JsonObject json = new JsonObject();
            json.addProperty("t", "sendmessage");
            json.addProperty("c", channel.channel_id);
            json.addProperty("m", message);
            json.addProperty("s", (Number)session);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            DiscordBotManager.callbacks.put(session, response -> {
                functionPayload.execution.put(functionPayload.instance, new Pins(response.get("i").getAsString()));
                for (CompiledScript.Node output : functionPayload.execOutput) {
                    output.run(functionPayload.execution);
                }
            });
        });
        functions.put("discord_channelid", pins -> {
            ScriptChannelData channel = (ScriptChannelData)pins.values[0];
            return new Pins(channel.channel_id);
        });
        specialFunctions.put("discord_channelname", payload -> {
            ScriptChannelData channel = (ScriptChannelData)payload.inputPins.values[0];
            int session = (int)(Math.random() * 2.147483647E9);
            JsonObject json = new JsonObject();
            json.addProperty("t", "channelname");
            json.addProperty("c", channel.channel_id);
            json.addProperty("s", (Number)session);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            DiscordBotManager.callbacks.put(session, response -> {
                functionPayload.execution.put(functionPayload.instance, new Pins(response.get("n").getAsString()));
                for (CompiledScript.Node output : functionPayload.execOutput) {
                    output.run(functionPayload.execution);
                }
            });
        });
        functions.put("discord_channelid", pins -> {
            String channelid = (String)pins.values[0];
            return new Pins(new ScriptChannelData(channelid));
        });
        functions.put("discord_getmember", pins -> {
            String userid = (String)pins.values[0];
            String guildid = (String)pins.values[1];
            return new Pins(new ScriptMemberData(guildid, userid));
        });
        functions.put("discord_addreaction", pins -> {
            ScriptChannelData channel = (ScriptChannelData)pins.values[0];
            String message = (String)pins.values[1];
            String reaction = (String)pins.values[2];
            JsonObject json = new JsonObject();
            json.addProperty("t", "addreaction");
            json.addProperty("c", channel.channel_id);
            json.addProperty("m", message);
            json.addProperty("r", reaction);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        functions.put("discord_removereaction", pins -> {
            ScriptChannelData channel = (ScriptChannelData)pins.values[0];
            String message = (String)pins.values[1];
            String reaction = (String)pins.values[2];
            JsonObject json = new JsonObject();
            json.addProperty("t", "removereaction");
            json.addProperty("c", channel.channel_id);
            json.addProperty("m", message);
            json.addProperty("r", reaction);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        functions.put("discord_deletemessage", pins -> {
            ScriptChannelData channel = (ScriptChannelData)pins.values[0];
            String message = (String)pins.values[1];
            JsonObject json = new JsonObject();
            json.addProperty("t", "deletemessage");
            json.addProperty("c", channel.channel_id);
            json.addProperty("m", message);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            return new Pins(new Object[0]);
        });
        specialFunctions.put("discord_getmessage", payload -> {
            ScriptChannelData channel = (ScriptChannelData)payload.inputPins.values[0];
            String message = (String)payload.inputPins.values[1];
            int session = (int)(Math.random() * 2.147483647E9);
            JsonObject json = new JsonObject();
            json.addProperty("t", "getmessage");
            json.addProperty("c", channel.channel_id);
            json.addProperty("m", message);
            json.addProperty("s", (Number)session);
            ConnectionClientHandler.sendInfoPacket("discordcontroller", json);
            DiscordBotManager.callbacks.put(session, response -> {
                functionPayload.execution.put(functionPayload.instance, new Pins(response.get("m").getAsString()));
                for (CompiledScript.Node output : functionPayload.execOutput) {
                    output.run(functionPayload.execution);
                }
            });
        });
        functions.put("loadcustomconfig", pins -> {
            UUID uuid;
            String groupid = (String)pins.values[0];
            String fileid = (String)pins.values[1];
            try {
                uuid = UUID.fromString(groupid);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            ConfigFile file = CustomConfigManager.getConfigFile(uuid, fileid);
            if (file != null) {
                return new Pins(file);
            }
            return null;
        });
        functions.put("customconfigexists", pins -> {
            UUID uuid;
            String groupid = (String)pins.values[0];
            String fileid = (String)pins.values[1];
            try {
                uuid = UUID.fromString(groupid);
            }
            catch (IllegalArgumentException ex) {
                return new Pins(Boolean.FALSE);
            }
            return new Pins(CustomConfigManager.configFileExists(uuid, fileid));
        });
        functions.put("savecustomconfig", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            file.instance.saveSingleFile(file.id, file.file);
            return new Pins(new Object[0]);
        });
        functions.put("savecustomconfig2", pins -> {
            UUID uuid;
            String groupid = (String)pins.values[0];
            String fileid = (String)pins.values[1];
            ConfigFile file = (ConfigFile)pins.values[2];
            try {
                uuid = UUID.fromString(groupid);
            }
            catch (IllegalArgumentException ex) {
                return new Pins(new Object[0]);
            }
            ConfigFile newFile = CustomConfigManager.getConfigFile(uuid, fileid);
            if (newFile != null) {
                YamlConfiguration config = ConfigInstance.optimizedClone((YamlConfiguration)file.file);
                newFile.instance.files.put(fileid, (FileConfiguration)config);
                newFile.instance.saveSingleFile(fileid, file.file);
            }
            return new Pins(new Object[0]);
        });
        functions.put("unloadcustomconfig", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            file.instance.files.remove(file.id);
            return new Pins(new Object[0]);
        });
        functions.put("deletecustomconfig", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            file.instance.deleteSingleFile(file.id);
            return new Pins(new Object[0]);
        });
        functions.put("getcustomconfigtext", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            if (key.equals("")) {
                return new Pins("");
            }
            return new Pins(file.file.getString(key, ""));
        });
        functions.put("getcustomconfignumber", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            if (key.equals("")) {
                return new Pins(0.0);
            }
            return new Pins(file.file.getDouble(key, 0.0));
        });
        functions.put("getcustomconfigbool", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            if (key.equals("")) {
                return new Pins(Boolean.FALSE);
            }
            return new Pins(file.file.getBoolean(key, false));
        });
        functions.put("getcustomconfiglist", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            if (key.equals("")) {
                return new Pins(new ArrayList());
            }
            return new Pins(file.file.getStringList(key));
        });
        functions.put("getcustomconfigmap", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            if (key.equals("")) {
                return new Pins(new HashMap());
            }
            return new Pins(CustomConfigUtils.getMapList(file.file, key));
        });
        functions.put("hascustomconfig", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            return new Pins(file.file.contains(key));
        });
        functions.put("setcustomconfigtext", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            String value = (String)pins.values[2];
            file.file.set(key, (Object)value);
            return new Pins(new Object[0]);
        });
        functions.put("setcustomconfignumber", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            Double value = (Double)pins.values[2];
            file.file.set(key, (Object)value);
            return new Pins(new Object[0]);
        });
        functions.put("setcustomconfigbool", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            Boolean value = (Boolean)pins.values[2];
            file.file.set(key, (Object)value);
            return new Pins(new Object[0]);
        });
        functions.put("setcustomconfiglist", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            List value = (List)pins.values[2];
            file.file.set(key, (Object)value);
            return new Pins(new Object[0]);
        });
        functions.put("setcustomconfigmap", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            Map value = (Map)pins.values[2];
            for (Map.Entry entry : value.entrySet()) {
                file.file.set(key + "." + (String)entry.getKey(), entry.getValue());
            }
            return new Pins(new Object[0]);
        });
        functions.put("removecustomconfig", pins -> {
            ConfigFile file = (ConfigFile)pins.values[0];
            String key = (String)pins.values[1];
            file.file.set(key, null);
            return new Pins(new Object[0]);
        });
    }
}

