/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.World;

public class Vector
implements Serializable {
    private static final long serialVersionUID = 1L;
    public float[] values;

    public Vector(float[] values) {
        this.values = values;
    }

    public Vector(double yaw, double pitch) {
        double xzLen = Math.cos(-pitch);
        float z = (float)(xzLen * Math.cos(yaw));
        float y = (float)Math.sin(-pitch);
        float x = (float)(xzLen * Math.sin(-yaw));
        this.values = new float[]{x, y, z};
    }

    public Vector(float x, float y, float z) {
        this(new float[]{x, y, z});
    }

    public Vector(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public Vector(Location loc) {
        this(loc.getX(), loc.getY(), loc.getZ());
    }

    public Vector normalize() {
        double length = 0.0;
        float[] fArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            double element = fArray[n2];
            length += element * element;
            ++n2;
        }
        if ((length = Math.sqrt(length)) == 0.0) {
            return this;
        }
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = (float)((double)this.values[i] / length);
            ++i;
        }
        return this;
    }

    public Vector rotateVector(float[] axisN, double angle) {
        double length = 0.0;
        float[] fArray = axisN;
        int n = axisN.length;
        int n2 = 0;
        while (n2 < n) {
            double element = fArray[n2];
            length += element * element;
            ++n2;
        }
        if ((length = Math.sqrt(length)) == 0.0) {
            return this;
        }
        double[] axis = new double[axisN.length];
        int i = 0;
        while (i < axisN.length) {
            axis[i] = (double)axisN[i] / length;
            ++i;
        }
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double dot = (double)this.values[0] * axis[0] + (double)this.values[1] * axis[1] + (double)this.values[2] * axis[2];
        float[] result = new float[]{(float)((double)this.values[0] * cos + (axis[1] * (double)this.values[2] - axis[2] * (double)this.values[1]) * sin + axis[0] * dot * (1.0 - cos)), (float)((double)this.values[1] * cos + (axis[2] * (double)this.values[0] - axis[0] * (double)this.values[2]) * sin + axis[1] * dot * (1.0 - cos)), (float)((double)this.values[2] * cos + (axis[0] * (double)this.values[1] - axis[1] * (double)this.values[0]) * sin + axis[2] * dot * (1.0 - cos))};
        this.values = result;
        return this;
    }

    public Location getLocation(World world) {
        return new Location(world, (double)this.values[0], (double)this.values[1], (double)this.values[2]);
    }

    public Vector copy() {
        return new Vector(this.values[0], this.values[1], this.values[2]);
    }

    public org.bukkit.util.Vector getVector() {
        return new org.bukkit.util.Vector(this.values[0], this.values[1], this.values[2]);
    }

    public String toString() {
        return "Vector [values=" + Arrays.toString(this.values) + "]";
    }

    public Vector rotateVector(double yaw, double pitch) {
        yaw = -yaw;
        double[][] Ry = new double[][]{{Math.cos(yaw), 0.0, Math.sin(yaw)}, {0.0, 1.0, 0.0}, {-Math.sin(yaw), 0.0, Math.cos(yaw)}};
        double[][] Rx = new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(pitch), -Math.sin(pitch)}, {0.0, Math.sin(pitch), Math.cos(pitch)}};
        double[][] R = Vector.matrixMultiply(Ry, Rx);
        double[] v_rotated = Vector.matrixVectorMultiply(R, this.values);
        this.values = new float[]{(float)v_rotated[0], (float)v_rotated[1], (float)v_rotated[2]};
        return this;
    }

    private static double[][] matrixMultiply(double[][] A, double[][] B) {
        int rowsA = A.length;
        int colsA = A[0].length;
        int colsB = B[0].length;
        double[][] C = new double[rowsA][colsB];
        int i = 0;
        while (i < rowsA) {
            int j = 0;
            while (j < colsB) {
                int k = 0;
                while (k < colsA) {
                    double[] dArray = C[i];
                    int n = j;
                    dArray[n] = dArray[n] + A[i][k] * B[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return C;
    }

    private static double[] matrixVectorMultiply(double[][] A, float[] v) {
        int rowsA = A.length;
        int colsA = A[0].length;
        if (colsA != v.length) {
            throw new IllegalArgumentException("Matrix and vector dimensions must match.");
        }
        double[] result = new double[rowsA];
        int i = 0;
        while (i < rowsA) {
            int j = 0;
            while (j < colsA) {
                int n = i;
                result[n] = result[n] + A[i][j] * (double)v[j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static Vector fromJson(JsonObject json) {
        if (json == null) {
            return null;
        }
        if (!(json.has("x") && json.has("y") && json.has("z"))) {
            return null;
        }
        float x = json.get("x").getAsFloat();
        float y = json.get("y").getAsFloat();
        float z = json.get("z").getAsFloat();
        return new Vector(x, y, z);
    }

    public static Vector fromJson(JsonArray json) {
        if (json == null) {
            return null;
        }
        float[] values = new float[3];
        int i = 0;
        while (i < 3) {
            values[i] = json.get(i).getAsFloat();
            ++i;
        }
        return new Vector(values);
    }

    public JsonObject toJsonObject() {
        JsonObject json = new JsonObject();
        json.addProperty("x", (Number)Float.valueOf(this.values[0]));
        json.addProperty("y", (Number)Float.valueOf(this.values[1]));
        json.addProperty("z", (Number)Float.valueOf(this.values[2]));
        return json;
    }

    public JsonArray toJsonArray() {
        JsonArray json = new JsonArray();
        json.add((Number)Float.valueOf(this.values[0]));
        json.add((Number)Float.valueOf(this.values[1]));
        json.add((Number)Float.valueOf(this.values[2]));
        return json;
    }
}

