/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.script.miscellaneous;

import com.crashstudios.crashcore.Main;
import com.crashstudios.crashcore.folia.CrashScheduler;
import com.crashstudios.crashcore.script.Vector;
import java.util.HashSet;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Snowball;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;

public class ProjectileData {
    public Entity entity;
    public Vector velocity;
    public double gravity;
    public int duration;
    public CrashScheduler.CancelHandle task;
    public HashSet<Entity> startingEntities = new HashSet();
    public Entity mover;
    private Object content;

    public ProjectileData(Entity entity, Vector velocity, double gravity, int duration) {
        this.entity = entity;
        this.velocity = velocity;
        this.gravity = gravity;
        this.duration = duration;
    }

    public void launch() {
        if (this.entity instanceof ItemDisplay) {
            ItemDisplay display = (ItemDisplay)this.entity;
            Snowball stand = (Snowball)this.entity.getWorld().spawnEntity(this.entity.getLocation(), EntityType.SNOWBALL);
            stand.setSilent(true);
            stand.setItem(display.getItemStack());
            this.mover = stand;
            this.content = display.getItemStack();
            display.setItemStack(new ItemStack(Material.AIR));
        } else if (this.entity instanceof BlockDisplay) {
            BlockDisplay display = (BlockDisplay)this.entity;
            Snowball stand = (Snowball)this.entity.getWorld().spawnEntity(this.entity.getLocation(), EntityType.SNOWBALL);
            stand.setSilent(true);
            stand.setItem(new ItemStack(display.getBlock().getMaterial()));
            this.mover = stand;
            this.content = display.getBlock();
            display.setBlock(Material.AIR.createBlockData());
        } else {
            this.mover = this.entity;
        }
        this.mover.setGravity(false);
        this.mover.setVelocity(this.velocity.getVector());
        this.startingEntities = new HashSet(this.mover.getWorld().getNearbyEntities(this.mover.getLocation(), 0.0, 0.0, 0.0, e -> e instanceof LivingEntity));
        this.task = CrashScheduler.runTaskTimer((Plugin)Main.INSTANCE, () -> this.tick(), 1L, 1L);
    }

    public void tick() {
        this.velocity.values[1] = (float)((double)this.velocity.values[1] - this.gravity);
        this.mover.setVelocity(this.velocity.getVector());
        HashSet ents = new HashSet();
        RayTraceResult result = this.mover.getWorld().rayTrace(this.mover.getLocation().clone(), this.mover.getVelocity(), this.mover.getVelocity().length(), FluidCollisionMode.NEVER, true, 0.1, e -> {
            if (this.startingEntities.contains(e)) {
                ents.add(e);
                return false;
            }
            return e instanceof LivingEntity && e != this.entity;
        });
        if (this.startingEntities.size() > 0) {
            this.startingEntities.removeIf(ent -> !ents.remove(ent));
        }
        if (result != null) {
            if (result.getHitBlock() != null) {
                this.end();
                this.exec(null, result.getHitBlock());
            } else if (result.getHitEntity() != null) {
                this.end();
                this.exec(result.getHitEntity(), null);
            }
        }
        --this.duration;
        if (this.duration < 0) {
            this.end();
            this.exec(null, null);
            return;
        }
    }

    public void end() {
        this.task.cancel();
        if (this.entity instanceof ItemDisplay) {
            ItemDisplay display = (ItemDisplay)this.entity;
            display.setItemStack((ItemStack)this.content);
            display.teleport(this.mover);
        } else if (this.entity instanceof BlockDisplay) {
            BlockDisplay display = (BlockDisplay)this.entity;
            display.setBlock((BlockData)this.content);
            display.teleport(this.mover);
        }
        if (this.mover != this.entity) {
            this.mover.remove();
        }
    }

    public void exec(Entity entity, Block block) {
    }
}

