/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.storage;

import com.crashstudios.crashcore.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class SLAPI {
    public static void save(Object obj, String path) throws IOException {
        SLAPI.save(obj, Paths.get(path, new String[0]));
    }

    public static void save(Object obj, File file) throws IOException {
        SLAPI.save(obj, file.toPath());
    }

    private static void save(Object obj, Path path) throws IOException {
        Path tempPath = path.resolveSibling(String.valueOf(path.getFileName()) + ".tmp");
        Path backupPath = path.resolveSibling(String.valueOf(path.getFileName()) + ".bak");
        Throwable throwable = null;
        Object var5_6 = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(tempPath.toFile()));){
            oos.writeObject(obj);
            oos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (Files.exists(path, new LinkOption[0])) {
            Files.move(path, backupPath, StandardCopyOption.REPLACE_EXISTING);
        }
        Files.move(tempPath, path, StandardCopyOption.ATOMIC_MOVE);
        Files.deleteIfExists(backupPath);
    }

    public static Object load(String path) throws IOException {
        return SLAPI.load(Paths.get(path, new String[0]));
    }

    public static Object load(File file) throws IOException {
        return SLAPI.load(file.toPath());
    }

    private static Object load(Path path) throws IOException {
        Path backupPath;
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return SLAPI.readObjectFromFile(path);
            }
            catch (IOException | ClassNotFoundException e) {
                Main.INSTANCE.getLogger().severe("Failed to load main file: " + String.valueOf(path) + ". Trying backup. Error: " + e.getMessage());
            }
        }
        if (Files.exists(backupPath = path.resolveSibling(String.valueOf(path.getFileName()) + ".bak"), new LinkOption[0])) {
            try {
                Main.INSTANCE.getLogger().severe("Loading from backup file: " + String.valueOf(backupPath));
                return SLAPI.readObjectFromFile(backupPath);
            }
            catch (IOException | ClassNotFoundException e) {
                Main.INSTANCE.getLogger().severe("Failed to load backup file as well: " + String.valueOf(backupPath) + ". Error: " + e.getMessage());
            }
        }
        throw new IOException("Both main and backup files are missing or corrupted: " + String.valueOf(path) + ", " + String.valueOf(backupPath));
    }

    private static Object readObjectFromFile(Path path) throws IOException, ClassNotFoundException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path.toFile()));){
            return ois.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

