/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.utilities;

import com.crashstudios.crashcore.utilities.IColorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.ChatColor;

public class ColorUtils
implements IColorUtils {
    private static List<IColorUtils> utils = new ArrayList<IColorUtils>();
    private static final String ALL_COLOR_CODES = "0123456789AaBbCcDdEeFf";

    public static List<IColorUtils> get() {
        return utils;
    }

    public static void add(IColorUtils utils) {
        ColorUtils.utils.add(utils);
        Collections.sort(ColorUtils.utils, (a, b) -> Integer.compare(a.priority(), b.priority()));
    }

    public static String color(String text) {
        for (IColorUtils u : utils) {
            text = u.translate(text);
        }
        return text;
    }

    @Override
    public String translate(String text) {
        return ColorUtils.encodeString(text);
    }

    private static String encodeString(String str) {
        str = ChatColor.translateAlternateColorCodes((char)'&', (String)str);
        str = ColorUtils.translateAlternateHexCodes(str);
        return str;
    }

    private static String translateAlternateHexCodes(String textToTranslate) {
        StringBuilder builder = new StringBuilder(textToTranslate);
        int index = -1;
        while ((index = builder.indexOf("&#", index + 1)) != -1 && index + 8 <= builder.length()) {
            String hex = builder.substring(index + 2, index + 8);
            if (!ColorUtils.isHexCode(hex)) continue;
            builder.replace(index, index + 8, ColorUtils.getTranslatedHexCode(hex));
        }
        return builder.toString();
    }

    private static boolean isHexCode(String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        int i = 0;
        while (i < b.length) {
            if (ALL_COLOR_CODES.indexOf(b[i]) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getTranslatedHexCode(String hex) {
        return "\u00a7x\u00a7" + hex.charAt(0) + "\u00a7" + hex.charAt(1) + "\u00a7" + hex.charAt(2) + "\u00a7" + hex.charAt(3) + "\u00a7" + hex.charAt(4) + "\u00a7" + hex.charAt(5);
    }
}

